﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Reflection;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    public partial class RegistriesLinqDataContext
    {
        public RegistriesLinqDataContext() :
        base(global::System.Configuration.ConfigurationManager.ConnectionStrings["RegistryConnectionString"].ConnectionString, mappingSource)
        {
            OnCreated();
        }
        //TLB.Fortify
        //partial void UpdateWKF_CASE(WKF_CASE instance)
        //{
        //    if (String.IsNullOrEmpty(instance.CREATEDBY))
        //    {
        //        throw new VABusinessRuleViolationException("Created By Field Cannot Be Empty", VABusinessRuleViolationException.VABusinessRuleViolationCode.RequiredFieldIsMissing);
        //    }

        //    if (instance.CREATED == DateTime.MinValue)
        //    {
        //        throw new VABusinessRuleViolationException("Must set created date", VABusinessRuleViolationException.VABusinessRuleViolationCode.RequiredFieldIsMissing);
        //    }
        //    this.ExecuteDynamicUpdate(instance);
        //}

        [Function(Name = "GetDate", IsComposable = true)]
        public DateTime GetSystemDate()
        {
            MethodInfo mi = MethodBase.GetCurrentMethod() as MethodInfo;
            return (DateTime)this.ExecuteMethodCall(this, mi, new object[] { }).ReturnValue;
        }

        //TLB.Fortify
        //partial void UpdateER_ENCOUNTER_REVIEWCOMMENT(ER_ENCOUNTER_REVIEWCOMMENT instance)
        //{
        //    this.ExecuteDynamicUpdate(instance);
        //}
    }

    public class RegistriesDataAccess : RegistriesLinqDataContext
    {
        //private bool disposed = false;
        private enum WorkFlowActivityTypes
        {
            LabKit = 1,
            Questionnaire = 2,
            LabOrder = 3,
            LabResult = 4,
            Diagnosis = 5,
            LetterSent = 13,
            Interpretation = 22
        }

        private enum WorkflowCaseActivityStatus
        {
            New = 6,
            InProcess = 1,
            Completed = 2,
            Voided = 3,
            Tracking = 4,
            Received = 5,
            Accepted = 7,
            Closed = 9,
            Interpreted = 10,
            AwaitingResults = 11
        }

        #region Constructors

        public RegistriesDataAccess()
            : base()
        {
            InitializeDataContextDebugger();
        }

        public RegistriesDataAccess(string connection)
            : base(connection)
        {
            InitializeDataContextDebugger();
        }

        public RegistriesDataAccess(System.Data.IDbConnection connection)
            : base(connection)
        {
            InitializeDataContextDebugger();
        }

        public RegistriesDataAccess(string connection, System.Data.Linq.Mapping.MappingSource mappingSource)
            : base(connection, mappingSource)
        {
            InitializeDataContextDebugger();
        }

        public RegistriesDataAccess(System.Data.IDbConnection connection, System.Data.Linq.Mapping.MappingSource mappingSource)
            : base(connection, mappingSource)
        {
            InitializeDataContextDebugger();
        }

        public new void Dispose()
        {
            DisposeDataContextDebugger();
            base.Dispose();
        }

        #endregion

        public void InitializeDataContextDebugger()
        {
            if (GlobalSettings.DalLogLing)
            {
                //using (RegistriesLinqDataContext Log = new RegistriesLinqDataContext()) 
                //{
                this.Log = new Utilities.DebuggerWriter();
                //}
            }
        }

        public void DisposeDataContextDebugger()
        {
            if (this.Log != null)
            {
                this.Log.Close();
                this.Log.Dispose();
                this.Log = null;
            }
        }

        public override void SubmitChanges(ConflictMode failureMode)
        {
            ChangeSet changeSet = this.GetChangeSet();
            var updates = (from t in changeSet.Updates select t);
            DateTime now = GetSystemDate();
            string currentUser = System.Threading.Thread.CurrentPrincipal.Identity.Name;
            foreach (object o in changeSet.Inserts)
            {
                Type type = o.GetType();
                PropertyInfo propCreatedBy = type.GetProperty("CREATEDBY");
                propCreatedBy.SetValue(o, currentUser, null);
                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                propUpdatedBy.SetValue(o, currentUser, null);
                SetDateIfNotSet(o, type, now, "CREATED");
                SetDateIfNotSet(o, type, now, "UPDATED");
            }
            foreach (object o in changeSet.Updates)
            {
                Type type = o.GetType();
                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                propUpdatedBy.SetValue(o, currentUser, null);
                PropertyInfo propUpdated = type.GetProperty("UPDATED");
                propUpdated.SetValue(o, now, null);
            }
            foreach (object o in changeSet.Updates.OfType<EFR_REFERRAL>())
            {
                Type type = o.GetType();
                EFR_REFERRAL referral = o as EFR_REFERRAL;
                if (referral != null)
                {
                    if (referral.StatusChanged)
                    {
                        PropertyInfo propUpdatedBy = type.GetProperty("REVIEW_BY");
                        propUpdatedBy.SetValue(o, currentUser, null);
                        PropertyInfo propUpdated = type.GetProperty("REVIEW_DATE");
                        propUpdated.SetValue(o, now, null);
                    }
                }
            }
            //force connection to open
            if (this.Connection.State != ConnectionState.Open)
            {
                this.Connection.Open();
            }
            //SetContextInfo to username
            this.sp_SetContextInfo(currentUser);
            base.SubmitChanges(failureMode);
            //Set Context Info back to empty string
            this.sp_SetContextInfo("");
        }

        private void SetDateIfNotSet(object recordObject, Type recordType, DateTime dateTime, string propertyName)
        {
            PropertyInfo info = recordType.GetProperty(propertyName);
            object value = info.GetValue(recordObject);
            if (!(value is DateTime) || (DateTime)value != default(DateTime))
                return;
            info.SetValue(recordObject, dateTime, null);
        }

        public ITable GetTableWithInheritance(DataContext data, Type type)
        {
            try
            {
                return data.GetTable(type);
            }
            catch
            {
                return GetTableWithInheritance(data, type.BaseType); // error was here
            }
        }
    }
}
