﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class PATIENT
    {
        public string FullName
        {
            get { return _LAST_NAME + ", " + _FIRST_NAME + " " + _MIDDLE_NAME; }
        }

        public string HomeAddress
        {
            get {
                string address = string.Empty;
                if (!string.IsNullOrEmpty(this.ADDRESS_LINE1))
                    address = this.ADDRESS_LINE1;
                if (!string.IsNullOrEmpty(this.ADDRESS_LINE2))
                    address = address + ", " + this.ADDRESS_LINE2;
                if (!string.IsNullOrEmpty(this.ADDRESS_LINE3))
                    address = address + "<Br />" + this.ADDRESS_LINE3;
                if (!string.IsNullOrEmpty(this.CITY))
                    address = address + "<Br />" + this.CITY;
                if (!string.IsNullOrEmpty(this.STATE))
                    address = address + ", " + this.STATE;
                if (!string.IsNullOrEmpty(this.POSTAL_CODE))
                    address = address + " " + this.POSTAL_CODE;

                return address; 
            }
        }

        public string TemporaryAddress
        {
            get
            {
                string address = string.Empty;
                if (this.REGISTRY_DEMOGRAPHICs != null)
                {
                    if (this.REGISTRY_DEMOGRAPHICs.Count > 0)
                    {
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().ADDRESS_LINE1))
                            address = this.ADDRESS_LINE1;
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().ADDRESS_LINE2))
                            address = address + ", " + this.REGISTRY_DEMOGRAPHICs.Last().ADDRESS_LINE2;
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().ADDRESS_LINE3))
                            address = address + "<Br />" + this.REGISTRY_DEMOGRAPHICs.Last().ADDRESS_LINE3;
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().CITY))
                            address = address + "<Br />" + this.REGISTRY_DEMOGRAPHICs.Last().CITY;
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().STATE))
                            address = address + ", " + this.REGISTRY_DEMOGRAPHICs.Last().STATE;
                        if (!string.IsNullOrEmpty(this.REGISTRY_DEMOGRAPHICs.Last().POSTAL_CODE))
                            address = address + " " + this.REGISTRY_DEMOGRAPHICs.Last().POSTAL_CODE;
                    }
                }
                return address;
            }
        }

        public string TemporaryAddressStartDate
        {
            get
            {
                //DateTime beginDate = DateTime.MinValue;
                

                if (this.REGISTRY_DEMOGRAPHICs.Count > 0)
                {
                    if (this.REGISTRY_DEMOGRAPHICs.Last().TEMPORARY_ADDRESS_START_DATE.HasValue)

                        return this.REGISTRY_DEMOGRAPHICs.Last().TEMPORARY_ADDRESS_START_DATE.Value.ToString("d"); 
                    
                }

                return String.Empty; 

            }
        }

        public string TemporaryAddressEndDate
        {
            get
            {
                //DateTime endDate = DateTime.MinValue;
                if (this.REGISTRY_DEMOGRAPHICs.Count > 0)
                {
                    if (this.REGISTRY_DEMOGRAPHICs.Last().TEMPORARY_ADDRESS_END_DATE.HasValue)

                        return this.REGISTRY_DEMOGRAPHICs.Last().TEMPORARY_ADDRESS_END_DATE.Value.ToString("d");

                }

                return String.Empty; 
            }
        }

        public string PcpName
        {
            get
            {
                string name = string.Empty;

                foreach (PRIMARY_CARE_PHYSICIAN pcp in PRIMARY_CARE_PHYSICIANs)
                {
                    if (pcp.PROVIDER != null)
                    {
                        name = name + pcp.PROVIDER.LAST_NAME + ", "
                            + pcp.PROVIDER.FIRST_NAME + " "
                            + pcp.PROVIDER.MIDDLE_NAME + "<br />";
                    }
                }

                return name;
            }
        }
        
        public string Gender
        {
            get
            {
                return this.STD_GENDER.CODE;
            }
        }
        public string PatientPhones
        {
            get
            {
                string phone = string.Empty;
                if (!string.IsNullOrEmpty(this.HOME_PHONE))
                    phone = "H: " + this.HOME_PHONE;
                if (!string.IsNullOrEmpty(this.WORK_PHONE))
                    phone = phone + "<Br />" + "W: " + this.WORK_PHONE;
                if (!string.IsNullOrEmpty(this.CELL_PHONE))
                    phone = phone + "<Br />" + "C: " + this.CELL_PHONE;

                return phone;
            }
        }

        public int Age
        {
            get
            {
                DateTime deathDate = DateTime.MinValue;
                if (this.DEATH_DATE != null)
                    deathDate = (DateTime)this.DEATH_DATE;

                return this.CalculateAge((DateTime)this.BIRTH_DATE, deathDate);
            }
        }

        public string OefOifIndicator
        {
            get
            {
                string indicator = string.Empty;

                if (OEF_OIF_IND != null)
                {
                    if (OEF_OIF_IND.ToString() == "1")
                    {
                        indicator = "Yes";
                    }
                    else if (OEF_OIF_IND.ToString() == "2")
                    {
                        indicator = "No";
                    }
                }
                return indicator;
            }
        }

        public string ServiceSeparationDate
        {
            get
            {
                string date = string.Empty;

                if (LastServiceSeparationDate != null)
                {
                    date = string.Format("{0:d}", LastServiceSeparationDate);                 
                }
                return date;
            }
        }

        #region private properties

        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();
        

        #endregion

        #region Public Properties

        private static int diagCount;
        public int DiagnosticsCount
        {
            get 
            { 
                return this.EFR_ICD9_DIAGs.Count(); 
            }

        }
        /// <summary>
        /// Ref Property containing list of broken business rules.
        /// </summary>
        public ValidationErrorsCollection BrokenRules
        {
            get
            {
                return _BrokenRules;
            }
        }

 
        #endregion

        #region Entity Events

        

        #endregion

       #region Public Methods

 
        #endregion

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();


            //TODO : Add rules

            return 0;
        }

        #endregion

        #region Properties for Validator Controls
   

        #endregion

        #region Private Methods

        private int CalculateAge(DateTime birthDate, DateTime deathDate)
        {
            int years = 0;

            if (birthDate != null)
            {
                // cache the current time
                DateTime now = DateTime.Today; // today is fine, don't need the timestamp from now
                if (deathDate != DateTime.MinValue)
                    now = deathDate;
                // get the difference in years
                years = now.Year - birthDate.Year;
                // subtract another year if we're before the
                // birth day in the current year
                if (now.Month < birthDate.Month || (now.Month == birthDate.Month && now.Day < birthDate.Day))
                    --years;
            }

            return years;
        }

        #endregion

    }

 
}
