﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    public class Institution : BaseBO
    {
        //public List<INSTITUTION_CONTACT> InstitutionContacts;
          
        public Institution() 
        {
            _defaultSortField = "ID";
            
        }
        
        
        private IQueryable<STD_INSTITUTION> LinqAll()
        {
            //populate LinqAll
            return (from e in _db.STD_INSTITUTIONs
                    select e);
                //add all business filtering rules 
        
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {   
            lo.LoadWith<STD_INSTITUTION>(i => i.INSTITUTION_CONTACTs);
            
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }


        #region Methods for Select

        public IEnumerable<STD_INSTITUTION> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            }
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter().Count();
            }
        }

        private IQueryable<STD_INSTITUTION> SelectLinqFilter()
        {
            IQueryable<STD_INSTITUTION> linqFilter = LinqAll();
            return linqFilter;
        }

        #endregion

        #region Methods for SelectByID

        public IEnumerable<STD_INSTITUTION> SelectByID(int id)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectByIDLinqFilter(id).ToList();
            }
        }

        private IQueryable<STD_INSTITUTION> SelectByIDLinqFilter(int id)
        {
            IQueryable<STD_INSTITUTION> linqFilter = LinqAll();
            
            linqFilter = from t in linqFilter where t.ID == id select t;

            return linqFilter;
        }

        #endregion

    }
}
