﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    public enum NotificationStatus
    {
        New = 1,
        InProcess = 2,
        Completed = 3,
    }

    [Serializable()]
    public partial class IM_NOTIFICATION_LETTER
    {
        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();

        public string PatientFullName
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.PATIENT != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.PATIENT.FullName))
                    ret = this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.PATIENT.FullName;

                return ret;
            }
        }

        public string SourceRecallID
        {
            get 
            {
                string ret = String.Empty;

                if (this.IM_RECALL != null && 
                    !string.IsNullOrEmpty(this.IM_RECALL.SOURCE_RECALL_ID))
                    ret = this.IM_RECALL.SOURCE_RECALL_ID;

                return ret;
            }
        }

        public string StationNumber
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION.STATIONNUMBER))
                    ret = this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION.STATIONNUMBER;

                return ret;
            }
        }

        public string Institution
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY != null
                    && this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION.NAME))
                    ret = this.IM_IMPLANT_ITEM.IM_PATIENT_SURGERY.STD_INSTITUTION.NAME;

                return ret;
            }
        }

        public string ImplantItemName
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.IMPLANT_ITEM_NAME))
                    ret = this.IM_IMPLANT_ITEM.IMPLANT_ITEM_NAME;

                return ret;
            }
        }

        public string ImplantManufacturer
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.MANUFACTURER_TEXT))
                    ret = this.IM_IMPLANT_ITEM.MANUFACTURER_TEXT;

                return ret;
            }
        }

        public string ImplantDistributor
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.DISTRIBUTOR_TEXT))
                    ret = this.IM_IMPLANT_ITEM.DISTRIBUTOR_TEXT;

                return ret;
            }
        }

        public string ImplantModel
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.MODEL_NUMBER))
                    ret = this.IM_IMPLANT_ITEM.MODEL_NUMBER;

                return ret;
            }
        }

        public string ImplantLot
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.LOT_NUMBER))
                    ret = this.IM_IMPLANT_ITEM.LOT_NUMBER;

                return ret;
            }
        }

        public string ImplantSerialNumber
        {
            get
            {
                string ret = String.Empty;

                if (this.IM_IMPLANT_ITEM != null
                    && !string.IsNullOrEmpty(this.IM_IMPLANT_ITEM.SERIAL_NUMBER))
                    ret = this.IM_IMPLANT_ITEM.SERIAL_NUMBER;

                return ret;
            }
        }

        public string Subject
        {
            get
            {
                string ret = String.Empty;

                if (this.STD_IM_NOTIFICATION_TYPE != null
                    && !string.IsNullOrEmpty(this.STD_IM_NOTIFICATION_TYPE.NAME)
                    && !string.IsNullOrEmpty(this.STD_IM_NOTIFICATION_TYPE.CODE)
                    && this.STD_IM_NOTIFICATION_TYPE.CODE.ToUpper() != "NULL VALUE")
                    ret = this.STD_IM_NOTIFICATION_TYPE.NAME;

                return ret;
            }
        }

        public string SubjectFull
        {
            get
            {
                string ret = String.Empty;

                if (this.STD_IM_NOTIFICATION_TYPE != null
                    && !string.IsNullOrEmpty(this.STD_IM_NOTIFICATION_TYPE.NAME)
                    && !string.IsNullOrEmpty(this.STD_IM_NOTIFICATION_TYPE.CODE)
                    && this.STD_IM_NOTIFICATION_TYPE.CODE.ToUpper() != "NULL VALUE")
                    if (string.IsNullOrEmpty(this.OTHER_NOTIFICATION_TEXT))
                        ret = this.STD_IM_NOTIFICATION_TYPE.NAME;
                    else
                        ret = this.STD_IM_NOTIFICATION_TYPE.NAME + ": " + this.OTHER_NOTIFICATION_TEXT;

                return ret;
            }
        }

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();


            //TODO : Add rules

            return 0;
        }

        #endregion
    }
}
