﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class IM_IMPLANT_ITEM
    {
        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();

        public string PatientFullName
        {
            get 
            {
                return this.IM_PATIENT_SURGERY.PATIENT.FullName;
            }
        }

        public string SourceRecallID
        {
            get 
            {
                if (this.IM_RECALL.SOURCE_RECALL_ID == null)
                    return String.Empty;
                else
                    return this.IM_RECALL.SOURCE_RECALL_ID;
            }
        }

        public string StationNumber
        {
            get
            {
                if (this.IM_PATIENT_SURGERY.STD_IMPLANT_FACILITY_ID == null)
                    return String.Empty;
                else
                {
                    if (this.IM_PATIENT_SURGERY.STD_INSTITUTION.STATIONNUMBER == null)
                        return String.Empty;
                    else
                        return this.IM_PATIENT_SURGERY.STD_INSTITUTION.STATIONNUMBER;
                }
            }
        }

        public string Institution
        {
            get
            {
                if (this.IM_PATIENT_SURGERY.STD_IMPLANT_FACILITY_ID == null)
                    return String.Empty;
                else
                {
                    if (this.IM_PATIENT_SURGERY.STD_INSTITUTION.NAME == null)
                        return String.Empty;
                    else
                        return this.IM_PATIENT_SURGERY.STD_INSTITUTION.NAME;
                }
            }
        }

        public string RecalledItem
        {
            get
            {
                if (ImplantType == String.Empty)
                {
                    if ((this.IMPLANT_ITEM_NAME == null) || (this.IMPLANT_ITEM_NAME == String.Empty))
                        return String.Empty;
                    else
                        return this.IMPLANT_ITEM_NAME;
                }
                else
                {
                    if ((this.IMPLANT_ITEM_NAME == null) || (this.IMPLANT_ITEM_NAME == String.Empty))
                        return ImplantType;
                    else
                        return ImplantType + ": " + this.IMPLANT_ITEM_NAME;
                }
            }
        }

        public string ImplantType
        {
            get {
                if (this.STD_IM_IMPLANT_TYPE.NAME == null) 
                    return String.Empty;
                else
                    if (this.STD_IM_IMPLANT_TYPE.NAME.ToUpper() == "NULL VALUE")
                        return String.Empty;
                    else
                        return this.STD_IM_IMPLANT_TYPE.NAME;
            }
        }

        public string ImplantDescription
        {
            get
            {
                string results = string.Empty;

                if (!string.IsNullOrEmpty(this.HCPCS_Desc))
                {
                    results = HCPCS_Desc;
                }
                else
                {
                    results = ImplantType;
                }

                return results;

            }
        }

        public string SpecialtyArea
        {
            get 
            {
                if (this.IM_PATIENT_SURGERY.VA_IMPLANT_FLAG)
                {
                    if (this.SPECIALTY_AREA == null)
                        return String.Empty;
                    else
                        return this.SPECIALTY_AREA;
                }
                else
                {
                    if (this.STD_IM_SPECIALTY_AREA.NAME == null)
                        return String.Empty;
                    else
                        return this.STD_IM_SPECIALTY_AREA.NAME;
                }
            }
        }

        public DateTime? ImplantDate
        {
            get { return this.IM_PATIENT_SURGERY.DATE_IMPLANTED; }
        }

        public bool OnAlert
        {
            get { return this.IMPLANT_ALERT_FLAG; }
        }

        public string DeviceStatus
        {
            get
            {
                if (this.IM_IMPLANT_DEVICE_STATUS.Count > 0)

                    return this.IM_IMPLANT_DEVICE_STATUS.First().STD_IM_DEVICE_STATUS_ID != 7 ? this.IM_IMPLANT_DEVICE_STATUS.First().STD_IM_DEVICE_STATUS.NAME : String.Empty;
                    
                else

                    return String.Empty; 
                 
            }
        }

        public string DeviceStatusId
        {
            get
            {
                if (this.IM_IMPLANT_DEVICE_STATUS.Count > 0)
                {
                    return this.IM_IMPLANT_DEVICE_STATUS.First().STD_IM_DEVICE_STATUS_ID != 7 ? this.IM_IMPLANT_DEVICE_STATUS.First().STD_IM_DEVICE_STATUS_ID.ToString() : String.Empty;

                }
                else
                {
                    return String.Empty;

                }
            }            
            
        }

        public bool IsVAImplant
        {
            get { return this.IM_PATIENT_SURGERY.VA_IMPLANT_FLAG; }
        }

        public bool IsNew
        {
            get { return this.ROW_VERSION == null; }
        }

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();


            //TODO : Add rules

            return 0;
        }

        #endregion
    }
}
