﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class ER_ENCOUNTER
    {
        #region private properties

        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();
        
        #endregion

        #region Public Properties

        public string FullVisnName { get; set; }


        /// <summary>
        /// Property to inform if the object is being loaded from a postback.
        /// </summary>
        public bool LoadedWithDisconnectedStateChanges { get; set; }

        /// <summary>
        /// Ref Property containing list of broken business rules.
        /// </summary>
        public ValidationErrorsCollection BrokenRules
        {
            get
            {
                return _BrokenRules;
            }
        }


        #endregion

        #region Entity Events

        

        #endregion

        #region Public Methods


        #endregion

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();

            RuleObjectRelationshipsRequiredReferenceObjects(db);

            RuleConfigurePropertiesForValidatorControls();

            return 0;
        }

  

        private void RuleObjectRelationshipsRequiredReferenceObjects(RegistriesDataAccess db) 
        {
            //Each encounter needs to have: 1 exam and 1 outcome
            if (this.ER_EXAM == null)
            {
                ER_EXAM exam = new ER_EXAM();

                exam.EXAM_DATE = this.VISIT_DATE;

                exam.PATIENT_ID = this.REFERRAL.PATIENT_ID;

                //exam.SetAsInsertOnSubmit();

                this.ER_EXAM = exam;
               
            }

            if (this.ER_OUTCOME == null)
            {
                ER_OUTCOME outcome = new ER_OUTCOME();

                outcome.PATIENT_ID = this.REFERRAL.PATIENT_ID;

                //outcome.SetAsInsertOnSubmit();

                this.ER_OUTCOME = outcome;

            }
        }

        
    

        private void RuleConfigurePropertiesForValidatorControls ()
        {
            
            

        }

  
        #endregion

        #region Properties for Validator Controls

    

        #endregion

        

    }

 
}