﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Data.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;
using VeteransAffairs.Registries.Business.Utilities;

namespace VeteransAffairs.Registries.Business
{
    public enum DVEIRReferralStatus
    {
        DVEIR_REFERRAL = 0,
        DVEIR_NEW = 11,
        DVEIR_IN_PROCESS = 12,
        DVEIR_RETURNED = 21,
        DVEIR_READY_FOR_REVIEW = 13,
        DVEIR_READY_TO_SEND_TO_DVEIR = 14,
        DVEIR_COMPLETED = 15
    }

    public enum DVEIRRoles : int
    {
        Abstractor = 21,
        MedicalProfessional = 24,
        Administrator = 19
    }

    public enum EyeSettingType
    {
        RightEye,
        LeftEye,
        BothEyes
    }

    public enum TabLocationNames
    {
        [StringValue("Provider")]
        Provider,
        [StringValue("Chief Complaint")]
        ChiefComplaint,
        [StringValue("Exam")]
        Exam,
        [StringValue("Diagnosis")]
        Diagnosis,
        [StringValue("Procedures")]
        Procedures
    }


    [Serializable()]
    public partial class DVEIR_REFERRAL
    {
        #region private properties

        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();
        
        //private int _referralStatus;
        

        #endregion

        #region Public Properties

        public bool? OnUpdate_SetAllEncountersToReadyToSend { get; set; }

        public static string GetEyeSettingDisplay(EyeSettingType eyeSettingType)
        {
            switch (eyeSettingType)
            {
                case EyeSettingType.LeftEye:
                    return "Left Eye";
                    break;
                case EyeSettingType.RightEye:
                    return "Right Eye";
                    break;
                case EyeSettingType.BothEyes:
                    return "Both Eyes";
                    break;
                default:
                    return "";
                    break;
            }
        }

        public static string GetEyeSettingDatabaseField(EyeSettingType eyeSettingType)
        {
                string _eyeSettingField = "";

                switch (eyeSettingType)
                {
                    case EyeSettingType.LeftEye:
                        _eyeSettingField = "LEFT_FLAG";
                        break;

                    case EyeSettingType.RightEye:
                        _eyeSettingField = "RIGHT_FLAG";
                        break;

                    case EyeSettingType.BothEyes:
                        _eyeSettingField = "BOTH_EYES";
                        break;
                }

                return _eyeSettingField;
        }
       
        //public DVEIR_REFERRAL()
        //{
         
        //}

        //public List<ER_ENCOUNTER_REVIEWCOMMENT> ReviewComments { get; set; }


        /// <summary>
        /// Property to inform if the object is being loaded from a postback.
        /// </summary>
        public bool LoadedWithDisconnectedStateChanges { get; set; }

        /// <summary>
        /// Ref Property containing list of broken business rules.
        /// </summary>
        public ValidationErrorsCollection BrokenRules
        {
            get
            {
                return _BrokenRules;
            }
        }


        #endregion

        #region Entity Events

        

        #endregion

        #region Public Methods


        #endregion

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();

            RuleObjectRelationshipsRequiredReferenceObjects(db);

            RuleConfigurePropertiesForValidatorControls();

            RuleSetItemAsNotNew(SavingData,db);

            return 0;
        }

        private void RuleSetItemAsNotNew(bool SavingData, RegistriesDataAccess db)
        {
            
            //if an item is saved then it is no longer new so move to pending if status is new
            if (SavingData && this.STD_REFERRALST != null && this.STD_REFERRALST.CODE == "DVEIR_NEW")
            {
                //Check if any actual changes will occur
                ChangeSet changeSet = db.GetChangeSet();

                if (changeSet.Deletes.Count > 0 || changeSet.Inserts.Count > 0
                    || changeSet.Updates.Count > 0)
                {
                    this.STD_REFERRALST = (from stat in db.STD_REFERRALSTs where stat.CODE == "DVEIR_IN_PROCESS" select stat).FirstOrDefault();

                    STD_WKFACTIVITYTYPE activityType = (from a in db.STD_WKFACTIVITYTYPEs where a.CODE == "DVEIR EDITED REFERRAL" select a).FirstOrDefault();

                    STD_WKFACTIVITYST activityStatus = (from s in db.STD_WKFACTIVITYSTs where s.CODE == "COMPLETED" select s).FirstOrDefault();

                    WKF_CASE_ACTIVITY activity = new WKF_CASE_ACTIVITY();

                    activity.STD_WKFACTIVITYTYPE = activityType;

                    activity.STD_WKFACTIVITYST = activityStatus;

                    activity.REPRESENTATIVE_NAME = "";

                    //activity.SetAsInsertOnSubmit();
                    //db.WKF_CASE_ACTIVITies.InsertOnSubmit(activity);

                    this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Add(activity);
                }
            }
        }

        private void RuleObjectRelationshipsRequiredReferenceObjects(RegistriesDataAccess db) 
        {
            //DVEIR Referral requires 1 Workflow Case
            if (this.WKF_CASEs.Count() == 0)
            {
                WKF_CASE wkCase = new WKF_CASE();
                wkCase.CASE_NUMBER = string.Empty;

                wkCase.STD_WKFCASEST =
                    (from caseStatus in db.STD_WKFCASESTs where caseStatus.CODE == "NEW" select caseStatus).FirstOrDefault();

                wkCase.PATIENT =
                    (from patient in db.PATIENTs where patient.PATIENT_ID == this.PATIENT_ID select patient).FirstOrDefault();

                wkCase.STD_WKFCASETYPE =
                    (from wkType in db.STD_WKFCASETYPEs where wkType.CODE == "DVEIR WORKFLOW" select wkType).FirstOrDefault();

                //wkCase.SetAsInsertOnSubmit();
                //db.WKF_CASEs.InsertOnSubmit(wkCase);

                this.WKF_CASEs.Add(wkCase);
            }
            
        }

        
    

        private void RuleConfigurePropertiesForValidatorControls ()
        {
            
            

        }

  
        #endregion

        #region Properties for Validator Controls

    

        #endregion

        

    }

 
}