﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class ANALYSIS_DETAIL
    {
        public const int TestNameStandardized = 4;
        public const int TestNameMassSpec = 6;
        public const int TestNameConcentration = 7;
        public const int TestNameCreatinine = 8;
        public const int TestNameRatioU235U238 = 9;

        public string SortByLabResults
        {
            get 
            {
                string result = string.Empty;

                switch ((int) STD_TEST_NAME_ID)
                {
                    case TestNameCreatinine:
                        result = "2" + ANALYTE_NAME;
                        break;
                    case TestNameMassSpec:
                        result = "3" + ANALYTE_NAME;
                        break;
                    case TestNameStandardized:
                        result = "4" + ANALYTE_NAME;
                        break;
                    case TestNameConcentration:
                        result = "1" + ANALYTE_NAME;
                        break;
                    case TestNameRatioU235U238:
                        result = "3" + "Uranium" + "2";
                        break;
                    default:
                        result = "9" + ANALYTE_NAME;
                        break;
                }

                return result;            
            }
        }
    }
}
