(function () {
    // Namespace Variables
    var Xrm = window.parent.Xrm;
    var veteran = Xrm.Page.getAttribute("customerid").getValue();
    var reason = Xrm.Page.getAttribute("ftp_reasonforrequest").getValue();
    var otherControl = Xrm.Page.getControl("ftp_otherreason");
    var height = 385;   // gets changed throughout loading and event handling based on different scenarios
    var multipleRfrId = "156db634-ee0d-e511-8108-00155d14711e";
    var otherRfrId = "136db634-ee0d-e511-8108-00155d14711e";
    //var parentLookup = Xrm.Page.getAttribute("parentcaseid").getValue();
    var grouped = Xrm.Page.getAttribute("ftp_grouped").getValue();
    Xrm.Page.getControl("ftp_reasonforrequest").clearNotification();

    // If reason is other show the other control, else hide it (on load)
    if (reason != null && reason[0].id.toString().replace(/[{}]/g, "").toLowerCase() == otherRfrId) {
        otherControl.setVisible(true);
        otherControl.setRequiredLevel("required");
    } else {
        otherControl.setVisible(false);
        otherControl.setRequiredLevel("none");
    }

    /// <summary>
    /// This angular module at a high level does the following (in order):
    /// 1) Gets Reasons for Request
    /// 2) Establishes a inter-controller connector (MySharedService)
    /// 3) Builds the Reason for Request controller
    /// 4) Gets Pact Role Names
    /// 5) Gets the Pact Id associated with the Veteran
    /// 6) Assembles a Pact Members object array
    /// 7) Adds the Pact Team to the beginning of the object array
    /// 8) Builds the Assignment controller
    /// 9) Executes the Addendum controller
    /// </summary>
    angular.module('RequestAssignment', [])
    .factory('pRoles', function () {
        // Retrieve the PACT Role Metadata
        var entityMetadata = SDK.Metadata.RetrieveEntity(
                SDK.Metadata.EntityFilters.Attributes,
                "systemuser",
                null,
                false
        );
        var AttributeMetadata;
        $(entityMetadata.Attributes).each(function () {
            if (this.SchemaName.toLowerCase() == "ftp_pactrole") {
                AttributeMetadata = this;
                return false;
            }
        });
        return AttributeMetadata;
    })
    .factory('pID', [function () {
        var _pID;
        //debugger;
//alert(veteran[0].id);
var vetid=veteran[0].id;
var nobracket=vetid.replace(/({|})/g,'');
        var pID = REST.SYNC.retrieveRecordSync(nobracket.toLowerCase(), "Contact", "ftp_PACTId", null);
        _pID = pID.ftp_PACTId.Id;
//alert("pID =" + _pID);
        return _pID;
    }])
    .factory('pMembers', ['pID', 'pRoles',
        function (pID, pRoles) {
            var _pMembers = [];
            var systemUsers = REST.SYNC.retrieveMultipleRecordsSync("SystemUser", "$select=SystemUserId,FullName,ftp_PACTRole,ftp_PACTSortOrder&$filter=ftp_PACTId/Id eq guid'" + pID + "'&$orderby=ftp_PACTSortOrder");
            var systemUserResults = systemUsers.results;
debugger;
            // for each PACT associated system user find their pact role and then add user id, full name, pact role, and logical name to the pMembers array
            $(systemUserResults).each(function () {
                var $this = this;
                $(pRoles.OptionSet.Options).each(function () {
                    if (this.Value == $this.ftp_PACTRole.Value) {
                        $this.ftp_PACTRole = " " + this.Label.UserLocalizedLabel.Label;
                        return false;
                    }
                });
                if (typeof this.ftp_PACTRole != "string") this.ftp_PACTRole = "";
                _pMembers.push({ Id: this.SystemUserId, Text: this.FullName + this.ftp_PACTRole, LogicalName: "systemuser" });
            });
            return _pMembers;
        }
    ])
    .factory('pTeam', ['pID',
        function (pID) {
            debugger;
            var _pTeam = [];
            var pTeam = REST.SYNC.retrieveRecordSync(pID, "ftp_pact", "ftp_Team", null);
var ph= REST.SYNC.retrieveMultipleRecordsSync("Team", "?$filter=Name eq 'Pharmacy'");
//var ta = REST.SYNC.retrieveMultipleRecordsSync("Team", "?$filter=Name eq 'TAN'");
var pharm={ Id: ph.results[0].TeamId, Text: ph.results[0].Name, LogicalName: "team"};
//var tan={ Id: ta.results[0].TeamId, Text: ta.results[0].Name, LogicalName: "team"};
            qTeam = { Id: pTeam.ftp_Team.Id, Text: pTeam.ftp_Team.Name, LogicalName: "team" };
            _pTeam.push(qTeam);
            _pTeam.push(pharm);
           // _pTeam.push(tan);
//alert(_pTeam);

            return _pTeam;
        }
    ])
    .factory('mySharedService', function ($rootScope) {
        // view this in debugger once for clarity, it's kind of weird.
        var sharedService = {};

        sharedService.message = '';

        sharedService.prepForBroadcast = function (msg) {
            this.message = msg;
            this.broadcastItem();
        };

        sharedService.broadcastItem = function () {
            $rootScope.$broadcast('handleBroadcast');
        };

        return sharedService;
    })
    .factory('rfrs',
        function () {
            var _rfrs = [];
            var rfrLookups = REST.SYNC.retrieveMultipleRecordsSync("ftp_reasonforrequest", "$select=ftp_reason,ftp_reasonforrequestId&$orderby=ftp_reason asc");
            for (var i = 0; i < rfrLookups.results.length; i++) {
                _rfrs.push({
                    text: rfrLookups.results[i].ftp_reason,
                    id: rfrLookups.results[i].ftp_reasonforrequestId
                });
            }
            return _rfrs;
        }
    )
    .controller('RfrController', ['rfrs', 'mySharedService',
        function (rfrs, mySharedService) {
            // convert #mySelect to a select2 control using rfrs as the datasource
            $("#mySelect").select2({
                placeholder: "--",
                data: rfrs,
                allowClear: true
            });

            // if there is a selected reason, set #mySelect to it on load
            if (reason != null) {
                var selected = [reason[0].id.toString().replace(/[{}]/g, "").toLowerCase()];
                $("#mySelect").select2("val", selected);
            }

            // When an option is selected in #mySelect
            $("#mySelect").on("select2:select", function () {
                var selected = $("#mySelect").select2("data");  // store all the data associated with the selected option
                var selectedId = selected[0].id.toString().replace(/[{}]/g, "").toLowerCase();  // store a cleaned selected id

                // If the selected option is other show the other control, otherwise hide it
                if (selected != null && selectedId == otherRfrId) {
                    otherControl.setVisible(true);
                    otherControl.setRequiredLevel("required");
                } else {
                    otherControl.setVisible(false);
                    otherControl.setRequiredLevel("none");
                }

                // if the selected option is not multiple reasons for request set the priority to the value associated with the reason
                if (selected != null && selectedId != multipleRfrId) {
                    debugger;
                    var reasonForRequest = REST.SYNC.retrieveRecordSync(selectedId, "ftp_reasonforrequest", "ftp_Priority", null);
                    Xrm.Page.getAttribute("ftp_priority").setValue(reasonForRequest.ftp_Priority.Value);
                }

                Xrm.Page.getAttribute("ftp_reasonforrequest").setValue([{ id: selected[0].id, name: selected[0].text, entityType: "ftp_reasonforrequest" }]);
                mySharedService.prepForBroadcast(selectedId);   // send the selectedid to the addendum controller for processing
            });

            // When #mySelect is opened
            $("#mySelect").on("select2:open", function () {
                // if the web resource is too small, temporarily increase the size to display #mySelect properly
                //*if ($("#mySelect").select2("val") != multipleRfrId) $('.ms-crm-FormSection-Container:first-of-type', window.parent.document).height(385);

                // Fix for backspace button in search menu
                $(".select2-search__field").keydown(function (event) {
                    event.stopImmediatePropagation();
                    if (event.keyCode == 8 && this.value != "") {
                        this.value = this.value.slice(0, -1);
                        return false;
                    }
                });
            });

            // When #mySelect is closed
            $("#mySelect").on("select2:close", function () {
                // If the selected value is multiple set the container to the global height, otherwise use a smaller collapsed height to limit white space
                if ($("#mySelect").select2("val") == multipleRfrId) {
                    //*$('.ms-crm-FormSection-Container:first-of-type', window.parent.document).height(height);
                }
                else {
                    //*$('.ms-crm-FormSection-Container:first-of-type', window.parent.document).height(210);
                }
            });

            // Utilize fireOnDisable (because IE is not a modern browser) to disable the rfrControl if on a readonly CRM form, or if it's a grouped request
            if (Xrm.Page.ui.getFormType() == 3 || Xrm.Page.ui.getFormType() == 4 || grouped) {
                $('#mySelect').fireOnDisable().select2();
                $('#mySelect').prop('disabled', true);
            }
        }
    ])
    .controller('AssignController', ['pMembers', 'pTeam',
        function (pMembers, pTeam) {
debugger;
            var assignCtrl = this;
//alert(pMembers);
            // Build the Assign Request ddl
            assignCtrl.assignees = pMembers;
//alert(assignCtrl.assignees[0]);
            assignCtrl.assignees.unshift(pTeam[0]);
            assignCtrl.assignees.push(pTeam[1]);
            //assignCtrl.assignees.push(pTeam[2]);
//alert(assignCtrl.assignees[0]);
            assignCtrl.selected = assignCtrl.assignees[0];

            assignCtrl.submit = function () {
                // Fill hidden field with value and update; the plugin handles assignment
                Xrm.Page.getAttribute("ftp_assignment").setValue(assignCtrl.selected.Id + "|" + assignCtrl.selected.LogicalName);
                Xrm.Page.data.refresh(true);
            };

            // Disable the AssignController if on a readonly CRM form
            if (Xrm.Page.ui.getFormType() == 3 || Xrm.Page.ui.getFormType() == 4) {
                $(".col2").children().prop('disabled', true);
            }
        }
    ])
    .controller('AddendumController', ['pMembers', 'rfrs', '$scope', 'mySharedService',
        function (pMembers, rfrs, $scope, mySharedService) {
            var addendumCtrl = this;
            var reasonLookup = Xrm.Page.getAttribute("ftp_reasonforrequest").getValue();

            // Watch the height div containing all addendum parts
            $scope.$watch(function () { return $(".footer").height() }, function (newValue, oldValue) {
                // if we have an addendum div check whether the div has gotten larger or smaller and adjust the web resource container size
                if ($scope.visible) {
                    var offset = (newValue - oldValue);
                    // Sometimes the offsets are rediculously large pos/neg numbers for no reason.
                    if (offset > 50) return;
                    if (offset < -50) return;
                    height += (offset);
                    //*$('.ms-crm-FormSection-Container:first-of-type', window.parent.document).height(height);
                }
            });

            // build an array of reasons from the reason for request field, not including Multiple Reasons for Request
            addendumCtrl.reasons = [];
            $.each(rfrs, function () {
                if (this.id != multipleRfrId && this.id != "") addendumCtrl.reasons.push(this);
            });

            // on load if there's a reasonforrequest on the CRM form assign it to the addendumctrl selectedreasonid
            addendumCtrl.selectedReasonId = reasonLookup != null ? reasonLookup[0].id.replace(/[{}]/g, "").toLowerCase() : "";

            // on load if the selected reason is multiple make the controller visible, otherwise hide it and set the web resource container size to the minimized value
            if (addendumCtrl.selectedReasonId == multipleRfrId) {
                $scope.visible = true;
            } else {
                $scope.visible = false;
                //*$('.ms-crm-FormSection-Container:first-of-type', window.parent.document).height(210);
            }

            // If the reason for request was changed to multiple show the addendum control, otherwise hide it
            $scope.$on('handleBroadcast', function () {
                addendumCtrl.selectedReasonId = mySharedService.message;
                addendumCtrl.selectedReasonId == multipleRfrId ? $scope.visible = true : $scope.visible = false;
                $scope.$apply();
            });

            addendumCtrl.owners = pMembers;
            addendumCtrl.reasons.owner = null;
            addendumCtrl.other = "";

            // Handles the submit event and performs validation
            addendumCtrl.submit = function () {
                var validOwner = true;
                var submit = [];
                $(addendumCtrl.reasons).each(function () {
                    if (this.checked) {
                        var myText;
                        if (typeof (this.owner) == 'undefined') {
                            validOwner = false;
                            return false;
                        }
                        this.id == otherRfrId ? myText = addendumCtrl.other : myText = this.text;
                        submit.push({ id: this.id, text: myText, owner: this.owner });
                        this.checked = false;
                    }
                });

                // Groupby owner id as an object array
                var groups = _.toArray(_.groupBy(submit, function (x) {
                    return x.owner.Id;
                }));

                var strLengthExceeded = false;

                // Go through the object array, if the request text exceeds the title maxlength then set our flag which is subsequently picked up in an alert
                $(groups).each(function () {
                    var txt = "";
                    $(this).each(function () {
                        txt += " " + this.text;
                        if (txt.length > 450) {
                            strLengthExceeded = true;
                            return false;
                        }
                    });
                    if (strLengthExceeded) return false;
                });
				//debugger;
				//var one = addendumCtrl.addendumForm.repeatForm.$valid;
				//var two = addendumCtrl.addendumForm.$valid;
				//var three = validOwner;
				//removed check for valid form -!addendumCtrl.addendumForm.$valid- need to add check statement
                if (!addendumCtrl.addendumForm.repeatForm.$valid || !validOwner) {
                    $("#validatemsg").text('Validation Failed: Please ensure all assignment fields are filled out');
                }
                else if (strLengthExceeded) {
                    $("#validatemsg").text('Validation Failed: Grouped user has too many addendum. Please assign fewer or disperse to other PACT Members');
                }
                else {
					
                    Xrm.Page.getAttribute("ftp_addendumstore").setValue(angular.toJson(submit));
var aStore= Xrm.Page.getAttribute("ftp_assignment").getValue();
                                        var a = Xrm.Page.getAttribute("ftp_addendumstore");
                    Xrm.Page.data.refresh(true);
                    Xrm.Page.getAttribute("ftp_addendumstore").setValue("");
                    $("#validatemsg").text('');
                }
            };
            addendumCtrl.reasons.checked = false;
            addendumCtrl.columns = [];
            addendumCtrl.columnCount = 3;
            addendumCtrl.colWidthPercent = Math.floor(1 / addendumCtrl.columnCount * 100);
            var itemsPerColumn = Math.ceil(addendumCtrl.reasons.length / addendumCtrl.columnCount);
            height += (itemsPerColumn - 8) * 30;
            for (var i = 0; i < addendumCtrl.reasons.length; i += itemsPerColumn) {
                var col = { start: i, end: Math.min(i + itemsPerColumn, addendumCtrl.reasons.length) };
                addendumCtrl.columns.push(col);
            }
            if (Xrm.Page.ui.getFormType() == 3 || Xrm.Page.ui.getFormType() == 4) {
                $(".footer").children().prop('disabled', true);
            }
        }
    ])
    .filter('slice', function () {
        return function (arr, start, end) {
            return arr.slice(start, end);
        };
    });
})();


