﻿using Microsoft.Xrm.Sdk;
using Microsoft.Crm.Sdk.Messages;
using System;
using System.ServiceModel;
using System.Collections;
using System.Linq;
using Newtonsoft.Json;
using System.Collections.Generic;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Metadata;
using VA.FTP2.Plugins.Helpers;
using Xrm;

namespace VA.FTP2.Plugins.Request
{
    class RequestUpdatePreStageRunner : MCSPlugins.PluginRunner
    {
        #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public RequestUpdatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion


        internal void Execute(IServiceProvider serviceProvider)
        {
            ITracingService tracingService =
                (ITracingService)serviceProvider.GetService(typeof(ITracingService));


            if (!PluginExecutionContext.InputParameters.Contains("Target") ||
                    !(PluginExecutionContext.InputParameters["Target"] is Entity)) return;
            try
            {
                tracingService.Trace("Reached first try method");
                var target = GetPrimaryEntity();
                tracingService.Trace("target set");
                var preImage = PluginExecutionContext.PreEntityImages["PreImage"];
                tracingService.Trace("preImage set");
                if (target.Contains("ftp_reasonforrequest")) SetSingleRequestPriority(target);
                tracingService.Trace("target contains reason for request");
                if (target.Contains("stageid")) ServiceStageStatusCodeMapping(target);
                tracingService.Trace("target contains stage id");
                if (target.Contains("ftp_addendumstore")&&target["ftp_addendumstore"].ToString()!=string.Empty && PluginExecutionContext.Depth<2) HandleAddendum(target, preImage);
                tracingService.Trace("passed handle addendum");
                if (target.Contains("ftp_assignment")) AssignRequest(target);
                tracingService.Trace("assigned request");
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
            catch (Exception ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
        }

        private void  SetSingleRequestPriority(Entity target)
        {

            // get reason for request lookup
            EntityReference reasonForRequestField = (EntityReference)target["ftp_reasonforrequest"];
            
            //if rfr is not multiple, update priority
            if (reasonForRequestField.Id.ToString() != "156db634-ee0d-e511-8108-00155d14711e")  //maps to Multiple Reasons for Request
            {
                OptionSetValue priorityOptionValue = PluginHelper.GetPriority(reasonForRequestField, OrganizationService);
                //Set priority value based on reason for request priority 
                if (priorityOptionValue != null)
                {
                    target["ftp_priority"] = priorityOptionValue;
                }
            }
            //if rfr is multiple, do nothing
        }

        private void AssignRequest(Entity target)
        {
            var assignment = (string)(target["ftp_assignment"]);
            var array = assignment.Split('|');

            AssignRequest assign = new AssignRequest
            {
                Assignee = new EntityReference(array[1],
                    new Guid(array[0])),
                Target = new EntityReference(target.LogicalName,
                    target.Id)
            };

            OrganizationService.Execute(assign);
        }

        public class owner
        {
            public string Id { get; set; }
            public string Text { get; set; }
            public string LogicalName { get; set; }
        }

        public class Addendum
        {
            public string id { get; set; }
            public string text { get; set; }
            public owner owner { get; set; }
        }

        /// <summary>
        /// When reasons are flagged as processed, this method groups 
        /// and creates child requests using data stored in hidden fields by ReasonsForRequest.js
        /// </summary>
        /// <param name="target"></param>
        /// <param name="preImage"></param>
        private void HandleAddendum(Entity target, Entity preImage)
        {
            var requests = new EntityCollection();
            List<Addendum> addendumList = JsonConvert.DeserializeObject<List<Addendum>>((String)(target["ftp_addendumstore"]));

            using (var xrm = new XrmServiceContext(OrganizationService))
            {
                foreach (Addendum a in addendumList)
                {
                    var reasonLookup = new EntityReference("ftp_reasonforrequest", new Guid(a.id));
                    var request = new Entity("incident");
                    var ownerRef = new EntityReference(a.owner.LogicalName, new Guid(a.owner.Id));

                    var matchedRequest =
                        xrm.IncidentSet.FirstOrDefault(
                            x => x.OwnerId == ownerRef && x.ParentCaseId == target.ToEntityReference());

                    if (matchedRequest != null)
                    {
                        request.Id = matchedRequest.Id;
                        request["title"] = matchedRequest.Title + " / " + a.text;

                        var currentPriority = matchedRequest.ftp_Priority;
                        var addendumReasonForRequest = xrm.ftp_reasonforrequestSet.FirstOrDefault(x => x.Id == reasonLookup.Id);
                        var addendumPriority = new OptionSetValue();
                        if (addendumReasonForRequest != null)
                        {
                            addendumPriority = addendumReasonForRequest.ftp_Priority;
                        }

                        if (currentPriority.Value != addendumPriority.Value)
                        {
                            if (PluginHelper.ComparePriorityValues(xrm, addendumPriority, currentPriority))
                            {
                                request["ftp_priority"] = addendumPriority;
                            }
                        }

                        OrganizationService.Update(request);

                        var parentRequest =
                            xrm.IncidentSet.FirstOrDefault(x => x.IncidentId == matchedRequest.ParentCaseId.Id);
                        if (parentRequest != null && parentRequest.ftp_Priority.Value!=addendumPriority.Value)
                        {
                            if (PluginHelper.ComparePriorityValues(xrm, addendumPriority, parentRequest.ftp_Priority))
                            {
                                parentRequest.ftp_Priority = addendumPriority;
                                xrm.UpdateObject(parentRequest);
                                xrm.SaveChanges();
                            }
                        }
                    }
                    else
                    {
                        request["ownerid"] = ownerRef;
                        request["customerid"] = preImage["customerid"];
                        request["parentcaseid"] = target.ToEntityReference();
                        request["ftp_reasonforrequest"] = reasonLookup;
                        request["title"] = a.text;
                        request["ftp_callbacknumber"] = preImage["ftp_callbacknumber"];
                        requests.Entities.Add(request);
                    }
                }
            }

            //  Group the child requests by PACT Member
            var groups = requests.Entities.GroupBy(x => x["ownerid"]);
            foreach (var group in groups)
            {
                // if we have a group of reasons for one PACT Member, create one child request with each reason in the title and a rfr of Multiple Reasons
                if (group.Count() > 1)
                {
                    var createEntity = group.First();
                    var title = "";
                    int optionIndex = 0;
                    OptionMetadata[] optionList;
                    using (var xrm = new XrmServiceContext(OrganizationService))
                    {
                        optionList = PluginHelper.GetOptionList("ftp_priority", xrm);   
                    }
                    int[] optionValueList = new int[optionList.Length];

                    for (int i = 0; i < optionList.Length; i++)
                    {
                        optionValueList[i] = (int) optionList[i].Value;
                    }

                    foreach (var r in group)
                    {
                        title = (title == "") ? (string)r["title"] : string.Concat(title, " / ", r["title"]);
                        var childPriority = PluginHelper.GetPriority((EntityReference)r.Attributes["ftp_reasonforrequest"], OrganizationService);

                        optionIndex = optionList.Select(optionMetadata => Array.IndexOf(optionValueList, (int) childPriority.Value)).Concat(new[] {optionIndex}).Max();
                    }
                    createEntity["title"] = title;
                    createEntity["ftp_grouped"] = true;
                    createEntity["ftp_priority"] = new OptionSetValue(optionValueList[optionIndex]);
                    createEntity["ftp_reasonforrequest"] = preImage["ftp_reasonforrequest"];
                    OrganizationService.Create(createEntity);
                }
                else
                {
                    // otherwise, create a nongrouped child request
                    OrganizationService.Create(group.First());
                }
            }
        }

        /// <summary>
        /// When the Request stage changes we map the status reason to the stageid
        /// </summary>
        /// <param name="target"></param>
        private void ServiceStageStatusCodeMapping(Entity target)
        {
            var stageId = (Guid)target["stageid"];
            var statusCode = new OptionSetValue();
            switch (stageId.ToString().ToUpper())
            {
                // Identify / New    
                case "15322A8F-67B8-47FB-8763-13A28686C29D":
                    statusCode.Value = 1;
                    break;
                // Propose / Acknowledged
                case "60CB4C39-D46B-C4EB-20AB-3C162E1BE671":
                    statusCode.Value = 2;
                    break;
                default:
                    return;
            }
            target["statuscode"] = statusCode;
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_requestplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
    }
}
