﻿using Microsoft.Xrm.Sdk;
using System;

namespace VA.FTP2.Plugins.Request
{
    class RequestSetStatePreStageRunner : MCSPlugins.PluginRunner
    {
         #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public RequestSetStatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            if (PluginExecutionContext.MessageName == "Close")
            {
                if (PluginExecutionContext.InputParameters.Contains("IncidentResolution") &&
                  PluginExecutionContext.InputParameters["IncidentResolution"] is Entity)
                {
                    var resolution = (Entity)PluginExecutionContext.InputParameters["IncidentResolution"];
                    var requestRef = (EntityReference)resolution["incidentid"];
                    var updateEntity = new Entity { Id = requestRef.Id, LogicalName = requestRef.LogicalName };
                    updateEntity["ftp_end"] = DateTime.UtcNow;
                    OrganizationService.Update(updateEntity);
                }
            }

            if (PluginExecutionContext.MessageName == "SetStateDynamicEntity")
            {
                if (PluginExecutionContext.InputParameters.Contains("EntityMoniker") &&
                PluginExecutionContext.InputParameters["EntityMoniker"] is EntityReference)
                {
                    var state = (OptionSetValue)PluginExecutionContext.InputParameters["State"];
                    Entity updateEntity = GetPrimaryEntity();

                    // if deactivating the record set the end to today
                    if (state.Value == 0) return;
                    updateEntity["ftp_end"] = DateTime.UtcNow;
                    OrganizationService.Update(updateEntity);
                }
            }
            
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_requestplugins"; }
        }

        /// <summary>
        /// Converts the EntityMoniker to a shell entity
        /// </summary>
        /// <returns></returns>
        public override Entity GetPrimaryEntity()
        {
            var eRef = (EntityReference)PluginExecutionContext.InputParameters["EntityMoniker"];
            var primaryEntity = new Entity(eRef.LogicalName);
            primaryEntity.Id = eRef.Id;
            return primaryEntity;
        }

        public override Entity GetSecondaryEntity()
        {
            return null;
        }
    }
}
