﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;

namespace VA.FTP2.Plugins.Request
{
    class RequestClosePostStageRunner : MCSPlugins.PluginRunner
    {
         #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public RequestClosePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            if (PluginExecutionContext.Depth == 1)
            {
                if (PluginExecutionContext.MessageName == "Close")
                {
                    if (PluginExecutionContext.InputParameters.Contains("IncidentResolution") &&
                      (PluginExecutionContext.InputParameters["IncidentResolution"] is Entity))
                    {
                        var resolution = (Entity)PluginExecutionContext.InputParameters["IncidentResolution"];
                        var entityRef = (EntityReference)resolution["incidentid"];
                        var columns = new ColumnSet("incidentid", "incidentstagecode", "masterid", "numberofchildincidents", "parentcaseid", "statecode", "statuscode", "servicestage", "title");
                        var originalEntity = OrganizationService.Retrieve(entityRef.LogicalName, entityRef.Id, columns);
                        if (originalEntity.Attributes.ContainsKey("parentcaseid"))
                        {
                            var parentCaseEntityReference = (EntityReference)(originalEntity["parentcaseid"]);
                            if (parentCaseEntityReference != null && parentCaseEntityReference.Id != null)
                            {
                                var parentCase = OrganizationService.Retrieve("incident", parentCaseEntityReference.Id, columns);
                                // check for statecode = Open for the Parent Case
                                if (((OptionSetValue)parentCase.Attributes["statecode"]).Value == 0)
                                {
                                    var siblingCasesQuery = new QueryByAttribute
                                    {
                                        ColumnSet = columns,
                                        EntityName = "incident"
                                    };
                                    siblingCasesQuery.AddAttributeValue("parentcaseid", parentCaseEntityReference.Id);
                                    var siblings = OrganizationService.RetrieveMultiple(siblingCasesQuery);
                                    var allClosed = true;
                                    foreach (var sibling in siblings.Entities)
                                    {
                                        // check for statecode = Closed
                                        if (((OptionSetValue)sibling["statecode"]).Value != 1)
                                        {
                                            allClosed = false;
                                            break;
                                        }
                                    }

                                    if (allClosed)
                                    {
                                        var incidentResolution = new Entity("incidentresolution");
                                        incidentResolution["subject"] = "Automatically closed due to All Addendum Closed";
                                        incidentResolution["incidentid"] = parentCaseEntityReference;
                                        var closeIncidentRequest = new CloseIncidentRequest
                                        {
                                            IncidentResolution = incidentResolution,
                                            Status = new OptionSetValue((int)incident_statuscode.Complete)
                                        };
                                        OrganizationService.Execute(closeIncidentRequest);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_requestplugins"; }
        }

        /// <summary>
        /// Converts the EntityMoniker to a shell entity
        /// </summary>
        /// <returns></returns>
        public override Entity GetPrimaryEntity()
        {
            var eRef = (EntityReference)PluginExecutionContext.InputParameters["EntityMoniker"];
            var primaryEntity = new Entity(eRef.LogicalName);
            primaryEntity.Id = eRef.Id;
            return primaryEntity;
        }

        public override Entity GetSecondaryEntity()
        {
            return null;
        }
    }
}
