﻿using MCSPlugins;
using Microsoft.Xrm.Sdk;
using System;

namespace VA.FTP2.Plugins.Patient
{
    public class PatientUpdatePreStageRunner : PluginRunner
    {
        public PatientUpdatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }

        internal void Execute()
        {
            TracingService.Trace("at the top");
            Logger.setMethod = "Execute";
            //start the timing for the plugin
            Logger.WriteTxnTimingMessage(String.Format("Starting : {0}", GetType()));
            Logger.WriteDebugMessage(String.Format("At the top of: {0}", GetType()));

            var target = GetPrimaryEntity();
            target.Attributes.Clear();
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_veteranplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
    }
}
