﻿using MCSPlugins;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using Newtonsoft.Json;
using Xrm;

namespace VA.FTP2.Plugins.Patient
{
    public class PatientRetrievePostStageRunner : PluginRunner
    {
        public PatientRetrievePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }

        private const string Target = "Target";

        public class MviPatient
        {
            public string crme_FirstName { get; set; }
            public string crme_LastName { get; set; }
            public string crme_SSN { get; set; }
            public string crme_Alias { get; set; }
            public string crme_DeceasedDate { get; set; }
            public string crme_EDIPI { get; set; }
            public string crme_FullAddress { get; set; }
            public string crme_FullName { get; set; }
            public string crme_Gender { get; set; }
            public string crme_IdentityTheft { get; set; }
            public string crme_MiddleName { get; set; }
            public string crme_PrimaryPhone { get; set; }
            public string crme_ParticipantID { get; set; }
            public string crme_DOBString { get; set; }
        }

        internal void Execute()
        {
                TracingService.Trace("at the top");
                Logger.setMethod = "Execute";
                //start the timing for the plugin
                Logger.WriteTxnTimingMessage(String.Format("Starting : {0}", GetType()));
                Logger.WriteDebugMessage(String.Format("At the top of: {0}", GetType()));

            // Determine if this is a recursive call
            // If recursive, return so that CRM will do the retrive from CRM
            if (PluginExecutionContext.ParentContext != null)
                return;
            
            Entity patient = (Entity)PluginExecutionContext.OutputParameters["BusinessEntity"];

            if (PluginExecutionContext.SharedVariables.Contains("data"))
            {
                var strData = PluginExecutionContext.SharedVariables["data"];
                var data = JsonConvert.DeserializeObject<MviPatient>(strData.ToString());
                patient["firstname"] = data.crme_FirstName;
                patient["lastname"] = data.crme_LastName;
                patient["middlename"] = data.crme_MiddleName;
                patient["ftp_edipi"] = data.crme_EDIPI;
                patient["ftp_dateofbirth"] = data.crme_DOBString;
                patient["ftp_mobilephone"] = data.crme_PrimaryPhone;
                patient["address1_composite"] = data.crme_FullAddress;
                patient["governmentid"] = data.crme_SSN;
            }

            Logger.WriteGranularTimingMessage("Finish Retrieve of Person(s)");
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_veteranplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

    }
}

