﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.ServiceModel;

namespace VA.FTP2.Plugins.ActionTaken
{
    class ActionTakenCreatePreStageRunner : MCSPlugins.PluginRunner
    {
        #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public ActionTakenCreatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            if (!PluginExecutionContext.InputParameters.Contains("Target") ||
                    !(PluginExecutionContext.InputParameters["Target"] is Entity)) return;
            try
            {
                var target = GetPrimaryEntity();
                target["ftp_name"] = McsHelper.getStringOptionSetValue("ftp_title");
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
            catch (Exception ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_actiontakenplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
    }
}
