﻿/// <reference path='../../triipcrm_/TR_KU_V2015_2_902/js/jquery.min.js' />
/// <reference path='../../triipcrm_/TR_KU_V2015_2_902/js/kendo.all.min.js' />
/// <reference path="SampleXmlData.js" />

//ServConnDisabilitiesGridScriptLib.js
//Contains variables and functions used by the ServConnDisabilitiesGrid.html page

function scdg_getQueryVariable(scdg_variable) {
    try {
        //Get a Query Variable
        var scdg_query = window.location.search.substring(1);
        var scdg_vars = scdg_query.split('&');
        for (var i = 0; i < scdg_vars.length; i++) {
            var scdg_pair = scdg_vars[i].split('=');
            if (scdg_pair[0] == scdg_variable) {
                return scdg_pair[1];
            }
        }
        //alert('A required Query Variable: ' + scdg_variable + ' is missing!');
        return '';
    }
    catch (err) {
        alert("Service Connected Disabilities Grid Web Resource Function Error(scdg_getQueryVariable): " + err.message);
    }
}

function scdg_getDisabilityData(scdg_nationalId) {
    try {
        var scdg_eesummaryURL = 'https://URL/WebParts/api/eesummary/1.0/xml/ftpCRM/000000' + scdg_nationalId + '000000';
        var scdg_xmlData = null;
jQuery.support.cors = true;
debugger;
        $.ajax({
            type: "GET",
            crossDomain: true,
            url: scdg_eesummaryURL,
            contentType: "application/xml; charset=utf-8",
            dataType: "text",
            success: function (xmlTextdata) {
                scdg_xmlData = xmlTextdata;
            },
            error: function (jqXHR, textStatus, errorThrown) {
                //System Error
                scdg_xmlData = null;
            },
            async: false,
            cache: false
        });
        return scdg_xmlData;
    }
    catch (err) {
        alert("Service Connected Disabilities Grid Web Resource Function Error(scdg_getDisabilityData): " + err.message);
        return null;
    }
}

function scdg_FormLoad() {
    try {
        //Get the passed nationalid variable
        var scdg_xrmdata = scdg_getQueryVariable("data");
        //alert('XrmData: ' + scdg_xrmdata);
        if (scdg_xrmdata == null || scdg_xrmdata == '') { return false; }

        //Get the service connected disabilities data from the web service
        var scdg_disabilitiesXmlData = scdg_getDisabilityData(scdg_xrmdata);

        //Temporary action: xml result is empty, use sample data
        //**********************************************************************************************************************
        //if (scdg_disabilitiesXmlData == null || scdg_disabilitiesXmlData == '') { scdg_disabilitiesXmlData = xml_results3; }
        //**********************************************************************************************************************

        //Define Grids
        //Define the main grid
        $('#ku_disabilitygrid').kendoGrid({
            columns: [
                { field: 'ID', type: 'string', hidden: true },
                { field: 'type', title: 'Eligibility', type: 'string', width: 150 },
                { field: 'enrollmentCategoryName', title: 'Status', type: 'string', width: 120 },
                { field: 'ratedDisabilityPercentageTotal', title: 'SC% (total)', type: 'string', width: 120 },
                { field: 'envContaminantsInd', title: 'Environmental Contaminant', type: 'string', width: 120 },
                { field: 'radiationExposureInd', title: 'Radiation Exposure', type: 'string', width: 120 },
                { field: 'agentOrangeInd', title: 'Agent Orange', type: 'string', width: 120 },
                { field: 'campLejeuneInd', title: 'Camp Lejeune', type: 'string', width: 120 },
            ],
            dataSource: {
                schema: {
                    model: {
                        id: 'ID'
                    }
                }
            },
            groupable: false,
            sortable: false,
            editable: false,
            height: 120,
            resizable: true,
            navigatable: true,
            selectable: false,
            noRecords: true
        });
        //Define the detail grid
        $('#ku_disabilitydetailgrid').kendoGrid({
            columns: [
                { field: 'ID', type: 'string', hidden: true },
                { field: 'disability', title: 'Individual Disability', type: 'string', width: 300 },
                { field: 'percentage', title: 'SC%', type: 'string', width: 120 },
            ],
            dataSource: {
                schema: {
                    model: {
                        id: 'ID'
                    }
                }
            },
            groupable: false,
            sortable: false,
            editable: false,
            height: 200,
            resizable: true,
            navigatable: true,
            selectable: false,
            noRecords: true
        });

        //Create disabilty grid datasource
        var scdg_disabilityGrid = $('#ku_disabilitygrid').data('kendoGrid');
        //Create disabilty detail grid datasource
        var scdg_disabilitydetailGrid = $('#ku_disabilitydetailgrid').data('kendoGrid');

        //Search XML values
        scdg_xmlDoc = $.parseXML(scdg_disabilitiesXmlData);
        $scdg_xml = $(scdg_xmlDoc);

        //Data from parentnode 'enrollmentDeterminationInfo' 
        var $scdg_enrollmentDeterminationInfo = null;
        var $scdg_primaryEligibility = null;
        var $scdg_type = null;
        var scdg_typeText = null;
        var $scdg_enrollmentCategoryName = null;
        var scdg_enrollmentCategoryNameText = null;
        var $scdg_specialFactors = null;
        var $scdg_envContaminantsInd = null;
        var scdg_envContaminantsIndText = null;
        var $scdg_radiationExposureInd = null;
        var scdg_radiationExposureIndText = null;
        var $scdg_agentOrangeInd = null;
        var scdg_agentOrangeIndText = null;
        var $scdg_campLejeuneInd = null;
        var scdg_campLejeuneIndText = null;
        var $scdg_serviceConnectionAward = null;
        var $scdg_serviceConnectedPercentage = null;
        var scdg_serviceConnectedPercentageText = null;
        var $scdg_ratedDisabilities = null;

        var scdg_ratedDisabilityPercentageTotal = 0;

        var scdg_detailrowcount = 0;

        $scdg_enrollmentDeterminationInfo = $scdg_xml.find('enrollmentDeterminationInfo');
        if ($scdg_enrollmentDeterminationInfo != null) {
            $scdg_primaryEligibility = $scdg_enrollmentDeterminationInfo.find('primaryEligibility');
            if ($scdg_primaryEligibility != null) {
                $scdg_type = $scdg_primaryEligibility.find('type');
                if ($scdg_type != null) { scdg_typeText = $scdg_type.text(); }
            }

            $scdg_enrollmentCategoryName = $scdg_enrollmentDeterminationInfo.find('enrollmentCategoryName');
            if ($scdg_enrollmentCategoryName != null) { scdg_enrollmentCategoryNameText = $scdg_enrollmentCategoryName.text(); }

            $scdg_specialFactors = $scdg_enrollmentDeterminationInfo.find('specialFactors');
            if ($scdg_specialFactors != null) {
                $scdg_envContaminantsInd = $scdg_specialFactors.find('envContaminantsInd');
                if ($scdg_envContaminantsInd != null) { scdg_envContaminantsIndText = $scdg_envContaminantsInd.text(); }
                $scdg_radiationExposureInd = $scdg_specialFactors.find('radiationExposureInd');
                if ($scdg_radiationExposureInd != null) { scdg_radiationExposureIndText = $scdg_radiationExposureInd.text(); }
                $scdg_agentOrangeInd = $scdg_specialFactors.find('agentOrangeInd');
                if ($scdg_agentOrangeInd != null) { scdg_agentOrangeIndText = $scdg_agentOrangeInd.text(); }
                $scdg_campLejeuneInd = $scdg_specialFactors.find('campLejeuneInd');
                if ($scdg_campLejeuneInd != null) { scdg_campLejeuneIndText = $scdg_campLejeuneInd.text(); }
            }

            $scdg_serviceConnectionAward = $scdg_enrollmentDeterminationInfo.find('serviceConnectionAward');
            if ($scdg_serviceConnectionAward != null) {
                $scdg_serviceConnectedPercentage = $scdg_serviceConnectionAward.find('serviceConnectedPercentage');
                if ($scdg_serviceConnectedPercentage != null) { scdg_serviceConnectedPercentageText = $scdg_serviceConnectedPercentage.text(); }
                $scdg_ratedDisabilities = $scdg_serviceConnectionAward.find('ratedDisabilities');
                //Get each disability listed
                $scdg_ratedDisabilities.find('ratedDisability').each(function () {
                    var scdg_ratedDisabilityPercent = 0;
                    var scdg_disability = null;
                    if (Number($(this).find('percentage').text()) > 0) {
                        scdg_ratedDisabilityPercentageTotal = scdg_ratedDisabilityPercentageTotal + Number($(this).find('percentage').text());
                        scdg_ratedDisabilityPercent = Number($(this).find('percentage').text());
                    }
                    //Add to detail grid
                    scdg_detailrowcount = scdg_detailrowcount + 1;
                    scdg_disabilitydetailGrid.dataSource.pushCreate({
                        ID: scdg_detailrowcount,
                        disability: $(this).find('disability').text(),
                        percentage: scdg_ratedDisabilityPercent
                    });
                });
            }
        }

        //If no eligibility specified, set to false
        if (scdg_typeText == null || scdg_typeText == '') { scdg_typeText = false; }

        //Change boolean values to false if not marked true
        if (scdg_envContaminantsIndText != 'true') { scdg_envContaminantsIndText = false; }
        if (scdg_radiationExposureIndText != 'true') { scdg_radiationExposureIndText = false; }
        if (scdg_agentOrangeIndText != 'true') { scdg_agentOrangeIndText = false; }
        if (scdg_campLejeuneIndText != 'true') { scdg_campLejeuneIndText = false; }

        //Update disability main grid data
        scdg_disabilityGrid.dataSource.pushCreate({
            ID: '01',
            type: scdg_typeText,
            enrollmentCategoryName: scdg_enrollmentCategoryNameText,
            ratedDisabilityPercentageTotal: scdg_serviceConnectedPercentageText,
            envContaminantsInd: scdg_envContaminantsIndText,
            radiationExposureInd: scdg_radiationExposureIndText,
            agentOrangeInd: scdg_agentOrangeIndText,
            campLejeuneInd: scdg_campLejeuneIndText
        });

        //Hide the details grid if the SC% total = 0
        if (scdg_ratedDisabilityPercentageTotal == 0 || scdg_ratedDisabilityPercentageTotal == null || scdg_ratedDisabilityPercentageTotal == '') {
            $('#ku_disabilitydetailgrid').hide();
        }

    }
    catch (err) {
        alert("Service Connected Disabilities Grid Web Resource Function Error(scdg_FormLoad): " + err.message);
    }
}