﻿using Microsoft.Xrm.Sdk;
using System;
using Microsoft.Xrm.Sdk.Query;
using VRMRest.WebApi;

namespace VRM.VEFT.Plugins
{
    public class VEFTInteractionStatusChange : IPlugin
    {
        private string _dacUriString = null;
        private Uri _dacUri = null;
        private WebServiceDetails _dacWsd = null;

        private String UName = null;
        private String PW = null;
        private String URL = null;

        public void Execute(IServiceProvider serviceProvider)
        {
            IOrganizationServiceFactory OrganizationServiceFactory = (IOrganizationServiceFactory)serviceProvider.GetService(typeof(IOrganizationServiceFactory));
            IPluginExecutionContext PluginExecutionContext = (IPluginExecutionContext)serviceProvider.GetService(typeof(IPluginExecutionContext));
            IOrganizationService OrganizationService = OrganizationServiceFactory.CreateOrganizationService(PluginExecutionContext.UserId);

            var entity = PluginExecutionContext.PostEntityImages["entity"];
            var surveyID = entity.GetAttributeValue<int>("ftp_surveyid_num").ToString();
            var status = entity.FormattedValues["statuscode"].ToString();
            var caseID = entity.FormattedValues["ftp_caseguid_text"].ToString();

            if ((status == "Assigned" || status == "Inactive") && (surveyID != null || caseID != null))
            {
                //var serviceCredentialRecord = OrganizationService.Retrieve("mcs_setting", new Guid("{00000000-0000-0000-0000-000000000000}"), new ColumnSet("ftp_medalliaapilogin", "ftp_medalliaapipassword"));
                QueryByAttribute querybyexpression = new QueryByAttribute("mcs_setting");
                querybyexpression.ColumnSet = new ColumnSet("ftp_medalliaapilogin", "ftp_medalliaapipassword", "ftp_medalliaapiurl");
                querybyexpression.Attributes.AddRange("mcs_name");
                querybyexpression.Values.AddRange("Active Settings");
                EntityCollection retrieved = OrganizationService.RetrieveMultiple(querybyexpression);

                foreach (var c in retrieved.Entities)
                {
                    UName = c.Attributes["ftp_medalliaapilogin"].ToString();
                    PW = c.Attributes["ftp_medalliaapipassword"].ToString();
                    URL = c.Attributes["ftp_medalliaapiurl"].ToString();
                }
                _dacUri = getVIMTURI(OrganizationService);

                UpdateStatusRequest request = new UpdateStatusRequest()
                {

                    SurveyID = surveyID,
                    CaseID = caseID,
                    Status = status

                };

                _dacWsd = new WebServiceDetails()
                {
                    TargetURL = _dacUriString,
                    WSUserName = UName,
                    Password = PW
                };
                try
                {
                    var response = WebApiUtility.SendReceive<UpdateStatusResponse>(_dacUri, "MedalliaUpdateStatusRequest", request, null, _dacWsd);
                    //Do Something with Response
                }
                catch (Exception ex)
                {
                    throw new InvalidPluginExecutionException(string.Format("Exception occurred while transmitting to DAC Server: {0}", ex.Message));
                }
            }
        }

        private Uri getVIMTURI(IOrganizationService organizationService)
        {
            try
            {
                Uri baseURI = null;
                if (URL != null)
                {
                    _dacUriString = URL;
                    if (_dacUriString != null)
                        baseURI = new Uri(_dacUriString);
                    if (baseURI == null)
                        throw new InvalidPluginExecutionException("No VIMT URL value found in settings entity. Please confirm settings are correctly configured.");
                }
                return baseURI;
            }
            catch (Exception ex)
            {
                throw new InvalidPluginExecutionException(string.Format("Exception occurred while reading settings entity: {0}\n\nPlease confirm settings entity exists in this environment.", ex.Message));
            }
        }
    }
    public class UpdateStatusRequest
    {
        public string SurveyID { get; set; }
        public string CaseID { get; set; }
        public string Status { get; set; }
        public string MessageID {get; set;}
    }

    public class UpdateStatusResponse
    {
        public string SurveyId { get; set; }
        public bool ExceptionOccurred { get; set; }
        public string ExceptionMessage { get; set; }
    }
}