﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Runtime.InteropServices;
using System.Security;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Crm.UnifiedServiceDesk.CommonUtility;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics.Utilities;
using Microsoft.Uii.Desktop.SessionManager;
using Microsoft.Uii.Csr;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Tooling.CrmConnectControl;
using Microsoft.Xrm.Tooling.CrmConnectControl.Utility;
using Microsoft.Uii.AifServices;
using Microsoft.Uii.Desktop.Cti.Core;
using Microsoft.Crm.UnifiedServiceDesk.BaseControl;

namespace VRM.VCCM.USD.Utilities
{
    /// <summary>
    /// Interaction logic for USDControl.xaml
    /// This is a base control for building Unified Service Desk Aware add-ins
    /// See USD API documentation for full API Information available via this control.
    /// </summary>
    public partial class UserSecurity : DynamicsBaseHostedControl
    {
        #region Vars
        /// <summary>
        /// Log writer for USD 
        /// </summary>
        private TraceLogger LogWriter = null;
        private Helper _helper;
        private EntityCollection _allUserPrivileges = new EntityCollection();
        private EntityCollection _allUserRoles = new EntityCollection();
        private EntityCollection _allUserTeams = new EntityCollection();

        #endregion

        /// <summary>
        /// UII Constructor 
        /// </summary>
        /// <param name="appID">ID of the application</param>
        /// <param name="appName">Name of the application</param>
        /// <param name="initString">Initializing XML for the application</param>
        public UserSecurity(Guid appID, string appName, string initString)
            : base(appID, appName, initString)
        {
            InitializeComponent();

            // This will create a log writer with the default provider for Unified Service desk
            LogWriter = new TraceLogger();
            _helper = new Helper();

            #region Enhanced LogProvider Info
            // This will create a log writer with the same name as your hosted control. 
            // LogWriter = new TraceLogger(traceSourceName:"MyTraceSource");

            // If you utilize this feature,  you would need to add a section to the system.diagnostics settings area of the UnifiedServiceDesk.exe.config
            //<source name="MyTraceSource" switchName="MyTraceSwitchName" switchType="System.Diagnostics.SourceSwitch">
            //    <listeners>
            //        <add name="console" type="System.Diagnostics.DefaultTraceListener"/>
            //        <add name="fileListener"/>
            //        <add name="USDDebugListener" />
            //        <remove name="Default"/>
            //    </listeners>
            //</source>

            // and then in the switches area : 
            //<add name="MyTraceSwitchName" value="Verbose"/>

            #endregion

        }

        /// <summary>
        /// Raised when the Desktop Ready event is fired. 
        /// </summary>
        protected override void DesktopReady()
        {
            // this will populate any toolbars assigned to this control in config. 
            PopulateToolbars(ProgrammableToolbarTray);
            base.DesktopReady();
        }

        /// <summary>
        /// Raised when an action is sent to this control
        /// </summary>
        /// <param name="args">args for the action</param>
        protected override void DoAction(Microsoft.Uii.Csr.RequestActionEventArgs args)
        {
            _helper.InitializeCrmConnection();//just in case.

            // Log process.
            LogWriter.Log(string.Format(CultureInfo.CurrentCulture, "{0} -- DoAction called for action: {1}", this.ApplicationName, args.Action), System.Diagnostics.TraceEventType.Information);

            #region Example process action
            //// Process Actions. 
            //if (args.Action.Equals("your action name", StringComparison.OrdinalIgnoreCase))
            //{
            //    // Do some work

            //    // Access CRM and fetch a Record
            //Microsoft.Xrm.Sdk.Messages.RetrieveRequest req = new Microsoft.Xrm.Sdk.Messages.RetrieveRequest();
            //req.Target = new Microsoft.Xrm.Sdk.EntityReference("account", Guid.Parse("0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5"));
            //req.ColumnSet = new Microsoft.Xrm.Sdk.Query.ColumnSet("accountid", "name");
            //Microsoft.Xrm.Sdk.Messages.RetrieveResponse response = (Microsoft.Xrm.Sdk.Messages.RetrieveResponse)this._client.CrmInterface.ExecuteCrmOrganizationRequest(req, "Requesting Account"); 


            //    // Example of pulling some data out of the passed in data array
            //    List<KeyValuePair<string, string>> actionDataList = Utility.SplitLines(args.Data, CurrentContext, localSession);
            //    string valueIwant = Utility.GetAndRemoveParameter(actionDataList, "mykey"); // asume there is a myKey=<value> in the data. 



            //    // Example of pushing data to USD
            //    string global = Utility.GetAndRemoveParameter(actionDataList, "global"); // Assume there is a global=true/false in the data
            //    bool saveInGlobalSession = false;
            //    if (!String.IsNullOrEmpty(global))
            //        saveInGlobalSession = bool.Parse(global);

            //    Dictionary<string, CRMApplicationData> myDataToSet = new Dictionary<string, CRMApplicationData>();
            //    // add a string: 
            //    myDataToSet.Add("myNewKey", new CRMApplicationData() { name = "myNewKey", type = "string", value = "TEST" });

            //    // add a entity lookup:
            //    myDataToSet.Add("myNewKey", new CRMApplicationData() { name = "myAccount", type = "lookup", value = "account,0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5,MyAccount" }); 

            //    if (saveInGlobalSession) 
            //    {
            //        // add context item to the global session
            //        ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(this.ApplicationName, myDataToSet, true);
            //    }
            //    else
            //    {
            //        // Add context item to the current session. 
            //        ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(this.ApplicationName, myDataToSet, true);
            //    }
            //}
            #endregion

            switch (args.Action)
            {
                case "CopyUserRolesToReplacementParameters":
                    CopyUserRolesToReplacementParameters(args);
                    break;
                case "CopyUserTeamsToReplacementParameters":
                    CopyUserTeamsToReplacementParameters(args);
                    break;
                case "GatherUserSecurityInfo":
                    string paramUserId = GetFieldFromArgs(args, "userid");
                    Guid userId = new Guid();
                    if (!string.IsNullOrEmpty(paramUserId))
                    {
                        try
                        {
                            userId = new Guid(paramUserId);
                        }
                        catch (Exception ex)
                        {
                            throw new Exception("Could not parse string into proper CRM GUID. Example value: userid=[[$User.systemuserid]]");
                        }
                    }
                    else
                    {
                        userId = _helper.service.GetMyCrmUserId();
                    }
                    if (userId != Guid.Empty)
                    {
                        _allUserPrivileges = _helper.GetAllUserPrivileges(userId);
                        _allUserRoles = _helper.GetUserRoles(userId);
                        _allUserTeams = _helper.GetUserTeams(userId);
                    }
                    break;
                case "UserHasPrivilege":
                    UserHasPrivilege(args);
                    break;
                case "CopyCredentialToReplacementParameters":
                    /*
                     * Args:
                     * name
                     * value
                     * */                    
                    CopyCredentialToReplacementParameters(args);
                    break;
                case "RetrieveCredentials":
                    RetrieveCredentials(args);
                    break;
                case "ClearCredentials":
                    ClearCredentials(args);
                    break;
                default:
                    AlertUnsupportedAction(args);
                    break;
            }

            base.DoAction(args);
        }

        /// <summary>
        /// Raised when a context change occurs in USD
        /// </summary>
        /// <param name="context"></param>
        public override void NotifyContextChange(Microsoft.Uii.Csr.Context context)
        {
            base.NotifyContextChange(context);
        }


        #region User Code Area
        private Dictionary<string, int> PrivilegeDepthMapping = new Dictionary<string, int>()
        {
            {"BASIC", 1},
            {"LOCAL", 2},
            {"DEEP", 4},
            {"GLOBAL", 8}
        };
        private bool UserHasPrivilege(RequestActionEventArgs args)
        {
            bool hasPrivilege = false;

            #region validate action call parameters
            string paramUserId = GetFieldFromArgs(args, "userid");
            Guid userId = new Guid();
            if (!string.IsNullOrEmpty(paramUserId))
            {
                try
                {
                    userId = new Guid(paramUserId);
                }
                catch (Exception ex)
                {
                    throw new Exception("Could not parse string into proper CRM GUID. Example value: userid=[[$User.systemuserid]]");
                }
            }
            else
            {
                userId = _helper.service.GetMyCrmUserId();
            }
            string privilegeName = GetFieldFromArgs(args, "privilege");
            if (string.IsNullOrEmpty(privilegeName))
            {
                throw new Exception("Must provide a valid privilege name, such as privilege=prvReadContact");
            }
            string pDepth = GetFieldFromArgs(args, "depth");
            #endregion

            int mappedDepthValue = 0;
            if (!string.IsNullOrEmpty(pDepth) &&
                !string.Equals(pDepth, "BASIC", StringComparison.CurrentCultureIgnoreCase) &&
                !string.Equals(pDepth, "LOCAL", StringComparison.CurrentCultureIgnoreCase) &&
                !string.Equals(pDepth, "DEEP", StringComparison.CurrentCultureIgnoreCase)
                && !string.Equals(pDepth, "GLOBAL", StringComparison.CurrentCultureIgnoreCase)
            )
            {
                throw new Exception("Must use a valid privilege depth, such as depth=BASIC [LOCAL, DEEP, GLOBAL]");
            }
            mappedDepthValue = string.IsNullOrEmpty(pDepth) ? 0 : PrivilegeDepthMapping[pDepth.ToUpper()];

            string refresh = GetFieldFromArgs(args, "refresh");
            refresh = refresh == null ? "" : refresh;

            string datumName = string.IsNullOrEmpty(pDepth) ? privilegeName : privilegeName + "_" + pDepth.ToUpper();
            Entity foundPrivilege = new Entity();
            if (refresh.ToLower() != "true")
            {
                try
                {
                    foreach(Entity thisPrivilege in _allUserPrivileges.Entities){
                        if((string)thisPrivilege["name"] == privilegeName && ((int)((AliasedValue)thisPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value) >= mappedDepthValue){
                            if(!foundPrivilege.Contains("RoleHasPrivilege.privilegedepthmask")){
                                foundPrivilege = thisPrivilege;
                            }
                            else{
                                if(((int)((AliasedValue)thisPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value) > ((int)((AliasedValue)foundPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value)){
                                    foundPrivilege = thisPrivilege;
                                }
                            }
                        }
                    }
                    if (foundPrivilege.Id != Guid.Empty)
                    {
                        hasPrivilege = true;
                    }
                }
                catch (Exception ex)
                {
                    //no match throws an InvalidOperationException 'Sequence contains no matching element'
                    hasPrivilege = false;
                }
            }
            else
            {
                EntityCollection matchingUserPrivileges = new EntityCollection();
                matchingUserPrivileges = string.IsNullOrEmpty(pDepth) ? _helper.GetSpecificUserPrivilege(userId, privilegeName) : _helper.GetSpecificUserPrivilege(userId, privilegeName, mappedDepthValue);
                
                try
                {
                    foreach (Entity thisPrivilege in matchingUserPrivileges.Entities)
                    {
                        if (((int)((AliasedValue)thisPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value) >= mappedDepthValue)
                        {
                            if (!foundPrivilege.Contains("RoleHasPrivilege.privilegedepthmask"))
                            {
                                foundPrivilege = thisPrivilege;
                            }
                            else
                            {
                                if (((int)((AliasedValue)thisPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value) > ((int)((AliasedValue)foundPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value))
                                {
                                    foundPrivilege = thisPrivilege;
                                }
                            }
                        }
                    }
                    if (foundPrivilege.Id != Guid.Empty)
                    {
                        hasPrivilege = true;
                    }
                }
                catch (Exception ex)
                {
                    //no match throws an InvalidOperationException 'Sequence contains no matching element'
                    hasPrivilege = false;
                }
            }

            string datumValue = !string.IsNullOrEmpty(pDepth) ? hasPrivilege.ToString() :
                foundPrivilege.Contains("RoleHasPrivilege.privilegedepthmask") ? ((int)((AliasedValue)foundPrivilege["RoleHasPrivilege.privilegedepthmask"]).Value).ToString() : "0";
            PushDatumToUSD(datumName, datumValue, "string", this.ApplicationName, true); //create replacement parameter of [[UserSecurity.<privilegeName>_<DEPTH>]]=<hasPrivilege.ToString()>
            return hasPrivilege;
        }
        private void CopyUserRolesToReplacementParameters(RequestActionEventArgs args)
        {
            string concatRoleList = "";
            string refresh = GetFieldFromArgs(args, "refresh");
            refresh = refresh == null ? "" : refresh;
            if (!(_allUserRoles.Entities.Count > 0 && refresh.ToLower() != "true"))
            {
                string paramUserId = GetFieldFromArgs(args, "userid");
                Guid userId = new Guid();
                if (!string.IsNullOrEmpty(paramUserId))
                {
                    try
                    {
                        userId = new Guid(paramUserId);
                    }
                    catch (Exception ex)
                    {
                        throw new Exception("Could not parse string into proper CRM GUID. Example value: userid=[[$User.systemuserid]]");
                    }
                }
                else
                {
                    userId = _helper.service.GetMyCrmUserId();
                }
                _allUserRoles = _helper.GetUserRoles(userId); ;
            }
            foreach (Entity thisRole in _allUserRoles.Entities)
            {
                concatRoleList += thisRole["name"] + "___";
            }
            PushDatumToUSD("UserRoles", concatRoleList, "string", this.ApplicationName, true);
        }
        private void CopyUserTeamsToReplacementParameters(RequestActionEventArgs args)
        {
            string concatTeamList = "";
            string refresh = GetFieldFromArgs(args, "refresh");
            refresh = refresh == null ? "" : refresh;
            if (!(_allUserTeams.Entities.Count > 0 && refresh.ToLower() != "true"))
            {
                string paramUserId = GetFieldFromArgs(args, "userid");
                Guid userId = new Guid();
                if (!string.IsNullOrEmpty(paramUserId))
                {
                    try
                    {
                        userId = new Guid(paramUserId);
                    }
                    catch (Exception ex)
                    {
                        throw new Exception("Could not parse string into proper CRM GUID. Example value: userid=[[$User.systemuserid]]");
                    }
                }
                else
                {
                    userId = _helper.service.GetMyCrmUserId();
                }
                _allUserTeams = _helper.GetUserTeams(userId);
            }
            foreach (Entity thisTeam in _allUserTeams.Entities)
            {
                concatTeamList += thisTeam["name"] + "___";
            }
            PushDatumToUSD("UserTeams", concatTeamList, "string", this.ApplicationName, true);
        }
        private void CopyCredentialToReplacementParameters(RequestActionEventArgs args)
        {
            string credentialName = GetFieldFromArgs(args, "name");
            string credentialValue = GetFieldFromArgs(args, "value");
            if (string.IsNullOrEmpty(credentialName))
            {
                throw new Exception("'name' is a required parameter");
            }
            if (string.IsNullOrEmpty(credentialValue))
            {
                throw new Exception("'value' is a required parameter");
            }
            PushDatumToUSD(credentialName, credentialValue, "string", this.ApplicationName, true);
        }

        #region helper functions
        private void RetrieveCredentials(RequestActionEventArgs args)
        {
            string appName = GetFieldFromArgs(args, "appName");
            if (appName == "$System")
            {
                try
                {
                    CrmConnectionManager cm = new CrmConnectionManager();
                    cm.UseUserLocalDirectoryForConfigStore = true;
                    cm.HostApplicatioNameOveride = "USD";
                    PushDataToUSD
                    (
                        new Dictionary<string, CRMApplicationData>()
				        {
					        { "CRMUserName", new CRMApplicationData() { name = "CRMUserName", value = cm.LoadConfigFromFile()[Dynamics_ConfigFileServerKeys.CrmUserName].ToString(), type = "string" } },
					        { "CRMPassword", new CRMApplicationData() { name = "CRMPassword", value = Marshal.PtrToStringUni(Marshal.SecureStringToGlobalAllocUnicode((SecureString)cm.LoadConfigFromFile()[Dynamics_ConfigFileServerKeys.CrmPassword])), type = "string" } },
					        { "CRMDomain", new CRMApplicationData() { name = "CRMDomain", value = cm.LoadConfigFromFile()[Dynamics_ConfigFileServerKeys.CrmDomain].ToString(), type = "string" } }
				        },
                        "Credentials",
                        true
                    );
                    Marshal.ZeroFreeGlobalAllocUnicode(Marshal.SecureStringToGlobalAllocUnicode((SecureString)cm.LoadConfigFromFile()[Dynamics_ConfigFileServerKeys.CrmPassword]));
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
        }
        private void ClearCredentials(RequestActionEventArgs args)
        {
            List<LookupRequestItem> lri = new List<LookupRequestItem>();
            DynamicsCustomerRecord custRec = (DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer;
            if (custRec != null)
            {
                //custRec.AddReplaceableParameter("Credentials", lri);
                custRec.ClearReplaceableParameter("Credentials");
            }
        }
        private void AlertUnsupportedAction(RequestActionEventArgs args)
        {
            throw new Exception("Action, '" + args.Action + "', is not supported or implemented.");
        }
        public string GetFieldFromArgs(RequestActionEventArgs args, string key)
        {
            List<KeyValuePair<string, string>> parameters = Utility.SplitLines(args.Data, CurrentContext, localSessionManager);
            return Utility.GetAndRemoveParameter(parameters, key);
        }
        public void PushDatumToUSD(string pKey, string pValue, string pType, string pAppName, bool pGlobal)
        {
            pType = "string";
            if (!String.IsNullOrEmpty(pKey) && !String.IsNullOrEmpty(pValue) && !String.IsNullOrEmpty(pType))
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;
                //string global = Utility.GetAndRemoveParameter(actionDataList, "global"); // Assume there is a global=true/false in the data
                //bool saveInGlobalSession = false;
                //if (!String.IsNullOrEmpty(global)) saveInGlobalSession = bool.Parse(global);

                Dictionary<string, CRMApplicationData> newData = new Dictionary<string, CRMApplicationData>();
                // add a string: 
                newData.Add(pKey, new CRMApplicationData() { name = pKey, value = pValue, type = pType.ToLower() });

                // add a entity lookup:
                //newData.Add("myNewKey", new CRMApplicationData() { name = "myAccount", type = "lookup", value = "account,0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5,MyAccount" });

                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
            }
        }
        public void PushDataToUSD(Dictionary<string, CRMApplicationData> pData, string pAppName, bool pGlobal)
        {
            //perform data translation into a Dictionary object before calling this function
            if (pData.Count > 0)
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;
                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
            }
        }
        #endregion
        #endregion
    }
}
