﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Security;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Crm.UnifiedServiceDesk.CommonUtility;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics.Utilities;
using Microsoft.Uii.Desktop.SessionManager;
using Microsoft.Uii.Csr;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Uii.AifServices;
using Microsoft.Crm.UnifiedServiceDesk.BaseControl;

namespace VRM.VCCM.USD.Utilities
{
    class Helper
    {

        public CrmServiceClient service;

        public Helper()
        {
            InitializeCrmConnection();
        }

        public void InitializeCrmConnection()
        {
            if (service == null)
            {
                ICrmUtilityHostedControl crmConnectionService = AifServiceContainer.Instance.GetService<ICrmUtilityHostedControl>();
                if (crmConnectionService != null && crmConnectionService.CrmInterface != null && crmConnectionService.CrmInterface.IsReady)
                {
                    service = crmConnectionService.CrmInterface;

                }
            }
        }

        public EntityCollection GetUserRoles(Guid pUserId)
        {
            EntityCollection allUserRoles = new EntityCollection();

            #region gather directly-assigned roles
            EntityCollection rolesAssignedToUser = new EntityCollection();
            QueryExpression userRoleQuery = new QueryExpression("role")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("role", "systemuserroles", "roleid", "roleid", JoinOperator.Inner){
                        LinkEntities = {
                            new LinkEntity("systemuserroles", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner){
                                LinkCriteria = {
                                    Conditions = {
                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                    }
                                }
                            }
                        }
                    }
                }
            };
            try
            {
                rolesAssignedToUser = service.RetrieveMultiple(userRoleQuery);
                if (rolesAssignedToUser.Entities.Count > 0)
                {
                    allUserRoles.Entities.AddRange(rolesAssignedToUser.Entities);
                }
            }
            catch (Exception ex)
            {
                return allUserRoles;
            } 
            #endregion

            #region gather roles from user's teams
            EntityCollection rolesViaTeamMembership = new EntityCollection();
            QueryExpression userTeamRoleQuery = new QueryExpression("role")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("role", "teamroles", "roleid", "roleid", JoinOperator.Inner){
                        LinkEntities = {
                            new LinkEntity("teamroles", "team", "teamid", "teamid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("team", "teammembership", "teamid", "teamid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("teammembership", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner)
                                            {
                                                LinkCriteria = 
                                                {
                                                    Conditions = {
                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };
            try
            {
                rolesViaTeamMembership = service.RetrieveMultiple(userTeamRoleQuery);
                if (rolesViaTeamMembership.Entities.Count > 0)
                {
                    allUserRoles.Entities.AddRange(rolesViaTeamMembership.Entities);
                }
            }
            catch (Exception ex)
            {
                return allUserRoles;
            } 
            #endregion

            return allUserRoles;
        }
        public EntityCollection GetUserTeams(Guid pUserId)
        {
            EntityCollection retrievedUserTeams = new EntityCollection();
            QueryExpression userTeamQuery = new QueryExpression("team")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("team", "teammembership", "teamid", "teamid", JoinOperator.Inner){
                        LinkEntities = {
                            new LinkEntity("teammembership", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner){
                                LinkCriteria = {
                                    Conditions = {
                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                    }
                                }
                            }
                        }
                    }
                }
            };
            try
            {
                retrievedUserTeams = service.RetrieveMultiple(userTeamQuery);
            }
            catch (Exception ex)
            {
                return retrievedUserTeams;
            }
            return retrievedUserTeams;
        }
        public EntityCollection GetAllUserPrivileges(Guid pUserId)
        {
            EntityCollection allUserPrivileges = new EntityCollection();
            if (pUserId.Equals(Guid.Empty)) { return allUserPrivileges; }

            #region get privileges from user's roles
            QueryExpression UserPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "systemuserroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("systemuserroles", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner){
                                                LinkCriteria = {
                                                    Conditions = {
                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };
            EntityCollection userPrivilegesViaRoleAssignments = new EntityCollection();
            try
            {
                userPrivilegesViaRoleAssignments = service.RetrieveMultiple(UserPrivilegeQuery);
                if (userPrivilegesViaRoleAssignments.Entities.Count > 0)
                {
                    allUserPrivileges.Entities.AddRange(userPrivilegesViaRoleAssignments.Entities);

                }
            }
            catch (Exception ex)
            {
                return allUserPrivileges;
            }
            #endregion

            #region get privileges from user's teams' roles
            QueryExpression UserTeamPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "teamroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("teamroles", "team", "teamid", "teamid", JoinOperator.Inner){
                                                LinkEntities = {
                                                    new LinkEntity("team", "teammembership", "teamid", "teamid", JoinOperator.Inner){
                                                        LinkEntities = {
                                                            new LinkEntity("teammembership", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner)
                                                            {
                                                                LinkCriteria = 
                                                                {
                                                                    Conditions = {
                                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                }
                            }
                        }
                    }
                }
            };
            EntityCollection userPrivilegesViaTeamMemberships = new EntityCollection();
            try
            {
                userPrivilegesViaTeamMemberships = service.RetrieveMultiple(UserTeamPrivilegeQuery);
                if (userPrivilegesViaTeamMemberships.Entities.Count > 0)
                {
                    allUserPrivileges.Entities.AddRange(userPrivilegesViaTeamMemberships.Entities);
                }
            }
            catch (Exception ex)
            {
                return allUserPrivileges;
            }
            #endregion

            return allUserPrivileges;
        }
        public EntityCollection GetSpecificUserPrivilege(Guid pUserId, string pPrivilegeName)
        {
            EntityCollection allRetrievedPrivileges = new EntityCollection();
            if (pUserId.Equals(Guid.Empty)) { return allRetrievedPrivileges; }
            if (string.IsNullOrEmpty(pPrivilegeName)) { return allRetrievedPrivileges; }

            #region get privileges from user's roles
            QueryExpression UserPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet("privilegeid"),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "systemuserroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("systemuserroles", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner){
                                                LinkCriteria = {
                                                    Conditions = {
                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                Criteria =
                {
                    FilterOperator = LogicalOperator.And,
                    Conditions =
                    {
                        new ConditionExpression("name", ConditionOperator.Equal, pPrivilegeName)
                    }
                }
            };
            EntityCollection userPrivilegesViaRoleAssignments = new EntityCollection();
            try
            {
                userPrivilegesViaRoleAssignments = service.RetrieveMultiple(UserPrivilegeQuery);
                if (userPrivilegesViaRoleAssignments.Entities.Count > 0)
                {
                    allRetrievedPrivileges.Entities.AddRange(userPrivilegesViaRoleAssignments.Entities);

                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            #endregion

            #region get privileges from user's teams' roles
            QueryExpression UserTeamPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet("privilegeid"),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "teamroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("teamroles", "team", "teamid", "teamid", JoinOperator.Inner){
                                                LinkEntities = {
                                                    new LinkEntity("team", "teammembership", "teamid", "teamid", JoinOperator.Inner){
                                                        LinkEntities = {
                                                            new LinkEntity("teammembership", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner)
                                                            {
                                                                LinkCriteria = 
                                                                {
                                                                    Conditions = {
                                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                Criteria =
                {
                    FilterOperator = LogicalOperator.And,
                    Conditions =
                    {
                        new ConditionExpression("name", ConditionOperator.Equal, pPrivilegeName)
                    }
                }
            };
            EntityCollection userPrivilegesViaTeamMemberships = new EntityCollection();
            try
            {
                userPrivilegesViaTeamMemberships = service.RetrieveMultiple(UserTeamPrivilegeQuery);
                if (userPrivilegesViaTeamMemberships.Entities.Count > 0)
                {
                    allRetrievedPrivileges.Entities.AddRange(userPrivilegesViaTeamMemberships.Entities);
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            #endregion

            return allRetrievedPrivileges;
        }
        public EntityCollection GetSpecificUserPrivilege(Guid pUserId, string pPrivilegeName, int pDepth)
        {
            EntityCollection allRetrievedPrivileges = new EntityCollection();
            if (pUserId.Equals(Guid.Empty)) { return allRetrievedPrivileges; }
            if (string.IsNullOrEmpty(pPrivilegeName)) { return allRetrievedPrivileges; }
            if (pDepth > 8) { return allRetrievedPrivileges; }

            #region get privileges from user's roles
            QueryExpression UserPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet("privilegeid"),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkCriteria = {
                            Conditions = {
                                new ConditionExpression("privilegedepthmask", ConditionOperator.GreaterEqual, pDepth)
                            }
                        },
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "systemuserroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("systemuserroles", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner){
                                                LinkCriteria = {
                                                    Conditions = {
                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                },
                Criteria =
                {
                    FilterOperator = LogicalOperator.And,
                    Conditions =
                        {
                            new ConditionExpression("name", ConditionOperator.Equal, pPrivilegeName)
                        }
                }
            };
            EntityCollection userPrivilegesViaRoleAssignments = new EntityCollection();
            try
            {
                userPrivilegesViaRoleAssignments = service.RetrieveMultiple(UserPrivilegeQuery);
                if (userPrivilegesViaRoleAssignments.Entities.Count > 0)
                {
                    allRetrievedPrivileges.Entities.AddRange(userPrivilegesViaRoleAssignments.Entities);

                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            #endregion

            #region get privileges from user's teams' roles
            QueryExpression UserTeamPrivilegeQuery = new QueryExpression("privilege")
            {
                ColumnSet = new ColumnSet(true),
                LinkEntities =
                {
                    new LinkEntity("privilege", "roleprivileges", "privilegeid", "privilegeid", JoinOperator.Inner){
                        Columns = new ColumnSet("privilegedepthmask"),
                        EntityAlias = "RoleHasPrivilege",
                        LinkCriteria = {
                            Conditions = {
                                new ConditionExpression("privilegedepthmask", ConditionOperator.GreaterEqual, pDepth)
                            }
                        },
                        LinkEntities = {
                            new LinkEntity("roleprivileges", "role", "roleid", "roleid", JoinOperator.Inner){
                                LinkEntities = {
                                    new LinkEntity("role", "teamroles", "roleid", "roleid", JoinOperator.Inner){
                                        LinkEntities = {
                                            new LinkEntity("teamroles", "team", "teamid", "teamid", JoinOperator.Inner){
                                                LinkEntities = {
                                                    new LinkEntity("team", "teammembership", "teamid", "teamid", JoinOperator.Inner){
                                                        LinkEntities = {
                                                            new LinkEntity("teammembership", "systemuser", "systemuserid", "systemuserid", JoinOperator.Inner)
                                                            {
                                                                LinkCriteria = 
                                                                {
                                                                    Conditions = {
                                                                        new ConditionExpression("systemuserid", ConditionOperator.Equal, pUserId)
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                }
                            }
                        }
                    }
                },
                Criteria =
                {
                    FilterOperator = LogicalOperator.And,
                    Conditions =
                        {
                            new ConditionExpression("name", ConditionOperator.Equal, pPrivilegeName)
                        }
                }
            };
            EntityCollection userPrivilegesViaTeamMemberships = new EntityCollection();
            try
            {
                userPrivilegesViaTeamMemberships = service.RetrieveMultiple(UserTeamPrivilegeQuery);
                if (userPrivilegesViaTeamMemberships.Entities.Count > 0)
                {
                    allRetrievedPrivileges.Entities.AddRange(userPrivilegesViaTeamMemberships.Entities);
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            #endregion

            return allRetrievedPrivileges;
        }
    }
}
