﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml;
using Microsoft.Crm.UnifiedServiceDesk.CommonUtility;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics.Utilities;
using Microsoft.Uii.Desktop.SessionManager;
using Microsoft.Uii.Common;
using Microsoft.Uii.Csr;
using Microsoft.Uii.HostedApplicationToolkit.AutomationHosting;
using Microsoft.Uii.HostedApplicationToolkit.DataDrivenAdapter;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Uii.AifServices;
using Microsoft.Crm.UnifiedServiceDesk.BaseControl;
using System.Diagnostics;
using System.Windows.Forms;

namespace VRM.VCCM.USD.Utilities
{
    /// <summary>
    /// Interaction logic for Common.xaml
    /// This is a base control for building Unified Service Desk Aware add-ins
    /// See USD API documentation for full API Information available via this control.
    /// </summary>
    public partial class Common : DynamicsBaseHostedControl
    {
        #region Vars
        /// <summary>
        /// Log writer for USD 
        /// </summary>
        private TraceLogger LogWriter = null;
        private DataDrivenAdapterBase _vseAdapter = null;
        #endregion

        /// <summary>
        /// UII Constructor 
        /// </summary>
        /// <param name="appID">ID of the application</param>
        /// <param name="appName">Name of the application</param>
        /// <param name="initString">Initializing XML for the application</param>
        public Common(Guid appID, string appName, string initString)
            : base(appID, appName, initString)
        {
            InitializeComponent();

            // This will create a log writer with the default provider for Unified Service desk
            LogWriter = new TraceLogger();

            #region Enhanced LogProvider Info
            // This will create a log writer with the same name as your hosted control. 
            // LogWriter = new TraceLogger(traceSourceName:"MyTraceSource");

            // If you utilize this feature,  you would need to add a section to the system.diagnostics settings area of the UnifiedServiceDesk.exe.config
            //<source name="MyTraceSource" switchName="MyTraceSwitchName" switchType="System.Diagnostics.SourceSwitch">
            //    <listeners>
            //        <add name="console" type="System.Diagnostics.DefaultTraceListener"/>
            //        <add name="fileListener"/>
            //        <add name="USDDebugListener" />
            //        <remove name="Default"/>
            //    </listeners>
            //</source>

            // and then in the switches area : 
            //<add name="MyTraceSwitchName" value="Verbose"/>

            #endregion

        }

        /// <summary>
        /// Raised when the Desktop Ready event is fired. 
        /// </summary>
        protected override void DesktopReady()
        {
            // this will populate any toolbars assigned to this control in config. 
            PopulateToolbars(ProgrammableToolbarTray);
            base.DesktopReady();
        }

        /// <summary>
        /// Raised when an action is sent to this control
        /// </summary>
        /// <param name="args">args for the action</param>
        protected override void DoAction(Microsoft.Uii.Csr.RequestActionEventArgs args)
        {
            // Log process.
            LogWriter.Log(string.Format(CultureInfo.CurrentCulture, "{0} -- DoAction called for action: {1}", this.ApplicationName, args.Action), System.Diagnostics.TraceEventType.Information);

            #region action handlers
            switch (args.Action)
            {
                case "CopyDataToReplacementParameters":
                    CopyDataToReplacementParameters(args);
                    break;
                case "StartHostedApplication":
                    StartHostedApplication(args);
                    break;
                case "CloseHostedApplication":
                    CloseHostedApplication(args);
                    break;
                case "OpenVSE":
                    OpenVSE(args);
                    break;
                case "CloseVSE":
                    CloseVSE(args);
                    break;
                case "VSEPerformSearchMSAA":
                    VSEPerformSearchMSAA(args);
                    break;
                case "VSEPerformLoginMSAA":
                    VSEPerformLoginMSAA_VistaCreds(args);
                    break;
                default:
                    AlertUnsupportedAction(args);
                    break;
            }
            
            #endregion

            base.DoAction(args);
        }

        /// <summary>
        /// Raised when a context change occurs in USD
        /// </summary>
        /// <param name="context"></param>
        public override void NotifyContextChange(Microsoft.Uii.Csr.Context context)
        {
            base.NotifyContextChange(context);
        }


        #region User Code Area
        private void CopyDataToReplacementParameters(RequestActionEventArgs args)
        {
            List<KeyValuePair<string, string>> argList = Utility.SplitLines(args.Data, CurrentContext, localSessionManager);
            string appName = Utility.GetAndRemoveParameter(argList, "group");
            appName = !String.IsNullOrEmpty(appName) ? appName : this.ApplicationName;
            string globalString = Utility.GetAndRemoveParameter(argList, "global");
            bool global = !String.IsNullOrEmpty(globalString) && globalString.ToLower() == "true";

            if (argList.Count == 0)
            {
                throw new Exception("Provide at least one key/value pair, joined by an equal sign. Place additional key/value pairs on their own lines in the action call data.");
            }

            //assemble rest of parameters into Dictionary object
            Dictionary<string, CRMApplicationData> data = argList.ToDictionary(thisArg => thisArg.Key, thisArg => new CRMApplicationData() { name = thisArg.Key, value = thisArg.Value, type = "string" });

            PushDataToUSD(data, appName, global);
        }
        private void StartHostedApplication(RequestActionEventArgs args)
        {
            string appName = GetFieldFromArgs(args, "app");
            string canCloseString = GetFieldFromArgs(args, "userCanClose");
            bool canClose = !String.IsNullOrEmpty(canCloseString) && canCloseString.ToLower() == "true";
            string globalString = GetFieldFromArgs(args, "global");
            bool global = !String.IsNullOrEmpty(globalString) && globalString.ToLower() == "true";
            //string doDefaultActionString = GetFieldFromArgs(args, "doDefaultAction");
            //bool doDefaultAction = !String.IsNullOrEmpty(doDefaultActionString) && doDefaultActionString.ToLower() == "true";
            try
            {
                if (!(string.IsNullOrEmpty(appName)))
                {
                    HostedApplication app = GetOrStartHostedApp(appName, global, canClose);
                }
                else
                {
                    throw new Exception("Exception in StartHostedApplication(): 'app' parameter cannot be null.");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        private ExternalApplication GetOrStartExternalApplication(RequestActionEventArgs args)
        {
            ExternalApplication app = null;
            string appName = GetFieldFromArgs(args, "app");
            string canCloseString = GetFieldFromArgs(args, "userCanClose");
            bool canClose = !String.IsNullOrEmpty(canCloseString) && canCloseString.ToLower() == "true";
            string globalString = GetFieldFromArgs(args, "global");
            bool global = !String.IsNullOrEmpty(globalString) && globalString.ToLower() == "true";
            try
            {
                if (!(string.IsNullOrEmpty(appName)))
                {
                    ApplicationHost appHost = GetAppHost(global);
                    app = (ExternalApplication)GetOrStartHostedApp(appName, global, canClose);                    
                    if(app == null)
                    {
                        System.Collections.ArrayList availableDynamicApps = appHost.GetDynamicApplicationNames(global);
                        if (availableDynamicApps.IndexOf(appName) > -1)
                        {
                            app = (ExternalApplication)appHost.LoadDynamicApplication(appName, canClose);
                            app.Initialize();
                        }
                        else
                        {
                            //throw new Exception("'" + appName + "' is not an available dynamic application.");
                        }
                    }                    
                }
                else
                {
                    throw new Exception("Exception in GetOrStartExternalApplication(): 'app' parameter cannot be null.");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return app;
        }
        private void CloseHostedApplication(RequestActionEventArgs args)
        {
            string appName = GetFieldFromArgs(args, "app");
            string procName = GetFieldFromArgs(args, "process");
            string globalString = GetFieldFromArgs(args, "global");
            bool global = !String.IsNullOrEmpty(globalString) && globalString.ToLower() == "true";
            try
            {
                if (appName == "VSE")
                {
                    if (_vseAdapter != null)
                    {
                        _vseAdapter.Dispose();
                        _vseAdapter = null;
                    }
                }
                bool appClosed = CloseHostedApp(appName, global);   
                if (appClosed)
                {
                    bool procKilled = KillProcess(procName);
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        #endregion
        #region VSE code
        private void OpenVSE(RequestActionEventArgs args)
        {
            string performLoginString = GetFieldFromArgs(args, "performLogin");
            bool performLogin = !String.IsNullOrEmpty(performLoginString) && performLoginString.ToLower() == "true";
            if (performLogin)
            {
                string accessCodeValue = GetFieldFromArgs(args, "access");
                string verifyCodeValue = GetFieldFromArgs(args, "verify");
                if (string.IsNullOrEmpty(accessCodeValue) || string.IsNullOrEmpty(verifyCodeValue))
                {
                    throw new Exception("To perform automatic login with VistA credentials, you must also provide values for 'access' and 'verify' parameters to this action call");
                }
            }
            try
            {
                ExternalApplication vseApp = (ExternalApplication)GetOrStartHostedApp("VSE", true, false);
                if (vseApp != null)
                {
                    InitializeVSEAdapter(vseApp);
                    if (_vseAdapter != null)
                    {
                        if (performLogin)
                        {
                            System.Threading.Thread.Sleep(500);//wait for User Login window to load?
                            //((System.Threading.Thread)UIThread.Thread).
                            VSEPerformLoginMSAA_VistaCreds(args);
                        }
                    }
                }
            }
            catch (DataDrivenAdapterException ddex)
            {
                string maxRetriesStringValue = GetFieldFromArgs(args, "maxRetries");
                if (!string.IsNullOrEmpty(maxRetriesStringValue))
                {
                    bool vseClosed = CloseHostedApp("VSE", true);
                    int maxRetries = 0;
                    bool parsedMaxRetries = int.TryParse(maxRetriesStringValue, out maxRetries);
                    if (maxRetries > 0)
                    {
                        string retryCountStringValue = GetFieldFromArgs(args, "retryCount");
                        if (string.IsNullOrEmpty(retryCountStringValue))
                        {
                            args.Data += "\nretryCount=1";
                            OpenVSE(args);
                        }
                        else
                        {
                            int retryCount = 0;
                            bool parsed = int.TryParse(retryCountStringValue, out retryCount);
                            if (parsed)
                            {
                                retryCount++;
                            }
                            else
                            {
                                retryCount = 1;
                            }
                            args.Data = args.Data.Replace("retryCount=" + retryCountStringValue, "retryCount=" + retryCount.ToString());
                            if (retryCount <= maxRetries)
                            {
                                OpenVSE(args);
                            }
                            else
                            {
                                throw ddex;
                            }
                        }
                    }
                    else
                    {
                        throw ddex;
                    }
                }
                else
                {
                    throw ddex;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        private void InitializeVSEAdapter(ExternalApplication pVSE)
        {
            try
            {
                if (pVSE != null)
                {
                    _vseAdapter = DataDrivenAdapterBase.CreateInstance(pVSE.ApplicationInitializationXml, pVSE.HostedApplicationAdapter.DdaApplicationObject);
                }
            }
            catch (DataDrivenAdapterException ex)
            {
                throw ex;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        private void SetVSEDataParameters(string pOpen, string pTooltip)
        {
            Dictionary<string, CRMApplicationData> newData = new Dictionary<string, CRMApplicationData>()
            {
                {"open", new CRMApplicationData() { name = "open", value = pOpen, type = "string" } },
                {"tooltip", new CRMApplicationData() { name = "tooltip", value = pTooltip, type = "string" } }
            };
            PushDataToUSD(newData, "VSE", true);
        }
        private void VSEPerformLoginMSAA_VistaCreds(RequestActionEventArgs args)
        {
            string accessCodeValue = GetFieldFromArgs(args, "access");
            string verifyCodeValue = GetFieldFromArgs(args, "verify");
            if (!string.IsNullOrEmpty(accessCodeValue) && !string.IsNullOrEmpty(verifyCodeValue))
            {
                try
                {
                    ApplicationHost appHost = GetAppHost(true);
                    ExternalApplication app = (ExternalApplication)appHost.GetApplication("VSE");
                    if (app != null)
                    {
                        if (!string.IsNullOrEmpty(app.ApplicationInitializationXml) && app.HostedApplicationAdapter != null)
                        {
                            //DataDrivenAdapterBase inLineVSEAdapter = DataDrivenAdapterBase.CreateInstance(app.ApplicationInitializationXml, app.HostedApplicationAdapter.DdaApplicationObject);
                            //bool foundLoginBox = inLineVSEAdapter.FindControl("MSAA:UserLogin_AccessField_ByOffset");
                            if (_vseAdapter == null)
                            {
                                InitializeVSEAdapter(app);
                            }
                            if (_vseAdapter != null)
                            {
                                bool foundLoginBox = _vseAdapter.FindControl("UserLogin_AccessField_ByOffset");
                                if (foundLoginBox)
                                {
                                    //inLineVSEAdapter.SetControlValue("MSAA:UserLogin_AccessField_ByOffset", accessCodeValue, "");
                                    //inLineVSEAdapter.SetControlValue("MSAA:UserLogin_VerifyField_ByOffset", verifyCodeValue, "");
                                    //inLineVSEAdapter.ExecuteControlAction("MSAA:UserLogin_OKButton_ByOffset", false, "");

                                    _vseAdapter.SetControlValue("UserLogin_AccessField_ByOffset", accessCodeValue, "");
                                    _vseAdapter.SetControlValue("UserLogin_VerifyField_ByOffset", verifyCodeValue, "");
                                    _vseAdapter.ExecuteControlAction("UserLogin_OKButton_ByOffset", false, "");
                                    //inLineVSEAdapter.Dispose();

                                    System.Threading.Thread.Sleep(3000);
                                    //SendKeys.Send("{%TAB}");
                                    BringProcessWindowToFront("UnifiedServiceDesk");
                                }
                                else
                                {
                                    //inLineVSEAdapter.Dispose();
                                    throw new DataDrivenAdapterException("Could not find User Login box.");
                                }
                            }
                        }
                        else
                        {
                            throw new Exception("Error creating instance of VSE DataDrivenAdapter. App object is missing ApplicationInitializationXml or HostedApplicationAdapter.");
                        }
                    }
                    else
                    {
                        throw new Exception("Could not find or create the hosted application: VSE");
                    }
                }
                catch (DataDrivenAdapterException ex)
                {
                    throw ex;
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
            else
            {
                throw new Exception("Values of 'access' and 'verify' parameters cannot be null.");
            }
        }
        private void VSEPerformSearchMSAA(RequestActionEventArgs args)
        {
            string searchValue = GetFieldFromArgs(args, "searchText");
            if (!string.IsNullOrEmpty(searchValue))
            {
                try
                {
                    //ApplicationHost appHost = GetAppHost(true);
                    //ExternalApplication app = (ExternalApplication)appHost.GetApplication("VSE");
                    ExternalApplication vseApp = (ExternalApplication)GetOrStartHostedApp("VSE", true, true);
                    if (vseApp != null)
                    {
                        if (!string.IsNullOrEmpty(vseApp.ApplicationInitializationXml) && vseApp.HostedApplicationAdapter != null)
                        {
                            //DataDrivenAdapterBase inLineVSEAdapter = DataDrivenAdapterBase.CreateInstance(app.ApplicationInitializationXml, app.HostedApplicationAdapter.DdaApplicationObject);
                            if (_vseAdapter == null)
                            {
                                InitializeVSEAdapter(vseApp);
                            }
                            if (_vseAdapter != null)
                            {
                                bool foundSearchBox = _vseAdapter.FindControl("VSE_SearchBox");
                                if (foundSearchBox)
                                {
                                    _vseAdapter.SetControlValue("VSE_SearchBox", searchValue, "");
                                    _vseAdapter.ExecuteControlAction("VSE_SearchButton", false, "");
                                    //inLineVSEAdapter.Dispose();
                                }
                                else
                                {
                                    //inLineVSEAdapter.Dispose();
                                    throw new DataDrivenAdapterException("Could not find VSE_SearchBox control");

                                    //instead of throwing the above error, try again: close the VSE control, reopen it, login, and try searching again                                
                                    //bool closed = CloseHostedApp("VSE", true);
                                    //if (closed)
                                    //{

                                    //}
                                }
                            }
                        }
                        else
                        {
                            throw new Exception("Error creating instance of VSE DataDrivenAdapter. App object is missing ApplicationInitializationXml or HostedApplicationAdapter.");
                        }
                    }
                    else
                    {
                        throw new Exception("Could not find or start the hosted application: VSE");
                    }
                }
                catch (DataDrivenAdapterException ddex)
                {
                    string maxRetriesStringValue = GetFieldFromArgs(args, "maxRetries");
                    if (!string.IsNullOrEmpty(maxRetriesStringValue))
                    {
                        int maxRetries = 0;
                        bool parsedMaxRetries = int.TryParse(maxRetriesStringValue, out maxRetries);
                        if (maxRetries > 0)
                        {
                            string retryCountStringValue = GetFieldFromArgs(args, "retryCount");
                            if (string.IsNullOrEmpty(retryCountStringValue))
                            {
                                args.Data += "\nretryCount=1";
                                VSEPerformSearchMSAA(args);
                            }
                            else
                            {
                                int retryCount = 0;
                                bool parsed = int.TryParse(retryCountStringValue, out retryCount);
                                if (parsed)
                                {
                                    retryCount++;
                                }
                                else
                                {
                                    retryCount = 1;
                                }
                                args.Data = args.Data.Replace("retryCount=" + retryCountStringValue, "retryCount=" + retryCount.ToString());
                                if (retryCount <= maxRetries)
                                {
                                    VSEPerformSearchMSAA(args);
                                }
                                else
                                {
                                    throw ddex;
                                }
                            }
                        }
                        else
                        {
                            throw ddex;
                        }
                    }
                    else
                    {
                        throw ddex;
                    }
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
            else
            {
                throw new Exception("Value of 'searchText' parameter cannot be null.");
            }
        }
        private void CloseVSE(RequestActionEventArgs args)
        {
            if (_vseAdapter != null)
            {
                _vseAdapter.Dispose();
                bool vseClosed = CloseHostedApp("VSE", true);
            }
        }
        #endregion
        #region
        #region helper functions
        private HostedApplication GetOrStartHostedApp(string pApplicationName, bool pGlobal, bool pUserCanClose)
        {
            HostedApplication app = null;
            try
            {
                ApplicationHost appHost = GetAppHost(pGlobal);
                System.Collections.ArrayList availableDynamicApps = appHost.GetDynamicApplicationNames(pGlobal);
                if (availableDynamicApps.IndexOf(pApplicationName) > -1)
                {
                    app = (HostedApplication)appHost.GetApplication(pApplicationName);
                    if (app != null)
                    {
                        if (pApplicationName == "VSE")
                        {
                            if (!string.IsNullOrEmpty(((ExternalApplication)app).ApplicationInitializationXml) && ((ExternalApplication)app).HostedApplicationAdapter != null)
                            {
                                SetVSEDataParameters("true", "Search VSE for current veteran");
                            }
                            else
                            {
                                bool appClosed = CloseHostedApp(pApplicationName, pGlobal);
                                if (appClosed)
                                {
                                    app = GetOrStartHostedApp(pApplicationName, pGlobal, pUserCanClose);
                                }
                            }
                        }
                        //else
                        //{
                        //    SetVSEDataParameters("true", "Search VSE for current veteran");
                        //}
                    }
                    else
                    {
                        try
                        {
                            app = (HostedApplication)appHost.LoadDynamicApplication(pApplicationName, pUserCanClose);
                            app.Initialize();

                            SetVSEDataParameters("true", "Search VSE for current veteran");
                        }
                        catch (Exception ex)
                        {
                            throw ex;
                        }
                    }
                }
                else
                {
                    throw new Exception("'" + pApplicationName + "' is not an available dynamic application.");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return app;
        }
        private bool CloseHostedApp(string pApplicationName, bool pGlobal)
        {
            bool appClosed = false;
            try
            {
                if (!(string.IsNullOrEmpty(pApplicationName)))
                {                    
                    ApplicationHost appHost = GetAppHost(pGlobal);
                    HostedApplication app = null;
                    app = (HostedApplication)appHost.GetApplication(pApplicationName);
                    if (app != null)
                    {
                        try
                        {
                            if (pApplicationName == "VSE")
                            {
                                //try disposing adapters first??
                                if(_vseAdapter != null)
                                {
                                    _vseAdapter.Dispose();
                                    _vseAdapter = null;
                                }
                                ExternalApplication vseApp = (ExternalApplication)app;
                                vseApp.Close();
                                appHost.UnloadDynamicApplication(vseApp);
                                appClosed = true;
                                SetVSEDataParameters("false", "Open VSE");
                            }
                            else
                            {
                                app.Close();
                                appHost.UnloadDynamicApplication(app);
                                appClosed = true;
                            }
                        }
                        catch (Exception ex)
                        {
                            throw ex;
                        }
                    }
                    else
                    {
                        appClosed = true;
                        if (pApplicationName == "VSE")
                        {
                            if(_vseAdapter != null)
                                {
                                    _vseAdapter.Dispose();
                                    _vseAdapter = null;
                                }
                            SetVSEDataParameters("false", "Open VSE");
                        }
                    }
                }
                else
                {
                    throw new Exception("Exception in CloseHostedApp(): pApplicationName cannot be null.");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return appClosed;
        }
        private bool KillProcess(string pProccessName)
        {
            bool processKilled = false;
            try
            {
                if (!(string.IsNullOrEmpty(pProccessName)))
                {
                    Process[] foundProcesses = Process.GetProcessesByName(pProccessName);
                    if (foundProcesses.Length == 1)
                    {
                        foundProcesses[0].Kill();
                    }

                    foundProcesses = Process.GetProcessesByName(pProccessName);
                    if (foundProcesses.Length == 0)
                    {
                        processKilled = true;
                    }
                }
                else
                {
                    //throw new Exception("Process name cannot be empty. Pass parameter using syntax 'process=<name>'");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return processKilled;
        }
        private void BringProcessWindowToFront(string pProcessName)
        {
            try
            {
                if (!(string.IsNullOrEmpty(pProcessName)))
                {
                    Process[] foundProcesses = Process.GetProcessesByName(pProcessName);
                    if (foundProcesses.Length == 1)
                    {
                        SetForegroundWindow(foundProcesses[0].MainWindowHandle);
                    }
                }
                else
                {
                    //throw new Exception("Process name cannot be empty. Pass parameter using syntax 'process=<name>'");
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        [System.Runtime.InteropServices.DllImport("User32.dll")]
        public static extern bool SetForegroundWindow(IntPtr hWnd);
        private ApplicationHost GetAppHost(bool pGlobal)
        {
            //if (pGlobal)
            //{
            //    AgentDesktopSession session = (AgentDesktopSession)localSessionManager.GlobalSession;
            //    return session.AppHost;
            //}
            //else
            //{
                AgentDesktopSession session = (AgentDesktopSession)localSessionManager.ActiveSession;
                return session.AppHost;
            //}
        }
        private void AlertUnsupportedAction(RequestActionEventArgs args)
        {
            throw new Exception("Action, '" + args.Action + "', is not supported or implemented by this hosted control.");
        }
        public string GetFieldFromArgs(RequestActionEventArgs args, string key)
        {
            return Utility.GetAndRemoveParameter(Utility.SplitLines(args.Data, CurrentContext, localSessionManager), key);
            
        }
        public void PushDatumToUSD(string pKey, string pValue, string pType, string pAppName, bool pGlobal)
        {
            pType = "string";
            if (!String.IsNullOrEmpty(pKey) && !String.IsNullOrEmpty(pValue) && !String.IsNullOrEmpty(pType))
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;

                Dictionary<string, CRMApplicationData> newData = new Dictionary<string, CRMApplicationData>();
                // add a string: 
                newData.Add(pKey, new CRMApplicationData() { name = pKey, value = pValue, type = pType.ToLower() });

                // add a entity lookup:
                //newData.Add("myNewKey", new CRMApplicationData() { name = "myAccount", type = "lookup", value = "account,0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5,MyAccount" });

                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
            }
        }
        public void PushDataToUSD(Dictionary<string, CRMApplicationData> pData, string pAppName, bool pGlobal)
        {
            //perform data translation into a Dictionary object before calling this function
            if (pData.Count > 0)
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;
                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
            }
        }
        #endregion
        #endregion
    }
}
