﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Crm.UnifiedServiceDesk.CommonUtility;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics;
using Microsoft.Crm.UnifiedServiceDesk.Dynamics.Utilities;
using Microsoft.Uii.Desktop.SessionManager;
using Microsoft.Uii.Csr;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk.Discovery;
using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Uii.AifServices;
using Microsoft.Crm.UnifiedServiceDesk.BaseControl;

namespace VRM.VCCM.USD.Utilities
{
    /// <summary>
    /// Interaction logic for About.xaml
    /// This is a base control for building Unified Service Desk Aware add-ins
    /// See USD API documentation for full API Information available via this control.
    /// </summary>
    public partial class About : DynamicsBaseHostedControl
    {
        #region Vars
        /// <summary>
        /// Log writer for USD 
        /// </summary>
        private TraceLogger LogWriter = null;
        private CrmServiceClient service;

        #endregion

        /// <summary>
        /// UII Constructor 
        /// </summary>
        /// <param name="appID">ID of the application</param>
        /// <param name="appName">Name of the application</param>
        /// <param name="initString">Initializing XML for the application</param>
        public About(Guid appID, string appName, string initString)
            : base(appID, appName, initString)
        {
            InitializeComponent();

            // This will create a log writer with the default provider for Unified Service desk
            LogWriter = new TraceLogger();
            InitializeCrmConnection();

            #region Enhanced LogProvider Info
            // This will create a log writer with the same name as your hosted control. 
            // LogWriter = new TraceLogger(traceSourceName:"MyTraceSource");

            // If you utilize this feature,  you would need to add a section to the system.diagnostics settings area of the UnifiedServiceDesk.exe.config
            //<source name="MyTraceSource" switchName="MyTraceSwitchName" switchType="System.Diagnostics.SourceSwitch">
            //    <listeners>
            //        <add name="console" type="System.Diagnostics.DefaultTraceListener"/>
            //        <add name="fileListener"/>
            //        <add name="USDDebugListener" />
            //        <remove name="Default"/>
            //    </listeners>
            //</source>

            // and then in the switches area : 
            //<add name="MyTraceSwitchName" value="Verbose"/>

            #endregion

        }

        private bool InitializeCrmConnection()
        {
            if (service != null) return true;
            if (this._client != null && this._client.CrmInterface != null && this._client.CrmInterface.IsReady)
            {
                service = this._client.CrmInterface;
            }
            return false;
        }

        /// <summary>
        /// Raised when the Desktop Ready event is fired. 
        /// </summary>
        protected override void DesktopReady()
        {
            // this will populate any toolbars assigned to this control in config. 
            PopulateToolbars(ProgrammableToolbarTray);
            base.DesktopReady();
        }

        /// <summary>
        /// Raised when an action is sent to this control
        /// </summary>
        /// <param name="args">args for the action</param>
        protected override void DoAction(Microsoft.Uii.Csr.RequestActionEventArgs args)
        {
            // Log process.
            LogWriter.Log(string.Format(CultureInfo.CurrentCulture, "{0} -- DoAction called for action: {1}", this.ApplicationName, args.Action), System.Diagnostics.TraceEventType.Information);

            #region Example process action
            //// Process Actions. 
            //if (args.Action.Equals("your action name", StringComparison.OrdinalIgnoreCase))
            //{
            //    // Do some work

            //    // Access CRM and fetch a Record
            //Microsoft.Xrm.Sdk.Messages.RetrieveRequest req = new Microsoft.Xrm.Sdk.Messages.RetrieveRequest();
            //req.Target = new Microsoft.Xrm.Sdk.EntityReference("account", Guid.Parse("0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5"));
            //req.ColumnSet = new Microsoft.Xrm.Sdk.Query.ColumnSet("accountid", "name");
            //Microsoft.Xrm.Sdk.Messages.RetrieveResponse response = (Microsoft.Xrm.Sdk.Messages.RetrieveResponse)this._client.CrmInterface.ExecuteCrmOrganizationRequest(req, "Requesting Account"); 


            //    // Example of pulling some data out of the passed in data array
            //    List<KeyValuePair<string, string>> actionDataList = Utility.SplitLines(args.Data, CurrentContext, localSession);
            //    string valueIwant = Utility.GetAndRemoveParameter(actionDataList, "mykey"); // asume there is a myKey=<value> in the data. 



            //    // Example of pushing data to USD
            //    string global = Utility.GetAndRemoveParameter(actionDataList, "global"); // Assume there is a global=true/false in the data
            //    bool saveInGlobalSession = false;
            //    if (!String.IsNullOrEmpty(global))
            //        saveInGlobalSession = bool.Parse(global);

            //    Dictionary<string, CRMApplicationData> myDataToSet = new Dictionary<string, CRMApplicationData>();
            //    // add a string: 
            //    myDataToSet.Add("myNewKey", new CRMApplicationData() { name = "myNewKey", type = "string", value = "TEST" });

            //    // add a entity lookup:
            //    myDataToSet.Add("myNewKey", new CRMApplicationData() { name = "myAccount", type = "lookup", value = "account,0EF05F4F-0D39-4219-A3F5-07A0A5E46FD5,MyAccount" }); 

            //    if (saveInGlobalSession) 
            //    {
            //        // add context item to the global session
            //        ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(this.ApplicationName, myDataToSet, true);
            //    }
            //    else
            //    {
            //        // Add context item to the current session. 
            //        ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(this.ApplicationName, myDataToSet, true);
            //    }
            //}
            #endregion

            InitializeCrmConnection();

            switch (args.Action)
            {
                case "Open":
                    string serverName = string.Empty;
                    string productVersion = GetFieldFromArgs(args, "productversion");
                    string productName = GetFieldFromArgs(args, "productname");
                    string fullName = GetUserName();

                    LblProductName.Content = productName;
                    LblProductVersion.Content = productVersion;

                    EndpointCollection endPoints = service.ConnectedOrgPublishedEndpoints;
                    foreach (KeyValuePair<EndpointType,string> thisEndpoint in service.ConnectedOrgPublishedEndpoints)
                    {
                        if (thisEndpoint.Key == Microsoft.Xrm.Sdk.Discovery.EndpointType.WebApplication)
                        {
                            serverName = thisEndpoint.Value;
                            break;
                        }
                    }
                    serverName = serverName.Replace("http://", "");
                    serverName = serverName.Replace("https://", "");
                    serverName = serverName.Replace("/", "");

                    LblServerName.Content = serverName;
                    LblOrgName.Content = service.ConnectedOrgFriendlyName;
                    LblUserName.Content = fullName;
                    break;
                default:
                    break;
            }

            base.DoAction(args);
        }

        /// <summary>
        /// Raised when a context change occurs in USD
        /// </summary>
        /// <param name="context"></param>
        public override void NotifyContextChange(Microsoft.Uii.Csr.Context context)
        {
            base.NotifyContextChange(context);
        }


        #region User Code Area
        private string GetUserName()
        {
            string userName = string.Empty;
            Entity retrievedUser = new Entity();
            try
            {
                retrievedUser = service.Retrieve("systemuser", service.GetMyCrmUserId(), new ColumnSet("systemuserid", "fullname"));
            }
            catch (Exception)
            {

            }
            if (retrievedUser.Id != Guid.Empty && retrievedUser.Contains("fullname"))
            {
                userName = (string)retrievedUser["fullname"];
            }
            return userName;
        }

        #region helper functions
        public string GetFieldFromArgs(RequestActionEventArgs args, string key)
        {
            List<KeyValuePair<string, string>> parameters = Utility.SplitLines(args.Data, CurrentContext, localSessionManager);
            return Utility.GetAndRemoveParameter(parameters, key);
        }
        public void PushDatumToUSD(string pKey, string pValue, string pType, string pAppName, bool pGlobal)
        {
            pType = "string";
            if (!String.IsNullOrEmpty(pKey) && !String.IsNullOrEmpty(pValue) && !String.IsNullOrEmpty(pType))
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;

                Dictionary<string, CRMApplicationData> newData = new Dictionary<string, CRMApplicationData>();
                // add a string: 
                newData.Add(pKey, new CRMApplicationData() { name = pKey, value = pValue, type = pType.ToLower() });

                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, newData, true);
                }
            }
        }
        public void PushDataToUSD(Dictionary<string, CRMApplicationData> pData, string pAppName, bool pGlobal)
        {
            //perform data translation into a Dictionary object before calling this function
            if (pData.Count > 0)
            {
                string appName = !String.IsNullOrEmpty(pAppName) ? pAppName : this.ApplicationName;
                if (pGlobal)
                {
                    // add context item to the global session
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.GlobalSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
                else
                {
                    // Add context item to the current session. 
                    ((DynamicsCustomerRecord)((AgentDesktopSession)localSessionManager.ActiveSession).Customer.DesktopCustomer).MergeReplacementParameter(appName, pData, true);
                }
            }
        }
        #endregion
        #endregion
    }
}
