﻿using System;
using System.ServiceModel;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;

namespace VRM.VCCM.Plugins
{

    /// <summary>
    /// PluginEntryPoint plug-in.
    /// This is a generic entry point for a plug-in class. Use the Plug-in Registration tool found in the CRM SDK to register this class, import the assembly into CRM, and then create step associations.
    /// A given plug-in can have any number of steps associated with it. 
    /// </summary>    
    public class QueueItemPrePick : IPlugin
    {
        #region Secure/Unsecure Configuration Setup
        private string _secureConfig = null;
        private string _unsecureConfig = null;

        public QueueItemPrePick(string unsecureConfig, string secureConfig)
        {
            _secureConfig = secureConfig;
            _unsecureConfig = unsecureConfig;
        }
        #endregion
        public void Execute(IServiceProvider serviceProvider)
        {
            ITracingService tracer = (ITracingService)serviceProvider.GetService(typeof(ITracingService));
            IPluginExecutionContext context = (IPluginExecutionContext)serviceProvider.GetService(typeof(IPluginExecutionContext));
            IOrganizationServiceFactory factory = (IOrganizationServiceFactory)serviceProvider.GetService(typeof(IOrganizationServiceFactory));
            IOrganizationService service = factory.CreateOrganizationService(context.UserId);

            if (context.Depth == 1)
            {
                try
                {
                    if (context.InputParameters.Contains("QueueItemId") && context.InputParameters.Contains("WorkerId"))
                    {
                        Entity retrievedRecord = service.Retrieve("queueitem", (Guid)context.InputParameters["QueueItemId"], new ColumnSet("workerid"));
                        if (retrievedRecord.Contains("workerid") && ((EntityReference)retrievedRecord["workerid"]).Id != (Guid)context.InputParameters["WorkerId"])
                        {
                            throw new InvalidPluginExecutionException("Somebody else has already picked this queueitem. Be sure to refresh the queue to see the latest queue data.");
                        }
                    }
                }
                catch (Exception e)
                {
                    throw new InvalidPluginExecutionException(e.Message);
                }
            }
        }
    }
}
