﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;

namespace VA.FTP2.Plugins.Request
{
    class RequestSetStatePostStageRunner : MCSPlugins.PluginRunner
    {
         #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public RequestSetStatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            // check to make sure this is not a recursive plugin event
            if (PluginExecutionContext.Depth == 1)
            {
                if (PluginExecutionContext.MessageName == "SetStateDynamicEntity")
                {
                    if (PluginExecutionContext.InputParameters.Contains("EntityMoniker") &&
                     (PluginExecutionContext.InputParameters["EntityMoniker"] is EntityReference))
                    {
                        #region If reactivating the request, reactivate the parent request if it was closed
                        var state = (OptionSetValue)PluginExecutionContext.InputParameters["State"];
                        // check for statecode = Open
                        if (state.Value == 0)
                        {
                            var entityRef = (EntityReference)(PluginExecutionContext.InputParameters["EntityMoniker"]);
                            var columns = new ColumnSet("incidentid", "incidentstagecode", "masterid", "numberofchildincidents", "parentcaseid", "statecode", "statuscode", "servicestage", "title");
                            var originalEntity = OrganizationService.Retrieve(entityRef.LogicalName, entityRef.Id, columns);
                            if (originalEntity.Attributes.ContainsKey("parentcaseid"))
                            {
                                var parentCaseEntityReference = (EntityReference)(originalEntity["parentcaseid"]);
                                if (parentCaseEntityReference != null && parentCaseEntityReference.Id != null)
                                {
                                    var parentCase = OrganizationService.Retrieve("incident", parentCaseEntityReference.Id, columns);
                                    // check for statecode = Closed for the Parent Case
                                    if (((OptionSetValue)parentCase.Attributes["statecode"]).Value == 1)
                                    {
                                        // Change the state/status of the parent request using the SetStateRequest message
                                        var setStateRequest = new SetStateRequest
                                        {
                                            EntityMoniker = new EntityReference("incident", parentCase.Id),
                                            State = new OptionSetValue(0),
                                            Status = new OptionSetValue((int)incident_statuscode.Pending)
                                        };
                                        OrganizationService.Execute(setStateRequest);
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                }
            }
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_requestplugins"; }
        }

        /// <summary>
        /// Converts the EntityMoniker to a shell entity
        /// </summary>
        /// <returns></returns>
        public override Entity GetPrimaryEntity()
        {
            var eRef = (EntityReference)PluginExecutionContext.InputParameters["EntityMoniker"];
            var primaryEntity = new Entity(eRef.LogicalName);
            primaryEntity.Id = eRef.Id;
            return primaryEntity;
        }

        public override Entity GetSecondaryEntity()
        {
            return null;
        }
    }
}
