﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.ServiceModel;
using System.Linq;
using VA.FTP2.Plugins.Helpers;
using Xrm;

namespace VA.FTP2.Plugins.Request
{
    class RequestCreatePostStageRunner : MCSPlugins.PluginRunner
    {
        #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public RequestCreatePostStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            if (!PluginExecutionContext.InputParameters.Contains("Target") ||
                    !(PluginExecutionContext.InputParameters["Target"] is Entity)) return;
            try
            {
                var target = GetPrimaryEntity();
                if (target.Contains("parentcaseid")) SetParentPriority(target);
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
            catch (Exception ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
        }

        private void SetParentPriority(Entity target)
        {
            var parentRequestReference = (EntityReference)target["parentcaseid"];
            var priorityValue = (OptionSetValue) target.Attributes["ftp_priority"];
            using (var xrm = new XrmServiceContext(OrganizationService))
            {
                var parentRequest = xrm.IncidentSet.FirstOrDefault(x => x.Id == parentRequestReference.Id);
                if (parentRequest.ftp_Priority != null)
                {
                    if (PluginHelper.ComparePriorityValues(xrm, priorityValue, parentRequest.ftp_Priority))
                    {
                        parentRequest.ftp_Priority = priorityValue;
                    }
                    else
                    {
                        return;
                    }
                }
                else
                {
                    parentRequest.ftp_Priority = priorityValue;
                }

                xrm.UpdateObject(parentRequest);
                xrm.SaveChanges();
            }
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_requestplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
    }
}
