﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.ServiceModel;

namespace VA.FTP2.Plugins.Pact
{
    class PactCreatePreStageRunner : MCSPlugins.PluginRunner
    {
        #region Constructor
        /// <summary>
        /// Standard Constructor
        /// </summary>
        /// <param name="serviceProvider"></param>
        public PactCreatePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }
        #endregion

        internal void Execute(IServiceProvider serviceProvider)
        {
            if (!PluginExecutionContext.InputParameters.Contains("Target") ||
                    !(PluginExecutionContext.InputParameters["Target"] is Entity)) return;
            try
            {
                CreatePactTeam();
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
            catch (Exception ex)
            {
                Logger.WriteToFile(ex.Message);
                throw new InvalidPluginExecutionException(McsSettings.getUnexpectedErrorMessage);
            }
        }

        /// <summary>
        /// Creates a Team with the same name as the Created Pact and adds it to the Pact as a lookup, similar to BU functionality.
        /// </summary>
        private void CreatePactTeam()
        {
            var pact = GetPrimaryEntity();
            var ownerRef = (EntityReference)pact["ownerid"];
            var ownerDetails = OrganizationService.Retrieve("systemuser", ownerRef.Id, new ColumnSet("businessunitid"));
            var createEntity = new Entity("team");
            createEntity["name"] = pact["ftp_name"];
            createEntity["administratorid"] = ownerDetails.ToEntityReference();
            createEntity["businessunitid"] = ownerDetails["businessunitid"];
            var teamId = OrganizationService.Create(createEntity);
            pact["ftp_team"] = new EntityReference("team", teamId);
            
            // Retrieve a role from CRM.
            QueryExpression query = new QueryExpression
            {
                EntityName = "role",
                ColumnSet = new ColumnSet("roleid"),
                Criteria = new FilterExpression
                {
                    Conditions =
                        {
                            new ConditionExpression
                            {
                                AttributeName = "name",
                                Operator = ConditionOperator.Equal,
                                Values = {"FtP Agent"}
                            }
                        }
                }
            };

            var role = OrganizationService.RetrieveMultiple(query).Entities[0];

            // Add the role to the team.
            OrganizationService.Associate(
                   "team",
                   teamId,
                   new Relationship("teamroles_association"),
                   new EntityReferenceCollection() { role.ToEntityReference() });
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_pactplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }
    }
}
