﻿using System;
using System.Linq;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Metadata;
using Microsoft.Xrm.Sdk.Query;
using Xrm;

namespace VA.FTP2.Plugins.Helpers
{
    public class PluginHelper
    {
        private static DateTime? ParseMviDate(string mviDate)
        {
            int year;
            if (!int.TryParse(mviDate.Substring(0, 4), out year)) return null;
            int month;
            if (!int.TryParse(mviDate.Substring(4, 2), out month)) return null;
            int day;
            if (!int.TryParse(mviDate.Substring(6, 2), out day)) return null;
            return new DateTime(year, month, day);
        }

        public static User TryGetUserName(Guid userId, IOrganizationService service)
        {
            var filter = new FilterExpression(LogicalOperator.And);
            filter.AddCondition("systemuserid", ConditionOperator.Equal, userId);
            var query = new QueryExpression("systemuser")
            {
                ColumnSet = new ColumnSet("firstname", "lastname"),
                Criteria = filter
            };
            var result = service.RetrieveMultiple(query);
            var userEntity = result[0];
            return new User
            {
                FirstName = (string)userEntity["firstname"],
                LastName = (string)userEntity["lastname"]
            };
        }

        public static OptionSetValue GetPriority(EntityReference priorityField, IOrganizationService orgService)
        {
            using (var xrm = new XrmServiceContext(orgService))
            {
                //Get reason for request object
                var reasonForRequest = xrm.ftp_reasonforrequestSet.FirstOrDefault(
                    x => x.ftp_reasonforrequestId == priorityField.Id);
                //Get the priority option value
                if (reasonForRequest != null)
                    return reasonForRequest.ftp_Priority;
            }
            return null;
        }

        public static OptionMetadata[] GetOptionList(string optionSetName, XrmServiceContext xrm)
        {
            RetrieveOptionSetResponse retrieveOptionSetResponse;
            retrieveOptionSetResponse =
                    (RetrieveOptionSetResponse)xrm.Execute(new RetrieveOptionSetRequest
                    {
                        Name = "ftp_priority"
                    });    
            
            // Access the retrieved OptionSetMetadata.
            OptionSetMetadata retrievedOptionSetMetadata = (OptionSetMetadata)retrieveOptionSetResponse.OptionSetMetadata;

            // Get the current options list for the retrieved attribute.
            return retrievedOptionSetMetadata.Options.ToArray();
        }

        public static bool ComparePriorityValues(XrmServiceContext xrm, OptionSetValue firstPriority, OptionSetValue secondPriority)
        {
            var optionList = GetOptionList("ftp_reasonforrequest", xrm);

            int[] optionValueList = new int[optionList.Length];

            for (int i = 0; i < optionList.Length; i++)
            {
                optionValueList[i] = (int)optionList[i].Value;
            }

            var firstPriorityIndex = Array.IndexOf(optionValueList, firstPriority.Value);
            var secondPriorityIndex = Array.IndexOf(optionValueList, secondPriority.Value);
            
            return secondPriorityIndex < firstPriorityIndex;
        }

        public class User
        {
            public string FirstName { get; set; }
            public string LastName { get; set; }
        }


    }
}
