﻿using MCSPlugins;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.ServiceModel;
using System.Web;
using Newtonsoft.Json;
using Xrm;

namespace VA.FTP2.Plugins.Patient
{
    public class PatientRetrievePreStageRunner : PluginRunner
    {
        public PatientRetrievePreStageRunner(IServiceProvider serviceProvider)
            : base(serviceProvider)
        {
        }

        private const string Target = "Target";
        public class MviPatient
        {
            public string crme_FirstName { get; set; }
            public string crme_LastName { get; set; }
            public string crme_SSN { get; set; }
            public string crme_Alias { get; set; }
            public string crme_DeceasedDate { get; set; }
            public string crme_EDIPI { get; set; }
            public string crme_FullAddress { get; set; }
            public string crme_FullName { get; set; }
            public string crme_Gender { get; set; }
            public string crme_IdentityTheft { get; set; }
            public string crme_MiddleName { get; set; }
            public string crme_PrimaryPhone { get; set; }
            public string crme_ParticipantID { get; set; }
            public string crme_DOBString { get; set; }
        }

        internal void Execute(string dataMvi)
        {
                TracingService.Trace("at the top");
                Logger.setMethod = "Execute";
                //start the timing for the plugin
                Logger.WriteTxnTimingMessage(String.Format("Starting : {0}", GetType()));
                Logger.WriteDebugMessage(String.Format("At the top of: {0}", GetType()));

            // Determine if this is a recursive call
            // If recursive, return so that CRM will do the retrive from CRM
            if (PluginExecutionContext.ParentContext != null)
                return;

            if (!PluginExecutionContext.InputParameters.Contains(Target) ||
                !(PluginExecutionContext.InputParameters[Target] is EntityReference)) return;

            if (dataMvi != null)
            {
                //data = JsonConvert.DeserializeObject<MviPatient>(dataMvi);
                var data = dataMvi;
                PluginExecutionContext.SharedVariables.Add("data", (Object)data);
            }

            // Get the ephemeral id passed in to retrieve (generated by RetrieveMultiple plugin)
            Guid newid = ((EntityReference)PluginExecutionContext.InputParameters[Target]).Id;

            // Try to retrieve the contact record by ID from CRM to determine if a shadow record already exists
            Entity crment;
            try
            {
                crment = OrganizationService.Retrieve("contact", newid, (ColumnSet)PluginExecutionContext.InputParameters["ColumnSet"]);
            }
            // If a fault occurs, we know the contact was not found
            // In this case, we will create a shadow record
            catch (FaultException<OrganizationServiceFault> e)
            {
                // Check if the exception is for "record does not exist"
                if (e.Detail.InnerFault.ErrorCode == -2147220969)
                {
                    // Create a shadow record
                    Entity ent = new Entity("contact");
                    ent.Id = newid;
                    ent["contactid"] = newid;
                    var data = JsonConvert.DeserializeObject<MviPatient>(dataMvi);
                    if (data.crme_LastName != null) ent["lastname"] = data.crme_LastName;
                    OrganizationService.Create(ent);
                    return;
                }
            }

            Logger.WriteGranularTimingMessage("Finish Retrieve of Person(s)");
        }

        public override string McsSettingsDebugField
        {
            get { return "ftp_veteranplugins"; }
        }

        public override Entity GetPrimaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

        public override Entity GetSecondaryEntity()
        {
            return (Entity)PluginExecutionContext.InputParameters["Target"];
        }

    }
}

