﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.Business;

public partial class controls_TypeOfServiceSelector : System.Web.UI.UserControl
{

    #region Public Member Variables

    public string SurveyTypeCode { get; set; }
    public string QuestionNumber { get; set; }
    public string QuestionText { get; set; }
    public string SelectedChoiceId { get; set; }

    public short StartTabIndex
    {
        set
        {
            LabelForQTS.TabIndex = value;
            //rblTypeOfServiceSelector.TabIndex = (short)(value + 1);
            //RequiredFieldValidatorTSList.TabIndex = (short)(value + 2);
            //LabelOtherDescriptionTS.TabIndex = (short)(value + 3);
            //txtOtherTS.TabIndex = (short)(value + 4);
            //RequiredFieldValidatorOtherTS.TabIndex = (short)(value + 5);
        }
        get
        {
            return LabelForQTS.TabIndex;
        }
    }

    #endregion

    #region Public Methods
    /// <summary>
    /// returns the value to be stored in the survey_result - result_text field.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedResultText()
    {
        if (rblTypeOfServiceSelector.SelectedItem == null)
            return "";
        if (rblTypeOfServiceSelector.SelectedItem.Text.ToLower() == "other")
        {
            // if other ... return what is in text box
            return txtOtherTS.Text;
        }
        else
        {
            return rblTypeOfServiceSelector.SelectedItem.Text;
        }
    }

    /// <summary>
    /// Set other desc text.
    /// </summary>
    /// <param name="value"></param>
    public void SetOtherDescriptionText(string value)
    {
        pnlOtherDescriptionTS.Enabled = txtOtherTS.Enabled = RequiredFieldValidatorOtherTS.Enabled = true;
        txtOtherTS.Text = value;
    }

    #endregion

    /// <summary>
    /// Path_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        LabelForQTS.Text = QuestionText;
        HiddenQTS.Value = QuestionNumber;
        HiddenSurveyTypeTS.Value = SurveyTypeCode;

        if (IsPostBack)
        {
            if (rblTypeOfServiceSelector.SelectedIndex > -1)
            {
                if (rblTypeOfServiceSelector.SelectedItem.Text.ToLower().Contains("other"))
                {
                    pnlOtherDescriptionTS.Enabled = txtOtherTS.Enabled = RequiredFieldValidatorOtherTS.Enabled = true;
                }
                else
                {
                    pnlOtherDescriptionTS.Enabled = txtOtherTS.Enabled = RequiredFieldValidatorOtherTS.Enabled = false;
                }
            }
            else
            {
                pnlOtherDescriptionTS.Enabled = txtOtherTS.Enabled = RequiredFieldValidatorOtherTS.Enabled = false;
            }
        }
    }

    /// <summary>
    /// Databound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblTypeOfServiceSelector_DataBound(object sender, EventArgs e)
    {
        if (!String.IsNullOrEmpty(SelectedChoiceId))
        {
            rblTypeOfServiceSelector.SelectedValue = SelectedChoiceId;
        }
    }

    #region Caching

    private string IDFieldName { get { return this.ID + "_ID"; } }
    private string OtherFieldName { get { return this.ID + "_Other"; } }

    public void TSReadFromCache(Dictionary<string, string> cache)
    {
        string value;
        if (cache.TryGetValue(IDFieldName, out value) && value != null)
        {
            this.SelectedChoiceId = value;
        }
        if (cache.TryGetValue(OtherFieldName, out value) && value != null)
        {
            this.SetOtherDescriptionText(value);
        }
    }

    public string GetSelectedId()
    {
        return rblTypeOfServiceSelector.SelectedValue;
    }

    public void WriteToCache(Dictionary<string, string> cache)
    {
        cache[IDFieldName] = GetSelectedId();

        if (!String.IsNullOrEmpty(GetSelectedId()) && rblTypeOfServiceSelector.SelectedItem.Text.ToLower() == "other")
            cache[OtherFieldName] = txtOtherTS.Text;
    }

    #endregion Caching
}