﻿using System;

public partial class controls_TechDeviceSelector : System.Web.UI.UserControl {

    #region Public Member Variables

    public string SurveyTypeCode { get; set; }
    public string QuestionNumber { get; set; }
    public string QuestionText { get; set; }
    public string SelectedChoiceId { get; set; }

    public short StartTabIndex {
        set {
            LabelForQTechDev.TabIndex = value;
            rblTechDevList.TabIndex = (short)(value + 1);
            RequiredFieldValidatorTechDevList.TabIndex = (short)(value + 2);
            LabelOtherDescription.TabIndex = (short)(value + 3);
            txtOther.TabIndex = (short)(value + 4);
            RequiredFieldValidatorOther.TabIndex = (short)(value + 5);
        }
        get {
            return LabelForQTechDev.TabIndex;
        }
    }

    #endregion

    #region Public Methods

    /// <summary>
    /// returns the selected value of the choice - choice id ... cast to int before save.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedId() {
        return rblTechDevList.SelectedValue;
    }

    /// <summary>
    /// returns the value to be stored in the survey_result - result_text field.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedResultText() {
        if (rblTechDevList.SelectedItem.Text.ToLower() == "other") {
            // if other ... return what is in text box
            return txtOther.Text;
        } else {
            return rblTechDevList.SelectedItem.Text;
        }
    }

    /// <summary>
    /// Set other desc text.
    /// </summary>
    /// <param name="value"></param>
    public void SetOtherDescriptionText(string value) {
        pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = true;
        txtOther.Text = value;
    }

    #endregion

    /// <summary>
    /// Path_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        LabelForQTechDev.Text = QuestionText;
        HiddenQTechDev.Value = QuestionNumber;
        HiddenSurveyTypeTechDev.Value = SurveyTypeCode;

        if (IsPostBack) {
            if (rblTechDevList.SelectedIndex > -1) {
                if (rblTechDevList.SelectedItem.Text.ToLower().Contains("other")) {
                    pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = true;
                }
            } else {
                pnlOtherDescription.Enabled = txtOther.Enabled = RequiredFieldValidatorOther.Enabled = false;
            }
        }
    }

    /// <summary>
    /// Databound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblTechDevList_DataBound(object sender, EventArgs e) {
        if (!String.IsNullOrEmpty(SelectedChoiceId)) {
            rblTechDevList.SelectedValue = SelectedChoiceId;
        }
    }
}