﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportLevel : System.Web.UI.UserControl
{
    private UserAccountManager _currentUser = (UserAccountManager)HttpContext.Current.User;

    public int width
    {
        set { this.mainDiv.Style[HtmlTextWriterStyle.Width] = Unit.Pixel(value).ToString(); }
    }
    /// <summary>
    /// return selected level
    /// </summary>
    public string SelectedLevel
    {
        get { return DropDownListReportLevel.SelectedValue.Trim(); }
    }
    /// <summary>
    /// return selected visn
    /// </summary>
    public string SelectedVisn
    {
        get { return this.DropDownListVisnID.SelectedValue.Trim(); }
    }
    /// <summary>
    /// return selected visn index
    /// </summary>
    public int SelectedVisnIndex
    {
        get { return this.DropDownListVisnID.SelectedIndex; }
    }
    /// <summary>
    /// return selected facility
    /// </summary>
    public string SelectedFacility
    {
        get { return this.DropDownListFacility.SelectedValue.Trim(); }
    }
    /// <summary>
    /// return selected facility Index
    /// </summary>
    public int SelectedFacilityIndex
    {
        get { return this.DropDownListFacility.SelectedIndex; }
    }
    /// <summary>
    /// thes two control properties 
    /// </summary>
    public string REPORT_VISN{ get; set; }
    public string REPORT_FACILITY{ get; set; }
    public string ReportTitle { set; get; }
    public string TableTitle { get; set; }
    //set session variables based on the levels
    public void SetSessionVarsFromLevel()
    {
        if (SelectedLevel == "National")
        {
            ReportTitle = "VISN";
            TableTitle = "National";
            REPORT_VISN = String.Empty;
            REPORT_FACILITY = String.Empty;



        }


        else if (SelectedLevel == "VISN")
        {
            ReportTitle = "Station";
            TableTitle = "VISN";
            REPORT_VISN= SelectedVisn;
            REPORT_FACILITY = String.Empty;

        }
        else if (SelectedLevel == "Station")
        {
            ReportTitle = "Division";
            TableTitle = "Station";
            REPORT_VISN = String.Empty;
            REPORT_FACILITY = SelectedFacility;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DivVISN.Visible = false;
            DivStation.Visible = false;

            SetDropDownListLevel();
        }
    }
    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListReportLevel.SelectedValue == "Select One")
        {
            EnableDropDownListsVisnAndStation(false, false);
        }
        else if (DropDownListReportLevel.SelectedValue == "National")
        {
            EnableDropDownListsVisnAndStation(false, false);
        }
        else
        {
            EnableDropDownListsVisnAndStation(true, false);
            SetDropDownListVisnId();
        }
    }
    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListReportLevel.SelectedValue == "VISN")
        {
            EnableDropDownListsVisnAndStation(true, false);
        }
        else if (DropDownListReportLevel.SelectedValue == "Station")
        {
            SetDropDownListFacility();
            if (DropDownListVisnID.SelectedIndex > 0)
            {
                EnableDropDownListsVisnAndStation(true, true);
            }
            else 
            {
                EnableDropDownListsVisnAndStation(true, false);
            }
        }
    }
    protected void SqlDataSource1_Selecting(object sender, SqlDataSourceSelectingEventArgs e)
    {

    }
    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }

    private void SetDropDownListLevel()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        AddListItem("Select One");

        if (_currentUser.IsInRole(16))
        {
            AddListItem("National");
            AddListItem("VISN");
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }

        if (_currentUser.IsInRole(17))
        {
            AddListItem("VISN");
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }

        if (_currentUser.IsInRole(18))
        {
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }
    }
    private void AddListItem(string itemValue)
    {
        var listItem = new ListItem( itemValue );
        if (!DropDownListReportLevel.Items.Contains(listItem))
            DropDownListReportLevel.Items.Add(listItem);
    }
    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        DivVISN.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        DivStation.Visible = dropDownListFacilityIsVisible;
    }
    private void SetDropDownListVisnId()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        if (!_currentUser.IsInRole(16))
        {
            if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                DropDownListVisnID.DataSource = ObjectDataSourceDirectlyPermittedVISNs;
            }
            else if (DropDownListReportLevel.SelectedValue == "Station")
            {
                DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
            }
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }

        DropDownListVisnID.SelectedIndex = 0;
    }
    private void SetDropDownListFacility()
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            if (_currentUser.IsInRole(16))
            {
                DropDownListFacility.DataSource = ObjectDataSource3;
            }
            else
            {
                DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
            }
            DropDownListFacility.DataBind();
            DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));
            DropDownListFacility.SelectedIndex = 0;
        }
    }
}
