﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="Whodas-i.aspx.cs"
    Inherits="TBI_Instruments_Whodas_i" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField
        {
            font-weight: bold;
            color: #FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>

        <script type="text/javascript">
            $(document).ready(function() {
                $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function() {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                    // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > World Health Organization Disability Assessment Schedule 2.0 - Interview"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="WHODAS-I" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        <h2>
                            Introduction</h2>
                        <br />
                        <p>
                            This instrument was developed by the WHO Classification, Terminology and Standards team, within the framework of the WHO/National
                            Institutes of Health (NIH) Joint Project on Assessment and Classification of Disability.
                        </p>
                        <p>
                            Before using this instrument, interviewers must be trained using the manual Measuring Health and Disability: Manual for
                            WHO Disability Assessment Schedule – WHODAS 2.0 (WHO, 2010), which includes an interview guide and other training material.
                        </p>
                        <p>
                            The versions of the interview available are as follows:
                        </p>
                        <ul>
                            <li>36-item – Interviewer-administered<sup>a</sup></li>
                            <li>36-item – Self-administered</li>
                            <li>36-item – Proxy-administered<sup>b</sup></li>
                            <li>12-item – Interviewer-administered<sup>c</sup></li>
                            <li>12-item – Self-administered</li>
                            <li>12-item – Proxy-administered</li>
                            <li>12+24-item – Interviewer-administered</li>
                        </ul>
                        <p>
                            <sup>a</sup>A computerized version of the interview (iShell) is available for computer-assisted interviews or for data entry
                        </p>
                        <p>
                            <sup>b</sup>Relatives, friends or caretakers
                        </p>
                        <p>
                            <sup>c</sup>The 12-item version explains 81% of the variance of the more detailed 36-item version
                        </p>
                        <p>
                            For more details of the versions please refer to the WHODAS 2.0 manual Measuring Health and Disability: Manual for WHO Disability
                            Assessment Schedule – WHODAS 2.0 (WHO, 2010).
                        </p>
                        <p>
                            Permission to translate this instrument into any language should be obtained from WHO, and all translations should be prepared
                            according to the WHO translation guidelines, as detailed in the accompanying manual.
                        </p>
                        <p>
                            For additional information, please visit www.who.int/whodas or contact:
                        </p>
                        <p>
                            Dr T Bedirhan Üstün<br />
                            Classification, Terminology and Standards<br />
                            Health Statistics and Informatics<br />
                            World Health Organization (WHO)<br />
                            1211 Geneva 27<br />
                            Switzerland<br />
                            <br />
                            Tel: + 41 22 791 3609<br />
                            E-mail: ustunb@who.int
                        </p>
                        <p>
                            This questionnaire contains the interviewer-administered, 12-item version of WHODAS 2.0.
                        </p>
                        <p>
                            Instructions to the interviewer are written in bold and italics – do not read these aloud. <br />
                            Text for the respondent to hear is written in standard text. Read this text aloud.
                        </p>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <br />
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                    <table style="width: 800px; margin-left: 20px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;<!--D-->
                            </td>
                            <td>
                                <!--Date of assessment-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label>
                                <span class="requiredField">*</span>
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="21">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h2>
                                    Section 1 - Face Sheet</h2>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                Complete items F1–F5 before starting each interview
                            </td>
                        </tr>
                        <tr>
                            <td>
                                F1
                            </td>
                            <td>
                                <asp:Label ID="LabelForF1" runat="server" AssociatedControlID="txtF1" SkinID="DataLabel" TabIndex="26"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtF1" runat="server" MaxLength="2" Width="25px" TabIndex="27"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorF1" runat="server" ControlToValidate="txtF1" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                F2
                            </td>
                            <td>
                                <asp:Label ID="LabelForF2" runat="server" AssociatedControlID="txtF2" SkinID="DataLabel" TabIndex="31"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtF2" runat="server" MaxLength="2" Width="25px" TabIndex="32"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorF2" runat="server" ControlToValidate="txtF2" TabIndex="33" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                F3
                            </td>
                            <td>
                                <asp:Label ID="LabelForF3" runat="server" AssociatedControlID="txtF3" SkinID="DataLabel" TabIndex="41"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtF3" runat="server" MaxLength="2" Width="25px" TabIndex="42"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorF3" runat="server" ControlToValidate="txtF3" TabIndex="43" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                F4
                            </td>
                            <td>
                                <!--Interview date-->
                                <asp:Label ID="LabelForF4" runat="server" AssociatedControlID="dpDateF4" SkinID="DataLabel" TabIndex="51">
                                </asp:Label><span class="requiredField">*</span>
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDateF4" runat="server" TabIndex="52">
                                    <Calendar ID="calDateF4" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDateF4" runat="server" ControlToValidate="dpDateF4" TabIndex="53" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                F5
                            </td>
                            <td>
                                <asp:Label ID="LabelForF5" runat="server" AssociatedControlID="rblF5" SkinID="DataLabel" TabIndex="63">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblF5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceF5" TabIndex="64"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorF5" runat="server" ControlToValidate="rblF5" TabIndex="65" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceF5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenF5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenF5" runat="server" Visible="false" Value="F5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h2>
                                    Section 2 - Demographic and Background Information</h2>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <p>
                                    This interview has been developed by the World Health Organization (WHO) to better understand the difficulties people may
                                    have due to their health conditions. The information that you provide in this interview is confidential and will be used
                                    only for research. The interview will take 5–10 minutes to complete.</p>
                                <p>
                                    For respondents from the general population (not the clinical population) say: Even if you are healthy and have no difficulties,
                                    I need to ask all of the questions so that the survey is complete.</p>
                                <p>
                                    I will start with some background questions.</p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                A1
                            </td>
                            <td>
                                <asp:Label ID="LabelForA1" runat="server" AssociatedControlID="rblA1" SkinID="DataLabel" TabIndex="73">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblA1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceA1" TabIndex="74"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorA1" runat="server" ControlToValidate="rblA1" TabIndex="75" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceA1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenA1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenA1" runat="server" Visible="false" Value="A1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                A2
                            </td>
                            <td>
                                <asp:Label ID="LabelForA2" runat="server" AssociatedControlID="txtA2" SkinID="DataLabel" TabIndex="83"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtA2" runat="server" MaxLength="1000" Width="25px" TabIndex="84"></asp:TextBox>&nbsp;years
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorA2" runat="server" ControlToValidate="txtA2" TabIndex="85" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForA2" runat="server" TabIndex="86" ControlToValidate="txtA2" ErrorMessage="Age must be a valid number, greater than 0."
                                    MaximumValue="120" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                A3
                            </td>
                            <td>
                                <asp:Label ID="LabelForA3" runat="server" AssociatedControlID="txtA3" SkinID="DataLabel" TabIndex="93"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtA3" runat="server" MaxLength="1000" Width="25px" TabIndex="94"></asp:TextBox>&nbsp;years
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorA3" runat="server" ControlToValidate="txtA3" TabIndex="95" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForA3" runat="server" TabIndex="96" ControlToValidate="txtA3" ErrorMessage="Must be a number 0 or larger."
                                    MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                A4
                            </td>
                            <td>
                                <asp:Label ID="LabelForA4" runat="server" AssociatedControlID="rblA4" SkinID="DataLabel" TabIndex="103">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                (Select the single best option)<br />
                                <asp:RadioButtonList ID="rblA4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceA4" TabIndex="104"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorA4" runat="server" ControlToValidate="rblA4" TabIndex="105" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceA4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenA4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenA4" runat="server" Visible="false" Value="A4" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                A5
                            </td>
                            <td>
                                <asp:Label ID="LabelForA5" runat="server" AssociatedControlID="rblA5" SkinID="DataLabel" TabIndex="113">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                (Select the single best option)<br />
                                <asp:RadioButtonList ID="rblA5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceA5" TabIndex="114"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true"
                                    OnSelectedIndexChanged="rblA5_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:TextBox ID="txtA5Other" runat="server" Visible="false"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorA5" runat="server" ControlToValidate="rblA5" TabIndex="115" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceA5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenA5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenA5" runat="server" Visible="false" Value="A5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h2>
                                    Section 3 - Preamble</h2>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Say to respondent:</span><br />
                                The interview is about difficulties people have because of health conditions.
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Hand flashcard #1 to respondent</span><br />
                                <p>
                                    By health condition I mean diseases or illnesses, or other health problems that may be short or long lasting; injuries;
                                    mental or emotional problems; and problems with alcohol or drugs.</p>
                                <p>
                                    Remember to keep all of your health problems in mind as you answer the questions. When I ask you about difficulties in doing
                                    an activity think about...</p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Point to flashcard #1</span><br />
                                <ul>
                                    <li>Increased effort</li>
                                    <li>Discomfort or pain</li>
                                    <li>Slowness</li>
                                    <li>Changes in the way you do the activity.</li>
                                </ul>
                                <p>
                                    When answering, I’d like you to think back over the past 30 days. I would also like you to answer these questions thinking
                                    about how much difficulty you have had, on average, over the past 30 days, while doing the activity as you <u>usually</u>
                                    do it.
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Hand flashcard #2 to respondent</span><br />
                                <p>
                                    Use this scale when responding.</p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Read scale aloud:</span><br />
                                <p>
                                    None, mild, moderate, severe, extreme or cannot do.</p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <span style="font-weight: bold; font-style: italic;">Ensure that the respondent can easily see flashcards #1 and #2 throughout
                                    the interview </span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h2>
                                    Section 4 - Core Questions</h2>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <b>In the past 30 days how much difficulty did you have in:</b>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S1
                            </td>
                            <td>
                                <asp:Label ID="LabelForS1" runat="server" AssociatedControlID="rblS1" SkinID="DataLabel" TabIndex="123">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS1" TabIndex="124"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS1" runat="server" ControlToValidate="rblS1" TabIndex="125" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS1" runat="server" Visible="false" Value="S1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S2
                            </td>
                            <td>
                                <asp:Label ID="LabelForS2" runat="server" AssociatedControlID="rblS2" SkinID="DataLabel" TabIndex="133">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS2" TabIndex="134"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS2" runat="server" ControlToValidate="rblS2" TabIndex="135" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS2" runat="server" Visible="false" Value="S2" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S3
                            </td>
                            <td>
                                <asp:Label ID="LabelForS3" runat="server" AssociatedControlID="rblS3" SkinID="DataLabel" TabIndex="143">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS3" TabIndex="144"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS3" runat="server" ControlToValidate="rblS3" TabIndex="145" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS3" runat="server" Visible="false" Value="S3" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S4
                            </td>
                            <td>
                                <asp:Label ID="LabelForS4" runat="server" AssociatedControlID="rblS4" SkinID="DataLabel" TabIndex="153">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS4" TabIndex="154"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS4" runat="server" ControlToValidate="rblS4" TabIndex="155" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS4" runat="server" Visible="false" Value="S4" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S5
                            </td>
                            <td>
                                <asp:Label ID="LabelForS5" runat="server" AssociatedControlID="rblS5" SkinID="DataLabel" TabIndex="163">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS5" TabIndex="164"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS5" runat="server" ControlToValidate="rblS5" TabIndex="165" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS5" runat="server" Visible="false" Value="S5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S6
                            </td>
                            <td>
                                <asp:Label ID="LabelForS6" runat="server" AssociatedControlID="rblS6" SkinID="DataLabel" TabIndex="173">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS6" TabIndex="174"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS6" runat="server" ControlToValidate="rblS6" TabIndex="175" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS6" runat="server" Visible="false" Value="S6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S7
                            </td>
                            <td>
                                <asp:Label ID="LabelForS7" runat="server" AssociatedControlID="rblS7" SkinID="DataLabel" TabIndex="183">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS7" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS7" TabIndex="184"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS7" runat="server" ControlToValidate="rblS7" TabIndex="185" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS7" runat="server" Visible="false" Value="S7" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S8
                            </td>
                            <td>
                                <asp:Label ID="LabelForS8" runat="server" AssociatedControlID="rblS8" SkinID="DataLabel" TabIndex="193">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS8" TabIndex="194"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS8" runat="server" ControlToValidate="rblS8" TabIndex="195" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS8" runat="server" Visible="false" Value="S8" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S9
                            </td>
                            <td>
                                <asp:Label ID="LabelForS9" runat="server" AssociatedControlID="rblS9" SkinID="DataLabel" TabIndex="203">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS9" TabIndex="204"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS9" runat="server" ControlToValidate="rblS9" TabIndex="205" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS9" runat="server" Visible="false" Value="S9" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S10
                            </td>
                            <td>
                                <asp:Label ID="LabelForS10" runat="server" AssociatedControlID="rblS10" SkinID="DataLabel" TabIndex="213">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS10" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS10" TabIndex="214"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS10" runat="server" ControlToValidate="rblS10" TabIndex="215" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS10" runat="server" Visible="false" Value="S10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S11
                            </td>
                            <td>
                                <asp:Label ID="LabelForS11" runat="server" AssociatedControlID="rblS11" SkinID="DataLabel" TabIndex="223">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS11" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS11" TabIndex="224"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS11" runat="server" ControlToValidate="rblS11" TabIndex="225" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS11" runat="server" Visible="false" Value="S11" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                S12
                            </td>
                            <td>
                                <asp:Label ID="LabelForS12" runat="server" AssociatedControlID="rblS12" SkinID="DataLabel" TabIndex="233">
                                </asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblS12" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceS12" TabIndex="234"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorS12" runat="server" ControlToValidate="rblS12" TabIndex="235" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceS12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenS12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenS12" runat="server" Visible="false" Value="S12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                H1
                            </td>
                            <td>
                                <asp:Label ID="LabelForH1" runat="server" AssociatedControlID="txtH1" SkinID="DataLabel" TabIndex="243"></asp:Label>
                                <span class="requiredField">*</span><br />
                                Record number of days
                                <asp:TextBox ID="txtH1" runat="server" MaxLength="1000" Width="25px" TabIndex="244"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorH1" runat="server" ControlToValidate="txtH1" TabIndex="245" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForH1" runat="server" TabIndex="246" ControlToValidate="txtH1" ErrorMessage="Value must be between 0 and 30"
                                    MaximumValue="30" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                H2
                            </td>
                            <td>
                                <asp:Label ID="LabelForH2" runat="server" AssociatedControlID="txtH2" SkinID="DataLabel" TabIndex="253"></asp:Label>
                                <span class="requiredField">*</span><br />
                                Record number of days
                                <asp:TextBox ID="txtH2" runat="server" MaxLength="1000" Width="25px" TabIndex="254"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorH2" runat="server" ControlToValidate="txtH2" TabIndex="255" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForH2" runat="server" TabIndex="256" ControlToValidate="txtH2" ErrorMessage="Value must be between 0 and 30"
                                    MaximumValue="30" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                H3
                            </td>
                            <td>
                                <asp:Label ID="LabelForH3" runat="server" AssociatedControlID="txtH3" SkinID="DataLabel" TabIndex="263"></asp:Label>
                                <span class="requiredField">*</span><br />
                                Record number of days
                                <asp:TextBox ID="txtH3" runat="server" MaxLength="1000" Width="25px" TabIndex="264"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorH3" runat="server" ControlToValidate="txtH3" TabIndex="265" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForH3" runat="server" TabIndex="266" ControlToValidate="txtH3" ErrorMessage="Value must be between 0 and 30"
                                    MaximumValue="30" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblSurveyError" runat="server" TabIndex="300" CssClass="requiredField"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Button ID="btnCalculate" runat="server" Text="Calculate" OnClick="btnCalculate_Click" TabIndex="311" />
                                <br />
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <h3>
                                    Scores</h3>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question S5Score: Compute Screen5 -->
                                <asp:Label ID="LabelForS5Score" runat="server" SkinID="DataLabel" TabIndex="331"></asp:Label>:&nbsp;
                                <asp:Label ID="lblS5Score" runat="server" Font-Bold="true" Text="0" TabIndex="332"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question S11Score: Compute Screen11 -->
                                <asp:Label ID="LabelForS11Score" runat="server" SkinID="DataLabel" TabIndex="333"></asp:Label>:&nbsp;
                                <asp:Label ID="lblS11Score" runat="server" Font-Bold="true" Text="0" TabIndex="334"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question S12Score: Compute Screen12 -->
                                <asp:Label ID="LabelForS12Score" runat="server" SkinID="DataLabel" TabIndex="335"></asp:Label>:&nbsp;
                                <asp:Label ID="lblS12Score" runat="server" Font-Bold="true" Text="0" TabIndex="336"></asp:Label>
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <table style="width: 800px; margin-left: 20px;">
                    <tr>
                        <td style="width: 20px;">
                            &nbsp;
                        </td>
                        <td>
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                ValidationGroup="OnSaveDraft" TabIndex="360" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                                ValidationGroup="OnSave" TabIndex="361" />
                            <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="362" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
