﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="SatisfactionWithLifeScale.aspx.cs"
    Inherits="TBI_Instruments_SatisfactionWithLifeScale" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Satisfaction with Life Scale (SWLS)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="SWLS" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                                        
                    <br />
                    <!-- Question Area -->
                    
                    <br />
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td style="width:20px;">&nbsp;</td>
                            <td style="text-align: left;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="5">
                                </asp:Label>:
                            </td>
                            <td style="text-align: left;">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="6">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align:left;">
                                <!-- Question : Type of submission -->
                                <!-- Get text in code-behind -->
                                <%--<asp:Label ID="LabelForQTYP" runat="server" AssociatedControlID="rblQTYP" SkinID="DataLabel" TabIndex="8">
                                </asp:Label>--%>
                                Type of submission:
                            </td>
                            <td style="text-align: left;">
                                <!-- Question TYP Choice List-->
                                <asp:RadioButtonList ID="rblQTYP" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQTYP" TabIndex="9"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question TYP Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQTYP" runat="server" ControlToValidate="rblQTYP" TabIndex="10" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question TYP Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQTYP" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQTYP" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question TYP : Question Number-->
                                <asp:HiddenField ID="HiddenQTYP" runat="server" Visible="false" Value="TYP" />
                            </td>
                        </tr>
                        
                        
                        <tr>
                            <td style="width:20px;">&nbsp;</td>
                            <td colspan="2">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="11" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width:20px;">&nbsp;</td>
                            <td colspan="2">
                                Below are five statements with which you may agree or disagree. Using the 1-7 scale below, indicate your agreement with
                                each item by placing the appropriate number on the line preceding that item. Please be open and honest in your responding.
                                The 7-point scale is as follows:
                            </td>
                        </tr>
                        <tr>
                            <td style="width:20px;">&nbsp;</td>
                            <td style="text-align: left; padding-left:20px;" colspan="2">
                                1 = strongly disagree
                                <br />
                                2 = disagree
                                <br />
                                3 = slightly disagree
                                <br />
                                4 = neither agree nor disagree
                                <br />
                                5 = slightly agree
                                <br />
                                6 = agree
                                <br />
                                7 = strongly agree
                            </td>
                        </tr>
                            
                        <tr>
                            <td style="width: 20px;">
                                1.
                            </td>
                            <td style="text-align: left;">
                                <!-- Question 1: In most ways my life is close to my ideal. -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="30">
                                </asp:Label>
                            </td>
                            <td style="text-align: right;">
                                <!-- Question 1 Choice List-->
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ1" TabIndex="31"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 1 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 1 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 1 : Question Number-->
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                2.
                            </td>
                            <td style="text-align: left;">
                                <!-- Question 2: The conditions of my life are excellent. -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="33">
                                </asp:Label>
                            </td>
                            <td style="text-align: right;">
                                <!-- Question 2 Choice List-->
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ2" TabIndex="34"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 2 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 2 : Question Number-->
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                3.
                            </td>
                            <td style="text-align: left;">
                                <!-- Question 3: I am satisfied with my life. -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="36">
                                </asp:Label>
                            </td>
                            <td style="text-align: right;">
                                <!-- Question 3 Choice List-->
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ3" TabIndex="37"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 3 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 3 : Question Number-->
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                4.
                            </td>
                            <td style="text-align: left;">
                                <!-- Question 4: So far I have gotten the important things I want in life. -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="39">
                                </asp:Label>
                            </td>
                            <td style="text-align: right;">
                                <!-- Question 4 Choice List-->
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ4" TabIndex="40"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="41" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 4 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 4 : Question Number-->
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                5.
                            </td>
                            <td style="text-align: left;">
                                <!-- Question 5: If I could live my life over, I would change almost nothing. -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="42">
                                </asp:Label>
                            </td>
                            <td style="text-align: right;">
                                <!-- Question 5 Choice List-->
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ5" TabIndex="43"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="44" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 5 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 5 : Question Number-->
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                    </table>
                    <p style="font-style:italic;">
                        Information collected in this instrument is not sufficient to use alone for diagnostic purposes.  Any assessment results need to be verified by the clinician collecting the data for accuracy and used in conjunction with appropriate clinical tools for developing a diagnosis and an individualized treatment plan.
                    </p>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="51" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="52" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="53" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
