﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VHAReportViewer;

public partial class ReportStatusCounts : System.Web.UI.Page
{

    #region Variable Declarations

    private UserAccountManager _currentUser;
    private ReportViewerHandler _reportViewerHandler;
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();
    string _reportName = "ReportStatusCounts";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            ReportViewer1.Visible = false;

            if (!Page.IsPostBack)
            {
                ViewState["ReportViewerHandler"] = _reportViewerHandler = new ReportViewerHandler();
            }
            else
            {
                _reportViewerHandler = (ReportViewerHandler)ViewState["ReportViewerHandler"];
            }

            EnableButtonRunReport();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    void Page_PreRender(object sender, EventArgs e)
    {
        EnableButtonRunReport();
    }
    
    protected void Button1_Click(object sender, EventArgs e)
    {

    }

    protected void btnRunReport_Click(object sender, EventArgs e)
    {
               
       try
       {
        this.ReportLevel1.SetSessionVarsFromLevel();

        ReportViewer1.Reset();

        _reportViewerHandler.ClearParams();
        _reportViewerHandler.AddReportVariable("TableTitle", ReportLevel1.TableTitle);
        _reportViewerHandler.AddReportVariable("ReportTitle", ReportLevel1.ReportTitle);
        _reportViewerHandler.AddReportVariable("VisnId", (ReportLevel1.REPORT_VISN == "" ? null : ReportLevel1.REPORT_VISN));
        _reportViewerHandler.AddReportVariable("FacilityId", (ReportLevel1.REPORT_FACILITY == "" ? null : ReportLevel1.REPORT_FACILITY));
        _reportViewerHandler.AddReportVariable("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
        _reportViewerHandler.AddReportVariable("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
        _reportViewerHandler.AddReportVariable("Username", _currentUser.FullName);

        ReportViewer1.ServerReport.ReportPath = _reportName;
        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        
        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
        }
        _reportViewerHandler.SetServerReportParameters(ReportViewer1);

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
        ReportViewer1.ServerReport.Refresh();
        ReportViewer1.Visible = true;
       }
       catch(Exception ex )
       {
           //_tbiexception.HandleTBIException(ex, _reportName, "100032", "Dropdown Stations Binding");
       }
    }

    #endregion

    #region Private Methods

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }

    private void EnableButtonRunReport()
    {
        if (ReportLevel1.SelectedLevel == "Select One" ||
             (ReportLevel1.SelectedLevel == "VISN" && ReportLevel1.SelectedVisnIndex < 1) ||
             (ReportLevel1.SelectedLevel == "Station" &&
                  (ReportLevel1.SelectedVisnIndex < 1
                   || ReportLevel1.SelectedFacilityIndex < 1))
            )
        {
            ButtonRunReport.Enabled = false;
        }
        else
            ButtonRunReport.Enabled = true;
    }

    #endregion

}
