﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class InitialScreeningNationalSummary : System.Web.UI.Page
{

    #region Variable Declarations

    private UserAccountManager _currentUser;
    string _reportName = "ReportScreenVISNSummary";
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!Page.IsPostBack)
            {
                Session["ReportYear"] = "09";
                Session["ReportMonth"] = "August";
                ReportViewer1.Visible = false;
                SetDropDownListVisnIdForVisnUser();
            }

            if (DropDownListVisnID.SelectedIndex == 0)
            {
                btnRunReport.Enabled = false;
            }
            else
                btnRunReport.Enabled = true;

            //SetReportParameters();

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {

        try
        {
            ReportViewer1.Reset();
            ReportViewer1.ServerReport.ReportPath = _reportName;

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            ReportParameter paramUsername = new ReportParameter("Username", _currentUser.FullName);
            ReportParameter paramVisnId = new ReportParameter("VisnId", DropDownListVisnID.SelectedValue);

          
            ReportViewer1.ServerReport.SetParameters(new ReportParameter[] { paramUsername, paramVisnId });
            ReportViewer1.ProcessingMode = ProcessingMode.Remote;
            ReportViewer1.Visible = true; 
            ReportViewer1.ServerReport.Refresh();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100010", "Get() ReportData");
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100010", "Dropdown Visns Selecting");
        }
    }

    #endregion

    #region Private Methods

    private void SetReportParameters()
    {

        //ReportParameter paramMonth = new ReportParameter("Month", (string)Session["ReportMonth"]);
        //ReportParameter paramYear =  new ReportParameter("Year", (string)Session["ReportYear"]);
        //ReportViewer1.LocalReport.SetParameters(new ReportParameter[] { paramMonth, paramYear });
    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17));
    }

    private void SetDropDownListVisnIdForVisnUser()
    {
        try
        {
            if (!_currentUser.IsInRole(16))
            {
                DropDownListVisnID.DataSource = ObjectDataSourcePermittedVISNs;
                DropDownListVisnID.DataBind();
                DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100010", "Dropdown Visns Binding");
        }
    }

    #endregion

}
