﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class ReportComprehensiveVisnSummary : System.Web.UI.Page
{

    #region Variable Declarations

    private UserAccountManager _currentUser;
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();
    string _reportName = "ReportComprehensiveVisnSummary";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                ReportViewer1.Visible = false;
                SetDropDownListVisnIdForVisnUser();
            }

            if (DropDownListVisnID.SelectedIndex == 0) 
            {
                ButtonRunReport.Enabled = false;
            }
            else
                ButtonRunReport.Enabled = true;

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            string test1 = DropDownListVisnID.SelectedValue;
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

            ReportParameter reportParamVisn = new ReportParameter("VisnId", DropDownListVisnID.SelectedValue);
            ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);

            ReportViewer1.Reset();

            _reportParameters.Clear();
            _reportParameters.Add(reportParamVisn);
            _reportParameters.Add(reportParamUsername);
            ReportViewer1.ServerReport.ReportPath = _reportName;
            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
            ReportViewer1.ProcessingMode = ProcessingMode.Remote;
            ReportViewer1.Visible = true;
            ReportViewer1.ServerReport.Refresh();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100020", "Get() ReportData");
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100020", "Dropdown Visns Selecting");
        }
    }

    #endregion

    #region Private Methods

    private void SetDropDownListVisnIdForVisnUser()
    {
        try
        {
            if (!_currentUser.IsInRole(16))
            {
                DropDownListVisnID.DataSource = ObjectDataSourcePermittedVISNs;
                DropDownListVisnID.DataBind();
                DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100020", "private Function SetDropDownListVisnIdForVisnUser()");
        }
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17));
    }

    #endregion

}
