﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Runtime.InteropServices;
using Telerik.Web.UI;

public partial class TBI_Instruments_RehabFollowUp : BaseTBIInstrumentPage
{

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    private const string FailedFormValuesName = "RehabFollowUpFailedFormValues";
    private const string DeferredMessageKeyName = "RehabFollowUpDeferredMessageKey";
    protected int _surveyTypeId = 36; // Database Id for MedRed_LCI_v2

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();
    String _instTitle;


    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_RehabFollowUp()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods
    protected void OnDateSelected(object sender, EventArgs e)
    {
        if (dpDischarge.SelectedDate != null)
        {
            DateTime temp;
            DateTime temp2;
            if (DateTime.TryParse(dpDischarge.SelectedDate.ToString(), out temp))
            {
                if (DateTime.TryParse(dpFollowUp.SelectedDate.ToString(), out temp2))
                {
                    if (temp > temp2)
                        dpFollowUp.Clear();
                    //dpFollowUp.MinDate = temp;

                }
            }
        }
    }
    /// <summary>
    /// Page Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            // confirm instrument is active - if not, a redirect will occur.
            this.CheckActiveStatus(_surveyTypeId);

            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;
            _instTitle=instTitle;
            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = _tbiInstrumentManager.TbiServiceTo.UserName;

                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "RehabFollowUp.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum)) {
                string patICN = patientManager.GetPatientICNBySSN(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew) {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null) {
                Logging.WriteLogToFile("RehabFollowUp.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                //LabelFacility.Text = _tbiInstrumentManager.TbiServiceTo.InstitutionName;
            }
        }

        QuestionList = GetAllQuestionsForSurvey();        

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        //LabelDate1.Text = GetQuestionText("18");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");

        
        dpDischarge.MaxDate = DateTime.Now;
        //calDischarge.EnableAjaxSkinRendering = "true";

        if (dpDischarge.SelectedDate != null)
        {
            DateTime temp;
            if (DateTime.TryParse(dpDischarge.SelectedDate.ToString(), out temp))
            {
                if(dpFollowUp.SelectedDate<temp)
                { 
                    dpFollowUp.Clear();
                }
                    dpFollowUp.MinDate = temp;
            }            
        }
        dpFollowUp.MaxDate = DateTime.Now;
    }
    
    bool preventNotification = false;

    private InstrumentType selectedInstrumentType;

    protected void Page_Init(object sender, EventArgs e)
    {
        selectedInstrumentType = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId);
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        preventNotification = Request.UrlReferrer.ToString().Contains("InstrumentSummaryNote");
        if (preventNotification != true)
        {
            if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
            {
                SuppressSaveMessage = false;
                SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
                RenderStartUpMessage(false);
            }
            else if (Page.IsPostBack && !preventNotification)
            {
                DeferredMessage = "Save was Successful!";
            }
            else if (DeferredMessage != null)
            {
                SuppressSaveMessage = false;
                SaveSuccessMessage = DeferredMessage;
                RenderStartUpMessage(true);
                DeferredMessage = null;
            }
        }
    }
   
    protected override void OnPreRender(EventArgs e)
    {
        base.OnPreRender(e);
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }
    
    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0)
        {
            preventNotification = true;
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("RehabFollowUp.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Fired when scoring is updated.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void updateTotals(object sender, EventArgs e) {
        calculateTotals();
    }
 


    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }
    private List<STD_QUESTION_CHOICE> getChoiceDetails(String QuestionNumber)
    {
        //string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;
        //string sTypeID = _tbiInstrumentManager.GetSurveyTypeID("Rehab Follow Up");
        //int surveyTypeID = Int32.ParsesTypeID;
         return _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType(QuestionNumber, "Rehab Follow Up");
    }
    public String getChoiceID(String QuestionNumber)
    {
        List<STD_QUESTION_CHOICE> choiceList = new List<STD_QUESTION_CHOICE>();
        choiceList = getChoiceDetails(QuestionNumber);
        String s = "";
        foreach (STD_QUESTION_CHOICE choice in choiceList)
        {
            if (choice.CHOICE_NAME == QuestionNumber)
            {
                s= Convert.ToString(choice.STD_QUESTION_CHOICE_ID);
            }
            
        }

        return s;
    }
    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if (Page.IsValid) {

            calculateTotals();

            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null) {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("RehabFollowUp.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("RehabFollowUp.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null) {
                if (_survey.isNew) {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("RehabFollowUp.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    } else {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey) {
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();


        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();
        

        try {
        // Question DX
        _surveyResult = new SURVEY_RESULT();
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
            _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Question DX");
        }

        try
        {  
        // Discharge Date
        _surveyResult = new SURVEY_RESULT(); 
            if(DischargeQID.Value=="")
            {
                DischargeQID.Value = getChoiceID("Discharge Date");
            }
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(DischargeQID.Value);
            _surveyResult.RESULT_TEXT = string.Format("{0:MM/dd/yyyy}", dpDischarge.SelectedDate); ;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }

        try
        {
        // Follow Up Date
        _surveyResult = new SURVEY_RESULT();
            if (FollowUpQID.Value == "")
            {
                FollowUpQID.Value = getChoiceID("Date of Follow up");
            }
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(FollowUpQID.Value);
            _surveyResult.RESULT_TEXT = string.Format("{0:MM/dd/yyyy}", dpFollowUp.SelectedDate);
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }

        try
        {
            Helpers.SaveRadBtnListAnswers(PanelHdr, survey);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "SaveSurvey() - SaveRadBtnListAnswers");
        }
        try
        {
            Helpers.SaveRadBtnListAnswers(pnlRadBtn, survey);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "SaveSurvey() - SaveRadBtnListAnswers");
        }
        try
        {
            // Follow Up Date
            _surveyResult = new SURVEY_RESULT();
            
            
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "SaveSurvey() - Rehabilitation Setting");
        }


    }// END SaveSurvey
    private void SaveRadBtnListAnswers(Panel panel, SURVEY survey)
    {
        try
        {
            foreach (Control ctrl in panel.Controls)
            {
                if (ctrl is RadioButtonList)
                {
                    RadioButtonList rbl = (RadioButtonList)ctrl;

                    for (int i = 0; i < ((RadioButtonList)ctrl).Items.Count; i++)
                    {
                        if (rbl.Items[i].Selected)
                        {
                            _surveyResult = new SURVEY_RESULT();

                                // Add Question Living Arrangements
                                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbl.Items[i].Value);
                                _surveyResult.RESULT_TEXT = rbl.Items[i].Text;
                                survey.SURVEY_RESULTs.Add(_surveyResult);
                            }

                        }
                    }
                }
            }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "SaveSurvey() - SaveRadBtnListAnswers");
        }
    }
    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        try {

            rblActivity.DataBind();
            rblEnvironment.DataBind();
            rblHealthStatus.DataBind();
            rblParticipation.DataBind();
            rblQualityofLife.DataBind();

            setUpRadioButtons(pnlRadBtn, survey);
            FollowUpQID.Value = getChoiceID("Date of Follow up");
            DischargeQID.Value=getChoiceID("Discharge Date");
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other")) {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        } else {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;


                    case "Respondent":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rbl3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rbl3.SelectedIndex = -1;
                        }

                        break;                                                
                    case "Rehabilitation Setting":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rbl4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rbl4.SelectedIndex = -1;
                        }

                        break;
                  
                    case "Discharge Date":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                        {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                            {
                                dpDischarge.SelectedDate = temp;
                            }                                                        
                        }
                        break;
                    case "Date of Follow up":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                        {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                            {
                                dpFollowUp.SelectedDate = temp;
                            }                           
                        }
                        break;
                    default:
                        break;
                }
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "RehabFollowUp.aspx", "100027", "SetUpSurvey()");
        }
    }// END SetUpSurvey
    private void setUpRadioButtons(Panel panel, SURVEY survey)
    {

        String _sControlID = "";


        foreach (var sResult in survey.SURVEY_RESULTs)
        {
            String s = sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER;
            _sControlID = "rbl" + s.Replace(" ","");
            foreach (Control ctrl in panel.Controls)
            {
                if (ctrl is RadioButtonList)
                {
                    RadioButtonList rbl = (RadioButtonList)ctrl;
                    try
                    {
                        if (rbl.ID == _sControlID)
                        {
                            rbl.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        }
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "Optimal.aspx", "100027", "setUpRadioButtons");
                    }
                }
            }
        }

    }
    /// <summary>
    /// Retrieve instrument title
    /// </summary>
    /// <param name="surveyID"></param>
    /// <returns></returns>
    private string GetInstrumentTitle(int surveyID) {
        string ret = String.Empty;

        try {
            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(surveyID).Title;
            if (instrumentTitle.Count > 0) {
                foreach (string titleLine in instrumentTitle) {
                    if (titleLine.Contains("PhD")) {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    } else {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "RehabFollowUp.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }

        return ret;
    }

    /// <summary>
    /// performs total calcuation
    /// </summary>
    private void calculateTotals() {
        #region calculate basic

        int basicScore = 0;

        foreach (Control ctrl in pnlRadBtn.Controls)
        {
            if (ctrl is RadioButtonList)
            {
                RadioButtonList rbl = (RadioButtonList)ctrl;

                for (int i = 0; i < ((RadioButtonList)ctrl).Items.Count; i++)
                {

                    if ((rbl.Items[i].Selected) && (i != 5))
                    {
                        try
                        {
                            basicScore += i + 1;
                        }
                        catch (Exception surveyEx)
                        {
                            Exception _tbilogerror = HandleTBIException(surveyEx, "RehabFollowUp.aspx", "100027", "calculateTotals()");
                        }

                    }
                }
            }
        }

        
       // lblBasicActivitiesScore.Text = basicScore.ToString();

        #endregion

        #region calculate advanced

        //int advancedScore = 0;

        
        
       // lblAdvancedActivitiesScore.Text = advancedScore.ToString();

        #endregion

        // calculate total
        //int totalScore = basicScore + advancedScore;
        //lblTotalActivitiesScore.Text = totalScore.ToString();

        //HiddenBasicScore.Value = basicScore.ToString();
        //HiddenAdvancedScore.Value = advancedScore.ToString();
        //HiddenTotalScore.Value = totalScore.ToString();
    }

    #endregion
}