﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master"  AutoEventWireup="true" CodeFile="RehabFollowUp.aspx.cs" Inherits="TBI_Instruments_RehabFollowUp" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
            function dateSelected(sender, eventArgs) {
               
                var ndate = eventArgs.get_newDate();   
                //Use $find instead of document.getElementById when dealing with
                //Telerik controls in javascript.
                //From the Telrik forums:  "Our controls are based on the Microsoft AJAX framework. In order to get a reference to a component 
                //object on the client-side, so that you can use its API, you should use the short-hand method $find, which is part of the Microsoft AJAX client library.
                // There is no way to attain the same using getElementById because it returns an HTML DOM object, not a control instance"
                var foUpDt= $find("<%=dpFollowUp.ClientID%>");
                var FollowUpDate=foUpDt.get_selectedDate();


                if(FollowUpDate<ndate)
                {
                    foUpDt.clear();
                }
                foUpDt.set_minDate(ndate);
            }
            
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }
            function OnPopupOpening(sender, args) {


            }

 

            function OnPopupClosing(sender, args) {


            }

            
        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Locomotor Capability Index - 5 (LCI - 5)" TabIndex="10"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" SkinID="DataLabel"  TabIndex="9" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient" TabIndex="10"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="11"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:" TabIndex="12"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="13"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="14"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="Rehab Follow Up" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold"  SkinID="DataLabel" TabIndex="15" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                  <br />
                    <br />
                    
                    <asp:Panel id="PanelHdr" runat="server">
                    <table style="width: 600px;">
                      
                    </table>
                    <br />
                    <table style="width: 700px;" cellpadding="5">
                        <tr>
                            <td colspan="3">
                              <asp:Label ID="LabelforBasicInformation" runat="server"  SkinID="DataLabel" TabIndex="16">
                                Basic Information
                                </asp:Label> 
                            </td>
                        </tr>                                  
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor3" runat="server" AssociatedControlID="rbl3" SkinID="DataLabel" TabIndex="17">
                                <%=GetQuestionText("Respondent")%>
                                </asp:Label>
                            </td>
                            <td style="width: 150px;">
                                <%--Question 03 Choice List--%>
                                <asp:RadioButtonList ID="rbl3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource3"  SkinID="DataLabel" TabIndex="18"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 03 Required Validator--%>
                                <asp:RequiredFieldValidator ID="ResondentValidator" runat="server" ControlToValidate="rbl3"  SkinID="DataLabel" TabIndex="19" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Respondent Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 03 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 03 : Question Number--%>
                                <asp:HiddenField ID="Hidden3" runat="server" Visible="false" Value="Respondent" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor4" runat="server" AssociatedControlID="rbl4" SkinID="DataLabel" TabIndex="20">
                                <%=GetQuestionText("Rehabilitation Setting")%>
                                </asp:Label>
                            </td>
                            <td style="width: 150px;">
                                <%--Question 04 Choice List--%>
                                <asp:RadioButtonList ID="rbl4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource4"  SkinID="DataLabel" TabIndex="21"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 04 Required Validator--%>
                                <asp:RequiredFieldValidator ID="WhereValidator" runat="server" ControlToValidate="rbl4" SkinID="DataLabel"  TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Rehabilitation Setting Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 04 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 04 : Question Number--%>
                                <asp:HiddenField ID="Hidden4" runat="server" Visible="false" Value="Rehabilitation Setting" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 33%;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDischarge" SkinID="DataLabel" TabIndex="23" Text="Discharge Date">
                                </asp:Label>
                            </td>
                            <td colspan="2">
                                <!--Date picker
                                    
                                    -->
                                <telerik:RadDatePicker ID="dpDischarge" runat="server" SkinID="DataLabel"  TabIndex="24" AutoPostBack="false" >
                                        <ClientEvents OnDateSelected="dateSelected" />
                                    <Calendar ID="calDischarge" runat="server">

                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDischarge" SkinID="DataLabel"  TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Discharge Date is required."></asp:RequiredFieldValidator>                                
                                <asp:HiddenField ID="HiddenDisDate" runat="server" Visible="true" Value="Discharge Date" />
                                <asp:HiddenField ID="DischargeQID" runat="server" Visible="true" Value="" />
                                
                                <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenDisDate" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 33%;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate2" runat="server" AssociatedControlID="dpFollowUp" SkinID="DataLabel" TabIndex="26" Text="Date of Follow Up">
                                </asp:Label>
                            </td>
                            <td colspan="2">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpFollowUp" runat="server" SkinID="DataLabel"  TabIndex="27" AutoPostBack="false">
                                    <Calendar ID="calFollowUp" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="dpFollowUp"  SkinID="DataLabel" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Follow Up Date is required."></asp:RequiredFieldValidator>                             
                                <asp:HiddenField ID="hFollowUpDate" runat="server" Visible="true" Value="Date of Follow up" />
                                <asp:HiddenField ID="FollowUpQID" runat="server" Visible="true" Value="" />
                                
                                <asp:ObjectDataSource ID="ObjectDataSource2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="hFollowUpDate" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX"  SkinID="DataLabel" StartTabIndex="29" />
                            </td>
                        </tr>
                        </table>
                </asp:Panel>
                    <asp:Panel id="pnlRadBtn" runat="server">
                        <table>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblActivity" SkinID="DataLabel" TabIndex="33">
                                <%=GetQuestionText("Activity")%>
                                </asp:Label>
                            </td>
                            <td style="width: 400px;">
                                <%--Question 1 Choice List--%>
                                <asp:RadioButtonList ID="rblActivity" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ1" SkinID="DataLabel"  TabIndex="34"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 1 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblActivity"  SkinID="DataLabel" TabIndex="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Take care of yourself Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 1 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 1 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="Activity" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblEnvironment" SkinID="DataLabel" TabIndex="36">
                                     <%=GetQuestionText("Environment")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 2 Choice List--%>
                                <asp:RadioButtonList ID="rblEnvironment" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ2" SkinID="DataLabel"  TabIndex="37"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 2 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblEnvironment"  SkinID="DataLabel" TabIndex="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Live in your home Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 2 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 2 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="Environment" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblHealthStatus" SkinID="DataLabel" TabIndex="39">
                                     <%=GetQuestionText("Health Status")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 3 Choice List--%>
                                <asp:RadioButtonList ID="rblHealthStatus" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ3" SkinID="DataLabel"  TabIndex="40"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 3 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblHealthStatus" SkinID="DataLabel"  TabIndex="41" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Overall health Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 3 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 3 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="Health Status" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblParticipation" SkinID="DataLabel" TabIndex="42">
                                     <%=GetQuestionText("Participation")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 4 Choice List--%>
                                <asp:RadioButtonList ID="rblParticipation" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ4" SkinID="DataLabel"  TabIndex="43"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 4 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblParticipation" SkinID="DataLabel"  TabIndex="44" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Participate in your community Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 4 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 4 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="Participation" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQualityofLife" SkinID="DataLabel" TabIndex="45">
                                     <%=GetQuestionText("Quality of Life")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 5 Choice List--%>
                                <asp:RadioButtonList ID="rblQualityofLife" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ5" SkinID="DataLabel"  TabIndex="46"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 5 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQualityofLife"  SkinID="DataLabel" TabIndex="47" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Overall quality of life Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 5 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 5 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="Quality of Life" />
                            </td>
                        </tr>
                     
        
                       
                        <tr>
                            <td colspan="3">
                                &nbsp;
                            </td>
                        </tr>

               </table></asp:Panel>
                    <table >

                                      
                        
                        <tr>
                            <td colspan="2">
                                <b></b>
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblAdvancedActivitiesScore" runat="server" Text="_"  SkinID="DataLabel" TabIndex="52" Visible="False"></asp:Label></b>
                                <asp:HiddenField ID="HiddenAdvancedScore" runat="server" Value="" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <b></b>
                                <asp:Button ID="btnCalculateTotal" runat="server" Text="Calculate" ToolTip="Calculate Total Score" OnClick="updateTotals" SkinID="DataLabel"  TabIndex="53" Visible="False" />
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblTotalActivitiesScore" runat="server" Text="_" SkinID="DataLabel"  TabIndex="54" Visible="False"></asp:Label></b>
                                <asp:HiddenField ID="HiddenTotalScore" runat="server" Value="" />
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" SkinID="DataLabel"  TabIndex="55" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" SkinID="DataLabel"  TabIndex="56" />
                <asp:Button ID="btnCancelSurvey" runat="server" SkinID="DataLabel"  TabIndex="57" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
    <br />
</asp:Content>