﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class RegistryInstrumentMaster : System.Web.UI.MasterPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //Sets the correct URL for context sensitive help, based on content page
        HyperLinkHelp.NavigateUrl = GetContextSensitiveHelpURL();
        // If the session is timed out due to inactivity, redirect to the timeout screen
       
        if (!AccessAllowed())
        {
            HyperLink1.Visible = false;
        }
    }

    public void SetDirtyFlag(bool flag)
    {
        dirtyFlag.Value = flag == true ? "1" : "0";
    }

    private bool AccessAllowed()
    {
        UserAccountManager _currentUser;
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(413) || _currentUser.IsInRole(417));
    }

    protected void Page_Init(object Sender, EventArgs e)
    {
        Response.Cache.SetCacheability(HttpCacheability.NoCache);
        Response.Cache.SetExpires(DateTime.Now.AddSeconds(-1));
        Response.Cache.SetNoStore();
    }

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html").Replace("tbi_instruments_", "");
    }
}
