﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using System.Web.Configuration;

public partial class PatientInstrumentsNoMDWS : BaseTBIInstrumentPage
{

    #region Variable Declarations

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (DisplayApplicationWarning() == false)
        {
            if (!IsPostBack)
            {
                try
                {
                    //Set the flag that the app should be bypassing MDWS calls
                    Session["BypassMDWS"] = true;

                    PanelPatientConfirm.Visible = true;
                    PanelInstrumentList.Visible = false;

                    TBIServiceTO _tbiServiceTo = new TBIServiceTO();

                    _tbiServiceTo.DUZ = "0001";
                    _tbiServiceTo.DFN = "1316";
                    AddtoSessionTBIServiceTo(_tbiServiceTo);

                    base.BaseTBIInstrumentPage_Load(sender, e);

                    LabelPatient.Text = "None selected"; // _tbiInstrumentManager.TbiServiceTo.PatientName;

                    PanelInstrumentList.Visible = true;

                    GridViewInstruments.DataSource = _tbiInstrumentManager.GetActiveInstrumentList();
                    GridViewInstruments.DataBind();
                }
                catch (Exception ex2)
                {
                    Exception _tbilogerror = HandleTBIException(ex2, "PatientInstrumentsNoMDSWS.aspx", "100002", "GridViewInstruments - DataBind");
                }

            }
            else
            {
                TBIServiceTO _tbiServiceTo;

                try
                {
                    _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
                    _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;
                }
                catch (Exception ex)
                {
                    Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "TBIServiceTO - Session");
                }
            }
        }
    }

    protected int ConfirmPatient(string snum)
    {
        string error = String.Empty;

        int ret = 2; //Default to generic error

        string formattedSnum = snum.Replace("-", "");

        try
        {
            _tbiInstrumentManager.TbiServiceTo.PatientSnum = formattedSnum;

            PatientManager pManager = new PatientManager();
            string patICN = pManager.GetPatientICNBySnum(formattedSnum);

            if (!string.IsNullOrEmpty(patICN))
            {
                //Use matched patient's record
                // _tbiInstrumentManager.TbiServiceTo.PatientName = pManager.GetPatientNameByICN(patICN);
                _tbiInstrumentManager.TbiServiceTo.PatientName = pManager.GetPatientNameBySSN(formattedSnum);
                _tbiInstrumentManager.TbiServiceTo.PatientICN = patICN;

                AddtoSessionSSN(formattedSnum);

                PanelPatientConfirm.Visible = false;
                PanelInstrumentList.Visible = true;

                GridViewInstruments.DataSource = _tbiInstrumentManager.TbiServiceTo.Instruments;
                GridViewInstruments.DataBind();

                return 0;
            }
            else
            {
                //Add new patient
                _tbiInstrumentManager.TbiServiceTo.PatientICN = formattedSnum;

                Survey_Patient surveyPatient = new Survey_Patient();
                surveyPatient.SetAsChangeTrackingRoot(EntityState.New, true);
                surveyPatient.PATIENT_ICN = _tbiInstrumentManager.TbiServiceTo.PatientICN;

                if (String.IsNullOrEmpty(surveyPatient.PATIENT_ICN))
                {
                    error = "Patient's record cannot be added to the Registries database because the ICN identifier is blank; contact your Registries Administrator for assistance.";
                    DisplayErrorMessage(error);
                    return 1;
                }
                else
                {
                    try
                    {
                        surveyPatient.STD_INSTITUTION_ID = Convert.ToInt32(_tbiInstrumentManager.TbiServiceTo.PatientLocationId);
                    }
                    catch (Exception e)
                    {
                        //Invalid value. Ignore error and leave the STD_INSTITUTION_ID field blank
                    }
                    surveyPatient.Snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
                    try
                    {
                        surveyPatient.BIRTH_DATE = Convert.ToDateTime(_tbiInstrumentManager.TbiServiceTo.PatientDOB.Insert(4, "-").Insert(7, "-"));
                    }
                    catch (Exception e)
                    {
                        //Invalid value. Ignore error and leave the BIRTH_DATE field blank
                    }
                    fillPatientNameFields(ref surveyPatient, _tbiInstrumentManager.TbiServiceTo.PatientName);
                    surveyPatient.GENDER = _tbiInstrumentManager.TbiServiceTo.PatientGender;
                    surveyPatient.STA6N = _tbiInstrumentManager.TbiServiceTo.STA6N;
                    surveyPatient.DFN = _tbiInstrumentManager.TbiServiceTo.PatientDFN;

                    if (!pManager.AddSurveyPatient(surveyPatient))
                    {
                        error = "Unable to add Patient record to the Registries database; contact your Registries Administrator for assistance.";
                        DisplayErrorMessage(error);

                        ret = 1;
                    }
                    else
                    {
                        ret = 0;
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "ConfirmPatient()");
        }

        return ret;
    }

    protected void GridViewInstruments_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        try
        {
            Page.Validate();

            if (Page.IsValid)
            {
                int errCode = ConfirmPatient(TextBoxSSNConfirm.Text.Trim());
                switch (errCode)
                {
                    case 0:
                        int selectedInstrumentId = Convert.ToInt32(e.CommandArgument);

                        _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType =
                            (from i in _tbiInstrumentManager.TbiServiceTo.Instruments
                             where i.Id == selectedInstrumentId
                             select i).FirstOrDefault();

                        AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                        //Retrieve status of comprehensive survey
                        string status = String.Empty;
                        SURVEY survey = null;
                        if (selectedInstrumentId == 2) //Comprehensive survey
                        {
                            var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(_tbiInstrumentManager.TbiServiceTo.PatientICN, 2, false).ToList();

                            if (surveys.Count > 0)
                            {
                                survey = surveys.First();
                                if (survey.SURVEY_STATUS != null)
                                {
                                    status = survey.SURVEY_STATUS.ToLower();
                                }

                            }
                        }

                        if (status == "completed")
                        {
                            if (survey != null)
                            {
                                Session["survey"] = survey;
                                Session["ViewOnly"] = true;
                            }

                            Response.Redirect(string.Format("InstrumentSummaryNote.aspx"));
                        }
                        else
                        {
                            AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                            switch (_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Id)
                            {
                                case 2:
                                    Response.Redirect("InstrumentEvaluationEntry.aspx", false);
                                    break;
                                case 3:
                                    Response.Redirect("InstrumentFollowUpEntry.aspx", false);
                                    break;
                                case 4:
                                    Response.Redirect("InstrumentMpaiEntry.aspx", false);
                                    break;
                                case 5:
                                    Response.Redirect("InstrumentCarePlanEntry.aspx", false);
                                    break;
                                case 7:
                                    // MedRed L-Test
                                    Response.Redirect("MedRed_L-Test.aspx", false);
                                    break;
                                case 8:
                                    // MedRed LCI v2
                                    Response.Redirect("MedRed_LCI-v2.aspx", false);
                                    break;
                                case 9:
                                    // MedRed - Two Minute Walk
                                    Response.Redirect("MedRedTwoMinuteWalk.aspx", false);
                                    break;
                                case 10:
                                    // Patients Global Impression of Change (PGIC) scale
                                    Response.Redirect("PatientGlobalImpOfChange.aspx", false);
                                    break;
                                case 11:
                                    // Neurobehavioral Symptom Inventory form
                                    Response.Redirect("NeurobehavioralSymptomInventory.aspx", false);
                                    break;
                                case 12:
                                    // Disabilty Rating Scale
                                    Response.Redirect("DisabiltyRatingScale.aspx", false);
                                    break;
                                case 13:
                                    // QUEST
                                    Response.Redirect("QUESTInstrument.aspx", false);
                                    break;
                                case 14:
                                    // Satisfaction With Life Scale
                                    Response.Redirect("SatisfactionWithLifeScale.aspx", false);
                                    break;
                                case 15:
                                    // Functional Mobility Assessment
                                    Response.Redirect("FunctionalMobilityAssessment.aspx", false);
                                    break;
                                case 16:
                                    // Berg Balance Scale
                                    Response.Redirect("BergBalanceScale.aspx", false);
                                    break;
                                case 17:
                                    // VA Low Vision Visual Functioning (VA LV VFQ 20) Survey
                                    Response.Redirect("VALowVisionSurvey.aspx", false);
                                    break;
                                case 18:
                                    // VA Participation Assessment with Recombined Tools (PART-O) Survey
                                    Response.Redirect("PART-O.aspx", false);
                                    break;
                                case 19:
                                    // VA Mayo-Portland Adaptability Inventory-4 (MPAI-4) Survey
                                    Response.Redirect("MayoPortlandAdaptabilityInventory4.aspx", false);
                                    break;
                                case 20:
                                    // VA JFK Coma Recovery Scale - Revised (CRS-R) Survey
                                    Response.Redirect("JFKComaRecoveryScale.aspx", false);
                                    break;
                                case 21:
                                    // VA Oswestry Low Back Pain Disability Questionnaire (OLBPDQ) Survey
                                    Response.Redirect("OswestryLBDQ.aspx", false);
                                    break;
                                default:                        
                                    Logging.WriteLogToFile("PatientInstrumentsnoMDWS.GridViewInstruments_RowCommand(): WarningRedirect: invalid error code: " + _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Id.ToString());

                                    //incorrectly accessed if value is not in the above
                                    //redirect to warning page
                                    Response.Redirect("Warning.aspx?err=5", false);
                                    break;
                            }
                        }

                        break;
                    case 1:
                        break; // Corresponds to popping an alert 
                    default:                        
                        Logging.WriteLogToFile("PatientInstrumentsNoMDWS.GridViewInstruments_RowCommand(): WarningRedirect: invalid error code: " + errCode.ToString());

                        //Display error message to user
                        Response.Redirect(string.Format("Warning.aspx?err={0}", errCode));
                        break;
                }
            }
            else
            {
                string errMsg = "";

                foreach (IValidator aValidator in this.Validators)
                {
                    if (!aValidator.IsValid)
                    {
                        errMsg = aValidator.ErrorMessage;
                    }
                }

                if (errMsg != "")
                    ShowAlert(errMsg);
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "GridViewInstruments_RowCommand()");
        }
    }

    #endregion

    #region Private Methods

    private bool DisplayApplicationWarning()
    {
        bool result = false;

        try
        {

            if (Session["SkipWarning"] != null)
            {
                if (Session["SkipWarning"].ToString() == "Yes")
                {
                    result = false;
                }
            }
            else
            {
                RegistriesCommonManager commonManager = new RegistriesCommonManager();

                APPLICATION_STATUS appStatus = commonManager.GetApplicationStatus(WebConfigurationManager.AppSettings.Get("Registry"));

                if (appStatus != null)
                {
                    if (appStatus.PROCESS_FLAG > 0)
                    {
                        result = true;
                        Session["warningMessage"] = appStatus.MESSAGE;
                        Session["theUrl"] = Request.Url.Segments[Request.Url.Segments.Length - 1] + Request.Url.Query;

                        Logging.WriteLogToFile("PatientInstrumentsNoMDWS.DisplayApplicationWarning(): WarningRedirect: appStatus.PROCESS_FLAG > 0");

                        Response.Redirect("InstrumentWarning.aspx?id=" + appStatus.PROCESS_FLAG);
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "DisplayApplicationWarning()");
        }

        return result;
    }

    private void DisplayErrorMessage(string sErrorMessage)
    {
        try
        {
            if (!LabelWarningNotificationMessage.Visible)
            {
                LabelWarningNotificationMessage.Visible = true;
                LabelWarningNotificationMessage.Text = sErrorMessage;

                StringBuilder oErrorScript = new StringBuilder();
                string sScript1 = @"<script type=""text/javascript"" language=""JavaScript"">";
                string sScript2a = @" alert('";
                string sScript2b = @"')";
                string sScript3 = @"</script>";
                oErrorScript.AppendLine(sScript1);
                oErrorScript.Append(sScript2a);


                oErrorScript.Append(sErrorMessage.Replace("'", "\\'"));

                oErrorScript.AppendLine(sScript2b);
                oErrorScript.AppendLine(sScript3);

                ClientScript.RegisterStartupScript(this.GetType(), "AlertMessage", oErrorScript.ToString());

                return;
            }
            else
            {
                LabelWarningNotificationMessage.Visible = false;

            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "DisplayErrorMessage()");
        }
    }

    protected void ShowAlert(string message)
    {
        string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
        ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
    }

    private void fillPatientNameFields(ref Survey_Patient surveyPatient, string fullName)
    {
        string name;
        string firstName = "";
        string middleName = "";
        string lastName = "";
        int commaPosition;
        int spacePosition;

        name = fullName.Trim();
        commaPosition = name.IndexOf(",");
        if (commaPosition < 0)
            commaPosition = name.Length;

        lastName = name.Substring(0, commaPosition);

        try
        {
            name = fullName.Substring(commaPosition + 1).Trim();

            spacePosition = name.IndexOf(" ");
            if (spacePosition < 0)
                spacePosition = name.Length;

            firstName = name.Substring(0, spacePosition).Trim();
            middleName = name.Substring(spacePosition + 1).Trim();
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PatientInstrumentsNoMDSWS.aspx", "100002", "fillPatientNameFields()");
        }

        surveyPatient.FIRST_NAME = firstName;
        surveyPatient.MIDDLE_NAME = middleName;
        surveyPatient.LAST_NAME = lastName;
    }

    #endregion

}
