﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using System.Configuration;
using System.Web.Configuration;

public partial class PatientInstruments : BaseTBIInstrumentPage {

    #region Member Variables

    private string _inSiteCode = String.Empty;
    private string _inDUZ = String.Empty;
    private string _inDFN = String.Empty;

    private string _inServerIP = String.Empty;
    private string _inServerPort = String.Empty;

    private string _inTBIEvaluationNoteId = String.Empty;
    private string _inTBIFollowUpNoteId = String.Empty;

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e) {

        if (DisplayApplicationWarning() == false) {
            Session["SkipWarning"] = "Yes";

            //Get parameters from querystring 
            Session["SiteCode"] = Request.QueryString["q9gtw0"];
            Session["DUZ"] = Request.QueryString["yiicf"];
            Session["DFN"] = Request.QueryString["xqi4z"];
            Session["ServerIP"] = Request.QueryString["jbPI0202"];
            Session["ServerPort"] = Request.QueryString["27trp"];
            Session["TBIEvaluationNoteId"] = Request.QueryString["5Sfty21"];
            Session["TBIFollowUpNoteId"] = Request.QueryString["45vlw93"];

            if (Helpers.IsSessionVariableNullOrEmpty(Session["DUZ"])
                || Helpers.IsSessionVariableNullOrEmpty(Session["DFN"])
                || Helpers.IsSessionVariableNullOrEmpty(Session["SiteCode"])
                || Helpers.IsSessionVariableNullOrEmpty(Session["ServerIP"])
                || Helpers.IsSessionVariableNullOrEmpty(Session["ServerPort"])
                ) 
            {
                string sError = "PatientInstruments.Page_Load(): WarningRedirect: null or missing query string values: ";
                if (Helpers.IsSessionVariableNullOrEmpty(Session["DUZ"]))
                    sError += "DUZ;";
                if (Helpers.IsSessionVariableNullOrEmpty(Session["DFN"]))
                    sError += "DFN;";
                if (Helpers.IsSessionVariableNullOrEmpty(Session["SiteCode"]))
                    sError += "SiteCode;";
                if (Helpers.IsSessionVariableNullOrEmpty(Session["ServerIP"]))
                    sError += "ServerIP";
                if (Helpers.IsSessionVariableNullOrEmpty(Session["ServerPort"]))
                    sError += "ServerPort";

                Logging.WriteLogToFile("PatientInstruments.Page_Load(): WarningRedirect: " + sError);

                //if any value is not passed in then the page was called incorrectly, display error message to user
                Response.Redirect("Warning.aspx?err=7");

            } else {
                Response.Redirect("PatientInstrumentsMain.aspx");
            }
        }
    }

    #endregion

    #region Private Methods

    private bool DisplayApplicationWarning() {
        bool result = false;
        try {
            String currentURL = Request.Url.Segments[Request.Url.Segments.Length - 1] + Request.Url.Query;
            Logging.WriteLogToFile("PatientInstruments.DisplayApplicationWarning(): currentURL=" + currentURL);

            if (Session["SkipWarning"] != null)
            {
                if (Session["SkipWarning"].ToString() == "Yes") {
                    result = false;
                }
            } else {
                RegistriesCommonManager commonManager = new RegistriesCommonManager();

                APPLICATION_STATUS appStatus = commonManager.GetApplicationStatus(WebConfigurationManager.AppSettings.Get("Registry"));

                if (appStatus != null) {
                    if (appStatus.PROCESS_FLAG > 0) {
                        result = true;
                        Session["warningMessage"] = appStatus.MESSAGE;
                        Session["theUrl"] = currentURL;

                        Logging.WriteLogToFile("PatientInstruments.DisplayApplicationWarning(): WarningRedirect: appStatus.PROCESS_FLAG > 0");
                        Response.Redirect("InstrumentWarning.aspx?id=" + appStatus.PROCESS_FLAG, false);
                    }
                }
            }
        } catch (Exception _ex) {
            Exception _tbilogerror = HandleTBIException(_ex, "PatientInstruments.aspx", "100007", "DisplayApplicationWarning()");
        }

        return result;
    }

    #endregion

}
