﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="Optimal.aspx.cs"
    Inherits="TBI_Instruments_Optimal" Title="" EnableEventValidation="false" %>


<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
         table.radioWithProperWrap input
         {    
              float: left;
         }

         table.radioWithProperWrap label
         {    
              margin-left: 25px;
              display: block;
         }
         table.checkboxWithProperWrap input
         {    
              float: left;
         }

         table.checkboxWithProperWrap label
         {    
              margin-left: 25px;
              display: block;
         }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
                $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });
               
                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                    // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                    _inactivetimer._stopTimer();
                    _inactivetimer.set_interval(idleSeconds*1000);
                    _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 
            
            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }
            

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" SkinID="DataLabel"  Text="TBI Instruments > Instrument Associations > Locomotor Capability Index - 5 (LCI - 5)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5" border="0">
                        <tr>
                            <td>&nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" SkinID="DataLabel" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>

                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="Optimal" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" SkinID="DataLabel" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="pnlQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                   <%-- Top level panel to get Patient Status, Diagnosis, Work status, Housing status, and living arrangement status
                    --%>                                            
                    <table id="rbl1" cellpadding="5" cellspacing="5" style="width:800px" border="0">         
                         <tr>
                            <td colspan="3">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="5" Visible="True">
                                </asp:Label>
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="6" style="display:none">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                               <%-- <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required." Visible="False"></asp:RequiredFieldValidator>--%>
                            </td>
                        </tr>                  
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td style="width: 280px;">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForPS" runat="server" AssociatedControlID="rbps" SkinID="DataLabel" TabIndex="7">
                                <%=GetQuestionText("Patient Status")%>
                                </asp:Label>
                            </td>
                            <td style="width: 500px;">
                                <%--Question Patient Status Choice List--%>
                                <asp:RadioButtonList ID="rbps" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourcePS" TabIndex="8"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question Patient Status Required Validator--%>
                                <asp:RequiredFieldValidator ID="StatusValidator" runat="server" ControlToValidate="rbps" ValidationGroup="OnSave" TabIndex="9"
                                    Display="Dynamic" ErrorMessage="*Patient Status Selection is required."></asp:RequiredFieldValidator>
                                <%--Question Patient Status Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourcePS" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenPS" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question Patient Status : Question Number--%>
                                <asp:HiddenField ID="HiddenPS" runat="server" Visible="false" Value="Patient Status" />
                            </td>
                        </tr>

                    </table>

                    <table  cellpadding="5" cellspacing="5" style="width: 1000px;" border="0">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                                
                            </td>
                        </tr>

                           
                    </table>
                    <br />
                    </asp:Panel>
                <asp:Panel ID="pnlStatus" runat="server">
                    <table cellpadding="5" cellspacing="5"  style="width: 1000px;" border="0">
                        <tr>
                            <td colspan="3">
                                <asp:Label ID="LabelForBasicActivities" runat="server" AssociatedControlID="pnlStatus" SkinID="DataLabel" TabIndex="11">Basic Activities</asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td style="width: 280px">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor1" runat="server" AssociatedControlID="chbx1" SkinID="DataLabel" TabIndex="12">
                                <%=GetQuestionText("1")%>
                                </asp:Label>
                            </td>
                            <td style="width: 500px;">
                                <%--Question 01 Choice List--%>
                                <asp:CheckBoxList ID="chbx1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource1" TabIndex="13"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="checkboxWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false" RepeatColumns="1" >
                                </asp:CheckBoxList>
                                <%--Question 01 Required Validator--%>
                                <web:RequiredFieldValidatorForCheckBoxLists ID="EmployentValidator" runat="server" TabIndex="14"
                                    ControlToValidate="chbx1"
                                    Display="Dynamic"
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave"
                                    ErrorMessage="Basic Activities Question 1 Employment is required."
                                    CssClass="">
                                </web:RequiredFieldValidatorForCheckBoxLists>
                                <%--Question 01 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 01 : Question Number--%>
                                <asp:HiddenField ID="Hidden1" runat="server"  Value="1" />
                                <br />
                                <asp:TextBox runat="server" ID="txtWork"></asp:TextBox><br/>

                                <asp:RequiredFieldValidator ID="OtherWorkRequiredFieldValidator" TabIndex="15"
                                    ControlToValidate="txtWork"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage="If Occupation is selected text is required in occupation text box."
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave" CssClass="" Enabled="false">
                                </asp:RequiredFieldValidator>


                                <script type="text/javascript">
                                    function pageLoad(sender, args) {

                                        //FIX issue created by timer reload.
                                        
                             
                                        Update_q24();
                                            

                                        var primeGoal=document.getElementById('<%=qt.ClientID%>').value;
                                        var ddp=document.getElementById('<%=q24.ClientID%>');
                                        var ddp2=document.getElementById('<%=ddPrimaryGoal.ClientID%>')   
                                        
                                        for(var x=0;x < ddp.length; x++)
                                        {                                               
                                            if( ddp.options[x].text ==  primeGoal.toString())
                                            {
                                                
                                                ddp.selectedIndex=x;
                                                SetPrimaryGoalValue(); 
                                            }
                                        }  
                                    }
                                </script>
                            </td>

                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor2" runat="server" AssociatedControlID="chbx2" SkinID="DataLabel" TabIndex="16">
                                <%=GetQuestionText("2")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 02 Choice List--%>
                                <asp:CheckBoxList ID="chbx2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource2" TabIndex="17"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="checkboxWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false" RepeatColumns="1">
                                </asp:CheckBoxList>
                                <%--Question 02 Required Validator--%>
                                <web:RequiredFieldValidatorForCheckBoxLists ID="UseValidator" runat="server" TabIndex="18"
                                    ControlToValidate="chbx2"
                                    Display="Dynamic"
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave"
                                    ErrorMessage="Basic Activities Question 2 Select Type of Aid Used"
                                    CssClass="">
                                </web:RequiredFieldValidatorForCheckBoxLists>
                                <%--Question 02 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 02 : Question Number--%>
                                <asp:HiddenField ID="Hidden2" runat="server" Visible="false" Value="2" />
                                <br />
                                <asp:TextBox runat="server" ID="txtUse" TabIndex="19"></asp:TextBox><br/>

                                <asp:RequiredFieldValidator ID="OtherUseRequiredFieldValidator" TabIndex="20"
                                    ControlToValidate="txtUse"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage="Basic Activities Question 2 Other Use is required."
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave" CssClass="" Enabled="false">
                                </asp:RequiredFieldValidator>




                            </td>
                        </tr>



                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor3" runat="server" AssociatedControlID="chbx3" SkinID="DataLabel" TabIndex="21">
                                <%=GetQuestionText("3")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 03 Choice List--%>
                                <asp:CheckBoxList ID="chbx3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource3" TabIndex="22"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="checkboxWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false" RepeatColumns="1">
                                </asp:CheckBoxList>
                                <%--Question 03 Required Validator--%>
                                <web:RequiredFieldValidatorForCheckBoxLists ID="WhomValidator" runat="server" TabIndex="23"
                                    ControlToValidate="chbx3"
                                    Display="Dynamic"
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave"
                                    ErrorMessage="Basic Activities Question 3 Select Living Arrangement Status."
                                    CssClass="">
                                </web:RequiredFieldValidatorForCheckBoxLists>
                                <%--Question 03 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 03 : Question Number--%>
                                <asp:HiddenField ID="Hidden3" runat="server" Visible="false" Value="3" />
                                <br />
                                <asp:TextBox runat="server" ID="txtWhom" TabIndex="24"></asp:TextBox><br/>

                                <asp:RequiredFieldValidator ID="OtherWhomRequiredFieldValidator" TabIndex="25"
                                    ControlToValidate="txtWhom"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage="Basic Activities Question 3 Other arrangement is required."
                                    SetFocusOnError="true"
                                    ValidationGroup="OnSave" CssClass="" Enabled="false">
                                </asp:RequiredFieldValidator>
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelFor4" runat="server" AssociatedControlID="rbl4" SkinID="DataLabel" TabIndex="26">
                                <%=GetQuestionText("4")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 04 Choice List--%>
                                <asp:RadioButtonList ID="rbl4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSource4" TabIndex="27"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 04 Required Validator--%>
                                <asp:RequiredFieldValidator ID="WhereValidator" runat="server" ControlToValidate="rbl4" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="*Basic Activities Question 4 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 04 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSource4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="Hidden4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 04 : Question Number--%>
                                <asp:HiddenField ID="Hidden4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                         </table>
                    <br />
                    </asp:Panel>
                <asp:Panel ID="pnlBaselineDifficulty" runat="server">
                    <table cellpadding="5" cellspacing="5" style="width: 1000px;"border="0">

                        <tr>
                            <td colspan="3">
                                <asp:Label ID="LabelForBaseline" runat="server" AssociatedControlID="pnlBaselineDifficulty" SkinID="DataLabel" TabIndex="29">Baseline Difficulty</asp:Label>
                            </td>
                        </tr>


                        <tr>
                            <td style="width: 1000px;" colspan="3">&nbsp;

                                <br />
                                <asp:Label ID="LabelForInstructions" runat="server" AssociatedControlID="pnlBaselineDifficulty" SkinID="DataLabel" TabIndex="30">  <strong>
                                    Instructions: Please select the level of difficulty you have for each activity today.

                                </strong></asp:Label>
                              
                                

                            </td>

                        </tr>
                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td style="width: 280px;">&nbsp;
                            </td>
                            <td style="width: 700px;">&nbsp;
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQdifficulty1" SkinID="DataLabel" TabIndex="31">
                                <%=GetQuestionText("Baseline Difficulty-1")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 1 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty1" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ1" TabIndex="32"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 1 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQdifficulty1" TabIndex="33" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 1 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 1 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 1 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="Baseline Difficulty-1" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQdifficulty2" SkinID="DataLabel" TabIndex="34">
                                     <%=GetQuestionText("Baseline Difficulty-2")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 2 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ2" TabIndex="35"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 2 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQdifficulty2" TabIndex="36" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 2 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 2 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 2 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="Baseline Difficulty-2" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQdifficulty3" SkinID="DataLabel" TabIndex="37">
                                     <%=GetQuestionText("Baseline Difficulty-3")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 3 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty3" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ3" TabIndex="38"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 3 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQdifficulty3" TabIndex="39" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 3 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 3 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 3 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="Baseline Difficulty-3" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQdifficulty4" SkinID="DataLabel" TabIndex="40">
                                     <%=GetQuestionText("Baseline Difficulty-4")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 4 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty4" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ4" TabIndex="41"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 4 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQdifficulty4" TabIndex="42" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 4 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 4 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 4 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="Baseline Difficulty-4" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQdifficulty5" SkinID="DataLabel" TabIndex="43">
                                     <%=GetQuestionText("Baseline Difficulty-5")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 5 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty5" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ5" TabIndex="44"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 5 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQdifficulty5" TabIndex="45" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 5 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 5 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 5 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="Baseline Difficulty-5" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQdifficulty6" SkinID="DataLabel" TabIndex="46">
                                     <%=GetQuestionText("Baseline Difficulty-6")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 6 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty6" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ6" TabIndex="47"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 6 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQdifficulty6" TabIndex="48" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 6 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 6 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 6 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="Baseline Difficulty-6" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQdifficulty7" SkinID="DataLabel" TabIndex="49">
                                     <%=GetQuestionText("Baseline Difficulty-7")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 7 Choice List--%>
                                <asp:RadioButtonList    ID="rblQdifficulty7" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ7" TabIndex="50"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 7 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQdifficulty7" TabIndex="51" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 7 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 7 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 7 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="Baseline Difficulty-7" />
                            </td>
                        </tr>

                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQdifficulty8" SkinID="DataLabel" TabIndex="52">
                                     <%=GetQuestionText("Baseline Difficulty-8")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 8 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty8" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ8" TabIndex="53"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 8 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQdifficulty8" TabIndex="54" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 8 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 8 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 8 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="Baseline Difficulty-8" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQdifficulty9" SkinID="DataLabel" TabIndex="55">
                                     <%=GetQuestionText("Baseline Difficulty-9")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 9 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty9" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ9" TabIndex="56"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 9 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQdifficulty9" TabIndex="57" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 9 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 9 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 9 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="Baseline Difficulty-9" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQdifficulty10" SkinID="DataLabel" TabIndex="58">
                                     <%=GetQuestionText("Baseline Difficulty-10")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 10 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty10" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ10" TabIndex="59"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 10 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQdifficulty10" TabIndex="60" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 10 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 10 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 10 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="Baseline Difficulty-10" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQdifficulty11" SkinID="DataLabel" TabIndex="61">
                                     <%=GetQuestionText("Baseline Difficulty-11")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 11 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty11" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11" TabIndex="62"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 11 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQdifficulty11" TabIndex="63" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 11 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 11 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 11 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="Baseline Difficulty-11" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQdifficulty12" SkinID="DataLabel" TabIndex="64">
                                     <%=GetQuestionText("Baseline Difficulty-12")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 12 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ12" TabIndex="65"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 12 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQdifficulty12" TabIndex="66" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 12 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 12 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 12 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="Baseline Difficulty-12" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQdifficulty13" SkinID="DataLabel" TabIndex="67">
                                     <%=GetQuestionText("Baseline Difficulty-13")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 13 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty13" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ13" TabIndex="68"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 13 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQdifficulty13" TabIndex="69" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 13 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 13 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 13 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="Baseline Difficulty-13" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQdifficulty14" SkinID="DataLabel" TabIndex="70">
                                     <%=GetQuestionText("Baseline Difficulty-14")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 14 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty14" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ14" TabIndex="71"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 14 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQdifficulty14" TabIndex="72" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 14 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 14 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 14 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="Baseline Difficulty-14" />
                            </td>
                        </tr>

                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQdifficulty15" SkinID="DataLabel" TabIndex="73">
                                     <%=GetQuestionText("Baseline Difficulty-15")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 15 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty15" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ15" TabIndex="74"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 15 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQdifficulty15" TabIndex="75" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 15 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 15 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ15" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 15 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="Baseline Difficulty-15" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQdifficulty16" SkinID="DataLabel" TabIndex="76">
                                     <%=GetQuestionText("Baseline Difficulty-16")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 16 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty16" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ16" TabIndex="77"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 16 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQdifficulty16" TabIndex="78" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 16 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 16 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ16" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 16 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="Baseline Difficulty-16" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQdifficulty17" SkinID="DataLabel" TabIndex="79">
                                     <%=GetQuestionText("Baseline Difficulty-17")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 17 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty17" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ17" TabIndex="80"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 17 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQdifficulty17" TabIndex="81" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 17 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 17 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 17 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="Baseline Difficulty-17" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQdifficulty18" SkinID="DataLabel" TabIndex="82">
                                     <%=GetQuestionText("Baseline Difficulty-18")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 18 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty18" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ18" TabIndex="83"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 18 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQdifficulty18" TabIndex="84" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 18 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 18 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 18 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="Baseline Difficulty-18" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQdifficulty19" SkinID="DataLabel" TabIndex="85">
                                     <%=GetQuestionText("Baseline Difficulty-19")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 19 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty19" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ19" TabIndex="86"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 19 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQdifficulty19" TabIndex="87" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 19 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 19 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 19 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="Baseline Difficulty-19" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQdifficulty20" SkinID="DataLabel" TabIndex="88">
                                     <%=GetQuestionText("Baseline Difficulty-20")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 20 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty20" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ20" TabIndex="89"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 20 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQdifficulty20" TabIndex="90" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 20 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 20 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 20 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="Baseline Difficulty-20" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQdifficulty21" SkinID="DataLabel" TabIndex="91">
                                     <%=GetQuestionText("Baseline Difficulty-21")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 21 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty21" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ21" TabIndex="92"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 21 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQdifficulty21" TabIndex="93" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 21 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 21 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 21 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="Baseline Difficulty-21" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQdifficulty22" SkinID="DataLabel" TabIndex="94">
                                     <%=GetQuestionText("Baseline Difficulty-22")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 22 Choice List--%>
                                <asp:RadioButtonList ID="rblQdifficulty22" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ22" TabIndex="95"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"  CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false" >
                                </asp:RadioButtonList>
                                <%--Question 22 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQdifficulty22" TabIndex="96" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 22 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 22 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ22" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 22 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="Baseline Difficulty-22" />
                            </td>
                        </tr>
                        </table>
                    <table  style="width: 1000px;" cellpadding="5" cellspacing="5" border="0">

                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td>
                                <b>Difficulty Baseline Score</b>
                                <asp:Button ID="btnCalculateBasicScore" runat="server" Text="Calculate" OnClick="updateTotals" ToolTip="Calculate Basic Score"  TabIndex="97" />
                               <!-- <input type="button" id="Button1" onclick="sumTotals" value="Calculate"  TabIndex="38" visible="false" ></button> -->
                            </td>
                            <td align="right">
                                <b>
                                <asp:Label ID="lblBasicActivitiesScore" runat="server" Text="_" SkinID="DataLabel"  TabIndex="98"></asp:Label><asp:Label ID="lblBasicActivitiesScoreTotal" runat="server" Text="_" SkinID="DataLabel"  TabIndex="98">_Total Score For Difficulty Baseline</asp:Label></b>
                                <asp:HiddenField ID="HiddenBasicScore" runat="server" Value="" />
                                
                                <asp:label ID="lblScoreID" style="display: none;" runat="server" Text="" TabIndex="99" />
                                <asp:label ID="lblScore" style="display: none;" runat="server" Text="0" TabIndex="100"  />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">&nbsp;
                            </td>
                        </tr>
                        
                        <tr>
                            <td style="width:20px;">&nbsp
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForBD23" runat="server" AssociatedControlID="dd23a" SkinID="DataLabel" TabIndex="99">
                                     <%=GetQuestionText("Baseline Difficulty-23")%>
                                </asp:Label>                                                               
                            </td>
                        </tr>
                        </table>
                    </asp:Panel>
                    <asp:Panel ID="pnlDropDownLists" runat="server">
                        <table style="width: 1000px;" cellpadding="5" cellspacing="5" border="0">
                            <tr>
                                <td style="width: 20px;">&nbsp;
                                </td>
                                <td colspan="2">
                                    <table style="width:600px;" border="0">
                                        <tr>
                                            <td style="width:200px;">
                                                <asp:Label ID="LabelForBD23a" runat="server" AssociatedControlID="dd23a" SkinID="DataLabel" TabIndex="100">
                                                 <%=GetQuestionText("Baseline Difficulty-23a")%>
                                                </asp:Label>
                                            </td>
                                            <td style="width:200px;">
                                                <asp:Label ID="LabelForBD23b" runat="server" AssociatedControlID="dd23b" SkinID="DataLabel" TabIndex="101">
                                                 <%=GetQuestionText("Baseline Difficulty-23b")%>
                                                </asp:Label>
                                            </td>
                                            <td style="width:200px;">
                                                <asp:Label ID="LabelForBD23c" runat="server" AssociatedControlID="dd23c" SkinID="DataLabel" TabIndex="102">
                                                 <%=GetQuestionText("Baseline Difficulty-23c")%>
                                                </asp:Label>
                                            </td>

                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:DropDownList ID="dd23a" runat="server" DataSourceID="ObjectDataSource23a" TabIndex="103" onchange="Update_q24();" 
                                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AppendDataBoundItems="true"
                                                    AutoPostBack="false" Visible="true">
                                                    <asp:ListItem Text="Select One" Value="0"></asp:ListItem>
                                                </asp:DropDownList>
                                                <%--Question 23a Required Validator--%>
                                                <asp:RequiredFieldValidator ID="dd23aRequiredFieldValidator" runat="server" ControlToValidate="dd23a" TabIndex="104" ValidationGroup="OnSave" InitialValue="0"
                                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 23A Selection is required." Enabled="False"></asp:RequiredFieldValidator>
                                                <%--Question 23a Object Data Source--%>
                                                <asp:ObjectDataSource ID="ObjectDataSource23a" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenField23a" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <%--Question 23a : Question Number--%>
                                                <asp:HiddenField ID="HiddenField23a" runat="server"  Value="Baseline Difficulty-23a" />
                                            </td>
                                            <td>
                                                <asp:DropDownList ID="dd23b" runat="server" DataSourceID="ObjectDataSource23b" TabIndex="105" onchange="Update_q24()"
                                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AppendDataBoundItems="true"
                                                    AutoPostBack="false" Visible="true">
                                                    <asp:ListItem Text="Select One" Value="0"></asp:ListItem>
                                                </asp:DropDownList>
                                                <%--Question 23b Required Validator--%>
                                                <asp:RequiredFieldValidator ID="dd23bRequiredFieldValidator" runat="server" ControlToValidate="dd23b" TabIndex="106" ValidationGroup="OnSave" InitialValue="0"
                                                    Display="Dynamic" ErrorMessage="*Baseline Difficulty Question 23B  Selection is required." Enabled="False"></asp:RequiredFieldValidator>
                                                <%--Question 23b Object Data Source--%>
                                                <asp:ObjectDataSource ID="ObjectDataSource23b" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenField23b" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <%--Question 23b : Question Number--%>
                                                <asp:HiddenField ID="HiddenField23b" runat="server" Value="Baseline Difficulty-23b" />
                                            </td>
                                            <td>
                                                <asp:DropDownList ID="dd23c" runat="server" DataSourceID="ObjectDataSource23c" TabIndex="107" onchange="Update_q24()"
                                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AppendDataBoundItems="true"
                                                    AutoPostBack="false" Visible="true">
                                                    <asp:ListItem Text="Select One" Value="0"></asp:ListItem>
                                                </asp:DropDownList>
                                                <%--Question 23c Required Validator--%>
                                                <asp:RequiredFieldValidator ID="dd23cRequiredFieldValidator" runat="server" ControlToValidate="dd23c" TabIndex="108" ValidationGroup="OnSave" InitialValue="0"
                                                    Display="Dynamic" ErrorMessage="Baseline Difficulty Question 23C Selection is required."  Enabled="False"></asp:RequiredFieldValidator>
                                                <%--Question 23c Object Data Source--%>
                                                <asp:ObjectDataSource ID="ObjectDataSource23c" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenField23c" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <%--Question 23c : Question Number--%>
                                                <asp:HiddenField ID="HiddenField23c" runat="server" Value="Baseline Difficulty-23c" />                                                
                                            </td>
                                        </tr>
                                    </table>
                                    <%--OnServerValidate="cusCustom_ServerValidate" --%>

                                    <asp:CustomValidator runat="server" ID="cusCustomq23" ClientValidationFunction="cusCustom_ClientValidate" ErrorMessage="Only Choose Each Activity Once" ValidationGroup="OnSave" TabIndex="109"></asp:CustomValidator>


                                    

                                    <%--<asp:CompareValidator ID="q23oneCompareValidator" runat="server" ErrorMessage="Only Choose Each Activity Once," ValidationGroup="second" ControlToValidate="q23one" ControlToCompare="q23two" Operator="NotEqual"></asp:CompareValidator>
                                <asp:CompareValidator ID="q23twoCompareValidator" runat="server" ErrorMessage="*" ValidationGroup="second" ControlToValidate="q23one" ControlToCompare="q23three" Operator="NotEqual"></asp:CompareValidator>
                                <asp:CompareValidator ID="q23threeCompareValidator" runat="server" ErrorMessage="*" ValidationGroup="second" ControlToValidate="q23two" ControlToCompare="q23three" Operator="NotEqual"></asp:CompareValidator>--%>

                                    <br />
                                    &nbsp
                                </td>
                            </tr>

                            <tr>
                                <td colspan="3">&nbsp
                                </td>
                            </tr>
                            <tr>
                                <td>&nbsp
                                </td>
                                <td colspan="2">
                                    <!-- Get text in code-behind -->
                                    <asp:Label ID="Label2" runat="server" AssociatedControlID="q24" SkinID="DataLabel" TabIndex="110">
                                     <%=GetQuestionText("Baseline Difficulty-24a")%>
                                    </asp:Label>
                                     
                                </td>
                            </tr>

                            <tr>
                                <td></td>
                                <td colspan="2">
                                    
                                   
                                    <%--<asp:CompareValidator ID="q24oneCompareValidator" runat="server" ErrorMessage="Needs to Match" ValidationGroup="second" ControlToValidate="q24" ControlToCompare="q23one" Operator="Equal"></asp:CompareValidator>
                                <asp:CompareValidator ID="q24twoCompareValidator" runat="server" ErrorMessage="Needs to Match" ValidationGroup="second" ControlToValidate="q24" ControlToCompare="q23two" Operator="Equal"></asp:CompareValidator>
                                <asp:CompareValidator ID="q24threeCompareValidator" runat="server" ErrorMessage="Needs to Match" ValidationGroup="second" ControlToValidate="q24" ControlToCompare="q23three" Operator="Equal"></asp:CompareValidator>--%>

                                <asp:DropDownList runat="server" ID="q24" TabIndex="113"  onchange="SetPrimaryGoalValue()" onFocus="checkq23Vals()"
                                    CssClass="" ValidationGroup="OnSave" AppendDataBoundItems="true"
                                    AutoPostBack="false" Visible="true">
                                    <asp:ListItem Text="Select One" Value="0"></asp:ListItem>
                                </asp:DropDownList><br/>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="q24" TabIndex="114"
                                    ErrorMessage="A Primary PT Goal is required." Display="Dynamic"
                                    ValidationGroup="OnSave" InitialValue="0"></asp:RequiredFieldValidator>

                                    <asp:HiddenField ID="HiddenFieldq24" runat="server" Value="Primary Goal" />
                                    <asp:HiddenField ID="qcid" runat="server" Visible="true" Value=""/>
                                    <asp:HiddenField ID="qt" runat="server" Visible="true" value=""/>

                                     
                                    
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3"><asp:DropDownList ID="ddPrimaryGoal" runat="server" DataSourceID="ObjectDataSource24"  
                                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AppendDataBoundItems="true"
                                                    AutoPostBack="false" style="display:none" TabIndex="112">
                                                    <asp:ListItem Text="Select One" Value="0"></asp:ListItem>
                                                </asp:DropDownList>
                                            
                                                <%--Question 23c Object Data Source--%>
                                                <asp:ObjectDataSource ID="ObjectDataSource24" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"  
                                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenField24" Direction="Input" Name="questionNumber" Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <%--Question 23c : Question Number--%>
                                                <asp:HiddenField ID="HiddenField24" runat="server" Value="Baseline Difficulty-24" />

                                <asp:CustomValidator runat="server" ID="custValid24" ClientValidationFunction="checkq23Vals" ErrorMessage="All 3 goals must be selected" 
                                    ValidationGroup="OnSave" TabIndex="115"></asp:CustomValidator>
                                    
                                    &nbsp;&nbsp; 
                                </td>
                            </tr>
                        </table>
                        <script type="text/javascript">
                                                                             
                                        
                            function cusCustom_ClientValidate(sender, e)
                            {

                                //alert('cusCustom_ClientValidate');
                                var t1, t2, t3;
                                t1 = $('#<%=dd23a.ClientID%> option:selected').text();
                                            t2 = $('#<%=dd23b.ClientID%> option:selected').text();
                                            t3 = $('#<%=dd23c.ClientID%> option:selected').text();
                                            //alert(t1 + ' - ' + t2 + ' - ' + t3);
                                            if ((t1 == t2) || (t2 == t3) || (t1 == t3))
                                                e.IsValid = false;
                                            else
                                                e.IsValid = true;
                                        }

                                        function Update_q24() 
                                        {
                                            //alert("here");
                                            var t1, t2, t3;
                                            t1 = $('#<%=dd23a.ClientID%> option:selected').text();
                                            t2 = $('#<%=dd23b.ClientID%> option:selected').text();
                                            t3 = $('#<%=dd23c.ClientID%> option:selected').text();

                                            var t1_val, t2_val, t3_val;
                                            t1_val = $('#<%=dd23a.ClientID%> option:selected').val();
                                            t2_val = $('#<%=dd23b.ClientID%> option:selected').val();
                                            t3_val = $('#<%=dd23c.ClientID%> option:selected').val();
                                        
                                            $('#<%=q24.ClientID%>').find('option').remove().end()
                                                 
                                                .append('<option value="0">Select One</option>') 
                                                .append('<option value="' + t1_val + '">' + t1 + '</option>')
                                                .append('<option value="' + t2_val + '">' + t2 + '</option>')
                                                .append('<option value="' + t3_val + '">' + t3 + '</option>');

                                        }
                                        //.append('<option value="0">Selected One</option>')
                                   
                                        $('#<%=dd23a.ClientID%>').change(function() {Update_q24(); Page_ClientValidate("");});
                            $('#<%=dd23b.ClientID%>').change(function() {Update_q24(); Page_ClientValidate("");});
                            $('#<%=dd23c.ClientID%>').change(function() {Update_q24(); Page_ClientValidate("");});                                        
                                    
                            function checkq23Vals()
                            {
                                var t1, t2, t3, msg, errCount;
                                t1 = $('#<%=dd23a.ClientID%> option:selected').val();
                                            t2 = $('#<%=dd23b.ClientID%> option:selected').val();
                                            t3 = $('#<%=dd23c.ClientID%> option:selected').val();
                                            msg='A selection for First, Second, and Third PT objectives must be selected.';
                                            errCount=0;
                                            if (t1 == 0)
                                            {  
                                                errCount=errCount+1;
                                            }
                                            if (t2 == 0)
                                            {  
                                                errCount=errCount+2;
                                            }
                                            if (t3 == 0)
                                            {                                                      
                                                errCount=errCount+4;
                                            }
                                            if(errCount>0)
                                            {
                                                alert(msg);
                                                switch(errCount) 
                                                {
                                                    case 1:
                                                        //Only Number One needs a value
                                                        document.getElementById('<%=dd23a.ClientID%>').focus();
                                                        break;
                                                    case 2:
                                                        //Only Number Two needs a value
                                                        document.getElementById('<%=dd23b.ClientID%>').focus();
                                                        break;
                                                    case 3:
                                                        //Numbers One and Two need values
                                                        document.getElementById('<%=dd23a.ClientID%>').focus();
                                                        break;
                                                    case 4:
                                                        //Only Number Three needs a value
                                                        document.getElementById('<%=dd23c.ClientID%>').focus();
                                                        break;
                                                    case 5:
                                                        //Numbers One and Three need values
                                                        document.getElementById('<%=dd23a.ClientID%>').focus();
                                                        break;
                                                    case 6:
                                                        //Numbers Two and Three need values
                                                        document.getElementById('<%=dd23b.ClientID%>').focus();
                                                        break;
                                                    case 7:
                                                        //Numbers One, Two, and Three need values
                                                        document.getElementById('<%=dd23a.ClientID%>').focus();
                                                        break;
                                                    default:
                                                } 
                                            }
                                            //Update_q24();
                                        }
                                       
                                        function SetPrimaryGoalValue() 
                                        {   
                                            var choice=$('#<%=q24.ClientID%> option:selected').text();
                                            var choice2=$('#<%=q24.ClientID%> option:selected').val();
                                            var qcid=$('#<%= qcid.ClientID %>');
                                            var qt=$('#<%= qt.ClientID %>');
                                            var ddp=document.getElementById('<%=ddPrimaryGoal.ClientID%>');

                                            if(choice!='Select One')
                                            {

                                                qcid.value=choice2;
                                                qt.value=choice;
                                            
                                                for(var x=0;x < ddp.length; x++)
                                                {                                                
                                                    if( ddp.options[x].text ==  choice && x>0)
                                                    {
                                                        ddp.selectedIndex=x;
                                                        qcid.value=ddp.options[x].value;
                                                        qt.value=ddp.options[x].text;
                                                        x=ddp.length;
                                                    }
                                                } 
                                                
                                            }
                                        }
                                        function cusCustom_ClientValidate4(sender, e)
                                        {
                                            var t1, t2, t3, t4;
                                            t1 = $('#<%=dd23a.ClientID%> option:selected').text();
                                            t2 = $('#<%=dd23b.ClientID%> option:selected').text();
                                            t3 = $('#<%=dd23c.ClientID%> option:selected').text();
                                            t4 = $('#<%=q24.ClientID%> option:selected').text();
                                            //alert(t1 + ' - ' + t2 + ' - ' + t3);
                                            if ((t4 == t1) || (t4 == t2) || (t4 == t3))
                                                e.IsValid = true;
                                            else
                                                e.IsValid = false;
                                        }
                                    
                                    </script>
                                    <script type="text/javascript">
                                        if($('#<%=chbx1.ClientID %>_10').is(':checked')==false) {$('#<%=txtWork.ClientID%>').toggle().val('');}//alert('now');}
                                        if($('#<%=chbx2.ClientID %>_4').is(':checked')==false) {$('#<%=txtUse.ClientID%>').toggle().val('');}//alert('now1');}
                                        if($('#<%=chbx3.ClientID %>_6').is(':checked')==false) {$('#<%=txtWhom.ClientID%>').toggle().val('');}//alert('now2');}

                                        $('#<%=chbx1.ClientID %>_10').click(function() 
                                        {
                                            for (i = 0; i < Page_Validators.length; i++) 
                                            {
                                                if (Page_Validators[i].controltovalidate == "<%=txtWork.ClientID %>" && $('#<%=chbx1.ClientID %>_10').is(':checked')==false) 
                                                {
                                                    $('#<%=txtWork.ClientID%>').hide();
                                                    ValidatorEnable(Page_Validators[i], false);
                                                }
                                                else if(Page_Validators[i].controltovalidate == "<%=txtWork.ClientID %>" && $('#<%=chbx1.ClientID %>_10').is(':checked')==true)
                                                {   
                                                    $('#<%=txtWork.ClientID%>').show();
                                                    ValidatorEnable(Page_Validators[i], true);
                                                }
                                        }
                                        });

                                    $('#<%=chbx2.ClientID %>_4').click(function() 
                                        {
                                            for (i = 0; i < Page_Validators.length; i++) 
                                            {
                                                if (Page_Validators[i].controltovalidate == "<%=txtUse.ClientID %>" && $('#<%=chbx2.ClientID %>_4').is(':checked')==false) 
                                                {
                                                    $('#<%=txtUse.ClientID%>').hide();
                                                    ValidatorEnable(Page_Validators[i], false);
                                                }
                                                else if(Page_Validators[i].controltovalidate == "<%=txtUse.ClientID %>" && $('#<%=chbx2.ClientID %>_4').is(':checked')==true)
                                                {     
                                                    $('#<%=txtUse.ClientID%>').show();
                                                    ValidatorEnable(Page_Validators[i], true);
                                                }
                                        }
                                    });

                                    $('#<%=chbx3.ClientID %>_6').click(function() 
                                        {                                            
                                            for (i = 0; i < Page_Validators.length; i++) 
                                            {
                                                if (Page_Validators[i].controltovalidate == "<%=txtWhom.ClientID %>" && $('#<%=chbx3.ClientID %>_6').is(':checked')==false) 
                                                {
                                                    $('#<%=txtWhom.ClientID%>').hide();
                                                    ValidatorEnable(Page_Validators[i], false);
                                                }
                                                else if(Page_Validators[i].controltovalidate == "<%=txtWhom.ClientID %>" && $('#<%=chbx3.ClientID %>_6').is(':checked')==true)
                                                {
                                                    $('#<%=txtWhom.ClientID%>').show();
                                                    ValidatorEnable(Page_Validators[i], true);
                                                }
                                        } 
                                    });
                                    </script>
                    </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="116" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="117" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="118" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
    <br />
    <asp:Label runat="server" ID="cclabel" Text="Copyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved." SkinID="DataLabel" TabIndex="119"></asp:Label>
</asp:Content>
