﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_NeurobehavioralSymptomInventory : BaseTBIInstrumentPage {

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 11; // Database Id for Neurobehavioral Symptom Inventory form 

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_NeurobehavioralSymptomInventory() {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            // confirm instrument is active - if not, a redirect will occur.
            this.CheckActiveStatus(_surveyTypeId);

            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > "
                                  + _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "NeurobehavioralSymptomInventory.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew) {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("NeurobehavioralSymptomInventory.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        }

        string instrumentTitle = GetInstrumentTitle(_surveyTypeId);
        LabelInstrumentTitle.Text = instrumentTitle;
        Page.Title = "TBI Instruments - " + instrumentTitle;

        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        #region Setting Label Text

        // set label text, etc.
        LabelDate1.Text = GetQuestionText("D");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7.Text = GetQuestionText("7");
        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");
        LabelForQ14.Text = GetQuestionText("14");
        LabelForQ15.Text = GetQuestionText("15");
        LabelForQ16.Text = GetQuestionText("16");
        LabelForQ17.Text = GetQuestionText("17");
        LabelForQ18.Text = GetQuestionText("18");
        LabelForQ19.Text = GetQuestionText("19");
        LabelForQ20.Text = GetQuestionText("20");
        LabelForQ21.Text = GetQuestionText("21");
        LabelForQ22.Text = GetQuestionText("22");

        #endregion

        dpDate1.MaxDate = DateTime.Now;
    }

    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        btnCancelSurvey.Enabled = btnSaveSurveyDraft.Enabled = btnSubmitSurvey.Enabled = false;

        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        btnCancelSurvey.Enabled = btnSaveSurveyDraft.Enabled = btnSubmitSurvey.Enabled = false;

        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            //Session["rawScore"] = hiddenRawScore.Value.ToString();
            //Session["tScore"] = hiddenTScore.Value.ToString();
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("NeurobehavioralSymptomInventory.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e) {
        if (PanelInstructions.Visible) {
            PanelInstructions.Visible = false;
            lnkBtnToggleInstructions.Text = "Click for Instructions";
        } else {
            PanelInstructions.Visible = true;
            lnkBtnToggleInstructions.Text = "Hide Instructions";
        }
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if (Page.IsValid) {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null) {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("NeurobehavioralSymptomInventory.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("NeurobehavioralSymptomInventory.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null) {
                if (_survey.isNew) {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("NeurobehavioralSymptomInventory.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    } else {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey) {

        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

        //Delete all the survey results from database if there are any.
        SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
        _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);

        // Question DX
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
            _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question DX");
        }

        // Question D - Date
        STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question D choice
            _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {
            Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - QuestionD");
        }

        // Question 1 - Feeling Dizzy
        if (rblQ1.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 1 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ1.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ1.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question1");
            }
        }

        // Question 2 - Loss of balance
        if (rblQ2.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question2");
            }
        }

        // Question 3 - Poor coordination, clumsy
        if (rblQ3.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question3");
            }
        }

        // Question 4 - Headaches
        if (rblQ4.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question4");
            }
        }

        // Question 5 - Nausea
        if (rblQ5.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question5");
            }
        }

        // Question 6 - Vision problems, blurring, trouble seeing
        if (rblQ6.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 6 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question6");
            }
        }

        // Question 7 - Sensitivity to light
        if (rblQ7.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 7 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ7.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question7");
            }
        }

        // Question 8 - Hearing diffuculty
        if (rblQ8.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ8.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ8.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question8");
            }
        }

        // Question 9 - Sensitivity to noise
        if (rblQ9.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question9");
            }
        }

        // Question 10 - Numbness or tingling on parts of my body
        if (rblQ10.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ10.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question10");
            }
        }

        // Question 11 - Change in taste and/or smell
        if (rblQ11.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 11 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question11");
            }
        }

        // Question 12 - Loss of appetite or increased appetite
        if (rblQ12.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ12.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ12.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question12");
            }
        }

        // Question 13 - Poor concentration, can’t pay attention, easily distracted
        if (rblQ13.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 13 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ13.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ13.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question13");
            }
        }

        // Question 14 - Forgetfulness, can’t remember things
        if (rblQ14.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 14 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ14.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ14.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question14");
            }
        }

        // Question 15 - Difficulty making decisions
        if (rblQ15.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 15 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ15.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ15.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question15");
            }
        }

        // Question 16 - Slowed thinking, difficulty getting organized, can’t finish things
        if (rblQ16.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 16 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ16.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ16.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question16");
            }
        }

        // Question 17 - Fatigue, loss of energy, getting tired easily
        if (rblQ17.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 17 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ17.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ17.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question17");
            }
        }

        // Question 18 - Difficulty falling or staying asleep
        if (rblQ18.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 18 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ18.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ18.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question18");
            }
        }

        // Question 19 - Feeling anxious or tense
        if (rblQ19.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 19 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ19.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ19.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question19");
            }
        }

        // Question 20 - Feeling depressed or sad
        if (rblQ20.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 20 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ20.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ20.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question20");
            }
        }

        // Question 21 - Irritability, easily annoyed
        if (rblQ21.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 21 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ21.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ21.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question21");
            }
        }

        // Question 22 - Poor frustration tolerance, feeling easily overwhelmed by things
        if (rblQ22.SelectedIndex > -1) {
            _surveyResult = new SURVEY_RESULT();

            try {
                // Add Question 22 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ22.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ22.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            } catch (Exception surveyEx) {
                Exception _tbilogerror = HandleTBIException(surveyEx, "NeurobehavioralSymptomInventory.aspx", "100027", "SaveSurvey() - Question22");
            }
        }

        btnCancelSurvey.Enabled = btnSaveSurveyDraft.Enabled = btnSubmitSurvey.Enabled = true;

    }// END SaveSurvey

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1) {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other")) {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        } else {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    case "D":

                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                                dpDate1.SelectedDate = temp;
                            }
                        }

                        break;
                    case "1":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ1.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "2":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ2.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "3":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "4":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "5":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "6":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "7":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ7.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "8":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ8.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "9":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "10":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ10.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "11":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "12":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ12.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "13":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ13.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "14":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ14.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "15":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ15.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "16":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ16.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "17":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ17.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "18":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ18.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "19":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ19.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "20":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ20.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "21":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ21.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    case "22":
                        if (sResult.STD_QUESTION_CHOICE_ID != null) {
                            rblQ22.SelectedValue = sResult.STD_QUESTION_CHOICE_ID.ToString();
                        }

                        break;
                    default:
                        break;
                }
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "NeurobehavioralSymptomInventory.aspx", "100027", "SetUpSurvey()");
        }
    }// END SetUpSurvey

    /// <summary>
    /// Retrieve instrument title
    /// </summary>
    /// <param name="surveyID"></param>
    /// <returns></returns>
    private string GetInstrumentTitle(int surveyID) {
        string ret = String.Empty;

        try {
            List<string> instrumentTitle = _tbiInstrumentManager.GetInstrumentByID(surveyID).Title;
            if (instrumentTitle.Count > 0) {
                foreach (string titleLine in instrumentTitle) {
                    if (titleLine.Contains("PhD")) {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    } else {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "NeurobehavioralSymptomInventory.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }

        return ret;
    }

    #endregion
}