﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="MedRed_LCI-v2.aspx.cs"
    Inherits="TBI_Instruments_MedRed_LCI_v2" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Locomotor Capability Index - 5 (LCI - 5)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MRLCI" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                    The Locomotor Capabilities Index for face-to-face interview. Subjects were asked "Whether or not you wear your prosthesis,
                    at the present time, would you say that you are "able" to do the following activities."
                    <br />
                    
                    <br />
                    <table style="width: 600px;">
                        <tr>
                            <td style="width: 33%;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="5">
                                </asp:Label>
                            </td>
                            <td colspan="2">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="6">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table  cellpadding="5">
                        <tr>
                        <td colspan="3">
                            <strong>&nbsp;&nbsp;&nbsp; 0 = No, 1 = Yes, if someone helps me, 2 = Yes, if someone is near me, 3 = Yes Alone with ambulation aids, 4 = Yes Alone without ambulation aids </strong>
                        </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                Basic Activities
                            <br /></td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="17">
                                </asp:Label>
                            </td>
                            <td style="width: 150px;">
                                <%--Question 1 Choice List--%>
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ1" TabIndex="18"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 1 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="19" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 1 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 1 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="20">
                                     <%=GetQuestionText("2")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 2 Choice List--%>
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ2" TabIndex="21"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 2 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 2 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 2 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="23">
                                     <%=GetQuestionText("3")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 3 Choice List--%>
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ3" TabIndex="24"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 3 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 3 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 3 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="26">
                                     <%=GetQuestionText("4")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 4 Choice List--%>
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ4" TabIndex="27"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 4 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 4 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 4 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="29">
                                     <%=GetQuestionText("5")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 5 Choice List--%>
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ5" TabIndex="30"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 5 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="31" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 5 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 5 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="32">
                                     <%=GetQuestionText("6")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 6 Choice List--%>
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ6" TabIndex="33"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 6 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="34" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 6 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 6 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="35">
                                     <%=GetQuestionText("7")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 7 Choice List--%>
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ7" TabIndex="36"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 7 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="37" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 7 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 7 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <b>Basic activities score</b>
                                <asp:Button ID="btnCalculateBasicScore" runat="server" Text="Calculate" ToolTip="Calculate Basic Score" OnClick="updateTotals" TabIndex="38" />
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblBasicActivitiesScore" runat="server" Text="_" TabIndex="39"></asp:Label>/28</b>
                                <asp:HiddenField ID="HiddenBasicScore" runat="server" Value="" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                Advanced Activities
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="40">
                                     <%=GetQuestionText("8")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 8 Choice List--%>
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ8" TabIndex="41"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 8 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="42" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 8 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 8 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="43">
                                     <%=GetQuestionText("9")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 9 Choice List--%>
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ9" TabIndex="44"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 9 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="45" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 9 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 9 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="46">
                                     <%=GetQuestionText("10")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 10 Choice List--%>
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ10" TabIndex="47"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 10 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="48" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 10 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 10 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="49">
                                     <%=GetQuestionText("11")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 11 Choice List--%>
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11" TabIndex="50"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 11 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="51" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 11 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 11 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="52">
                                     <%=GetQuestionText("12")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 12 Choice List--%>
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ12" TabIndex="53"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 12 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="54" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 12 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 12 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="55">
                                     <%=GetQuestionText("13")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 13 Choice List--%>
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ13" TabIndex="56"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 13 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="57" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 13 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 13 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="58">
                                     <%=GetQuestionText("14")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 14 Choice List--%>
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ14" TabIndex="59"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="updateTotals"
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 14 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="60" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 14 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 14 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <b>Advanced activities score</b>
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblAdvancedActivitiesScore" runat="server" Text="_" TabIndex="61"></asp:Label>/28</b>
                                <asp:HiddenField ID="HiddenAdvancedScore" runat="server" Value="" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <b>Total score</b>
                                <asp:Button ID="btnCalculateTotal" runat="server" Text="Calculate" ToolTip="Calculate Total Score" OnClick="updateTotals" TabIndex="62" />
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblTotalActivitiesScore" runat="server" Text="_" TabIndex="63"></asp:Label>/56</b>
                                <asp:HiddenField ID="HiddenTotalScore" runat="server" Value="" />
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="64" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="65" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="66" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
