﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="MedRed_L-Test.aspx.cs"
    Inherits="TBI_Instruments_MedRed_L_Test" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
            DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > L - Test" TabIndex="2"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="5"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MRL" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;<asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="6" CausesValidation="false" />
                    <br />
                    <!-- Instruction Area -->
                    <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                        <br />
                        <div style="padding: 5px; width: 900px;">
                            The L Test incorporates transfers and turns into an assessment of mobility and gait speed.<br />
                            <p>
                                The standard total distance covered for the L Test should be 20 meters.</p>
                            <p>
                                The L Test should be demonstrated for each patient, and an untimed practice trial permitted for all patients.</p>
                            <p>
                                The time should be recorded as the number of seconds (rounded to the nearest 10th) required for each patient to complete
                                the task.</p>
                            <p>
                                Subjects are asked to rise from a chair, walk 3 meters, perform a right-angle turn, and continue walking 7 meters before turning around
                                and walking back along the same path and sitting down. Subjects cover 20 meters and perform four turns.</p>
                            <p>
                                The time for completion of the full test is recorded, as well as the distance (if different than 20 meters total), and the
                                average of two trials is recorded in the chart.</p>
                        </div>
                    </asp:Panel>
                    <!-- End Instruction Area -->
                    <br />
                    <table style="width: 600px" cellpadding="5">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!--Date 1-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForDate" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel">
                                </asp:Label>
                                <br />
                                <!--Date 1 picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="7">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="8" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelforLowerExtremityAmputation" runat="server" AssociatedControlID="rblLowerExtremityAmputation" SkinID="DataLabel" TabIndex="17">
                                </asp:Label>
                                <br />
                                <%--Lower Extremity Amputation Question List--%>
                                <asp:RadioButtonList ID="rblLowerExtremityAmputation" runat="server" AutoPostBack="True" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceLowerExtAmputation"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnSelectedIndexChanged="rblLowerExtremityAmputation_SelectedIndexChanged"
                                    TabIndex="18">
                                </asp:RadioButtonList>
                                <%--Lower Extremity Amputation Question Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorLowerExtremityAmputation" runat="server" ControlToValidate="rblLowerExtremityAmputation"
                                    TabIndex="19" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Lower Extremity Amputation selection is required."></asp:RequiredFieldValidator>
                                <%--Lower Extremity Amputation Question Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceLowerExtAmputation" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Lower Extremity Amputation Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <asp:Panel ID="pnlLowerExtremityAmputationLevel" runat="server" Visible="false">
                                    <!-- Get text in code-behind -->
                                    <asp:Label ID="LabelForLowerExtremityAmputationLevel" runat="server" AssociatedControlID="rblLowerExtremityAmputationLevel"
                                        SkinID="DataLabel" TabIndex="20">
                                    </asp:Label>
                                    <br />
                                    <%--Lower Extremity Amputation Level List--%>
                                    <asp:RadioButtonList ID="rblLowerExtremityAmputationLevel" runat="server" DataSourceID="ObjectDataSourceLowerExtAmpLevel"
                                        TabIndex="21" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                    </asp:RadioButtonList>
                                    <%--Lower Extremity Amputation Level Object Data Source--%>
                                    <asp:ObjectDataSource ID="ObjectDataSourceLowerExtAmpLevel" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                        TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <%--Lower Extremity Amputation Level Question Number--%>
                                    <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelforAssistiveDevice" runat="server" AssociatedControlID="rblAssistiveDevice" SkinID="DataLabel" TabIndex="22">
                                </asp:Label>
                                <br />
                                <%--Assistive Device Question List--%>
                                <asp:RadioButtonList ID="rblAssistiveDevice" runat="server" RepeatDirection="Horizontal" AutoPostBack="True" DataSourceID="ObjectDataSourceAssistiveDevice"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnSelectedIndexChanged="rblAssistiveDevice_SelectedIndexChanged"
                                    TabIndex="23">
                                </asp:RadioButtonList>
                                <%--Assistive Device Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorAssistiveDevice" runat="server" ControlToValidate="rblAssistiveDevice"
                                    TabIndex="24" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assistive Device answer is required."></asp:RequiredFieldValidator>
                                <%--Assistive Device Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceAssistiveDevice" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Assistive Device Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <asp:Panel ID="pnlAssistiveDeviceSelection" runat="server" Visible="false">
                                    <!-- Get text in code-behind -->
                                    <asp:Label ID="LabelForAssistiveDeviceSelection" runat="server" AssociatedControlID="rblAssistiveDeviceSelection" SkinID="DataLabel" TabIndex="25">
                                    </asp:Label>
                                    <br />
                                    <%--Assistive Device Selection Question List--%>
                                    <asp:RadioButtonList ID="rblAssistiveDeviceSelection" runat="server" DataSourceID="ObjectDataSourceAssistiveDeviceSelection"
                                        TabIndex="26" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                    </asp:RadioButtonList>
                                    <%--Assistive Device Selection Question Required Validator--%>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorAssistiveDeviceSelection" runat="server" ControlToValidate="rblAssistiveDeviceSelection"
                                        TabIndex="27" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assistive Device selection is required."></asp:RequiredFieldValidator>
                                    <%--Assistive Device Selection Object Data Source--%>
                                    <asp:ObjectDataSource ID="ObjectDataSourceAssistiveDeviceSelection" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                        TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <%--Assistive Device Selection Question Number--%>
                                    <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelPhysicalAssistance" runat="server" AssociatedControlID="rblPhysicalAssistance" SkinID="DataLabel" TabIndex="28">
                                </asp:Label>
                                <br />
                                <asp:RadioButtonList ID="rblPhysicalAssistance" runat="server" DataSourceID="ObjectDataSourcePhysicalAssistance" TabIndex="29"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                </asp:RadioButtonList>
                                <%--Physical Assistance Question Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorPhysicalAssistance" runat="server" ControlToValidate="rblPhysicalAssistance"
                                    TabIndex="30" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Physical Assistance selection is required."></asp:RequiredFieldValidator>
                                <%--Physical Assistance Question Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourcePhysicalAssistance" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Physical Assistance Question Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <table cellpadding="5" cellspacing="5">
                                    <tr>
                                        <td>
                                            <!-- Get text in code-behind -->
                                            <asp:Label ID="LabelTrial1Time" runat="server" AssociatedControlID="txtTrial1Time" SkinID="DataLabel" TabIndex="31">
                                            </asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtTrial1Time" runat="server" MaxLength="4" Width="50px" TabIndex="32"></asp:TextBox>&nbsp;seconds
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorTrial1Time" runat="server" ControlToValidate="txtTrial1Time" ValidationGroup="OnSave"
                                                TabIndex="33" Display="Dynamic" ErrorMessage="* Trial 1 Time Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorTrial1Time" runat="server" ControlToValidate="txtTrial1Time" ErrorMessage="Time Entry must be a positive integer"
                                                TabIndex="34" MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                            </asp:RangeValidator>
                                        </td>
                                        <td style="width: 10px;">
                                            &nbsp;
                                        </td>
                                        <td>
                                            <!-- Get text in code-behind -->
                                            <asp:Label ID="LabelTrial1Distance" runat="server" AssociatedControlID="txtTrial1Distance" SkinID="DataLabel" TabIndex="35">
                                            </asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtTrial1Distance" runat="server" MaxLength="2" Width="50px" TabIndex="36">20</asp:TextBox>&nbsp;meters
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorTrial1Distance" runat="server" ControlToValidate="txtTrial1Distance"
                                                TabIndex="37" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Trial 1 Distance Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorTrial1Distance" runat="server" ControlToValidate="txtTrial1Distance" ErrorMessage="Distance Entry must be a positive integer"
                                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic" TabIndex="38">
                                            </asp:RangeValidator>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <table cellpadding="5" cellspacing="5">
                                    <tr>
                                        <td>
                                            <!-- Get text in code-behind -->
                                            <asp:Label ID="LabelTrial2Time" runat="server" AssociatedControlID="txtTrial2Time" SkinID="DataLabel" TabIndex="39">
                                            </asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtTrial2Time" runat="server" MaxLength="4" Width="50px" TabIndex="40"></asp:TextBox>&nbsp;seconds
                                        </td>
                                        <td style="width: 10px;">
                                            &nbsp;
                                        </td>
                                        <td>
                                            <!-- Get text in code-behind -->
                                            <asp:Label ID="LabelTrial2Distance" runat="server" AssociatedControlID="txtTrial2Distance" SkinID="DataLabel" TabIndex="41">
                                            </asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtTrial2Distance" runat="server" MaxLength="2" Width="50px" TabIndex="42">20</asp:TextBox>&nbsp;meters
                                            <br />
                                            <asp:RangeValidator ID="RangeValidatorTrial2Distance" runat="server" ControlToValidate="txtTrial2Distance" ErrorMessage="Distance Entry must be a positive integer"
                                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic" TabIndex="43">
                                            </asp:RangeValidator>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelUnstableTurning" runat="server" AssociatedControlID="rblUnstableTurning" SkinID="DataLabel" TabIndex="44">
                                </asp:Label>
                                <br />
                                <%--Unstable Turning Question Choice List--%>
                                <asp:RadioButtonList ID="rblUnstableTurning" runat="server" DataSourceID="ObjectDataSourceUnstableTurning" TabIndex="45"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                </asp:RadioButtonList>
                                <br />
                                <%--Unstable Turning Question Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorUnstableTurning" runat="server" ControlToValidate="rblUnstableTurning"
                                    TabIndex="46" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Unstable Turning is required."></asp:RequiredFieldValidator>
                                <%--Unstable Turning Question Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceUnstableTurning" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Unstable Turning Question Number--%>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                    </table>
                    <!-- Hidden Averages - Only if more than one trial was performed. -->
                    <asp:HiddenField ID="HiddenAverageTime" runat="server" />
                    <asp:HiddenField ID="HiddenAverageDistance" runat="server" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server">
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    TabIndex="47" ValidationGroup="OnSaveDraft" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    TabIndex="48" ValidationGroup="OnSave" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="49" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
