﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MDWS;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_InstrumentTestEntry : BaseTBIInstrumentPage
{
    #region Variable Declarations

    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();

    #endregion

    #region Public Methods

    public TBI_InstrumentTestEntry()
    {
    }

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        base.BaseTBIInstrumentPage_Load(sender, e);

        if (!IsPostBack)
        {
            try
            {

                if (_tbiInstrumentManager.TbiServiceTo != null)
                {

                    if (_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType == null)
                    {
                        Logging.WriteLogToFile("InstrumentTestEntry.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType == null");
                        //if instrument type is not selected page was accessed incorrectly
                        //redirect to warning message
                        Response.Redirect("Warning.aspx?err=6", false);
                    }

                    DisplayMode.Value = "QuestionsAnswers";

                    LabelPatient.Text = LabelPatient2.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                }


                if (DisplayMode.Value == "QuestionsAnswers")
                {
                    PanelQuestionsAnswers.Visible = true;
                    PanelPreparedNote.Visible = false;
                }
                else
                {
                    PanelQuestionsAnswers.Visible = false;
                    PanelPreparedNote.Visible = true;
                }

                SetDisplayMode();
            }
            catch (Exception ex)
            {
                //Redirect to message that session is ended and need to log back in from CPRS.
                Exception _tbilogerror = HandleTBIException(ex, "InstrumentTestEntry.aspx", "100028", "Page_load");
            }
        }

    }

    protected void SetDisplayMode()
    {
        if (DisplayMode.Value == "QuestionsAnswers")
        {
            PanelQuestionsAnswers.Visible = true;
            PanelPreparedNote.Visible = false;
        }
        else
        {
            PanelQuestionsAnswers.Visible = false;
            PanelPreparedNote.Visible = true;
        }
    }

    protected void ButtonPrepareNote_Click(object sender, EventArgs e)
    {

        DisplayMode.Value = "PreparedNote";
        SetDisplayMode();

        PopulateFields();

    }

    protected void ButtonBack_Click(object sender, EventArgs e)
    {

        DisplayMode.Value = "QuestionsAnswers";
        SetDisplayMode();
    }

    protected void ButtonSubmitNote_Click(object sender, EventArgs e)
    {
        try
        {
            TBIServiceTO _tbiServiceTO = GetTBIServiceToFromSession();

            //TO DO
            //insert questions and answers into _tbiServiceTO.NoteText  
            //use string builder to build string
            //format should be question, line break, line break, indent, answer, line break, line break
            _tbiServiceTO.NoteText = LabelAnswerChiefComplaint.Text + "||" + "This is a test hard coded in Instrument Test Entry aspx page | line 2 | line 3";

            TBIInstrumentsManager _tbiInstrumentManager = new TBIInstrumentsManager();

            if (_tbiServiceTO != null)
            {
                _tbiInstrumentManager.LoadTbiService(_tbiServiceTO);

                NoteResultTO _result = _tbiInstrumentManager.writeNote(_tbiServiceTO);

                if (_result != null)
                {
                    //TO DO
                    //change SURVEYS.SURVEY_STATUS to "Completed"
                    //write to to Survey_Notes
                    //Note_Date = now
                    //Entry_date = now
                    //Notes_text = tbiServiceTO.NoteText


                }
                else
                {
                    //Display Error Message
                }

            }

            DisplayMode.Value = "PreparedNote";
            SetDisplayMode();
        }
        catch (Exception _ex)
        {
            Exception _tbilogerror = HandleTBIException(_ex, "InstrumentTestEntry.aspx", "100028", "ButtunSubmitClick");
        }
    }

    protected void PopulateFields()
    {
         try
         {
             LabelAnswerChiefComplaint.Text = BusinessHelper.FixStringToPreventXss(TextBoxChiefComplaint.Text);

             LabelAnswerHistoryIllness.Text = BusinessHelper.FixStringToPreventXss(TextBoxHistoryPresentIllness.Text);

             LabelAnswerMaritalStatus.Text = RadioButtonListChangeInMaritalStatus.SelectedItem.Text;

             LabelAnswerEducationLevel.Text = RadioButtonListHighestEducationalLevel.SelectedItem.Text;

             LabelAnswerCurrentSchool.Text = RadioButtonListCurrentSchool.SelectedItem.Text;

             LabelAnswerEmploymentStatus.Text = RadioButtonListCurrentEmploymentStatus.SelectedItem.Text;

             LabelAnswerExperienceHeadInjury.Text = RadioButtonListExperiencedHeadInjury.SelectedItem.Text;

             LabelAnswerMonthHeadInjury.Text = DropDownListMonthOfRecentHeadInjury.SelectedItem.Text;

             LabelAnswerYeadHeadInjury.Text = BusinessHelper.FixStringToPreventXss(TextBoxYearHeadInjury.Text);
         }
         catch (Exception _ex)
         {
             Exception _tbilogerror = HandleTBIException(_ex, "InstrumentTestEntry.aspx", "100028", "PopulateFields");
         }
    }

    #endregion
}