﻿using System;
using System.Data;  //DEBUG(ETM) This may not be needed
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.MDWS; // Add 29-Oct-2010 per JH
using System.Text;
using System.Runtime.InteropServices;
using Telerik.Web.UI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_InstrumentMpaiEntry : BaseTBIInstrumentPage //System.Web.UI.Page 
{

    #region Variable Declarations

    private const string FailedFormValuesName = "MPAIFailedFormValues";
    private const string DeferredMessageKeyName = "MPAIDeferredMessageKey";
    private const int _surveyTypeId = 4; // Database Id for MPAI 
    private int _answerCount = 0;

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey
    DataTable prevM2PINotes = new DataTable();
    bool isFollowUp = false;
    bool isDischarge = false;
    bool isInterim = false;
    #endregion

    #region Public Methods

    public TBI_InstrumentMpaiEntry()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    private InstrumentType selectedInstrumentType;

    protected void Page_Init(object sender, EventArgs e)
    {
        selectedInstrumentType = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId);
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        //if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
        //{
        //    SuppressSaveMessage = false;
        //    SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
        //    RenderStartUpMessage(false);
        //}
        //else 
            
        if (Page.IsPostBack && !preventNotification)
        {
            DeferredMessage = "Save was Successful!";
        }
        else if (DeferredMessage != null)
        {
            SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            RenderStartUpMessage(true);
            DeferredMessage = null;
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }
    protected void Index_Changed(object sender, EventArgs e)
    {
        bool _skipSwitch = false;
        int _i = -1;
        if (rbNoteType.SelectedIndex > -1)
        {
            _i = rbNoteType.SelectedIndex;
        }
        else
        {
            _i = 0;
            
            _skipSwitch = true;
            rbNoteType.SelectedIndex = _i;
            rbNoteType.Items[0].Enabled = false;
            rbNoteType.Items[1].Enabled = false;
            rbNoteType.Items[2].Enabled = false;
            rbNoteType.Items[3].Enabled = false;
            clear_form();
        }
        if (_skipSwitch == false)
        {
            switch (_i.ToString())
            {
                case null:
                    break;
                case "0":
                    rbNoteType.Items[0].Enabled = true;
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    rbNoteType.SelectedIndex = 0;
                    prevNoteID.Value = "self";
                    break;
                case "1":
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = true;
                    rbNoteType.Items[2].Enabled = true;
                    rbNoteType.Items[3].Enabled = false;
                    break;
                case "2":
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    rbNoteType.SelectedIndex = 3;
                    break;
                default:
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    //rbNoteType.SelectedIndex = 3;
                    break;
            }
        }
    }
    /// <summary>
    /// In addition to the normal actions taken in Page_Load,
    /// instantiate the MDWS Web Service (T)ransfer (O)bject.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            this.CheckActiveStatus(_surveyTypeId);

            LabelInstrumentTitle.Text = GetInstrumentTitle(_surveyTypeId);
            SetQuestionLabels();

            //Confirm instrument is active - if not, a redirect will occur.
            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("InstrumentMpaiEntry.Page_Load(): _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + selectedInstrumentType.Name;
            if (!IsPostBack)
            {
                string _snum = string.Empty;
                string _notesIDString = string.Empty;
                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                if (instrumentType.Status != null)
                {
                    _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
                }

                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);

                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                if (labelUser != null)
                {
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }

                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = patientManager.GetPatientICNBySnum(_snum);

                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        RefreshSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }
                   
                    try
                    {
                        StringBuilder _addToICN = new StringBuilder();
                        _addToICN.Append(patICN);
                        _addToICN.Append("0");
                        prevM2PINotes = _tbiInstrumentManager.PreviousM2PINoteTypes(_addToICN.ToString());
                        prevNotesList.DataSource = prevM2PINotes;
                        prevNotesList.DataBind();
                    }
                    catch (Exception ex)
                    {
                        //The return from the udfn is empty
                        Exception _tbilogerror = HandleTBIException(ex, "InstrumentMpaiEntry.aspx", "100027", "_tbiInstrumentManager.PreviousM2PINoteTypes(patICN)");
                    }
                    rbNoteType.DataBind();                    
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    if (SurveyDate.Value.Length < 1)
                    {
                        SurveyDate.Value = System.DateTime.Now.ToShortDateString();
                    }
                    if (_survey != null && !_survey.isNew)
                    {
                        SetUpSurvey(_survey);
                    }
                    if (prevM2PINotes != null)
                    {
                        if (prevM2PINotes.DefaultView.Count > 0)
                        {
                            _notesIDString = prevM2PINotes.Rows[0].ItemArray[0].ToString();
                            string[] _vals = _notesIDString.Split(',');

                            if (_vals[3] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                                //rbNoteType.SelectedIndex = 3;
                            }
                            else if (_vals[2] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else if (_vals[1] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else if (_vals[0] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                        }
                        else
                        {
                            if (isFollowUp)
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else
                            {
                                if (_notesIDString == "")
                                {
                                    rbNoteType.Items[0].Selected = true;
                                    rbNoteType.Items[0].Enabled = false;
                                    rbNoteType.Items[1].Enabled = false;
                                    rbNoteType.Items[2].Enabled = false;
                                    rbNoteType.Items[3].Enabled = false;
                                }
                                else
                                {
                                    rbNoteType.Items[0].Enabled = false;
                                    rbNoteType.Items[1].Enabled = true;
                                    rbNoteType.Items[2].Enabled = true;
                                    rbNoteType.Items[3].Enabled = false;
                                }

                            }

                        }
                    }
                    string referrer = string.Empty;
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
                }

                if (_survey != null)
                {
                    if (LabelNoteTypeID.Text == "")
                    {
                        List<STD_QUESTION_CHOICE> choices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices("-1");
                        if (_tbiInstrumentManager.IsInitialNoteType(_tbiInstrumentManager.TbiServiceTo.PatientICN, _surveyTypeId))
                        {
                            LabelNoteType.Text = choices[0].CHOICE_TEXT;
                            LabelNoteTypeID.Text = choices[0].STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            LabelNoteType.Text = choices[1].CHOICE_TEXT;
                            LabelNoteTypeID.Text = choices[1].STD_QUESTION_CHOICE_ID.ToString();
                        }
                    }
                }
            }
        }
        catch (Exception ex2)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex2, "InstrumentMpaiEntry.aspx", "100027", "Page_Load()");
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect(Request.Url.PathAndQuery, false);
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0)
        {
            preventNotification = true;
            Session["survey"] = _survey;
            Session["rawScore"] = hiddenRawScore.Value.ToString();
            Session["tScore"] = hiddenTScore.Value.ToString();
            Session["MPAIAnswerCount"] = _answerCount;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        }
        else
        {
            Response.Redirect(Request.Url.PathAndQuery, false);
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid)
        {
            SaveCompleteSurvey(ref status);
            Response.Redirect("UpperExtremityShortForm7a.aspx", false);
        }
        else
        {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    #endregion Protected Methods

    #region Private Methods

    private void clear_form()
    {
        string patICN = ViewState["PatientICN"].ToString();
        RefreshSurvey(patICN);
        RadioButtonListPersonReporting.ClearSelection();
        RadioButtonListQ1.ClearSelection();
        RadioButtonListQ2.ClearSelection();
        RadioButtonListQ3.ClearSelection();
        RadioButtonListQ4.ClearSelection();
        RadioButtonListQ5.ClearSelection();
        RadioButtonListQ6.ClearSelection();
        RadioButtonListQ7A.ClearSelection();
        RadioButtonListQ7BR.ClearSelection();
        RadioButtonListQ7B.ClearSelection();
        RadioButtonListQ8.ClearSelection();
        TextBoxPersonReportingDetail.Text = "";
        TextBoxC1.Text = "";
        TextBoxC2.Text = "";
        TextBoxC3.Text = "";
        TextBoxC4.Text = "";
        TextBoxC5.Text = "";
        TextBoxC6.Text = "";
        TextBoxC7A.Text = "";
        TextBoxC7B.Text = "";
        TextBoxC8.Text = "";
    }
    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
        if (surveys.Count > 0)
        {
            _survey = surveys.First();
        }
        else
        {
            _survey = new SURVEY();
        }
        _survey.SetAsChangeTrackingRoot();
    }

    private void SaveCompleteSurvey(ref Int32 status)
    {
        string patientICN = String.Empty;
        status = 0;

        try
        {
            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("InstrumentMpaiEntry.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("InstrumentMpaiEntry.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("InstrumentMpaiEntry.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";
                        _survey.SetAsInsertOnSubmit();
                        _survey.patient_ICN = patientICN;
                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);
                if (status != 0)
                {
                    ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);
                    RefreshSurvey(patientICN);
                    SuppressSaveMessage = false;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentMpaiEntry.aspx", "100027", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
                Helpers.SavePageToCache(this, FailedFormValuesName);
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    private void SaveText(SURVEY survey, TextBox textBox, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        string inputText = textBox.Text.Trim();
        int id = availableChoices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == 0).STD_QUESTION_CHOICE_ID;
        SaveGeneric(survey, id, inputText);
    }

    //Expects to caller to understand the impact of saving a simple item - may cause questions to have more than 1 response
    private void SaveGeneric(SURVEY survey, int id, string text)
    {
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => item.STD_QUESTION_CHOICE_ID == id);
        if (null != currentResult)
        {
            if (currentResult.RESULT_TEXT != text)
            {
                currentResult.SetAsUpdateOnSubmit();
                currentResult.RESULT_TEXT = text;
            }
            else
            {
                currentResult.SetAsNoChangeOnSubmit();
            }
        }
        else if (text != string.Empty)
        {
            SURVEY_RESULT result = new SURVEY_RESULT();
            result.RESULT_TEXT = text;
            result.STD_QUESTION_CHOICE_ID = id;
            survey.SURVEY_RESULTs.Add(result);
        }
    }

    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }
    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();
        //now determine whether to add or update each item

        //Survey header:
        //SaveGeneric(survey, Convert.ToInt32(LabelNoteTypeID.Text), LabelNoteType.Text);

       //Helpers.SaveSingleSelect(survey, rbNoteType, "-1");


        List<STD_QUESTION_CHOICE> listChoice = _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType("-11", "MPAI");

        int iRawScore = 0;
        int iTScore = 0;
        int iSurveyDate = 0;
        foreach (var choice in listChoice)
        {
            switch (choice.CHOICE_NAME)
            {
                case "Raw Score":
                    iRawScore = choice.STD_QUESTION_CHOICE_ID;
                    break;
                case "T Score":
                    iTScore = choice.STD_QUESTION_CHOICE_ID;
                    break;
                case "Initial Note Date":
                    iSurveyDate = choice.STD_QUESTION_CHOICE_ID;
                    break;
                default:
                    break;
            }
        }
        listChoice = _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType("-11", "MPAI");
        int iprevNoteID = listChoice[0].STD_QUESTION_CHOICE_ID;

        #region Save Radio Elements
        // Question -1 - Note Type
        if (rbNoteType.SelectedIndex > -1)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "-1");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question Note Typoe choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = rbNoteType.SelectedItem.Text.Trim();
                survey.SURVEY_RESULTs.Add(_surveyResult);
                
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - Question1");
            }
        }
        // Question RadioButtonListPersonReporting - 
        if (RadioButtonListQ1.SelectedIndex > -1)
        {
            STD_QUESTION question1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "0");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question RadioButtonListPersonReporting choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListPersonReporting.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListPersonReporting.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - Question1");
            }
        }
        if (!String.IsNullOrEmpty(TextBoxPersonReportingDetail.Text.Trim()) && (RadioButtonListPersonReporting.SelectedIndex == RadioButtonListPersonReporting.Items.Count - 1))
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "0-1");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question TextBoxPersonReportingDetail choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxPersonReportingDetail.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - Question2");
            }
        }

        
        //// Question 1- 
        if (RadioButtonListQ1.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "1");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ1.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ1.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 1");
            }
        }

        //// Question 2- 
        if (RadioButtonListQ2.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "2");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 2");
            }
        }

        //// Question 3- 
        if (RadioButtonListQ3.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "3");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 3");
            }
        }

        //// Question 4- 
        if (RadioButtonListQ4.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "4");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ4.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 4");
            }
        }

        //// Question 5- 
        if (RadioButtonListQ5.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "5");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ5.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
                _answerCount++;
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 5");
            }
        }

        //// Question 6- 
        if (RadioButtonListQ6.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "6");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ6.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 6");
            }
        }

        //// Question 7A- 
        if (RadioButtonListQ7A.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7A");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ7A.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ7A.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 7A");
            }
        }

        //// Question RadioButtonListQ7B- 
        if (RadioButtonListQ7B.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7B");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ7B.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ7B.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 7B");
            }
        }

        //// Question RadioButtonListQ7BR- 
        if (RadioButtonListQ7BR.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7B-R");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ7BR.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ7BR.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 7B-R");
            }
        }

        //// Question 8- 
        if (RadioButtonListQ8.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "8");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ8.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ8.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - 8");
            }
        }
        #endregion

        #region SaveText

        if (iSurveyDate != 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "Initial Note Date");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(iSurveyDate);
                _surveyResult.RESULT_TEXT = DateTime.Today.ToString();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - SurveyDate");
            }
        }
        if (iRawScore != 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "Raw Score");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(iRawScore);
                _surveyResult.RESULT_TEXT = hiddenRawScore.Value;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - RAW Score");
            }
        }

        if (iTScore != 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "T Score");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(iTScore);
                _surveyResult.RESULT_TEXT = hiddenTScore.Value;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - T Score");
            }
        }

        if (TextBoxC1.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C1");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC1.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C1");
            }
        }
        if (TextBoxC2.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C2");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC2.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C2");
            }
        }
        if (TextBoxC3.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C3");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC3.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C3");
            }
        }
        if (TextBoxC4.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C4");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC4.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C4");
            }
        }
        if (TextBoxC5.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C5");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC5.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C5");
            }
        }
        if (TextBoxC6.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C6");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC6.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C6");
            }
        }
        if (TextBoxC7A.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C7A");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC7A.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - TextBoxC7A");
            }
        }
        if (TextBoxC7B.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C7B");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC7B.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - TextBoxC7B");
            }
        }
        if (TextBoxC8.Text.Length > 0)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "C8");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                //   _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = TextBoxC8.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "InstrumentMpaiEntry.aspx", "100027", "SaveSurvey() - C8");
            }
        }
        #endregion

        #region old code
        //SaveGeneric(survey, iprevNoteID, prevNoteID.Value.ToString());
      
        //Helpers.SaveSingleSelect(survey, RadioButtonListPersonReporting, "0");
        //if (!String.IsNullOrEmpty(TextBoxPersonReportingDetail.Text.Trim()) && (RadioButtonListPersonReporting.SelectedIndex == RadioButtonListPersonReporting.Items.Count - 1))
        //{
        //    SaveText(survey, TextBoxPersonReportingDetail, "0-1");
        //}

        //Survey questions
        //foreach (SURVEY_RESULT sResult in survey.SURVEY_RESULTs)
        //{
        //    switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
        //    {
        //        case "0": SetRadioElement(sResult, RadioButtonListPersonReporting); break;
        //        case "0-1": SetTextBoxElement(sResult, TextBoxPersonReportingDetail); break;
        //        case "-1": SetRadioElement(sResult, rbNoteType); break;
        //        case "1": SetRadioElement(sResult, RadioButtonListQ1); break;
        //        case "2": SetRadioElement(sResult, RadioButtonListQ2); break;
        //        case "3": SetRadioElement(sResult, RadioButtonListQ3); break;
        //        case "4": SetRadioElement(sResult, RadioButtonListQ4); break;
        //        case "5": SetRadioElement(sResult, RadioButtonListQ5); break;
        //        case "6": SetRadioElement(sResult, RadioButtonListQ6); break;
               
        //        case "7B": SetRadioElement(sResult, RadioButtonListQ7B); break;
        //        case "8": SetRadioElement(sResult, RadioButtonListQ8); break;
        //        case "C1": SetTextBoxElement(sResult, TextBoxC1); break;
        //        case "C2": SetTextBoxElement(sResult, TextBoxC2); break;
        //        case "C3": SetTextBoxElement(sResult, TextBoxC3); break;
        //        case "C4": SetTextBoxElement(sResult, TextBoxC4); break;
        //        case "C5": SetTextBoxElement(sResult, TextBoxC5); break;
        //        case "C6": SetTextBoxElement(sResult, TextBoxC6); break;
        //        case "7BR": SetRadioElement(sResult, RadioButtonListQ7BR); break;
        //        //if (RadioButtonListQ7A.SelectedIndex > -1)
        //        //{
        //            case "7A": SetRadioElement(sResult, RadioButtonListQ7A); break;
        //            case "C7A": SetTextBoxElement(sResult, TextBoxC7A); break;
        //        //}
        //        case "C7B": SetTextBoxElement(sResult, TextBoxC7B); break;
        //        case "C8": SetTextBoxElement(sResult, TextBoxC8); break;
        //    }
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ1, "1");
        //SaveText(survey, TextBoxC1, "C1");
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ2, "2");
        //SaveText(survey, TextBoxC2, "C2");
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ3, "3");
        //SaveText(survey, TextBoxC3, "C3");
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ4, "4");
        //SaveText(survey, TextBoxC4, "C4");
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ5, "5");
        //SaveText(survey, TextBoxC5, "C5");
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ6, "6");
        //SaveText(survey, TextBoxC6, "C6");
        //}
        //if (RadioButtonListQ7A.SelectedIndex > -1)
        //{
        //    Helpers.SaveSingleSelect(survey, RadioButtonListQ7A, "7A");
        //    SaveText(survey, TextBoxC7A, "C7A");
        //}
        //if (RadioButtonListQ7B.SelectedIndex > -1)
        //{
        //    if (RadioButtonListQ7BR.SelectedIndex > -1)
        //    {
        //        Helpers.SaveSingleSelect(survey, RadioButtonListQ7BR, "7B-R");
        //    }
        //    Helpers.SaveSingleSelect(survey, RadioButtonListQ7B, "7B");
        //    SaveText(survey, TextBoxC7B, "C7B");
        //}
        //Helpers.SaveSingleSelect(survey, RadioButtonListQ8, "8");
        //SaveText(survey, TextBoxC8, "C8");
        //survey.STD_SURVEY_TYPE_ID = _surveyTypeId;
        #endregion
    }// END SaveSurvey

    private void SetNoteInformation(SURVEY_RESULT result)
    {
        rbNoteType.Text = result.STD_QUESTION_CHOICE_ID.ToString();
        rbNoteType.Text = result.STD_QUESTION_CHOICE.CHOICE_TEXT;
    }

    private void SetRadioElement(SURVEY_RESULT result, RadioButtonList radioButton)
    {
        if (result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
        {
            radioButton.SelectedIndex = result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value;
        }
        else
        {
            radioButton.SelectedIndex = -1;
        }
    }

    private void SetTextBoxElement(SURVEY_RESULT survey, TextBox textBox)
    {
        textBox.Text = survey.RESULT_TEXT;
    }

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "-1":
                        if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME != null)
                        {
                            if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Initial")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                                rbNoteType.SelectedIndex = 0;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Interim")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Discharge")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "FollowUp")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else
                            {
                                SetRadioElement(sResult, rbNoteType);
                            }
                        }
                        else
                        {
                            SetRadioElement(sResult, rbNoteType);
                        }
                        break;
                    case "-11": SurveyDate.Value = DateTime.Now.ToString(); break;
                    case "-111":
                        if (!sResult.RESULT_TEXT.IsNullOrEmpty())
                        {
                            string val = sResult.RESULT_TEXT;
                            if (!String.IsNullOrEmpty(val) && val.ToString() == "self")
                            {
                                prevNotesList.SelectedIndex = 0;
                                rbNoteType.Items[0].Enabled = true;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else
                            {
                                for (int i = 0; i <= prevNotesList.Items.Count-1; i++)
                                {

                                    if (prevNotesList.Items[i].Value.Contains(val))
                                    {
                                        prevNotesList.SelectedIndex = i;
                                        if (i > 0)
                                        {
                                            string _s = prevNotesList.Items[i].Value.ToString();
                                            string[] _vals = _s.Split(',');
                                            prevNoteID.Value = _vals[0];
                                            switch (_vals[1])
                                            {
                                                case "0":
                                                    rbNoteType.Items[0].Enabled = false;
                                                    rbNoteType.Items[1].Enabled = true;
                                                    rbNoteType.Items[2].Enabled = true;
                                                    rbNoteType.Items[3].Enabled = false;
                                                    break;
                                                default:
                                                    rbNoteType.Items[0].Enabled = false;
                                                    rbNoteType.Items[1].Enabled = false;
                                                    rbNoteType.Items[2].Enabled = false;
                                                    rbNoteType.Items[3].Enabled = true;
                                                    break;
                                            }
                                        }
                                        else
                                        {
                                            rbNoteType.Items[0].Enabled = true;
                                            rbNoteType.Items[1].Enabled = false;
                                            rbNoteType.Items[2].Enabled = false;
                                            rbNoteType.Items[3].Enabled = false;
                                        }
                                    }
                                }
                            }
                        }
                        prevNoteID.Value = sResult.RESULT_TEXT;
                        break;
                    case "0": SetRadioElement(sResult, RadioButtonListPersonReporting); break;
                    case "0-1": SetTextBoxElement(sResult, TextBoxPersonReportingDetail); break;
                    case "1": SetRadioElement(sResult, RadioButtonListQ1); break;
                    case "2": SetRadioElement(sResult, RadioButtonListQ2); break;
                    case "3": SetRadioElement(sResult, RadioButtonListQ3); break;
                    case "4": SetRadioElement(sResult, RadioButtonListQ4); break;
                    case "5": SetRadioElement(sResult, RadioButtonListQ5); break;
                    case "6": SetRadioElement(sResult, RadioButtonListQ6); break;
                    case "7A": SetRadioElement(sResult, RadioButtonListQ7A); break;
                    case "7B-R": SetRadioElement(sResult, RadioButtonListQ7BR); break;
                    case "7B": SetRadioElement(sResult, RadioButtonListQ7B); break;
                    case "8": SetRadioElement(sResult, RadioButtonListQ8); break;
                    case "C1": SetTextBoxElement(sResult, TextBoxC1); break;
                    case "C2": SetTextBoxElement(sResult, TextBoxC2); break;
                    case "C3": SetTextBoxElement(sResult, TextBoxC3); break;
                    case "C4": SetTextBoxElement(sResult, TextBoxC4); break;
                    case "C5": SetTextBoxElement(sResult, TextBoxC5); break;
                    case "C6": SetTextBoxElement(sResult, TextBoxC6); break;
                    case "C7A": SetTextBoxElement(sResult, TextBoxC7A); break;
                    case "C7B": SetTextBoxElement(sResult, TextBoxC7B); break;
                    case "C8": SetTextBoxElement(sResult, TextBoxC8); break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentMpaiEntry.aspx", "100027", "SetUpSurvey()");
        }
    }

    private void SetQuestionLabels()
    {
        List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
        NoteTypeLabel.Text = questions.First(q => q.QUESTION_NUMBER == "-1").QUESTION_TEXT + ":";
        PersonReportingLabel.Text = questions.First(q => q.QUESTION_NUMBER == "0").QUESTION_TEXT + ":";
        Q1Label.Text = "1. " + questions.First(q => q.QUESTION_NUMBER == "1").QUESTION_TEXT;
        C1Label.Text = questions.First(q => q.QUESTION_NUMBER == "C1").QUESTION_TEXT + ":";
        Q2Label.Text = "2. " + questions.First(q => q.QUESTION_NUMBER == "2").QUESTION_TEXT;
        C2Label.Text = questions.First(q => q.QUESTION_NUMBER == "C2").QUESTION_TEXT + ":";
        Q3Label.Text = "3. " + questions.First(q => q.QUESTION_NUMBER == "3").QUESTION_TEXT;
        C3Label.Text = questions.First(q => q.QUESTION_NUMBER == "C3").QUESTION_TEXT + ":";
        Q4Label.Text = "4. " + questions.First(q => q.QUESTION_NUMBER == "4").QUESTION_TEXT;
        C4Label.Text = questions.First(q => q.QUESTION_NUMBER == "C4").QUESTION_TEXT + ":";
        Q5Label.Text = "5. " + questions.First(q => q.QUESTION_NUMBER == "5").QUESTION_TEXT;
        C5Label.Text = questions.First(q => q.QUESTION_NUMBER == "C5").QUESTION_TEXT + ":";
        Q6Label.Text = "6. " + questions.First(q => q.QUESTION_NUMBER == "6").QUESTION_TEXT;
        C6Label.Text = questions.First(q => q.QUESTION_NUMBER == "C6").QUESTION_TEXT + ":";
        Q7ALabel.Text = "7A. " + questions.First(q => q.QUESTION_NUMBER == "7A").QUESTION_TEXT;
        C7ALabel.Text = questions.First(q => q.QUESTION_NUMBER == "C7A").QUESTION_TEXT + ":";
        Q7BLabel.Text = "7B. " + questions.First(q => q.QUESTION_NUMBER == "7B").QUESTION_TEXT;
        Q7BRLabel.Text = questions.First(q => q.QUESTION_NUMBER == "7B-R").QUESTION_TEXT + ":";
        C7BLabel.Text = questions.First(q => q.QUESTION_NUMBER == "C7B").QUESTION_TEXT + ":";
        Q8Label.Text = "8. " + questions.First(q => q.QUESTION_NUMBER == "8").QUESTION_TEXT;
        C8Label.Text = questions.First(q => q.QUESTION_NUMBER == "C8").QUESTION_TEXT + ":";
    }

    private string GetInstrumentTitle(int surveyID)
    {
        string ret = String.Empty;

        try
        {
            List<string> instrumentTitle = selectedInstrumentType.Title;
            if (instrumentTitle.Count > 0)
            {
                foreach (string titleLine in instrumentTitle)
                {
                    if (titleLine.Contains("PhD"))
                    {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    }
                    else
                    {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentMpaiEntry.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }

        return ret;
    }

    #endregion Private Methods
}