<%@ Page Language="C#" AutoEventWireup="true" CodeFile="InstrumentEvaluationEntry.aspx.cs" MaintainScrollPositionOnPostback = "true" Inherits="InstrumentEvaluationEntry" MasterPageFile = "~/TBI_Instruments/RegistryInstrument.master" %>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Assembly="RJS.Web.WebControl.PopCalendar.Net.2008" namespace="RJS.Web.WebControl" tagprefix="rjs" %>
<%@ Register src="~/controls/FromToDate.ascx" tagname="FromToDate" tagprefix="UserControlFromToDate" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .breadcrumbInstrument {
            background-color:#6B1424;
            border-bottom:1px solid #000;
            color:#FFF;
            font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant:small-caps;
            font-weight:700;
            letter-spacing:1px;
            margin: 2px 0 2px 0;
            padding:8px 25px 5px 10px;
        }
        .style15
        {
            width: 1037px;
        }
            .fixWidth tr td { width: 500px; }       
    </style>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeOut="700" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find('<%= InactiveTimer.ClientID %>');
            }
            return tmr;
        }

        function StopTimer() {
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable button during the AJAX call
            document.getElementById('<%=SaveButton.ClientID%>').disabled = true;
            document.getElementById('<%=SavePrepareNoteButton.ClientID%>').disabled = true;
            document.getElementById('<%=CancelButton.ClientID%>').disabled = true;
            $('#<%= PanelQuestions.ClientID %>').hide();
        }

        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=SaveButton.ClientID%>').disabled = false;
            document.getElementById('<%=SavePrepareNoteButton.ClientID%>').disabled = false;
            document.getElementById('<%=CancelButton.ClientID%>').disabled = false;

            if (document.getElementById('<%=SaveButton.ClientID%>').disabled == false) {
                $('#<%= PanelQuestions.ClientID %>').hide();
                return;
            }
        }

        //}


    </script>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
<script type = "text/javascript">

    $(document).ready(function () {
        //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
        //also resets inactive timer
        $('input').keydown(function (e) {
            StopTimer();
            StartTimer();
        });

        //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
        //also resets inactive timer
        $('div').keydown(function (e) {
            StopTimer();
            StartTimer();
        });

        //resets inactive timer on click of a radio element
        $('input[type=radio]').click(function (e) {
            StopTimer();
            StartTimer();
        });

        //resets inactive timer on click of a checkbox element
        $('input[type=checkbox]').click(function (e) {
            StopTimer();
            StartTimer();
        });

        window.onbeforeunload = function (e) {
            return;
        }



        if ($('#<%= rbnonVAProvider.ClientID %> input:checked').val() == '1') {

            $("table.survey > tbody > tr:not(.feebasis)").hide();
            $("tr.followup_feebasis").show();
            $("#TrSubmit").show();

            $.each(Page_Validators, function (index, validator) {
                if (!$(validator).hasClass("feebasis")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            $("table.survey > tbody > tr:not(.feebasis)").show();
            $("tr.followup_feebasis").hide();

            //now start looking at other conditionals
            if (($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '0') || ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == null)) {
                $('tr.injuriesnone').hide();
                $('tr.oneinjury').hide();
                $('tr.twoinjuries').hide();
                //$('.blastnone tr').hide();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("injuriesnone")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '1') {
                $('tr.injuriesnone').show();
                $('tr.oneinjury').hide();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("oneinjury")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '2') {

                $('tr.injuriesnone').show();
                $('tr.twoinjuries').hide();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("twoinjuries")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $('tr.injuriesnone').show();
            }

        if ($('#<%= rbFiveDSubsection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbFiveDSubsection.ClientID %> input:checked').val() == null) {
                $('.blastnone tr').hide();
                $('.blastnone tr').find("input:radio").attr("checked", false);
                $('.blastnone tr').find("input:checkbox").attr("checked", false);
                $('.blastnone tr').find("input:text").val("");

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("blastnone")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {

                if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                    $('tr.blastnone').show();
                }
            }

            if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbSixSection.ClientID %> input:checked').val() == '6'
                || $('#<%= rbSixSection.ClientID %> input:checked').val() == null) {
                $("tr.consciousness").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("consciousness")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {

                if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                    $('tr.consciousness').show()
                }
            }

            if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6'
                || $('#<%= rbSevenSection.ClientID %> input:checked').val() == null) {
                $("tr.disorientnone").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("disorientnone")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {

                if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                    $("tr.disorientnone").show();
                }
            }

            if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbEightSection.ClientID %> input:checked').val() == '6'
                || $('#<%= rbEightSection.ClientID %> input:checked').val() == null) {
                $("tr.memoryloss").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("memoryloss")) {
                        ValidatorEnable(validator, false);
                    }
                });

            }
            else {

                if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                    $("tr.memoryloss").show();
                }
            }

            if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbTwelveSection.ClientID %> input:checked').val() == null) {
                $("tr.notreatment").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("notreatment")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {

                if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                    $("tr.notreatment").show();
                }
            }


            if ($('#<%= rbEighteenSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbEighteenSection.ClientID %> input:checked').val() == null) {
                $("tr.pain").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("pain") || $(validator).className == "pain") {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.pain").show();
            }



            if ($('#<%= rbSectionTwentyEight.ClientID %> input:checked').val() != '5') {
                $("tr.symptoms").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("symptoms")) {
                        ValidatorEnable(validator, false);
                    }
                });

            }
            else {

                $("tr.symptoms").show();
            }







            if ($('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '2'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '4'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '5'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == null) {
                $("tr.followup").hide();
                $("tr.followup_feebasis").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("followup") || $(validator).hasClass("other2") || $(validator).hasClass("other3") || $(validator).hasClass("other5") || $(validator).hasClass("other7")) {
                        ValidatorEnable(validator, false);
                    }
                    
                });
                
            }
            else {


                $("tr.followup").show();
                $("tr.followup_feebasis").show();

                //$("tr.trials").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("followup")) {
                        ValidatorEnable(validator, true);
                    }
                });

                var consultRequest = false;

                var otherMedication = false;



            }

            //rb29a1f
            

            if ($('#<%= rb29A1f.ClientID %> input:checked').val() == '1') {
                $("tr.other2").hide();
                $("tr.other2").find("input:text").val("");
                $("tr.other3").show();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other2")) {

                        ValidatorEnable(validator, false);
                    }
                    if ($(validator).hasClass("other3")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
            }

            if ($('#<%= rb29A1f.ClientID %> input:checked').val() == '0') {
                $("tr.other2").show();
                //$("tr.other2").find("input:text").val("");
                $("tr.other3").hide();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other3")) {

                        ValidatorEnable(validator, false);
                    }
                    if ($(validator).hasClass("other2")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

            }
        
            if ($('#<%= rb29A1f.ClientID %> input:checked').val() != '0' && $('#<%= rb29A1f.ClientID %> input:checked').val() != '1') {
                $("tr.other2").hide();
                $("tr.other2").find("input:text").val("");
                $("tr.other3").hide();
            }
            if ($('#<%= rb29A1j.ClientID %> input:checked').val() != '1') {

                $("tr.other5").find('input[type=checkbox]').each(function () {
                    $(this).attr("checked", false);
                });

                // $("INPUT[id^='ctl00_ContentPlaceHolder_ConsultRequestListBox_']").attr('checked', false)


                $("tr.other5").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other5")) {

                        ValidatorEnable(validator, false);

                    }
                });

            }
            if ($('#<%= rb29A2.ClientID %> input:checked').val() != '0') {
                $('#<%= cb29A2no.ClientID %>').hide();
            }

        }

        $('.tbiDiagnosis input:radio').click(function (e) {

            // debugger;
            //No
            if ($(this).val() == 0 || $(this).val() == 6) {
                var count = 0;

                $('.tbiDiagnosis input:checked').not(this).each(function () {
                    if ($(this).val() != 0 && $(this).val() != 6) {
                        count = count + 1;
                    }
                });

                if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() > '0' && count == 0 && $('.tbiDiagnosis input:checked').length == 3) {
                    alert("In questions 6, 7, or 8, your responses indicate this patient did not experience one of the following:\n" +
                            "1. Period of loss of consciousness;\n" +
                            "2. Loss of memory for events immediately before or after the accident;\n" +
                            "3. Alteration in mental state at the time of the accident (eg, feeling dazed, disoriented, or confused);\n\n" +
                            "Based on the VA/DoD definition for a mild TBI, these responses would indicate that this patient has not suffered a TBI.\n\n" +
                            "If your responses to questions 6, 7, or 8 are not correct, and this patient experienced either loss of consciousness, post traumatic amnesia " +
                            "or alteration of consciousness related to the injury, please make the appropriate corrections to those questions, and you will then be permitted to indicate the patient suffered a TBI during OEF/OIF/OND deployment.");
                    e.preventDefault();
                }
            }

        });

        $('#<%= rbSectionTwentySeven.ClientID %>').click(function (e) {
            // debugger;
            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0')
                //No
            {
                var count = 0;
                if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() == '0') {

                    $('.tbiDiagnosis input:checked').each(function () {
                        if ($(this).val() != 0 && $(this).val() != 6) {
                            count = count + 1;
                        }
                    });

                    if (count > 0) {
                        alert("In questions 6, 7, or 8, your responses indicate this patient experienced one of the following:\n" +
                            "1. Period of loss of consciousness;\n" +
                            "2. Loss of memory for events immediately before or after the accident;\n" +
                            "3. Alteration in mental state at the time of the accident (eg, feeling dazed, disoriented, or confused);\n\n" +
                            "Based on the VA/DoD definition for a mild TBI, these responses would indicate that this patient has suffered a TBI.\n\n" +
                            "If your responses to questions 6, 7, or 8 are not correct, and this patient did not experience either loss of consciousness, post traumatic amnesia " +
                            "or alteration of consciousness related to the injury, please make the appropriate corrections to those questions, and you will then be permitted to indicate the patient did not suffer a TBI during OEF/OIF/OND deployment.");
                        e.preventDefault();
                    }
                }
                    //Yes
                else {

                    $('.tbiDiagnosis input:checked').each(function () {
                        if ($(this).val() != 0 && $(this).val() != 6) {
                            count = count + 1;
                        }
                    });

                    if (count == 0 && $('.tbiDiagnosis input:checked').length > 0) {
                        alert("In questions 6, 7, or 8, your responses indicate this patient did not experience one of the following:\n" +
                            "1. Period of loss of consciousness;\n" +
                            "2. Loss of memory for events immediately before or after the accident;\n" +
                            "3. Alteration in mental state at the time of the accident (eg, feeling dazed, disoriented, or confused);\n\n" +
                            "Based on the VA/DoD definition for a mild TBI, these responses would indicate that this patient has not suffered a TBI.\n\n" +
                            "If your responses to questions 6, 7, or 8 are not correct, and this patient experienced either loss of consciousness, post traumatic amnesia " +
                            "or alteration of consciousness related to the injury, please make the appropriate corrections to those questions, and you will then be permitted to indicate the patient suffered a TBI during OEF/OIF/OND deployment.");
                        e.preventDefault();
                    }
                    else
                    {
                        
                            if ($('#<%= rb29A1g.ClientID %> input:checked').val() == '1' && $('#<%= ConsultRequestListBox.ClientID %> input:checked').length > 0) {
                                //$("tr.other8").find("input:radio").attr("checked", true);
                                $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", true);
                                $('#<%= cb29A2no.ClientID %>').hide();
                                $('#<%= cb29A2no.ClientID %>').find('input[type=checkbox]').each(function () {
                                    $(this).attr("checked", false);
                                });

                            }
                            else {
                                $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", false);
                            };
                        
                    }
                }
            }
            else {
                if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() == '1') {
                    alert("In question #4, your response indicates this patient did not experience an OEF/OIF/OND\n" +
                     "deployment related injury.  Based on this response, this patient would not have suffered\n" +
                     "an OEF/OIF/OND deployment related TBI.\n\n" +
                     "If your response to question #4 is not correct, and this patient did experience an\n" +
                     "OEF/OIF/OND deployment related injury, please make the appropriate correction to question\n" +
                     "#4, and you will then be permitted to indicate the patient suffered a TBI.");

                    e.preventDefault();
                }
            }
        });

        $('#<%= rbnonVAProvider.ClientID %>').click(function () {
            if ($('#<%= rbnonVAProvider.ClientID %> input:checked').val() == '1') {
                $("table.survey > tbody > tr:not(.feebasis)").hide();
                $("tr.followup_feebasis").show();
                $("#TrSubmit").show();

                var rbnonVAProviderIndex = GetListIndexSelected("<%= rbnonVAProvider.ClientID %>");
                var rbQ27Index = GetListIndexSelected("<%= rbSectionTwentySeven.ClientID %>");

                $("tr:not(.feebasis)").find("input:radio").attr("checked", false);
                $("tr:not(.feebasis)").find("input:checkbox").attr("checked", false);
                $("tr:not(.feebasis)").find("input:text").val("");

                //Restore fee basis selection and Q27 selection
                $('#<%= rbnonVAProvider.ClientID %>').find("input:radio")[rbnonVAProviderIndex].checked = true;
                if (rbQ27Index != -1) {
                    $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[rbQ27Index].checked = true;
                }

                //disable all validators except 27
                $.each(Page_Validators, function (index, validator) {
                    if (!$(validator).hasClass("feebasis")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("table.survey > tbody > tr:not(.feebasis)").show();
                $("tr.followup_feebasis").hide();

                $.each(Page_Validators, function (index, validator) {
                    if (!$(validator).hasClass("feebasis") && !$(validator).hasClass("other5")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);

                        //alert('validator enabled');
                    }
                });

                var index = $('#<%= rbnonVAProvider.ClientID %> input:checked').val();
                $('#<%= rbnonVAProvider.ClientID %>_' + index).focus();
            }
        });

        $('#<%= rbInjuriesQuantity.ClientID %>').click(function (e) {
            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '0') {

                if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() == '1') {
                    alert("In question #21, your response indicates this patient experienced an OEF/OIF/OND\n" +
                     "deployment related injury.  Based on this response, this patient would not have suffered\n" +
                     "an OEF/OIF/OND deployment related TBI.\n\n" +
                     "If your response to question #21 is not correct, and this patient did experience an\n" +
                     "OEF/OIF/OND deployment related injury, please make the appropriate correction to question\n" +
                     "#21, and you will then be permitted to indicate the patient has not suffered a TBI.");

                    e.preventDefault();
                }
                else {
                    $("tr.injuriesnone").hide();
                    $("tr.injuriesnone").find("input:radio").attr("checked", false);
                    $("tr.injuriesnone").find("input:checkbox").attr("checked", false);
                    $("tr.injuriesnone").find("input:text").val("");
                    $('tr.injuriesnone').hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("injuriesnone")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
            }
            else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '1') {
                $("tr.injuriesnone").show();
                $("tr.oneinjury").hide();
                $("tr.oneinjury").find("input:text").val("");
                $("tr.injuriesnone").show();
                $("tr.oneinjury").hide();
                $("tr.oneinjury").find("input:text").val("");

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("injuriesnone")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("oneinjury")) {
                        ValidatorEnable(validator, false);
                    }
                });

                //hide sub-sections if they were hidden before
                if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbSixSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbSixSection.ClientID %> input:checked').val() == null) {
                    $("tr.consciousness").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("consciousness")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == null) {
                    $("tr.disorientnone").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("disorientnone")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbEightSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbEightSection.ClientID %> input:checked').val() == null) {
                    $("tr.memoryloss").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("memoryloss")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbTwelveSection.ClientID %> input:checked').val() == null) {
                    $("tr.notreatment").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("notreatment")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
            }
            else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '2') {

                $("tr.injuriesnone").show();
                $("tr.twoinjuries").hide();
                $("tr.twoinjuries").find("input:text").val("");

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("injuriesnone")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("twoinjuries")) {
                        ValidatorEnable(validator, false);
                    }
                });

                if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbSixSection.ClientID %> input:checked').val() == '6'
                || $('#<%= rbSixSection.ClientID %> input:checked').val() == null) {
                    $("tr.consciousness").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("consciousness")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == null) {
                    $("tr.disorientnone").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("disorientnone")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0'
                || $('#<%= rbEightSection.ClientID %> input:checked').val() == '6'
                || $('#<%= rbEightSection.ClientID %> input:checked').val() == null) {
                    $("tr.memoryloss").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("memoryloss")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbTwelveSection.ClientID %> input:checked').val() == null) {
                    $("tr.notreatment").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("notreatment")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
            }
            else {
                $("tr.injuriesnone").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("injuriesnone")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbSixSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbSixSection.ClientID %> input:checked').val() == null) {
                    $("tr.consciousness").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("consciousness")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbSevenSection.ClientID %> input:checked').val() == null) {
                    $("tr.disorientnone").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("disorientnone")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbEightSection.ClientID %> input:checked').val() == '6'
                    || $('#<%= rbEightSection.ClientID %> input:checked').val() == null) {
                    $("tr.memoryloss").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("memoryloss")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }

                if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0'
                    || $('#<%= rbTwelveSection.ClientID %> input:checked').val() == null) {
                    $("tr.notreatment").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("notreatment")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
            }
        });

        $('#<%= rbFiveDSubsection.ClientID %>').click(function () {
            var row = document.getElementById("TrQ5D1")
            if (row != null) {
                if ($('#<%= rbFiveDSubsection.ClientID %> input:checked').val() == '0') {
                    $('.blastnone tr').hide();
                    $('.blastnone tr').find("input:radio").attr("checked", false);
                    $('.blastnone tr').find("input:checkbox").attr("checked", false);
                    $('.blastnone tr').find("input:text").val("");

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("blastnone")) {
                            ValidatorEnable(validator, false);
                        }
                    });
                }
                else {
                    $('.blastnone tr').show();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("blastnone")) {
                            ValidatorEnable(validator, true);
                            validator.isvalid = true;
                            ValidatorUpdateDisplay(validator);
                        }
                    });

                    var index = $('#<%= rbFiveDSubsection.ClientID %> input:checked').val();
                    $('#<%= rbFiveDSubsection.ClientID %>_' + index).focus();
                }
            }
        });

        $('#<%= rbSixSection.ClientID %>').click(function () {

            if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0' || $('#<%= rbSixSection.ClientID %> input:checked').val() == '6') {
                $("tr.consciousness").hide();
                $("tr.consciousness").find("input:radio").attr("checked", false);
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("consciousness")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.consciousness").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("consciousness")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
                var index = $('#<%= rbSixSection.ClientID %> input:checked').val();
                $('#<%= rbSixSection.ClientID %>_' + index).focus();
            }

                $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[0].checked = false;
                $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[1].checked = false;
        });

        $('#<%= rbSevenSection.ClientID %>').click(function () {
            if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0' || $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6') {
                $("tr.disorientnone").hide();
                $("tr.disorientnone").find("input:radio").attr("checked", false);

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("disorientnone")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.disorientnone").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("disorientnone")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                var index = $('#<%= rbSevenSection.ClientID %> input:checked').val();
                $('#<%= rbSevenSection.ClientID %>_' + index).focus();
            }
            $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[0].checked = false;
            $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[1].checked = false;
        });

        $('#<%= rbEightSection.ClientID %>').click(function () {
            if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0'
            || $('#<%= rbEightSection.ClientID %> input:checked').val() == '6') {
                $("tr.memoryloss").hide();
                $("tr.memoryloss").find("input:radio").attr("checked", false);

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("memoryloss")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.memoryloss").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("memoryloss")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }

                    
                });

                var index = $('#<%= rbEightSection.ClientID %> input:checked').val();
                $('#<%= rbEightSection.ClientID %>_' + index).focus();
            }
                $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[0].checked = false;
                $('#<%= rbSectionTwentySeven.ClientID %>').find("input:radio")[1].checked = false;
        });

        $('#<%= rbTwelveSection.ClientID %>').click(function () {
            if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0') {
                $("tr.notreatment").hide();
                $("tr.notreatment").find("input:radio").attr("checked", false);

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("notreatment")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.notreatment").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("notreatment")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                var index = $('#<%= rbTwelveSection.ClientID %> input:checked').val();
                $('#<%= rbTwelveSection.ClientID %>_' + index).focus();
            }
        });


        $('#<%= rbEighteenSection.ClientID %>').click(function () {

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("pain") || $(validator).className == "pain") {
                    ValidatorEnable(validator, false);
                }
            });
            if ($('#<%= rbEighteenSection.ClientID %> input:checked').val() == '0') {
                $("tr.pain").hide();
                $("tr.pain").find("input:text").val("");
                $("tr.pain").find("input:radio").attr("checked", false);
                $("tr.pain").find("input:checkbox").attr("checked", false);
            }
            else {
                $("tr.pain").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("pain")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
                $('#<%= rbEighteenSection.ClientID %>_1').focus();
            }
        });

        // });


        $('#<%= rbSectionTwentyEight.ClientID %>').click(function () {

            if ($('#<%= rbSectionTwentyEight.ClientID %> input:checked').val() != '5') {
                $("tr.symptoms").hide();
                $("tr.symptoms").find("input:text").val("");
                $("tr.symptoms").find("input:radio").attr("checked", false);
                $("tr.symptoms").find("input:checkbox").attr("checked", false);

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("symptoms")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {
                $("tr.symptoms").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("symptoms")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
            }
        });

        $('#<%= rbSectionTwentyNine.ClientID %>').click(function () {

            if ($('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '2'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '4'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == '5'
                || $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() == null) {
                $("tr.followup").hide();
                $("tr.followup_feebasis").hide();
                $("tr.followup").find("input:text").val("");
                $("tr.followup").find("input:radio").attr("checked", false);
                $("tr.followup").find("input:checkbox").attr("checked", false);

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("followup")) {
                        ValidatorEnable(validator, false);
                    }
                });
            }
            else {



                $("tr.followup").show();
                $("tr.followup_feebasis").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("followup")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                var index = $('#<%= rbSectionTwentyNine.ClientID %> input:checked').val() - 1;
                $('#<%= rbSectionTwentyNine.ClientID %>_' + index).focus();


                if (true) {

                    $("tr.other1").hide();
                    $("tr.other1").find("input:text").val("");

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other1")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other1").show();

                }

                if (true) {
                    $("tr.other2").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other2")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other2").show();

                }


                if (true) {
                    $("tr.other3").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other3")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other3").show();

                }
                if (true) {
                    $("tr.other5").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other5")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other5").show();

                }




                if (true) {
                    $("tr.other6").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other6")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other6").show();

                }



                if (true) {
                    $("tr.other7").hide();

                    $.each(Page_Validators, function (index, validator) {
                        if ($(validator).hasClass("other7")) {

                            ValidatorEnable(validator, false);

                        }
                    });

                }
                else {

                    $("tr.other7").show();

                }

                if (true) {
                    $('#<%= cb29A2no.ClientID %>').hide();
                }

            }
        });


        //debugger;
        // working here...


        $('#<%= rb29A1a.ClientID %>').click(function () {

            if ($('#<%= rb29A1a.ClientID %> input:checked').val() != '1') {
                if ($('#<%= rb29A1b.ClientID %> input:checked').val() != '1') {
                    if ($('#<%= rb29A1c.ClientID %> input:checked').val() != '1') {
                        if ($('#<%= rb29A1d.ClientID %> input:checked').val() != '1') {
                            if ($('#<%= rb29A1e.ClientID %> input:checked').val() != '1') {
                                $("tr.other5").hide();
                                $("tr.other6").hide();
                                $("tr.other7").hide();


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other5")) {
                                        ValidatorEnable(validator, false);

                                    }
                                });



                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other6")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other7")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });



                            };
                        };
                    };
                };





            }
            else {

                $("tr.other6").show();
                $("tr.other7").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other6")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other7")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
            }
        });



        $('#<%= rb29A1b.ClientID %>').click(function () {

            if ($('#<%= rb29A1b.ClientID %> input:checked').val() != '1') {
                if ($('#<%= rb29A1a.ClientID %> input:checked').val() != '1') {
                    if ($('#<%= rb29A1c.ClientID %> input:checked').val() != '1') {
                        if ($('#<%= rb29A1d.ClientID %> input:checked').val() != '1') {
                            if ($('#<%= rb29A1e.ClientID %> input:checked').val() != '1') {
                                $("tr.other5").hide();
                                $("tr.other6").hide();
                                $("tr.other7").hide();




                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other5")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other6")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other7")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });




                            };
                        };
                    };
                };

            }
            else {
                $("tr.other6").show();
                $("tr.other7").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other6")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });


                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other7")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });

            }

        });




        $('#<%= rb29A1c.ClientID %>').click(function () {

            if ($('#<%= rb29A1c.ClientID %> input:checked').val() != '1') {
                if ($('#<%= rb29A1b.ClientID %> input:checked').val() != '1') {
                    if ($('#<%= rb29A1a.ClientID %> input:checked').val() != '1') {
                        if ($('#<%= rb29A1d.ClientID %> input:checked').val() != '1') {
                            if ($('#<%= rb29A1e.ClientID %> input:checked').val() != '1') {
                                $("tr.other5").hide();
                                $("tr.other6").hide();
                                $("tr.other7").hide();


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other5")) {
                                        ValidatorEnable(validator, false);
                                    }
                                });

                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other6")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other7")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });



                            };
                        };
                    };
                };

            }
            else {
                $("tr.other6").show();
                $("tr.other7").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other6")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });


                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other7")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });




            }

        });




        $('#<%= rb29A1d.ClientID %>').click(function () {

            if ($('#<%= rb29A1d.ClientID %> input:checked').val() != '1') {
                if ($('#<%= rb29A1b.ClientID %> input:checked').val() != '1') {
                    if ($('#<%= rb29A1c.ClientID %> input:checked').val() != '1') {
                        if ($('#<%= rb29A1a.ClientID %> input:checked').val() != '1') {
                            if ($('#<%= rb29A1e.ClientID %> input:checked').val() != '1') {
                                $("tr.other5").hide();
                                $("tr.other6").hide();
                                $("tr.other7").hide();

                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other5")) {
                                        ValidatorEnable(validator, false);

                                    }
                                });

                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other6")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });

                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other7")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                            };
                        };
                    };
                };


            }
            else {
                $("tr.other6").show();
                $("tr.other7").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other6")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });


                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other7")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
            }

        });




        $('#<%= rb29A1e.ClientID %>').click(function () {

            if ($('#<%= rb29A1e.ClientID %> input:checked').val() != '1') {
                $("tr.other1").hide();
                $("tr.other1").find("input:text").val("");
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other1")) {

                        ValidatorEnable(validator, false);

                    }
                });

                if ($('#<%= rb29A1b.ClientID %> input:checked').val() != '1') {
                    if ($('#<%= rb29A1c.ClientID %> input:checked').val() != '1') {
                        if ($('#<%= rb29A1d.ClientID %> input:checked').val() != '1') {
                            if ($('#<%= rb29A1a.ClientID %> input:checked').val() != '1') {
                                $("tr.other5").hide();
                                $("tr.other6").hide();
                                $("tr.other7").hide();


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other5")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });

                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other6")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                                $.each(Page_Validators, function (index, validator) {
                                    if ($(validator).hasClass("other7")) {

                                        ValidatorEnable(validator, false);

                                    }
                                });


                            };
                        };
                    };
                };

            }
            else {
                $("tr.other1").show();
                $("tr.other6").show();
                $("tr.other7").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other1")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });


                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other6")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });


                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other7")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });



            }

        });



        $('#<%= rb29A1f.ClientID %>').click(function () {

            if ($('#<%= rb29A1f.ClientID %> input:checked').val() != '0') {
                $("tr.other2").hide();
                $("tr.other2").find("input:text").val("");
                $("tr.other3").find("input:radio").attr("checked", false);
                $("tr.other3").show();
                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other2")) {

                        ValidatorEnable(validator, false);
                    }
                    if ($(validator).hasClass("other3")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                });
            }
            else {
                $("tr.other2").show();
                $("tr.other3").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other2")) {

                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);
                    }
                    if ($(validator).hasClass("other3")) {

                        ValidatorEnable(validator, false);
                    }
                });

            }
        });


        $('#<%= rb29A1g.ClientID %>').click(function () {

            if ($('#<%= rb29A1g.ClientID %> input:checked').val() == '1') {
                

                    if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() == '1' && $('#<%= ConsultRequestListBox.ClientID %> input:checked').length > 0) {
                        //$("tr.other8").find("input:radio").attr("checked", true);
                        $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", true);
                        $('#<%= cb29A2no.ClientID %>').hide();
                        $('#<%= cb29A2no.ClientID %>').find('input[type=checkbox]').each(function () {
                            $(this).attr("checked", false);
                        });

                    }
                    else {
                        $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", false);
                    };
                };

            


        });







        $('#<%= rb29A1j.ClientID %>').click(function () {

            if ($('#<%= rb29A1j.ClientID %> input:checked').val() != '1') {

                $("tr.other5").find('input[type=checkbox]').each(function () {
                    $(this).attr("checked", false);
                });

                // $("INPUT[id^='ctl00_ContentPlaceHolder_ConsultRequestListBox_']").attr('checked', false)


                $("tr.other5").hide();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other5")) {

                        ValidatorEnable(validator, false);

                    }
                });

            }
            else {
                $("tr.other5").show();

                $.each(Page_Validators, function (index, validator) {
                    if ($(validator).hasClass("other5")) {
                        ValidatorEnable(validator, true);
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);

                        // alert('other5 enabled');
                    }
                });

            }

        });


        $('#<%=ConsultRequestListBox.ClientID %> input:checkbox').click(function () {


            if ($('#<%=ConsultRequestListBox.ClientID %> input:checkbox').index($(this)) >= 0) {
                if ($(this).is(':checked')) {
                    if ($('#<%= rbSectionTwentySeven.ClientID %> input:checked').val() == '1' && $('#<%= rb29A1g.ClientID %> input:checked').val() == '1') {
                        //$("tr.other8").find("input:radio").attr("checked", true);
                        $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", true);
                        $('#<%= cb29A2no.ClientID %>').hide();
                        $('#<%= cb29A2no.ClientID %>').find('input[type=checkbox]').each(function () {
                            $(this).attr("checked", false);
                        });

                        
                }

                else {
                    $('#<%= rb29A2.ClientID %>').find("input:radio").attr("checked", false);
                };

                    

                    //$("tr.consults").show();


                }
                else {

                    //$("tr.consults").hide();
                    //$("tr.consults").find("input:text").val("");


                }
            }

        });



        $('#<%= rb29A2.ClientID %>').click(function () {

            if ($('#<%= rb29A2.ClientID %> input:checked').val() == '0') {
                //alert('testtest');
                //$("rb29A2no").find("input:radio").attr("visible", true);

                $('#<%= cb29A2no.ClientID %>').show();



            } else {
                $('#<%= cb29A2no.ClientID %>').hide();
                $('#<%= cb29A2no.ClientID %>').find('input[type=checkbox]').each(function () {
                    $(this).attr("checked", false);
                });
            }

        });

    });



    // });
    /******************/


    function checkConsultListValidate(sender, args) {
        args.IsValid = true;

        if ($('#<%= ConsultRequestListBox.ClientID %> input:checked').length > 0)
            args.IsValid = true;
        else
            args.IsValid = false;
    }


    function checkPainListValidate(sender, args) {
        args.IsValid = true;

        if ($('#<%= BodyPartsList.ClientID %> input:checked').length > 0)
            args.IsValid = true;
        else
            args.IsValid = false;
    }




    function checkBlastListValidate(sender, args) {
        args.IsValid = true;

        if ($('#<%= BlastExplosureTypeList.ClientID %> input:checked').length > 0)
            args.IsValid = true;
        else
            args.IsValid = false;
    }

    function checkFirstInjuryMonthValidate(sender, args) {
        var injYear = $('#<%= InjuryYearTextBox.ClientID %>').val();
        var injMonth = $('#<%= InjuryMonthTextBox.ClientID %>').val();
        var value = Number(injMonth);

        if (Math.floor(value) != value) {
            args.IsValid = false;
            return;
        }
        else {
            if (value < 1 || value > 12) {
                args.IsValid = false;
                return;
            }
            else {
                // month is an integer, do something based on that
                var currMonth = new Date().getMonth() + 1;
                var currYear = new Date().getFullYear();

                if (injYear == currYear && injMonth > currMonth) {
                    //future month
                    args.IsValid = false;
                }
                else {
                    //past or present month
                    args.IsValid = true;
                }
            }
        }
    }

    function checkSecondInjuryMonthValidate(sender, args) {
        var injYear = $('#<%= SecondInjuryYearTextBox.ClientID %>').val();
        var injMonth = $('#<%= SecondInjuryMonthTextBox.ClientID %>').val();
        var value = Number(injMonth);

        if (Math.floor(value) != value) {
            args.IsValid = false;
            return;
        }
        else {
            if (value < 1 || value > 12) {
                args.IsValid = false;
                return;
            }
            else {
                // month is an integer, do something based on that
                var currMonth = new Date().getMonth() + 1;
                var currYear = new Date().getFullYear();

                if (injYear == currYear && injMonth > currMonth) {
                    //future month
                    args.IsValid = false;
                }
                else {
                    //past or present month
                    args.IsValid = true;
                }
            }
        }
    }

    function checkThirdInjuryMonthValidate(sender, args) {
        var injYear = $('#<%= LeastInjuryYearTextBox.ClientID %>').val();
        var injMonth = $('#<%= LeastInjuryMonthTextBox.ClientID %>').val();
        var value = Number(injMonth);

        if (Math.floor(value) != value) {
            args.IsValid = false;
            return;
        }
        else {
            if (value < 1 || value > 12) {
                args.IsValid = false;
                return;
            }
            else {
                // month is an integer, do something based on that
                var currMonth = new Date().getMonth() + 1;
                var currYear = new Date().getFullYear();

                if (injYear == currYear && injMonth > currMonth) {
                    //future month
                    args.IsValid = false;
                }
                else {
                    //past or present month
                    args.IsValid = true;
                }
            }
        }
    }

    function GetListIndexSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = i;
                break;
            }
        }
        return ret;
    }

    //Show/hide section functions
    function ShowHideInjuriesQuantity() {
        if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbInjuriesQuantity.ClientID %> input:checked').length == 0) {

            $('tr.injuriesnone').hide();
            $('tr.oneinjury').hide();
            $('tr.twoinjuries').hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("injuriesnone")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '1') {
            $('tr.injuriesnone').show();
            $('tr.oneinjury').hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("oneinjury")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() == '2') {

            $('tr.injuriesnone').show();
            $('tr.twoinjuries').hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("twoinjuries")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            $('tr.injuriesnone').show();
        }
}

function ShowHideFiveDSubsection() {
    if ($('#<%= rbFiveDSubsection.ClientID %> input:checked').val() == '0' || $('#<%= rbFiveDSubsection.ClientID %> input:checked').length == 0) {
        $('tr.blastnone').hide();

        $.each(Page_Validators, function (index, validator) {
            if ($(validator).hasClass("blastnone")) {
                ValidatorEnable(validator, false);
            }
        });
    }
    else {
        if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
            $('tr.blastnone').show();
        }
    }
}

function ShowHideSixSection() {
    if ($('#<%= rbSixSection.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbSixSection.ClientID %> input:checked').val() == '6' ||
            $('#<%= rbSixSection.ClientID %> input:checked').length == 0) {

            $("tr.consciousness").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("consciousness")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {

            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                $('tr.consciousness').show()
            }
        }
    }

    function ShowHideSevenSection() {
        if ($('#<%= rbSevenSection.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbSevenSection.ClientID %> input:checked').val() == '6' ||
            $('#<%= rbSevenSection.ClientID %> input:checked').length == 0) {

            $("tr.disorientnone").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("disorientnone")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {

            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                $("tr.disorientnone").show();
            }
        }
    }

    function ShowHideEightSection() {
        if ($('#<%= rbEightSection.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbEightSection.ClientID %> input:checked').val() == '6' ||
            $('#<%= rbEightSection.ClientID %> input:checked').length == 0) {

            $("tr.memoryloss").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("memoryloss")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                $("tr.memoryloss").show();
            }
        }
    }

    function ShowHideTwelveSection() {
        if ($('#<%= rbTwelveSection.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbTwelveSection.ClientID %> input:checked').length == 0) {

            $("tr.notreatment").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("notreatment")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            if ($('#<%= rbInjuriesQuantity.ClientID %> input:checked').val() != '0') {
                $("tr.notreatment").show();
            }
        }
    }


    function ShowHideEighteenSection() {
        if ($('#<%= rbEighteenSection.ClientID %> input:checked').val() == '0' ||
            $('#<%= rbEighteenSection.ClientID %> input:checked').length == 0) {

            $("tr.pain").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("pain") || $(validator).className == "pain") {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            $("tr.pain").show();
        }
    }


//added 2/10/2017
    function ShowHideSectionTwentyEight() {
        if ($('#<%= rbSectionTwentyEight.ClientID %> input:checked').val() != '5' ||
            $('#<%= rbSectionTwentyEight.ClientID %> input:checked').length == 0) {

            $("tr.symptoms").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("symptoms")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            $("tr.symptoms").show();
        }
    }
    function ShowHideSectionTwentyEight() {
        if ($('#<%= rbSectionTwentyEight.ClientID %> input:checked').val() != '5' ||
             $('#<%= rbSectionTwentyEight.ClientID %> input:checked').length == 0) {

            $("tr.symptoms").hide();

            $.each(Page_Validators, function (index, validator) {
                if ($(validator).hasClass("symptoms")) {
                    ValidatorEnable(validator, false);
                }
            });
        }
        else {
            $("tr.symptoms").show();
        }
    }

    function btnSaveButtonChange_Click() {
        //Save draft if question 8,15,16V,28 is changed occurs
        //document.getElementById('<%= SaveButton.ClientID %>').click();
        // alert("Auto-Saving");
    }
</script>
</telerik:RadCodeBlock>
<telerik:RadCodeBlock runat="server" ID="RadCodeBlock4">
 <div class="breadcrumbInstrument">
            
    <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > COMPREHENSIVE TBI EVALUATION"></asp:Label> 
</div>
</telerik:RadCodeBlock>
<telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
<asp:UpdatePanel ID="MainUpdatePanel" runat="server">
    <ContentTemplate>
        <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="true" 
        ValidationGroup="OnSave" />

        <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
        <table cellpadding = "5" cellspacing = "5">
            <tr>
                <td>
                     &nbsp;&nbsp;<asp:Label ID = "LabelForName" runat = "server" Text = "Patient:" AssociatedControlID = "LabelPatient"></asp:Label>       
                    &nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel">Patient One Hundred and Four</asp:Label>
                </td>
                <td>
                    <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelSSN" Text = "SSN:"></asp:Label>
                    &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel"></asp:Label>
                
                </td>
                <td>
                    <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelFacility" Text = "Facility:" Visible="false"></asp:Label>
                    &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel"></asp:Label>
                
                </td>
            </tr>
        </table>
        </asp:Panel>
        
        <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="COMP TBI EVAL" />
        
        <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
       
        <table cellpadding = "5" cellspacing = "5" width = "100%" class = "survey">
        <tr id="TrQA" class = "feebasis">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="nonVAProviderPanel" AssociatedControlID="rbnonVAProvider" runat="server" CssClass="firstLevelQuestion">
                            A. Is this evaluation being completed by provider without access to CPRS (i.e. Fee Basis providers without a CPRS account)?<br></br>All evaluations not entered into CPRS utilizing the Comprehensive TBI Evaluation template should be scanned into the medical record.
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr class = "feebasis">
                        <td>
                            <asp:RadioButtonList ID = "rbnonVAProvider" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
        TabIndex="2"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>
                            </asp:RadioButtonList>  
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr class = "feebasis">
            <td style = "padding-left:10pt">
                <br />
                <asp:Label ID = "ReferredReasonLabel" runat = "server" Text = "You were referred because the primary level screening indicated that you may have had a head injury, 
                that is you reported having had an alteration of consciousness after some traumatic event. We are trying to determine the nature and severity of any of those types of injuries or
                related injuries, to determine how best we can assist you."></asp:Label>  
                <br />
                <br />
            </td>
        </tr>
        <tr id="TrQ1" >
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="MaritalStatusPanel" AssociatedControlID="rbMaritalStatus" runat="server" CssClass="firstLevelQuestion">
                            1. Current Marital Status:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbMaritalStatus" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
        TabIndex="3"
                            >                 
                                <asp:ListItem Text = "1. Single, never married" Value = "1"/>
                                <asp:ListItem Text = "2. Married or partnered" Value = "2"/>
                                <asp:ListItem Text = "3. Separated or divorced" Value = "3"/>
                                <asp:ListItem Text = "4. Widowed" Value = "4"/>
                             
                             </asp:RadioButtonList> 
                             <asp:RequiredFieldValidator ID="MaritalStatusValidator"
                                    ControlToValidate="rbMaritalStatus"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                 
        TabIndex="4"
                                    ErrorMessage = "Marital Status is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                    CssClass = "ValidatorClass">
                            </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>
          
        </tr>
        <tr id="TrQ2" >
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="EducationLevelPanel" AssociatedControlID="rbEducationalLevel" runat="server" CssClass="firstLevelQuestion">
                            2. Pre-military level of educational achievement:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbEducationalLevel" runat = "server" 
                                RepeatDirection="Horizontal"  RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
        TabIndex="5"
                            >                 
                                <asp:ListItem Text = "1. Less than high school" Value = "1"/>
                                <asp:ListItem Text = "2. High school graduate or equivalent" Value = "2"/>
                                <asp:ListItem Text = "3. Some college, associate degree or technical degree" Value = "3"/>
                                <asp:ListItem Text = "4. College graduate (baccalaureate)" Value = "4"/>
                                <asp:ListItem Text = "5. Post baccalaureate" Value = "5"/>
                                            
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="EducationalLevelValidator"
                                    ControlToValidate="rbEducationalLevel"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Educational Level is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                
        TabIndex="6"
                                    CssClass = "ValidatorClass">
                            </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td> 
        </tr>
        <tr id="TrQ3" >
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="EmploymentStatusPanel" AssociatedControlID="rbEmploymentStatus" runat="server" CssClass="firstLevelQuestion">
                            3. Current employment status:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbEmploymentStatus" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
                                TabIndex="7"
                            >                 
                                <asp:ListItem Text = "1. Unemployed, looking for work" Value = "1"/>
                                <asp:ListItem Text = "2. Unemployed, not looking for work" Value = "2"/>
                                <asp:ListItem Text = "3. Working part-time" Value = "3"/>
                                <asp:ListItem Text = "4. Working full-time" Value = "4"/>
                                <asp:ListItem Text = "5. Student" Value = "5"/>
                                <asp:ListItem Text = "6. Volunteer" Value = "6"/>
                                <asp:ListItem Text = "7. Homemaker" Value = "7"/>
                                            
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="EmploymentStatusValidator"
                                    ControlToValidate="rbEmploymentStatus"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Employment Status is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                    CssClass = "ValidatorClass"
                                    TabIndex="8"
                                >
                            </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td> 
        </tr>
        <tr id="TrChI" >
            <td>
                <br />
                <asp:Label ID = "ChapterOneLabel" runat = "server" Text = "I. Injury" Font-Bold = "true"/> 
            </td> 
        </tr>
        <tr id="TrQ4" >
            <td>                 
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td colspan="2">
                            <asp:Label ID="InjuriesQuantityPanel" AssociatedControlID="rbInjuriesQuantity" runat="server" CssClass="firstLevelQuestion">
                            4. How many serious OEF/OIF/OND deployment related injuries have occurred?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                        <asp:RadioButtonList ID = "rbInjuriesQuantity" runat = "server" 
                            RepeatDirection="Horizontal" RepeatColumns="2"
                            RepeatLayout="Table"
                            CssClass="fixWidth"
                            TabIndex="9"
                        >                 
                            <asp:ListItem Text = "0. None" Value = "0"/>
                            <asp:ListItem Text = "1. One" Value = "1"/>
                            <asp:ListItem Text = "2. Two" Value = "2"/>
                            <asp:ListItem Text = "3. Three" Value = "3"/>

                        </asp:RadioButtonList>
                        <asp:RequiredFieldValidator ID="InjuriesQuantityValidator"
                            ControlToValidate="rbInjuriesQuantity"
                            Display="Dynamic"
                            runat="server"
                            EnableClientScript="true"
                            ErrorMessage = "Number OEF/OIF/OND deployment related injuries is required"
                            SetFocusOnError="true"                            
                            ValidationGroup = "OnSave" 
                            CssClass = "ValidatorClass"
                            TabIndex="10">
                        </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                    <tr id="TrQ4A1" class = "injuriesnone">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "InjuryMonthLabel" runat = "server" Text = "4-A-1. Month of most serious injury:" AssociatedControlID = "InjuryMonthTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "InjuryMonthTextBox" runat = "server" Width = "75px" TabIndex="11"></asp:TextBox>
                            <asp:CustomValidator ID = "InjuryMonthValidator" runat = "server" 
                                ControlToValidate = "InjuryMonthTextBox" 
                                Display = "Dynamic" 
                                EnableClientScript = "true" 
                                SetFocusOnError = "true" 
                                ValidationGroup = "OnSave" 
                                ErrorMessage = "Injury month needs to be a valid month and should be in the past."
                                ClientValidationFunction = "checkFirstInjuryMonthValidate" 
                                CssClass = "injuriesnone"
                                TabIndex="12">
                            </asp:CustomValidator>           
                        </td>
                    </tr>
                    <tr id="TrQ4A2" class = "injuriesnone">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "InjuryYearLabel" runat = "server" Text = "4-A-2. Year of most serious injury:" AssociatedControlID = "InjuryYearTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "InjuryYearTextBox" runat = "server" Width = "75px" TabIndex="13"></asp:TextBox>
                            <asp:RangeValidator ID = "InjuryYearRangeValidator" runat = "server" ControlToValidate = "InjuryYearTextBox"
                                EnableClientScript = "true" SetFocusOnError="true" Display = "Dynamic" ValidationGroup = "OnSave"
                                ErrorMessage = "Injury year needs to be a valid year between 2001 and current date." Type = "Integer" CssClass = "injuriesnone"></asp:RangeValidator>   
                            <asp:RequiredFieldValidator ID="MostSeriousInjuryYearValidator"
                                    ControlToValidate="InjuryYearTextBox"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Year of most serious injury is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                    CssClass = "ValidatorClass injuriesnone"
                                TabIndex="14">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr id="TrQ4B1" class = "injuriesnone oneinjury">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "SecondInjuryMonthLabel" runat = "server" Text = "4-B-1. Month of second serious injury:" AssociatedControlID = "SecondInjuryMonthTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "SecondInjuryMonthTextBox" runat="server" Width = "75px" TabIndex="15"></asp:TextBox>
                            <asp:CustomValidator ID = "SecondInjuryValidMonthValidator" runat = "server" 
                                EnableClientScript = "true" 
                                SetFocusOnError = "true" 
                                Display = "Dynamic" 
                                ValidationGroup = "OnSave" 
                                ErrorMessage = "Second injury month needs to be a valid month and should be in the past."
                                ClientValidationFunction = "checkSecondInjuryMonthValidate" 
                                ControlToValidate = "SecondInjuryMonthTextBox" 
                                CssClass = "injuriesnone oneinjury"
                                TabIndex="16">
                            </asp:CustomValidator>       
                        </td>
                    </tr>
                    <tr id="TrQ4B2" class = "injuriesnone oneinjury">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "SecondInjuryYearLabel" runat = "server" Text = "4-B-2. Year of second serious injury:" AssociatedControlID = "SecondInjuryYearTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "SecondInjuryYearTextBox" runat = "server" Width = "75px" TabIndex="17"></asp:TextBox>
                            <asp:RangeValidator ID = "SecondInjuryYearRangeValidator" runat = "server" ControlToValidate = "SecondInjuryYearTextBox"
                                EnableClientScript = "true" SetFocusOnError="true" Display = "Dynamic" ValidationGroup = "OnSave"
                                ErrorMessage = "Second injury year needs to be a valid year between 2001 and current date." Type = "Integer" CssClass = "injuriesnone oneinjury"></asp:RangeValidator>   
                           <asp:RequiredFieldValidator ID="SecondInjuryYearValidator"
                                    ControlToValidate="SecondInjuryYearTextBox"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Year of second serious injury is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                    CssClass = "ValidatorClass injuriesnone oneinjury"
                               TabIndex="18">
                            </asp:RequiredFieldValidator>       
                        </td>
                    </tr>
                    <tr id="TrQ4C1" class = "injuriesnone oneinjury twoinjuries">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "LeastInjuryMonthLabel" runat = "server" Text = "4-C-1. Month of third serious injury:" AssociatedControlID = "LeastInjuryMonthTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "LeastInjuryMonthTextBox" runat = "server" Width = "75px" TabIndex="19"></asp:TextBox>
                            <asp:CustomValidator ID = "ThirdInjuryCustomValidator" runat = "server" EnableClientScript = "true" SetFocusOnError = "true" 
                            Display = "Dynamic" ValidationGroup = "OnSave" ErrorMessage = "Third injury month needs to be a valid month and should be in the past."
                            ClientValidationFunction = "checkThirdInjuryMonthValidate" ControlToValidate = "LeastInjuryMonthTextBox" CssClass = "injuriesnone oneinjury twoinjuries"
                                TabIndex="20"></asp:CustomValidator>  
                        </td>
                    </tr>
                    <tr id="TrQ4C2" class = "injuriesnone oneinjury twoinjuries">
                        <td style = "padding-left:10pt" width="20%">
                            <asp:Label ID = "LeastInjuryYearLabel" runat = "server" Text = "4-C-2. Year of third serious injury:" AssociatedControlID = "LeastInjuryYearTextBox"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox ID = "LeastInjuryYearTextBox" runat = "server" Width = "75px" TabIndex="21"></asp:TextBox>
                            <asp:RangeValidator ID = "LeastInjuryYearRangeValidator" runat = "server" ControlToValidate = "LeastInjuryYearTextBox"
                                EnableClientScript = "true" SetFocusOnError="true" Display = "Dynamic"
                                ErrorMessage = "Third injury year needs to be a valid year between 2001 and current date." Type = "Integer" ValidationGroup = "OnSave" 
                                CssClass = "injuriesnone oneinjury twoinjuries"></asp:RangeValidator>   
                            <asp:RequiredFieldValidator ID="ThirdInjuryYearValidator"
                                    ControlToValidate="LeastInjuryYearTextBox"
                                    Display="Dynamic"
                                    runat="server"
                                    EnableClientScript="true"
                                    ErrorMessage = "Year of third serious injury is required."
                                    SetFocusOnError="true"                            
                                    ValidationGroup = "OnSave" 
                                    CssClass = "ValidatorClass injuriesnone oneinjury twoinjuries"
                                TabIndex="22">
                            </asp:RequiredFieldValidator> 
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>               
        </tr>
        <tr id="TrQ5" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID = "InjuryCauseLabel" runat = "server" CssClass="firstLevelQuestion" Font-Bold = "true">
                            5. Cause of injury:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr id="TrQ5A" >
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="BulletInjuryPanel" AssociatedControlID="rbFiveASubsection" runat="server" CssClass="firstLevelQuestion">
                                        5-A. Bullet
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbFiveASubsection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="23"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                            
                                        </asp:RadioButtonList>             
                                        <asp:RequiredFieldValidator ID="BulletValidator"
                                                ControlToValidate="rbFiveASubsection"
                                                Display="Dynamic"
                                                runat="server"
                                                EnableClientScript="true"
                                                ErrorMessage = "Bullet episodes number is required."
                                                SetFocusOnError="true"                            
                                                ValidationGroup = "OnSave" 
                                                CssClass = "ValidatorClass injuriesnone"
                                                TabIndex="24">
                                        </asp:RequiredFieldValidator> 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ5B" >
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="VehicularInjuryPanel" AssociatedControlID="rbFiveBSubsection" runat="server" CssClass="firstLevelQuestion">
                                        5-B. Vehicular
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbFiveBSubsection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="25"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                            
                                        </asp:RadioButtonList> 
                                        <asp:RequiredFieldValidator ID="VehicleInjuryValidator"
                                                ControlToValidate="rbFiveBSubsection"
                                                Display="Dynamic"
                                                runat="server"
                                                EnableClientScript="true"
                                                ErrorMessage = "Vehicular episodes number is required."
                                                SetFocusOnError="true"                            
                                                ValidationGroup = "OnSave" 
                                                CssClass = "ValidatorClass injuriesnone"
                                                TabIndex="26"
                                            >
                                        </asp:RequiredFieldValidator> 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ5C" >
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="FallInjuryPanel" AssociatedControlID="rbFiveCSubsection" runat="server" CssClass="firstLevelQuestion">
                                        5-C. Fall
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbFiveCSubsection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="27"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="FallValidator"
                                                ControlToValidate="rbFiveCSubsection"
                                                Display="Dynamic"
                                                runat="server"
                                                EnableClientScript="true"
                                                ErrorMessage = "Fall episodes number is required."
                                                SetFocusOnError="true"                            
                                                ValidationGroup = "OnSave" 
                                                CssClass = "ValidatorClass injuriesnone"
                                                TabIndex="28">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ5D" >
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="BlastInjuryPanel" AssociatedControlID="rbFiveDSubsection" runat="server" CssClass="firstLevelQuestion">
                                        5-D. Blast:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbFiveDSubsection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="29"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="BlastEpisodesValidator"
                                                ControlToValidate="rbFiveDSubsection"
                                                Display="Dynamic"
                                                runat="server"
                                                EnableClientScript="true"
                                                ErrorMessage = "Blast episodes number is required."
                                                SetFocusOnError="true"                            
                                                ValidationGroup = "OnSave" 
                                                CssClass = "ValidatorClass injuriesnone"
                                            TabIndex="30">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr class = "injuriesnone blastnone">
                                    <td>
                                        <table width="100%" cellpadding = "5" cellspacing = "5">
                                            <tr id="TrQ5D1" class = "injuriesnone blastnone">
                                                <td>
                                                    <fieldset class="secondLevelQuestion">
                                                    <table width="100%">
                                                    <tr class="questionBackgroundColor">
                                                        <td>
                                                            <asp:Label ID="BlastWavePanel" AssociatedControlID="rbFiveDOneSubsection" runat="server" CssClass="firstLevelQuestion">
                                                            5-D-1. When a high-explosive bomb or IED goes off there is a &quot;blast wave&quot; which is a wave of highly compressed gas that may feel almost like being smashed into a wall. Do you remember experiencing this or were told that you experienced it?
                                                            </asp:Label>
                                                            <br />
                                                            <br />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:RadioButtonList ID = "rbFiveDOneSubsection" runat = "server" 
                                                                RepeatDirection="Horizontal" RepeatColumns="2"
                                                                RepeatLayout="Table"
                                                                CssClass="fixWidth"
                                                                TabIndex="31"
                                                            >                 
                                                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                                                <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                                                <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                                                <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                                                <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                                                <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                                            </asp:RadioButtonList>
                                                            <asp:RequiredFieldValidator ID="BlastWaveExperienceValidator"
                                                                        ControlToValidate="rbFiveDOneSubsection"
                                                                        Display="Dynamic"
                                                                        runat="server"
                                                                        EnableClientScript="true"
                                                                        ErrorMessage = "Blast wave episodes number is required."
                                                                        SetFocusOnError="true"                            
                                                                        ValidationGroup = "OnSave" 
                                                                        CssClass = "ValidatorClass injuriesnone blastnone"
                                                                TabIndex="32">
                                                            </asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr id="TrQ5D1a">
                                                        <td>
                                                        <fieldset class="secondLevelAnswer">
                                                            <table width="100%">
                                                                <tr class="subquestionBackgroundColor">
                                                                    <td>
                                                                        <asp:Label ID="BlastDistancePanel" AssociatedControlID="rbFiveDOneASection" runat="server" CssClass="firstLevelQuestion">
                                                                        5-D-1-a. Estimated distance from closest blast:
                                                                        </asp:Label>
                                                                        <br />
                                                                        <br />
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <asp:RadioButtonList ID = "rbFiveDOneASection" runat = "server" 
                                                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                                                            RepeatLayout="Table"
                                                                            CssClass="fixWidth"
                                                                            TabIndex="33"
                                                                        >                 
                                                                            <asp:ListItem Text = "1. Less than 10 feet" Value = "1"></asp:ListItem>
                                                                            <asp:ListItem Text = "2. Between 10 and 30 feet" Value = "2"></asp:ListItem>
                                                                            <asp:ListItem Text = "3. Between 31 and 50 feet" Value = "3"></asp:ListItem>
                                                                            <asp:ListItem Text = "4. Greater than 50 feet" Value = "4"></asp:ListItem>
                                                                        </asp:RadioButtonList>
                                                                        <asp:RequiredFieldValidator ID="BlastDistanceValidator"
                                                                            ControlToValidate="rbFiveDOneASection"
                                                                            Display="Dynamic"
                                                                            runat="server"
                                                                            EnableClientScript="true"
                                                                            ErrorMessage = "Estimated distance from closest blast is required."
                                                                            SetFocusOnError="true"                            
                                                                            ValidationGroup = "OnSave" 
                                                                            CssClass = "ValidatorClass injuriesnone blastnone"
                                                                            TabIndex="34">
                                                                        </asp:RequiredFieldValidator>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                            </fieldset>
                                                        </td>
                                                    </tr>
                                                    </table>
                                                    </fieldset>
                                               </td>
                                            </tr>
                                            <tr id="TrQ5D2" class = "injuriesnone blastnone">
                                                <td>
                                                    <fieldset class="secondLevelQuestion">
                                                    <table width="100%">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="BlastWindPanel" AssociatedControlID="rbFiveDTwoSection" runat="server" CssClass="firstLevelQuestion">
                                                                5-D-2. This  &quot;blast wave&quot; is followed by a wind in which particles of sand, debris, shrapnel, and fragments are moving rapidly. Were you close enough to the blast to be &quot;peppered&quot; or hit by such debris,  shrapnel, or other items?
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:RadioButtonList ID = "rbFiveDTwoSection" runat = "server" 
                                                                    RepeatDirection="Horizontal" RepeatColumns="2"
                                                                    RepeatLayout="Table"
                                                                    CssClass="fixWidth"
                                                                    TabIndex="35"
                                                                >                 
                                                                    <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                                                    <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                                                    <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                                                    <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                                                    <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                                                    <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                                                </asp:RadioButtonList>
                                                                <asp:RequiredFieldValidator ID="BlastWaveValidator"
                                                                    ControlToValidate="rbFiveDTwoSection"
                                                                    Display="Dynamic"
                                                                    runat="server"
                                                                    EnableClientScript="true"
                                                                    ErrorMessage = "Blast proximity episodes number is required."
                                                                    SetFocusOnError="true"                            
                                                                    ValidationGroup = "OnSave" 
                                                                    CssClass = "ValidatorClass injuriesnone blastnone"
                                                                    TabIndex="36">
                                                                </asp:RequiredFieldValidator>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    </fieldset>
                                                </td>                 
                                            </tr>
                                            <tr id="TrQ5D3" class = "injuriesnone blastnone">
                                                <td>
                                                    <fieldset class="secondLevelQuestion">
                                                    <table width="100%">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="BlastThrownPanel" AssociatedControlID="rbFiveDThreeSection" runat="server" CssClass="firstLevelQuestion">
                                                                5-D-3. Were you thrown to the ground or against some stationary object like a wall, vehicle or inside a vehicle by the explosion?  (This is not asking if you &quot;ducked to the ground&quot; to protect yourself).
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:RadioButtonList ID = "rbFiveDThreeSection" runat = "server" 
                                                                    RepeatDirection="Horizontal" RepeatColumns="2"
                                                                    RepeatLayout="Table"
                                                                    CssClass="fixWidth"
                                                                    TabIndex="37"
                                                                >                 
                                                                    <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                                                    <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                                                    <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                                                    <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                                                    <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                                                    <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                                                </asp:RadioButtonList>
                                                                <asp:RequiredFieldValidator ID="GroundThrownValidator"
                                                                    ControlToValidate="rbFiveDThreeSection"
                                                                    Display="Dynamic"
                                                                    runat="server"
                                                                    EnableClientScript="true"
                                                                    ErrorMessage = "Thrown to the ground episodes number is required."
                                                                    SetFocusOnError="true"                            
                                                                    ValidationGroup = "OnSave" 
                                                                    CssClass = "ValidatorClass injuriesnone blastnone"
                                                                    TabIndex="38">
                                                                </asp:RequiredFieldValidator>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    </fieldset>
                                                </td>                 
                                            </tr>
                                            <tr id="TrQ5D4" class = "injuriesnone blastnone">
                                                <td>
                                                    <fieldset class="secondLevelQuestion">
                                                    <table width="100%">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="BlastStructuresPanel" AssociatedControlID="rbFiveDFourSection" runat="server" CssClass="firstLevelQuestion">
                                                                5-D-4. Did you experience any of the following injuries as a result of an explosive blast:  burns, wounds, broken bones, amputations, breathing toxic fumes, or crush injuries from structures falling onto you?
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:RadioButtonList ID = "rbFiveDFourSection" runat = "server" 
                                                                    RepeatDirection="Horizontal" RepeatColumns="2"
                                                                    RepeatLayout="Table"
                                                                    CssClass="fixWidth"
                                                                    TabIndex="39"
                                                                >                 
                                                                    <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                                                    <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                                                    <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                                                    <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                                                    <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                                                    <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                                                </asp:RadioButtonList>
                                                                <asp:RequiredFieldValidator ID="ExplosiveBlastValidator"
                                                                    ControlToValidate="rbFiveDFourSection"
                                                                    Display="Dynamic"
                                                                    runat="server"
                                                                    EnableClientScript="true"
                                                                    ErrorMessage = "Falling structures episodes number is required."
                                                                    SetFocusOnError="true"                            
                                                                    ValidationGroup = "OnSave" 
                                                                    CssClass = "ValidatorClass injuriesnone blastnone"
                                                                    TabIndex="40">
                                                                </asp:RequiredFieldValidator>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    </fieldset>
                                                </td>                 
                                            </tr>
                                            <tr id="TrQ5D5" class = "injuriesnone blastnone">
                                                <td>
                                                    <fieldset class="secondLevelQuestion">
                                                    <table width="100%">
                                                        <tr class="questionBackgroundColor">
                                                            <td>
                                                                <asp:Label ID="FiveDFiveLabel" AssociatedControlID="BlastExplosureTypeList" runat="server" CssClass="firstLevelQuestion">
                                                                5-D-5. Type of blast exposures: (Check all that apply)
                                                                </asp:Label>
                                                                <br />
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:CheckBoxList ID = "BlastExplosureTypeList" runat = "server" 
                                                                    RepeatDirection="Horizontal" RepeatColumns="2"
                                                                    RepeatLayout="Table"
                                                                    CssClass="fixWidth"
                                                                    TabIndex="41"
                                                                >                 
                                                                    <asp:ListItem Text = "1. Improvised Explosive Device (IED)" Value = "0"></asp:ListItem>
                                                                    <asp:ListItem Text = "2. Rocket Propelled Grenade (RPG)" Value = "1"></asp:ListItem>
                                                                    <asp:ListItem Text = "3. Mortar" Value = "2"></asp:ListItem>
                                                                    <asp:ListItem Text = "4. Grenade" Value = "3"></asp:ListItem>
                                                                    <asp:ListItem Text = "5. Bomb" Value = "4"></asp:ListItem>
                                                                    <asp:ListItem Text = "6. Other" Value = "5"></asp:ListItem>
                                                                    <asp:ListItem Text = "7. Unknown" Value = "6"></asp:ListItem>
                                                                </asp:CheckBoxList>
                                                                <web:RequiredFieldValidatorForCheckBoxLists ID = "TypeofBlastExposuresValidator" 
                                                                    ControlToValidate="BlastExplosureTypeList"
                                                                    Display="Dynamic"
                                                                    runat="server"
                                                                    EnableClientScript="true"
                                                                    ErrorMessage = "Type of blast exposure is required."
                                                                    SetFocusOnError="true"
                                                                    ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone blastnone"
                                                                    TabIndex="42">
                                                                </web:RequiredFieldValidatorForCheckBoxLists> 
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    </fieldset>
                                                </td> 
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ5E" class = "injuriesnone">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="BluntTraumaPanel" AssociatedControlID="rbFiveESection" runat="server" CssClass="firstLevelQuestion">
                                        5-E. Blunt trauma other than from blast/vehicular injury, e.g., assault, blunt force, sports related or object hitting head.
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbFiveESection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="43"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorBluntTrauma"
                                            ControlToValidate="rbFiveESection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Blunt trauma other than from blast/vehicular injury episodes number is required."
                                            SetFocusOnError="true"                            
                                            ValidationGroup = "OnSave" 
                                            CssClass = "ValidatorClass injuriesnone blastnone"
                                            TabIndex="44">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>                 
                    </tr> 
                </table>
                </fieldset>
            </td>       
        </tr>
        <tr id="TrQ6" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="ConsciousnessPanel" AssociatedControlID="rbSixSection" runat="server" CssClass="firstLevelQuestion">
                            6. Did you lose consciousness immediately after any of these experiences?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbSixSection" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth tbiDiagnosis"
                                TabIndex="45"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                <asp:ListItem Text = "6. Uncertain" Value = "6"></asp:ListItem>
                                
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorConsciousnessLoss"
                                        ControlToValidate="rbSixSection"
                                        Display="Dynamic"
                                        runat="server"
                                        EnableClientScript="true"
                                        ErrorMessage = "Consciousness loss episodes number is required."
                                        SetFocusOnError="true"                            
                                        ValidationGroup = "OnSave" 
                                        CssClass = "ValidatorClass injuriesnone"
                                        TabIndex="46">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr id="TrQ6A"  class = "injuriesnone consciousness">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="ConsciousnessDurationPanel" AssociatedControlID="rbSixASection" runat="server" CssClass="firstLevelQuestion">
                                        6-A. If yes, estimate the duration of longest period of loss of consciousness.
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixASection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="47"
                                        >                 
                                            <asp:ListItem Text = "1. Very brief, probably less than 5 minutes" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Less than 30 minutes" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Less than 6 hours" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Up to a full day(24 hours)" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Up to a full week(7 days)" Value = "5"></asp:ListItem>
                                            <%--<asp:ListItem Text = "4. Up to 1 month" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Up to 3 months" Value = "5"></asp:ListItem>--%>
                                            <asp:ListItem Text = "6. More than one week" Value = "6"></asp:ListItem>  
                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="LossConsciousnessRequiredFieldValidator"
                                                    ControlToValidate="rbSixASection"
                                                    Display="Dynamic"
                                                    runat="server"
                                                    EnableClientScript="true"
                                                    ErrorMessage = "Longest period of loss of consciousness is required."
                                                    SetFocusOnError="true"                            
                                                    ValidationGroup = "OnSave" 
                                                    CssClass = "ValidatorClass injuriesnone consciousness"
                                                    TabIndex="48">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>       
        </tr>
        <tr id="TrQ7" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="DisorientationPeriodPanel" AssociatedControlID="rbSevenSection" runat="server" CssClass="firstLevelQuestion">
                            7. Did you have a period of disorientation or confusion immediately following the incident?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbSevenSection" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth tbiDiagnosis"
                                TabIndex="49"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                <asp:ListItem Text = "6. Uncertain" Value = "6"></asp:ListItem>
                            </asp:RadioButtonList> 
                            <asp:RequiredFieldValidator ID="DisorientationPeriodRequiredFieldValidator"
                                ControlToValidate="rbSevenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Period of disorientation or confusion episodes number is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="50">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr id="TrQ7A" class = "injuriesnone disorientnone">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="LongestDisorientationPanel" AssociatedControlID="rbSevenASection" runat="server" CssClass="firstLevelQuestion">
                                        7-A. If yes, estimate the duration of longest period of disorientation or confusion.
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSevenASection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="51"
                                        >                 
                                            <asp:ListItem Text = "1. Brief, probably less than 30 minutes" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Up to a full day(24 hours)" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Up to a full week(7 days)" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Up to 1 month" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Up to 3 months" Value = "5"></asp:ListItem>
                                            <asp:ListItem Text = "6. More than 3 months" Value = "6"></asp:ListItem>                    
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="LongestDisorientRequiredFieldValidator"
                                            ControlToValidate="rbSevenASection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Duration of longest period of disorientation or confusion is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone disorientnone"
                                            TabIndex="52">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>       
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr id="TrQ8" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="MemoryLossPanel" AssociatedControlID="rbEightSection" runat="server" CssClass="firstLevelQuestion">
                            8. Did you experience a period of memory loss immediately before or after the incident?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbEightSection" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth tbiDiagnosis"
                                TabIndex="53" 
                               >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes, one episode" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Yes, two episodes" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. Yes, three episodes" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "4. Yes, four episodes" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "5. Yes, five or more episodes" Value = "5"></asp:ListItem>
                                <asp:ListItem Text = "6. Uncertain" Value = "6"></asp:ListItem>
                            </asp:RadioButtonList> 
                            <asp:RequiredFieldValidator ID="MemoryLossRequiredFieldValidator"
                                ControlToValidate="rbEightSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Memory loss episodes number is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="54">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr id="TrQ8A" class = "injuriesnone memoryloss">
                        <td >
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="MemoryLossDurationPanel" AssociatedControlID="rbEightASection" runat="server" CssClass="firstLevelQuestion">
                                        8-A. If yes, estimate the duration of longest period of memory loss (Post Traumatic Amnesia (PTA)).
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbEightASection" runat = "server" 
                                            RepeatDirection="Horizontal" RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="55"
                                            >                 
                                            <asp:ListItem Text = "1. Brief, probably less than 30 minutes" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Up to a full day(24 hours)" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Up to a full week(7 days)" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Up to 1 month" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Up to 3 months" Value = "5"></asp:ListItem>
                                            <asp:ListItem Text = "6. More than 3 months" Value = "6"></asp:ListItem>                    
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="MemoryLossDurationRequiredFieldValidator"
                                            ControlToValidate="rbEightASection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Longest period of memory loss is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone memoryloss"
                                            TabIndex="56">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>       
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        <tr id="TrQ9" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="SkullPenetrationPanel" AssociatedControlID="rbNineSection" runat="server" CssClass="firstLevelQuestion">
                            9. During this/these experience(s), did an object penetrate your skull/cranium:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbNineSection" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
                                TabIndex="57"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                 
                            </asp:RadioButtonList> 
                            <asp:RequiredFieldValidator ID="ObjectPenetrationRequiredFieldValidator"
                                ControlToValidate="rbNineSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Did an object penetrate your skull/cranium is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="58">
                            </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr id="TrQ10" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="HelmetInjuryPanel" AssociatedControlID="rbTenSection" runat="server" CssClass="firstLevelQuestion">
                            10. Were you wearing a helmet at the time of most serious injury?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbTenSection" runat = "server" 
                                RepeatDirection="Horizontal" RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
                                TabIndex="59"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                 
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="HelmetRequiredFieldValidator"
                                ControlToValidate="rbTenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Were you wearing a helmet is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="60">
                            </asp:RequiredFieldValidator>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr id="TrQ11" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="EvacuationPanel" AssociatedControlID="rbElevenSection" runat="server" CssClass="firstLevelQuestion">
                            11. Were you evacuated from theatre?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbElevenSection" runat = "server" 
                                RepeatDirection="Vertical"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
                                TabIndex="61"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes, for traumatic brain injury" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Yes, for other medical reasons" Value = "2"></asp:ListItem>                                 
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="TheatreRequiredFieldValidator"
                                ControlToValidate="rbElevenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Were you evacuated from theatre is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="62">
                            </asp:RequiredFieldValidator> 
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr id="TrQ12" class = "injuriesnone">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="TBITreatmentPanel" AssociatedControlID="rbTwelveSection" runat="server" CssClass="firstLevelQuestion">
                            12. Prior to this evaluation, had you received any professional treatment (including medications) for your deployment-related TBI symptoms?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbTwelveSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="63">
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes, in the past" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Yes, currently" Value = "2"></asp:ListItem>                                 
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="TreatmentRequiredFieldValidator"
                                ControlToValidate="rbTwelveSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Had you received any professional treatment (including medications) for your deployment-related TBI symptoms is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass injuriesnone"
                                TabIndex="64">
                            </asp:RequiredFieldValidator>     
                        </td>
                    </tr>
                    
                </table>
                </fieldset>
            </td>        
        </tr>

        <tr id="TrQ14">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="PriorBrainInjuryPanel" AssociatedControlID="rbFourteenSection" runat="server" CssClass="firstLevelQuestion">
                            13. Prior to your OEF/OIF/OND deployment, did you experience a brain injury or concussion?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbFourteenSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="65">
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Uncertain" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. Not Assessed" Value = "3"></asp:ListItem>                                 
                            </asp:RadioButtonList>  
                            <asp:RequiredFieldValidator ID="PriorBrainInjuryRequiredFieldValidator"
                                ControlToValidate="rbFourteenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Brain injury or concussion prior to OEF/OIF/OND deployment is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="6">
                            </asp:RequiredFieldValidator>  
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr  id="TrQ15">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="SinceBrainInjuryPanel" AssociatedControlID="rbFifteenSection" runat="server" CssClass="firstLevelQuestion">
                            14. Since your OEF/OIF/OND deployment, have you experienced a brain injury or concussion?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbFifteenSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="67">
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "2. Uncertain" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. Not Assessed" Value = "3"></asp:ListItem>                                 
                            </asp:RadioButtonList> 
                            <asp:RequiredFieldValidator ID="SinceBrainInjuryRequiredFieldValidator"
                                ControlToValidate="rbFifteenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Brain injury or concussion since OEF/OIF/OND deployment is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="68">
                            </asp:RequiredFieldValidator>     
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>     
        </tr>
        <tr id="TrChII">
            <td>
                <br />
                <asp:Label ID = "ChapterTwoLabel" runat = "server" Text = "II. Symptoms" Font-Bold = "true"/> 
            </td>
        </tr>
        <tr id="TrQ16">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="SymptomsLabel" AssociatedControlID="" runat="server" CssClass="firstLevelQuestion">
                            <b>15. Please rate the following symptoms with regard to how they have affected you over the last 30 days. Use the following scale (Neurobehavioral Symptom Inventory):</b><br/> 
                            <b>&nbsp;&nbsp;None</b> 0 - Rarely if ever present not a problem at all.<br/>
                            <b>&nbsp;&nbsp;Mild</b> 1 - Occasionally present but it does not disrupt activities, I can usually continue what I am doing; does not really concern me.<br/>
                            <b>&nbsp;&nbsp;Moderate</b> 2 - Often present, occasionally disrupts my activities; I can usually continue what I am doing with some effort; I am somewhat concerned.<br/>
                            <b>&nbsp;&nbsp;Severe</b> 3 - Frequently present and disrupts activities; I can only do things that are fairly simple or take little effort; I feel like I need help.<br/>
                            <b>&nbsp;&nbsp;Very Severe</b> 4 - Almost always present and I have been unable to perform at work, school, or home due to this problem; I probably cannot function without help.
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr id="TrQ16A">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="FeelingDizzyPanel" AssociatedControlID="rbSixteenASection" runat="server" CssClass="firstLevelQuestion">
                                        15-A. Feeling dizzy:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenASection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="69">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="DizzyRequiredFieldValidator"
                                            ControlToValidate="rbSixteenASection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Feeling dizzy is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="70">
                                        </asp:RequiredFieldValidator>   
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ16B">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="BalanceLossPanel" AssociatedControlID="rbSixteenBSection" runat="server" CssClass="firstLevelQuestion">
                                        15-B. Loss of balance:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenBSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="71">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="BalanceLossRequiredFieldValidator"
                                            ControlToValidate="rbSixteenBSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Loss of balance is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="72">
                                        </asp:RequiredFieldValidator>     
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16C">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="CoordinationPanel" AssociatedControlID="rbSixteenCSection" runat="server" CssClass="firstLevelQuestion">
                                        15-C. Poor coordination, clumsy:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenCSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="73">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="CoordinationRequiredFieldValidator"
                                            ControlToValidate="rbSixteenCSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Poor coordination, clumsy is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="74">
                                        </asp:RequiredFieldValidator>    
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16D">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="HeadachesPanel" AssociatedControlID="rbSixteenDSection" runat="server" CssClass="firstLevelQuestion">
                                        15-D. Headaches:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenDSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="75">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList> 
                                        <asp:RequiredFieldValidator ID="HeadachesRequiredFieldValidator"
                                            ControlToValidate="rbSixteenDSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Headaches is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="76">
                                        </asp:RequiredFieldValidator>     
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16E">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="NauseaPanel" AssociatedControlID="rbSixteenESection" runat="server" CssClass="firstLevelQuestion">
                                        15-E. Nausea:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenESection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="77">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                         <asp:RequiredFieldValidator ID="NauseaRequiredFieldValidator"
                                            ControlToValidate="rbSixteenESection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Nausea is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="78">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16F">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="BlurringPanel" AssociatedControlID="rbSixteenFSection" runat="server" CssClass="firstLevelQuestion">
                                        15-F. Vision problems, blurring, trouble seeing:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenFSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="78">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="VisionRequiredFieldValidator"
                                            ControlToValidate="rbSixteenFSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Vision problems, blurring, trouble seeing is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="80">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16G">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="LightSensitivityPanel" AssociatedControlID="rbSixteenGSection" runat="server" CssClass="firstLevelQuestion">
                                        15-G. Sensitivity to light:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenGSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="81">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>  
                                        <asp:RequiredFieldValidator ID="LightSensitivityRequiredFieldValidator"
                                            ControlToValidate="rbSixteenGSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Sensitivity to light is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="82">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16H">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="HearingDifficultyPanel" AssociatedControlID="rbSixteenHSection" runat="server" CssClass="firstLevelQuestion">
                                        15-H. Hearing difficulty:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenHSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="83">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList> 
                                        <asp:RequiredFieldValidator ID="HearingRequiredFieldValidator"
                                            ControlToValidate="rbSixteenHSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Hearing difficulty is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="84">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16I">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="NoiseSensitivityPanel" AssociatedControlID="rbSixteenISection" runat="server" CssClass="firstLevelQuestion">
                                        15-I. Sensitivity to noise:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenISection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="85">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="NoiseRequiredFieldValidator"
                                            ControlToValidate="rbSixteenISection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Sensitivity to noise is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="86">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16J">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="NumbnessPanel" AssociatedControlID="rbSixteenJSection" runat="server" CssClass="firstLevelQuestion">
                                        15-J. Numbness or tingling in parts of my body:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenJSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="87">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList> 
                                        <asp:RequiredFieldValidator ID="NumbnessRequiredFieldValidator"
                                            ControlToValidate="rbSixteenJSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Numbness or tingling in parts of body is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="88">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16K">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="TastePanel" AssociatedControlID="rbSixteenKSection" runat="server" CssClass="firstLevelQuestion">
                                        15-K. Change in ability to taste and/or smell:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenKSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="89">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="TasteSmellRequiredFieldValidator"
                                            ControlToValidate="rbSixteenKSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Change in ability to taste and/or smell is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass"  TabIndex="90">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16L">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="AppetitePanel" AssociatedControlID="rbSixteenLSection" runat="server" CssClass="firstLevelQuestion">
                                        15-L. Loss of appetite or increase appetite:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenLSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="91">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>  
                                        <asp:RequiredFieldValidator ID="AppetiteRequiredFieldValidator"
                                            ControlToValidate="rbSixteenLSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Loss of appetite or increase appetite is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="92">
                                        </asp:RequiredFieldValidator>  
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16M">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="ConcentrationPanel" AssociatedControlID="rbSixteenMSection" runat="server" CssClass="firstLevelQuestion">
                                        15-M. Poor concentration, can't pay attention:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenMSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="93">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="ConcentrationRequiredFieldValidator"
                                            ControlToValidate="rbSixteenMSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Poor concentration, can't pay attention is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="94">
                                        </asp:RequiredFieldValidator>    
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16N">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="ForgetfulnessPanel" AssociatedControlID="rbSixteenNSection" runat="server" CssClass="firstLevelQuestion">
                                        15-N. Forgetfulness, can't remember things:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenNSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="95">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="ForgetfullnessRequiredFieldValidator"
                                            ControlToValidate="rbSixteenNSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Forgetfulness, can't remember things is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="96">
                                        </asp:RequiredFieldValidator> 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16O">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="DecisionsPanel" AssociatedControlID="rbSixteenOSection" runat="server" CssClass="firstLevelQuestion">
                                        15-O. Difficulty making decisions:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenOSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="97">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>  
                                        <asp:RequiredFieldValidator ID="DecisionsRequiredFieldValidator"
                                            ControlToValidate="rbSixteenOSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Difficulty making decisions is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="98">
                                        </asp:RequiredFieldValidator> 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16P">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="ThinkingPanel" AssociatedControlID="rbSixteenPSection" runat="server" CssClass="firstLevelQuestion">
                                        15-P. Slowed thinking, difficulty getting organized, can't finish things:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenPSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="99">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="ThinkingRequiredFieldValidator"
                                            ControlToValidate="rbSixteenPSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Slowed thinking, difficulty getting organized, can't finish things is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="100">
                                        </asp:RequiredFieldValidator>   
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16Q">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="FatiguePanel" AssociatedControlID="rbSixteenQSection" runat="server" CssClass="firstLevelQuestion">
                                        15-Q. Fatigue, loss of energy, getting tired easily
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenQSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="101">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>  
                                        <asp:RequiredFieldValidator ID="FatigueRequiredFieldValidator"
                                            ControlToValidate="rbSixteenQSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Fatigue, loss of energy, getting tired easily is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="102">
                                        </asp:RequiredFieldValidator>   
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16R">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="SleepPanel" AssociatedControlID="rbSixteenRSection" runat="server" CssClass="firstLevelQuestion">
                                        15-R. Difficulty falling or staying asleep
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenRSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="103">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="SleepingRequiredFieldValidator"
                                            ControlToValidate="rbSixteenRSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Difficulty falling or staying asleep is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="104">
                                        </asp:RequiredFieldValidator>    
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>            
                    </tr>
                    <tr id="TrQ16S">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="AnxietyPanel" AssociatedControlID="rbSixteenSSection" runat="server" CssClass="firstLevelQuestion">
                                        15-S. Feeling anxious or tense
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenSSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="105">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="AnxiousnessRequiredFieldValidator"
                                            ControlToValidate="rbSixteenSSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Feeling anxious or tense is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="106">
                                        </asp:RequiredFieldValidator>     
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>         
                    </tr>
                    <tr id="TrQ16T">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="DepressionPanel" AssociatedControlID="rbSixteenTSection" runat="server" CssClass="firstLevelQuestion">
                                        15-T. Feeling depressed or sad:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenTSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="107">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList> 
                                        <asp:RequiredFieldValidator ID="DepressedRequiredFieldValidator"
                                            ControlToValidate="rbSixteenTSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Feeling depressed or sad is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="108">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>         
                    </tr>
                    <tr id="TrQ16U">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="IrritabilityPanel" AssociatedControlID="rbSixteenUSection" runat="server" CssClass="firstLevelQuestion">
                                        15-U. Irritability, easily annoyed:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenUSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="109">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="IrritabilityRequiredFieldValidator"
                                            ControlToValidate="rbSixteenUSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Irritability, easily annoyed is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="110">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>         
                    </tr>
                    <tr id="TrQ16V">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="FrustrationPanel" AssociatedControlID="rbSixteenVSection" runat="server" CssClass="firstLevelQuestion">
                                        15-V. Poor frustration tolerance, feeling easily overwhelmed by things:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rbSixteenVSection" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="111">
                                            <asp:ListItem Text = "0. None" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Mild" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Moderate" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Severe" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Very Severe" Value = "4"></asp:ListItem>
                                        
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="FrustrationRequiredFieldValidator"
                                            ControlToValidate="rbSixteenVSection"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Poor frustration tolerance, feeling easily overwhelmed by things is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="112">
                                        </asp:RequiredFieldValidator>                 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>         
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        
        <tr id="TrChIII">
            <td>
                <br />
                <asp:Label ID = "ChapterThreeLabel" runat = "server" Font-Bold = "true" Text = "III. Pain"></asp:Label>
            </td>        
        </tr>
        <tr id="TrQ18">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="PainPanel" AssociatedControlID="rbEighteenSection" runat="server" CssClass="firstLevelQuestion">
                            16. In the last 30 days, have you had any problems with pain?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbEighteenSection" runat = "server" 
                                RepeatDirection="Horizontal"  RepeatColumns="2"
                                RepeatLayout="Table"
                                CssClass="fixWidth"
                                 TabIndex="113"
                            >                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>
                                                
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="PainProblemsRequiredFieldValidator"
                                ControlToValidate="rbEighteenSection"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Problems with pain is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="114">
                            </asp:RequiredFieldValidator> 
                        </td>
                    </tr>
                    <tr id="TrQ18A" class = "pain">
                        <td>       
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="SectionEighteenALabel" AssociatedControlID="BodyPartsList" runat="server" CssClass="firstLevelQuestion">
                                        16-A. Location of pain: (Check all that apply)
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:CheckBoxList id="BodyPartsList" runat="server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="115"
                                        >                 
                                            <asp:ListItem Text = "0. Head/headaches" Value = "0"></asp:ListItem>
                                            <asp:ListItem Text = "1. Leg(s)" Value = "1"></asp:ListItem>
                                            <asp:ListItem Text = "2. Arm(s)" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Neck" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Shoulder(s)" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Low Back" Value = "5"></asp:ListItem>
                                            <asp:ListItem Text = "6. Upper Back" Value = "6"></asp:ListItem>
                                            <asp:ListItem Text = "7. Feet" Value = "7"></asp:ListItem>
                                            <asp:ListItem Text = "8. Hand(s)" Value = "8"></asp:ListItem>
                                            <asp:ListItem Text = "9. Other(Describe in &quot;Details of Plan&quot;)" Value = "9"></asp:ListItem>
                                        </asp:CheckBoxList>
                                        <web:RequiredFieldValidatorForCheckBoxLists ID = "PainLocationValidator" 
                                            ControlToValidate="BodyPartsList"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Location of pain is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass pain" TabIndex="116">
                                        </web:RequiredFieldValidatorForCheckBoxLists> 
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    
                   
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr id="TrQ19">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="PainProgressPanel" AssociatedControlID="rbSectionNineteen" runat="server" CssClass="firstLevelQuestion">
                            17. Since the time of your deployment related injury/injuries, are your overall symptoms
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbSectionNineteen" runat = "server" RepeatDirection = "Horizontal" Width = "80%" TabIndex="117">
                                <asp:ListItem Text = "1. Better" Value = "1"></asp:ListItem>  
                                <asp:ListItem Text = "2. Worse" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "3. About the same" Value = "3"></asp:ListItem>
                                
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="PainProgressRequiredFieldValidator"
                                ControlToValidate="rbSectionNineteen"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Overall symptoms is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="118">
                            </asp:RequiredFieldValidator>  
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        
        <tr id="TrQ20">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="AdditionalHistoryLabel" AssociatedControlID="AdditionalHistoryTextBox" runat="server" CssClass="firstLevelQuestion">
                            18. Additional history of present illness, social history, functional history, patient goals, and other relevant information.
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID = "AdditionalHistoryTextBox" runat = "server" Width = "100%" TextMode = "MultiLine" Height = "250px" TabIndex="119"></asp:TextBox>          
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>                
        </tr>
        <tr id="TrQ21">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="CurrentMedicationLabel" Text="19. Current medications:" AssociatedControlID="CurrentMedicationTextBox" runat="server" CssClass="firstLevelQuestion" />
                            <br /><br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                           <asp:TextBox ID="CurrentMedicationTextBox" runat="server" TextMode="MultiLine" Height="67px" Width="100%" TabIndex="120"></asp:TextBox>
                        </td>
                    </tr>


                                        
                </table>
                </fieldset>
            </td>
        </tr>
        <tr id="TrQ22">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="PhysicalExaminationLabel" AssociatedControlID="PhysicalExaminationTextBox" runat="server" CssClass="firstLevelQuestion">
                            20. Physical Examination:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID = "PhysicalExaminationTextBox" runat = "server" Width = "100%" TextMode = "MultiLine" Height = "250px" TabIndex="121"></asp:TextBox>
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>       
        </tr>
       
        <tr  id="TrQ27" class = "feebasis">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor" >
                        <td>
                            <asp:Label ID="InjuryHistoryConsistencyPanel" AssociatedControlID="rbEducationalLevel" runat="server" CssClass="firstLevelQuestion">
                            21. Based on the history of the injury and the course of clinical symptoms, did the Veteran sustain a TBI during OEF/OIF/OND deployment?
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr class = "feebasis">
                        <td>
                            <asp:RadioButtonList ID = "rbSectionTwentySeven" runat = "server" 
                                RepeatDirection="Horizontal"  RepeatColumns="2" 
                                RepeatLayout="Table"
                                CssClass="fixWidth" TabIndex="122">                 
                                <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="InjuryHistoryRequiredFieldValidator"
                                ControlToValidate="rbSectionTwentySeven"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Are the history of the injury and the course of clinical symptoms consistent with a diagnosis of TBI sustained during OEF/OIF/OND deployment is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass feebasis" TabIndex="123">
                            </asp:RequiredFieldValidator>  
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr  id="TrQ28">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="SymptomsConsistencyPanel" AssociatedControlID="rbSectionTwentyEight" runat="server" CssClass="firstLevelQuestion">
                            22. In your clinical judgment the current clinical symptom presentation is most consistent with:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbSectionTwentyEight" runat = "server" 
                                RepeatDirection="Vertical"  
                                RepeatLayout="Table" TabIndex="124"
                                >                 
                                <asp:ListItem Text = "1. Symptom resolution (patient is currently not reporting symptoms)" Value = "1"></asp:ListItem>  
                                <asp:ListItem Text = "2. An OEF/OIF/OND deployment-related Traumatic Brain Injury (TBI) residual problems" Value = "2"></asp:ListItem>                                       
                                <asp:ListItem Text = "3. Behavioral Health conditions (e.g. PTSD, depression, etc.)" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "4. A combination of OEF/OIF/OND deployment-related TBI and Behavioral Health condition(s)" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "5. Other condition not related to OEF/OIF/OND deployment related TBI or Behavioral Health condition(s)" Value = "5"></asp:ListItem>
                            
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="ClinicalSymptomsRequiredFieldValidator"
                                ControlToValidate="rbSectionTwentyEight"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "In your clinical judgment the current clinical symptom presentation is most consistent with is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="125">
                            </asp:RequiredFieldValidator>  
                        </td>
                    </tr>
                    <tr id="TrQ28A" class = "symptoms">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td>
                                        <asp:Label ID="OtherConditionsLabel" AssociatedControlID="OtherConditionsTextBox" runat="server" CssClass="firstLevelQuestion">
                                        22-A. List additional Diagnosis:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:TextBox ID = "OtherConditionsTextBox" runat = "server" Width="80%" TextMode="MultiLine" Height="67px" TabIndex="126" ></asp:TextBox> 
                                        <asp:RequiredFieldValidator ID="OtherConditionsRequiredFieldValidator"
                                            ControlToValidate="OtherConditionsTextBox"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Other condition(s) is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass symptoms" TabIndex="127">
                                        </asp:RequiredFieldValidator>    
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td> 
                    </tr>
                </table>
                </fieldset>
            </td>        
        </tr>
        <tr  id="TrChVI" class = "feebasis">
            <td>
                <br />
                <asp:Label ID = "ChapterSixLabel" runat = "server" Font-Bold = "true" Text = "IV. Plan"></asp:Label>
            </td>        
        </tr>
        <tr id="TrQ29">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="FollowupPlanPanel" AssociatedControlID="rbSectionTwentyNine" runat="server" CssClass="firstLevelQuestion">
                            23. Follow up plan:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButtonList ID = "rbSectionTwentyNine" runat = "server" 
                                RepeatDirection="Vertical" 
                                RepeatLayout="Table" TabIndex="128"
                            >                 
                                <asp:ListItem Text = "1. Services will be provided within VA healthcare system" Value = "1"></asp:ListItem>  
                                <asp:ListItem Text = "2. Services will be provided outside VA" Value = "2"></asp:ListItem>                                       
                                <asp:ListItem Text = "3. Patient will receive both VA and non-VA services" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "4. No services needed" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "5. Patient refused or not interested in further services" Value = "5"></asp:ListItem>
                            
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="FollowupRequiredFieldValidator"
                                ControlToValidate="rbSectionTwentyNine"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Follow up plan is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave" CssClass = "ValidatorClass" TabIndex="129">
                            </asp:RequiredFieldValidator>  
                        </td>
                    </tr>
                    
                    <tr id="TrQ29A1" class = "followup">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="SectionTwentyNineA" AssociatedControlID="rbSectionTwentyNine" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1: Treatment: (Check all that apply)
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                                    
                                
                                
                                
                                                          
                      <tr id="TrQ29A1a" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1a" AssociatedControlID="rb29A1a" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-a Cognitive Issues
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1a" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="130"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1aRequiredFieldValidator"
                                            ControlToValidate="rb29A1a"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Cognitive Issue(s) required."
                                            SetFocusOnError="true"
                                            TabIndex="131"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                              
                                                                              
                      <tr id="TrQ29A1b" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1b" AssociatedControlID="rb29A1b" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-b Mood/PTSD Issues
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1b" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="132"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1bRequiredFieldValidator"
                                            ControlToValidate="rb29A1b"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Mood/PTSD Issue(s) required."
                                            SetFocusOnError="true"
                                            TabIndex="133"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                                                    
                                                                              
                      <tr id="TrQ29A1c" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1c" AssociatedControlID="rb29A1c" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-c Sleep Issues 
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1c" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="134"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1cRequiredFieldValidator"
                                            ControlToValidate="rb29A1c"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Sleep Issue(s) required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="135">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                              
                                                              
                      <tr id="TrQ29A1d" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1d" AssociatedControlID="rb29A1d" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-d Pain/Physical Issues 
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1d" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth"
                                            TabIndex="136"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1dRequiredFieldValidator"
                                            ControlToValidate="rb29A1d"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Pain/Physical Issue(s) required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="137">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                              
                                                              
                      <tr id="TrQ29A1e" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1e" AssociatedControlID="rb29A1e" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-e Other Symptoms 
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1e" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="138"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1eRequiredFieldValidator"
                                            ControlToValidate="rb29A1e"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Other Symptom(s) required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="139">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                              
                                <tr  id="TrQ29A1e1" class = "other1">
                                    <td>
                                        <fieldset class="secondLevelQuestion">
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="OtherSymptomLabel" AssociatedControlID="OtherSymptomTextBox" runat="server" CssClass="firstLevelQuestion">
                                                    23-A-1-e-1. Other Symptom:
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID = "OtherSymptomTextBox" runat = "server" Width = "80%" TabIndex="140"></asp:TextBox>
                                                    <asp:RequiredFieldValidator ID="tb29A1e1RequiredFieldValidator"
                                                        ControlToValidate="OtherSymptomTextBox"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage = "Other symptom(s) is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup = "OnSave" CssClass = "ValidatorClass symptoms" TabIndex="141">
                                                    </asp:RequiredFieldValidator> 
                                                
                                                
                                                </td>
                                            </tr>
                                        </table>
                                        </fieldset>
                                    </td> 
                                </tr>
                                

                                                                        
                      <tr id="TrQ29A1f" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1f" AssociatedControlID="rb29A1f" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-f Was a Medication Reconciliation Performed? 
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1f" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="142"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1fRequiredFieldValidator"
                                            ControlToValidate="rb29A1f"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Was a Medication Reconciliation Performed? required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="143">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                                                           
                              
                                <tr  id="TrQ29A1f2" class = "other2">
                                    <td>
                                        <fieldset class="secondLevelQuestion">
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="OtherMedicationsLabel" AssociatedControlID="OtherMedicationsTextBox" runat="server" CssClass="firstLevelQuestion">
                                                    23-A-1-f-2. Please explain in free text box below
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID = "OtherMedicationsTextBox" runat = "server" Width = "80%" TabIndex="144"></asp:TextBox>
                                                                                                    
                                                    <asp:RequiredFieldValidator ID="tb29A1f2RequiredFieldValidator"
                                                        ControlToValidate="OtherMedicationsTextBox"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage = "Other medication(s) is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup = "OnSave" CssClass = "ValidatorClass symptoms other2" TabIndex="145">
                                                    </asp:RequiredFieldValidator> 
                                                
                                                </td>
                                            </tr>
                                        </table>
                                        </fieldset>
                                    </td> 
                                </tr>         
                      <tr id="TrQ29A1f1" class = "other3">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29Af1" AssociatedControlID="rb29A1f1" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-f-1. Was a printed medication list given to the patient?
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1f1" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="146"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1f1RequiredFieldValidator"
                                            ControlToValidate="rb29A1f1"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Was a printed medication list given to the patient?"
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup other3" TabIndex="147">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>                                                 
                      <tr id="TrQ29A1g" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1g" AssociatedControlID="rb29A1g" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-g Does Veteran require Case Management?
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1g" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="148"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1gRequiredFieldValidator"
                                            ControlToValidate="rb29A1g"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Does Veteran require Case Management? required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="149">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>                                                     
                      <tr id="TrQ29A1h" class = "fall1">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="OtherTreatmentsLabel" AssociatedControlID="OtherTreatmentsTextBox" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-h Other Treatment
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                       <tr>
                                                <td>
                                                    <asp:TextBox ID = "OtherTreatmentsTextBox" runat = "server" Width = "80%" TabIndex="150"></asp:TextBox>
                                                    
                                                    <asp:RequiredFieldValidator ID="tb29A1hRequiredFieldValidator"
                                                        ControlToValidate="OtherTreatmentsTextBox"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage = "Other treatment(s) is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup = "OnSave" CssClass = "ValidatorClass symptoms" TabIndex="151">
                                                    </asp:RequiredFieldValidator> 
                                                
                                                

                                                </td>
                                         </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ29A1i" class = "other6">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1i" AssociatedControlID="rb29A1i" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-i Education:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1i" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="152"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                            
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1iRequiredFieldValidator"
                                            ControlToValidate="rb29A1i"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Education is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup other6" TabIndex="153">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>

                                
                                
                    <tr id="TrQ29A1j" class = "other7">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29A1j" AssociatedControlID="rb29A1j" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-j Consult:
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A1j" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="154"
                                        >                 
                                            <asp:ListItem Text = "0. No" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. Yes" Value = "1"></asp:ListItem>                                       
                                                           
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="rb29A1jRequiredFieldValidator"
                                            ControlToValidate="rb29A1j"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Consult is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup other7" TabIndex="155">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                            </fieldset>
                        </td>
                    </tr>

                                
                    <tr id="TrQ29A1j1" class = "other5">
                        <td>
                            <fieldset class="firstLevelAnswer">
                            <table width="100%">
                                <tr class="subquestionBackgroundColor">
                                    <td>
                                        <asp:Label ID="lbl29Aj1" AssociatedControlID="ConsultRequestListBox" runat="server" CssClass="firstLevelQuestion">
                                        23-A-1-j-1 Consult requested with: (Check all that apply)
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:CheckBoxList ID = "ConsultRequestListBox" runat = "server"
                                    RepeatDirection="Horizontal" RepeatColumns="2"
                                    RepeatLayout="Table"
                                    CssClass="fixWidth" TabIndex="156"
                                >                 
                                            <asp:ListItem Text = "0. Audiology" Value = "0"></asp:ListItem>  
                                            <asp:ListItem Text = "1. ENT" Value = "1"></asp:ListItem>                                       
                                            <asp:ListItem Text = "2. Neurology" Value = "2"></asp:ListItem>
                                            <asp:ListItem Text = "3. Neuropsychology/Neuropsychological assessment" Value = "3"></asp:ListItem>
                                            <asp:ListItem Text = "4. Occupational therapy" Value = "4"></asp:ListItem>
                                            <asp:ListItem Text = "5. Ophthalmology/Optometry" Value = "5"></asp:ListItem>
                                            <asp:ListItem Text = "6. Physical Therapy" Value = "7"></asp:ListItem>
                                            <asp:ListItem Text = "7. PM and R" Value = "8"></asp:ListItem>
                                            <asp:ListItem Text = "8. Prosthetics" Value = "9"></asp:ListItem>
                                            <asp:ListItem Text = "9. Psychiatry" Value = "10"></asp:ListItem>
                                            <asp:ListItem Text = "10. Speech-Language pathology" Value = "11"></asp:ListItem>
                                            <asp:ListItem Text = "11. Substance Use/Addictive Disorder Evaluation and/or Treatment" Value = "12"></asp:ListItem>                                                          
                                            <asp:ListItem Text = "12. Other" Value = "6"></asp:ListItem>                                                                              
                                       </asp:CheckBoxList>
                                       <web:RequiredFieldValidatorForCheckBoxLists ID = "cb29A1j1RequestValidator" runat = "server" 
                                            ControlToValidate = "ConsultRequestListBox" 
                                            Display = "Dynamic" 
                                            EnableClientScript = "true" 
                                            SetFocusOnError = "true" 
                                            ValidationGroup = "OnSave" 
                                            ErrorMessage = "Select Consult Request." 
                                            CssClass = "other5" Enabled="False" TabIndex="157">
                                        </web:RequiredFieldValidatorForCheckBoxLists> 


                                        <script type="text/javascript">

                                            function IsValidatorEnabled() {
                                                $.each(Page_Validators, function (index, validator) {
                                                    if ($(validator).hasClass("other5")) {

                                                        //ValidatorEnable(validator, false);
                                                        console.log(validator.enabled);
                                                    }
                                                });
                                            }
                                        </script>
                                    </td>
                                </tr>


                            </table>
                            </fieldset>
                        </td>
                    </tr>


        <tr id="TrQ29A2" class = "other8">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="Label2" AssociatedControlID="PlanDetailsTextBox" runat="server" CssClass="firstLevelQuestion">
                            23A2. Veteran diagnosed with TBI. An Individualized Rehabilitation and Community Reintegration Plan of Care is:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>

                                <tr>
                                    <td>
                                        <asp:RadioButtonList ID = "rb29A2" runat = "server" 
                                            RepeatDirection="Horizontal"  RepeatColumns="2"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="158"
                                        >                 
                                            <asp:ListItem Text = "NO, Not required. " Value = "0"></asp:ListItem> 
                                            <asp:ListItem Text = "YES, Required and the TBI/Polytrauma Case Manager has been notified." Value = "1"></asp:ListItem>                                       
                                                            
                                       </asp:RadioButtonList>

                                        <asp:CheckBoxList ID = "cb29A2no" runat = "server" visible="true" 
                                            RepeatDirection="Vertical"  RepeatColumns="1"
                                            RepeatLayout="Table"
                                            CssClass="fixWidth" TabIndex="159"
                                        
                                        >                 
                           
                                            <asp:ListItem Text =  "There are no skilled therapy needs related to TBI." Value = "0"></asp:ListItem> 
                                            <asp:ListItem Text =  "There is no need for case management." Value = "1"></asp:ListItem>  
                                                           
                                       </asp:CheckBoxList>

                                        <asp:RequiredFieldValidator ID="rb29A2RequiredFieldValidator"
                                            ControlToValidate="rb29A2"
                                            Display="Dynamic"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Answer is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" CssClass = "ValidatorClass followup" TabIndex="160">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                </table>
                </fieldset>
            </td> 
        
        </tr>

                               
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                   
                </table>
                </fieldset>
            </td>
        </tr>


        <tr id="TrQ31"  class = "followup_feebasis">
            <td>
                <fieldset>
                <table width="100%" cellpadding = "5" cellspacing = "5">
                    <tr class="questionBackgroundColor">
                        <td>
                            <asp:Label ID="Label1" AssociatedControlID="PlanDetailsTextBox" runat="server" CssClass="firstLevelQuestion">
                            24. Details of plan:
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID = "PlanDetailsTextBox" runat = "server" Width = "100%" TextMode = "MultiLine" Height = "250px" TabIndex="161"></asp:TextBox>   
                        </td>
                    </tr>
                </table>
                </fieldset>
            </td> 
        
        </tr>
        <tr id="TrSubmit">
            <td>
       
                 <asp:Button ID="SaveButton" 
                    runat="server"                    
                    UseSubmitBehavior = "false"  
                    Text = "Save Draft" 
                    Width = "130px" 
                    OnClick = "SaveSurvey_Click" 
                    ValidationGroup = "OnDraftSave" TabIndex="162" />
                    
                 <asp:Button ID = "SavePrepareNoteButton" 
                    runat="server" 
                    UseSubmitBehavior="false" 
                    Text="Save and Prepare Note" 
                    Width="180px" 
                    ValidationGroup = "OnSave"
                    OnClick = "SavePrepareNote_Click" TabIndex="163" />
                    
                <asp:Button ID = "CancelButton" runat = "server" 
                     TabIndex="164" 
                     UseSubmitBehavior = "false" 
                     Text = "Cancel" 
                     Width = "130px" 
                     CssClass = "cancel" 
                     OnClick = "CancelSurvey_Click" />
                     
                 <asp:Button ID = "SubmitNoteButton" runat = "server"                      
                     UseSubmitBehavior = "false" 
                     Text = "Cancel" 
                     Width = "130px" Visible = "false" TabIndex="165" />
                 <br />
                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                <br />
                 <asp:Label ID="Label8" runat="server" SkinID="DataLabel">
                    If you are unable to finish at this time, or if you just want to save while entering, click Save Draft.<br /><br />

                    If you are finished with entry, and ready to save and format the note (you will get another chance to review prior to submit),<br /> 
                    click Save and Prepare Note.<br /><br />
                    
                    If you want to return to CPRS press the Cancel Button. Do not use Internet browser back arrow.                                         
                 </asp:Label>
                 <br />
            </td>
        </tr>
        </table>
        
        </asp:Panel>   
        <br />
        <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
            <ProgressTemplate>
                <!-- Modal Popup for Loading -->
              <div style="padding-left: 3px;" >
                    <div style="background-color: #FF0000; width: 300px; color: #FFFFFF; padding: 5px;">
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                    </div>
                </div>
              
                <!-- End Modal Popup for Loading -->
            </ProgressTemplate>
        </asp:UpdateProgress>
        <br />
               
    
            
    </ContentTemplate>
</asp:UpdatePanel>
</telerik:RadCodeBlock>
</asp:Content>