﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using System.Xml.Linq;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instrument : BaseTBIInstrumentPage {

    #region Public Methods

    protected bool _isconsultnotetitle = false;

    SURVEY survey;

    public TBI_Instrument() {
    }

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e) {
        base.BaseTBIInstrumentPage_Load(sender, e);

        ErrorPanel.Visible = false;

        if (!IsPostBack) {
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                if (_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType == null)
                {
                    Logging.WriteLogToFile("Instrument.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType == null");
                    //if instrument type is not selected page was accessed incorrectly
                    //redirect to warning message
                    Response.Redirect("Warning.aspx?err=4", false);

                }

                if (!String.IsNullOrEmpty(_tbiInstrumentManager.TbiServiceTo.PatientLocationId)) {
                    LocationIdField.Value = _tbiInstrumentManager.TbiServiceTo.PatientLocationId;
                } else {
                    LocationIdField.Value = "0";
                }

                if (_tbiInstrumentManager.TbiServiceTo.CprsSentTBIEvaluationNoteId != 0
                    &&
                    _tbiInstrumentManager.TbiServiceTo.CprsSentTBIFollowUpNoteId != 0
                    ) {
                    tableRowInstrumentTypeLabel.Visible = false;
                    tableRowInstrumentTypeDropDown.Visible = false;

                    if (_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Id == 2) {
                        _tbiInstrumentManager.TbiServiceTo.SelectedNoteTitleId = _tbiInstrumentManager.TbiServiceTo.CprsSentTBIEvaluationNoteId.ToString();
                    } else {
                        _tbiInstrumentManager.TbiServiceTo.SelectedNoteTitleId = _tbiInstrumentManager.TbiServiceTo.CprsSentTBIFollowUpNoteId.ToString();
                    }

                }

                LabelInstrumentType.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Name);
            }

            RadioButtonListEncounterType.SelectedIndex = -1;
            TableRowClinicAppointment.Visible = false;
            TableRowHospitalAdmission.Visible = false;
            TableRowUnscheduledNewVisitLocation.Visible = false;
            TableRowCosigner.Visible = false;

            //populate consult drop down list 
            string errorMessage;

            try {

                //populate note title drop down list
                object titles;
                if (_tbiInstrumentManager != null) {
                    //titles = _tbiInstrumentManager.getNoteTitles("TBI", "", out errorMessage);
                    if (txtNoteSearchFilter.Text == "") {
                        if (getCurrentServiceToUse() == "VIA") {
                            titles = _tbiInstrumentManager.getNoteTitlesFromVIA("TBI", "", out errorMessage);
                        } else {
                            titles = _tbiInstrumentManager.getNoteTitles("TBI", "", out errorMessage);
                        }

                        txtNoteSearchFilter.Text = "TBI";
                    } else {
                        if (getCurrentServiceToUse() == "VIA") {
                            titles = _tbiInstrumentManager.getNoteTitlesFromVIA("" + txtNoteSearchFilter.Text + "", "", out errorMessage);
                        } else {
                            titles = _tbiInstrumentManager.getNoteTitles("" + txtNoteSearchFilter.Text + "", "", out errorMessage);
                        }
                        txtNoteSearchFilter.Text = txtNoteSearchFilter.Text;
                    }

                    if (errorMessage == "SUCCESS") {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage)) {
                        DropDownListNoteTitleId.DataSource = titles;
                        DropDownListNoteTitleId.DataBind();
                    } else {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = errorMessage;
                        return;
                    }
                } else {
                    titles = null;
                }

                int _consultCount = 0;
                List<KeyValuePair<string, string>> consults;
                if (_tbiInstrumentManager != null) {
                    if (getCurrentServiceToUse() == "VIA") {
                        consults = _tbiInstrumentManager.getConsultsFromVIA(out errorMessage);//try passing noteid as paramter
                        //_consultCount = _tbiInstrumentManager.getConsultsFromVIA(out errorMessage).Count;
                    } else {
                        consults = _tbiInstrumentManager.getConsults(out errorMessage);//try passing noteid as paramter
                        //_consultCount = _tbiInstrumentManager.getConsults(out errorMessage).Count;
                    }

                    if (consults != null) { _consultCount = consults.Count; }

                    if (errorMessage == "SUCCESS") {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage)) {
                        DropDownListConsult.DataSource = consults;
                        DropDownListConsult.DataBind();
                    } else {
                        //display error message and stop porcessing
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = errorMessage;
                        return;
                    }

                    if (_consultCount == 0) {
                        LabelforDropDownListConsult.Visible = false;
                        DropDownListConsult.Visible = false;
                        RequiredFieldValidatorDropDownListConsult.Enabled = false;
                    } else {
                        LabelforDropDownListConsult.Visible = true;
                        DropDownListConsult.Visible = true;
                        RequiredFieldValidatorDropDownListConsult.Enabled = true;
                        LabelforDropDownListConsult.Text = "Link to Consult:";
                        LabelforDropDownListConsult.Font.Bold = true;
                    }
                } else {
                    consults = null;
                }

            } catch (Exception ex) {
                if (ex.Message == "Index was outside the bounds of the array.")
                {
                    LabelforDropDownListConsult.Visible = false;
                    DropDownListConsult.Visible = false;
                    RequiredFieldValidatorDropDownListConsult.Enabled = false;
                }
                else
                {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;
                    Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "Page_load()");
                    MDWSCallError.Text = ex.Message;
                }
            }
        }

        if (_tbiInstrumentManager.TbiServiceTo != null) {
            LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);

            LabelInstrumentType.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Name);
        }

    }

    protected void ButtonContinue_Click(object sender, EventArgs e) {
        try {
            if (DropDownListCosigner.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedCosignerID = DropDownListCosigner.SelectedValue;
            }

            if (DropDownListNoteTitleId.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;
            }

            if (DropDownListConsult.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedConsultId = DropDownListConsult.SelectedValue;
            }

            if (DropDownListScheduledClinicAppointment.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedVisitId = DropDownListScheduledClinicAppointment.SelectedValue;
            }

            if (DropDownListHospitalAdmission.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedHospitalAdmissionId = DropDownListHospitalAdmission.SelectedValue;
            }

            if (DropDownListUnscheduleNewVisitLocation.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedLocationID = DropDownListUnscheduleNewVisitLocation.SelectedValue;
            }

            _tbiInstrumentManager.TbiServiceTo.isHistorical = CheckBoxUnscheduledNewVisitHistorical.Checked;

            if (RadioButtonListEncounterType.SelectedIndex != -1) {
                NoteType _SelectedNoteType = new NoteType();
                _SelectedNoteType.Id = RadioButtonListEncounterType.SelectedIndex;

                _tbiInstrumentManager.TbiServiceTo.SelectedNoteType = _SelectedNoteType;
            }

            AddtoSessionTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);
            LogInput();

            switch (_tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Id) {
                case 2:
                    Response.Redirect("InstrumentEvaluationEntry.aspx", false);
                    break;
                case 3:
                    Response.Redirect("InstrumentFollowUpEntry.aspx", false);
                    break;
                case 4:
                    Response.Redirect("InstrumentMpaiEntry.aspx", false);
                    break;
                case 5:
                    Response.Redirect("InstrumentCarePlanEntry.aspx", false);
                    break;
                case 6:
                    Response.Redirect("SRS.aspx", false);
                    break;
                case 7:
                    // MedRed L-Test
                    Response.Redirect("MedRed_L-Test.aspx", false);
                    break;
                case 8:
                    // MedRed LCI v2
                    Response.Redirect("MedRed_LCI-v2.aspx", false);
                    break;
                case 9:
                    // MedRed - Two Minute Walk
                    Response.Redirect("MedRedTwoMinuteWalk.aspx", false);
                    break;
                case 10:
                    // Patients Global Impression of Change (PGIC) scale
                    Response.Redirect("PatientGlobalImpOfChange.aspx", false);
                    break;
                case 11:
                    // Neurobehavioral Symptom Inventory form
                    Response.Redirect("NeurobehavioralSymptomInventory.aspx", false);
                    break;
                case 12:
                    // Disabilty Rating Scale
                    Response.Redirect("DisabiltyRatingScale.aspx", false);
                    break;
                case 13:
                    // QUEST
                    Response.Redirect("QUESTInstrument.aspx", false);
                    break;
                case 14:
                    // Satisfaction With Life Scale
                    Response.Redirect("SatisfactionWithLifeScale.aspx", false);
                    break;
                case 15:
                    // Functional Mobility Assessment
                    Response.Redirect("FunctionalMobilityAssessment.aspx", false);
                    break;
                case 16:
                    // Berg Balance Scale
                    Response.Redirect("BergBalanceScale.aspx", false);
                    break;
                case 17:
                    // VA Low Vision Visual Functioning (VA LV VFQ 20) Survey
                    Response.Redirect("VALowVisionSurvey.aspx", false);
                    break;
                case 18:
                    // PART-O Survey
                    Response.Redirect("PART-O.aspx", false);
                    break;
                case 19:
                    // Mayo-Portland Survey
                    Response.Redirect("MayoPortlandAdaptabilityInventory4.aspx", false);
                    break;
                case 20:
                    // JFK Coma Recovery Scale Survey
                    Response.Redirect("JFKComaRecoveryScale.aspx", false);
                    break;
                case 21:
                    // VA Oswestry Low Back Pain Disability Questionnaire (OLBPDQ) Survey
                    Response.Redirect("OswestryLBDQ.aspx", false);
                    break;
                case 22:
                    // VA Timed Up and Go (TUG) Survey
                    Response.Redirect("TimedUpAndGo.aspx", false);
                    break;
                case 23:
                    // VA Generalized Anxiety Disorder Scale (GAD-7) Survey
                    Response.Redirect("GAD-7.aspx", false);
                    break;
                case 24:
                    // VA Post Traumatic Stress Disorder (PTSD) CheckList - Civilian Version (PCL-C) Survey
                    Response.Redirect("PCL-C.aspx", false);
                    break;
                case 25:
                    // VA Patient Health Questionnaire - 9 Survey
                    Response.Redirect("PHQ-9.aspx", false);
                    break;
                case 26:
                    // VA Insomnia Severity Index Survey
                    Response.Redirect("InsomniaSeverityIndex.aspx", false);
                    break;
                case 27:
                    // VA Pain Outcomes Questionnaire VA Long Form - Intake Survey
                    Response.Redirect("PainOutcomes_Intake.aspx", false);
                    break;
                case 28:
                    // VA Pain Outcomes Questionnaire VA Long Form - Discharge Survey
                    Response.Redirect("PainOutcomes_Discharge.aspx", false);
                    break;
                case 29:
                    // VA Pain Outcomes Questionnaire VA Long Form - Follow Up Survey
                    Response.Redirect("PainOutcomes_Followup.aspx", false);
                    break;
                case 31:
                    // VA World Health Organization Disability Assessment Schedule 2.0 - Interview 
                    Response.Redirect("Whodas-i.aspx", false);
                    break;
                case 32:
                    // VA World Health Organization Disability Assessment Schedule 2.0 - Proxy 
                    Response.Redirect("Whodas-p.aspx", false);
                    break;
                case 33:
                    // VA World Health Organization Disability Assessment Schedule 2.0 - Self 
                    Response.Redirect("Whodas-s.aspx", false);
                    break;
                case 34:
                    //Optimal 1.1
                    Response.Redirect("Optimal.aspx", false);
                    break;
                case 35:
                    //Optimal 1.1
                    Response.Redirect("OptimalFollowUp.aspx", false);
                    break;
                case 36:
                    //Rehabilitation Followup
                    Response.Redirect("RehabFollowUp.aspx", false);
                    break;
                case 37:
                    //PainInterferenceShortForm6a Followup
                    Response.Redirect("PainInterferenceShortForm6a.aspx", false);
                    break;
                case 38:
                    //PhysicalFunctionwMobilityAid Followup
                    Response.Redirect("PhysicalFunctionwMobilityAid.aspx", false);
                    break;
                case 39:
                    //UpperExtremityShortForm7A Followup
                    Response.Redirect("UpperExtremityShortForm7A.aspx", false);
                    break;
                default:
                    //incorrectly accessed if value is not in the above
                    //redirect to warning page
                    Logging.WriteLogToFile("Instrument.ButtonContinue_Click(): WarningRedirect: Unknown Instrument Selected: " + _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType.Id.ToString());
                    Response.Redirect("Warning.aspx?err=5", false);
                    break;
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "ButtonContinue_Click()");
        }
    }

    private void LogInput()
    {
        string cacheName = "InstrumentSelectionCache";
        Helpers.SavePageToCache(this, cacheName);
        try
        {
            XElement root = new XElement(cacheName);
            Dictionary<string, string> cache = Session[cacheName] as Dictionary<string, string>;
            if (cache != null)
            {
                foreach (var pair in cache)
                {
                    var child = new XElement("item");
                    child.SetAttributeValue("id", pair.Key);
                    child.SetValue(pair.Value);
                    root.Add(child);
                }
            }
            System.Diagnostics.Debug.WriteLine(root.ToString());
            Logging.WriteLogToFile(root.ToString());
        }
        catch (Exception x)
        {
            Logging.WriteLogToFile(x);
        }
        finally
        {
            Session[cacheName] = null;
        }
    }

    protected void RadioButtonListEncounterType_SelectedIndexChanged(object sender, EventArgs e) {
        ButtonContinue.Visible = false;

        TableRowClinicAppointment.Visible = false;
        TableRowHospitalAdmission.Visible = false;
        TableRowUnscheduledNewVisitLocation.Visible = false;

        int encounterTypeSelected =
        Helpers.getIntFromString(RadioButtonListEncounterType.SelectedValue);

        string errorMessage;

        if (encounterTypeSelected != (int)NoteTypeEnum.ScheduledClinicAppointment) {
            TextBoxAppointmentSearchDateStart.Text = "";
            TextBoxAppointmentSearchDateEnd.Text = "";
        }

        switch (encounterTypeSelected) {
            case (int)NoteTypeEnum.ScheduledClinicAppointment:  //Scheduled Clinic Appointment
                TableRowClinicAppointment.Visible = true;

                FilterAndBindVisits();


                break;

            case (int)NoteTypeEnum.HospitalAdmission:  //Hospital Admission
                TableRowHospitalAdmission.Visible = true;

                //populate hospital admission drop down list
                //DropDownListHospitalAdmission.DataSource = _tbiInstrumentManager.getHospitalAdmissions(out errorMassage);
                try {
                    List<KeyValuePair<string, string>> admissions = new List<KeyValuePair<string, string>>();

                    if (getCurrentServiceToUse() == "VIA") {
                        admissions = _tbiInstrumentManager.getHospitalAdmissionsFromVIA(out errorMessage);
                    } else {
                        admissions = _tbiInstrumentManager.getHospitalAdmissions(out errorMessage);
                    }

                    if (errorMessage == "SUCCESS")
                    {
                        errorMessage = null;
                    }

                    //DropDownListConsult.DataSource = _tbiInstrumentManager.getConsults(out errorMessage);
                    if (String.IsNullOrEmpty(errorMessage)) {
                        DropDownListHospitalAdmission.DataSource = admissions;
                        DropDownListHospitalAdmission.DataBind();

                    } else {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = errorMessage;
                        return;

                    }
                } catch (Exception ex) {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;
                    Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "RadioButtonListEncounterType_SelectedIndexChanged() - HospitalAdmission");

                    MDWSCallError.Text = ex.Message;
                }
                break;

            case (int)NoteTypeEnum.CurrentStay:  //Current Stay

                if (string.IsNullOrEmpty(_tbiInstrumentManager.TbiServiceTo.PatientLocationId) || string.IsNullOrEmpty(_tbiInstrumentManager.TbiServiceTo.PatientAdmitTimeStamp))
                {
                    ErrorPanel.Visible = true;
                    MDWSCallError.Text = "This patient does not have a current stay available, please select a different Encounter Type";
                    RadioButtonListEncounterType.ClearSelection();
                }

                break;

            case (int)NoteTypeEnum.UnscheduledOrNewVisit: //Unscheduled or New Visit
                TableRowUnscheduledNewVisitLocation.Visible = true;

                FilterAndBindLocations();

                break;

        }

        ButtonContinue.Visible = true;
    }

    protected void Filter_NoteSearch(object sender, EventArgs e) {
        //Get the text from text box

        //Preview the text and show it in Div
        string errorMessage;
        try {
            if (IsPostBack) {
                object titles;

                string filter_text = null;
                if (_tbiInstrumentManager != null) {
                    //filter_text = ((TextBox)sender).Text;
                    filter_text = txtNoteSearchFilter.Text;
                    if (filter_text != null) {
                        if (DropDownListNoteTitleId.Items.Count > 0) {
                            DropDownListNoteTitleId.Items.Clear();
                            DropDownListNoteTitleId.Items.Add(new ListItem("-- Select a Value --", "0"));
                        }

                        if (getCurrentServiceToUse() == "VIA") {
                            titles = _tbiInstrumentManager.getNoteTitlesFromVIA("" + filter_text + "", "", out errorMessage);
                        } else {
                            titles = _tbiInstrumentManager.getNoteTitles("" + filter_text + "", "", out errorMessage);
                        }

                        if (errorMessage == "SUCCESS")
                        {
                            errorMessage = null;
                        }

                        if (String.IsNullOrEmpty(errorMessage)) {
                            DropDownListNoteTitleId.DataSource = titles;
                            DropDownListNoteTitleId.DataBind();
                        } else {
                            PanelObjectContent.Visible = false;
                            ErrorPanel.Visible = true;

                            MDWSCallError.Text = errorMessage;
                            return;
                        }
                    }
                } else {
                    titles = null;
                }
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "Filter_NoteSearch()");
        }
    }

    protected void DropDownListNoteTitleId_SelectedIndexChanged(object sender, EventArgs e) {
        string errorMessage;
        string _notetitle = "";

        try {

            if (DropDownListNoteTitleId.SelectedValue != "0") {
                _tbiInstrumentManager.TbiServiceTo.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;

                bool needCosigner;

                if (getCurrentServiceToUse() == "VIA") {
                    needCosigner = _tbiInstrumentManager.isCosignerRequiredVIA(_tbiInstrumentManager.TbiServiceTo, out errorMessage);
                } else {
                    needCosigner = _tbiInstrumentManager.isCosignerRequired(_tbiInstrumentManager.TbiServiceTo, out errorMessage);
                }

                if (errorMessage == "SUCCESS")
                {
                    errorMessage = null;
                }

                if (String.IsNullOrEmpty(errorMessage)) {
                    if (DropDownListNoteTitleId.SelectedItem != null) {
                        _notetitle = DropDownListNoteTitleId.SelectedItem.Text.ToString().ToUpper();

                        _isconsultnotetitle = _notetitle.Contains("CONSULT");
                    }

                    if (needCosigner) {
                        ButtonContinue.Visible = false;

                        TableRowCosigner.Visible = true;

                        FilterAndBindCosigners();

                        ButtonContinue.Visible = true;
                    } else {
                        TableRowCosigner.Visible = false;
                    }

                    if (_isconsultnotetitle == true) {
                        LabelforDropDownListConsult.Visible = true;
                        DropDownListConsult.Visible = true;
                        LabelforDropDownListConsult.Text = "Link to Consult *:";
                        LabelforDropDownListConsult.Font.Bold = true;
                        //DropDownListConsult.SelectedIndex = 0;
                        RequiredFieldValidatorDropDownListConsult.Enabled = true;
                    } else {
                        LabelforDropDownListConsult.Visible = false;
                        DropDownListConsult.Visible = false;
                        RequiredFieldValidatorDropDownListConsult.Enabled = false;
                    }
                } else {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;

                    MDWSCallError.Text = errorMessage;
                }
            } else {
                TableRowCosigner.Visible = false;
            }
        } catch (Exception ex) {
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "DropDownListNoteTitleId_SelectedIndexChanged()");
        }
    }

    protected void ButtonFilterAppointments_Click(object sender, EventArgs e) {
        FilterAndBindVisits();
    }

    protected void ButtonGetLocations_Click(object sender, EventArgs e) {
        FilterAndBindLocations();
    }

    protected void ButtonGetCPRSUsers_Click(object sender, EventArgs e) {
        FilterAndBindCosigners();
    }

    #endregion

    #region Private Methods

    private void FilterAndBindLocations() {

        //populate location drop down list
        //DropDownListUnscheduleNewVisitLocation.DataSource = _tbiInstrumentManager.getLocations(TextBoxLocationSearchString.Text, "TBI", "1");
        string errorMessage;

        List<KeyValuePair<string, string>> locations = new List<KeyValuePair<string, string>>();

        if (getCurrentServiceToUse() == "VIA") {
            locations = _tbiInstrumentManager.getLocationsFromVIA(TextBoxLocationSearchString.Text, "TBI", "1", out errorMessage);
        } else {
            locations = _tbiInstrumentManager.getLocations(TextBoxLocationSearchString.Text, "TBI", "1", out errorMessage);
        }

        try {

            if (errorMessage == "SUCCESS") {
                errorMessage = null;
            }

            if (String.IsNullOrEmpty(errorMessage)) {
                DropDownListUnscheduleNewVisitLocation.ClearSelection();
                DropDownListUnscheduleNewVisitLocation.Items.Clear();
                DropDownListUnscheduleNewVisitLocation.Items.Add(new ListItem("-- Select a Value --", "0"));

                DropDownListUnscheduleNewVisitLocation.DataSource = locations;
                DropDownListUnscheduleNewVisitLocation.DataBind();

            } else {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = errorMessage;
                return;

            }
        } catch (Exception ex) {
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "FilterAndBindLocations()");
            MDWSCallError.Text = ex.Message;
        }
    }

    private void FilterAndBindVisits() {
        //populate Appointments drop down list
        DateTime toDate = new DateTime();
        DateTime fromDate = new DateTime();
        string errorMessage;

        if (TextBoxAppointmentSearchDateStart.Text != "") {
            fromDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text);
        } else {
            //if user does not enter a date then default to 30 days prior
            if (TextBoxAppointmentSearchDateEnd.Text == "") {
                fromDate = System.DateTime.Now.AddDays(-30);
            } else {
                fromDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text).AddDays(-30);
            }
        }

        if (TextBoxAppointmentSearchDateEnd.Text != "") {
            toDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text);
        } else {
            //if user does not enter a date then default to 30 in future
            if (TextBoxAppointmentSearchDateStart.Text == "") {
                toDate = System.DateTime.Now.AddDays(30);
            } else {
                toDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text).AddDays(30);
            }
        }

        try {
            List<KeyValuePair<string, string>> visits = new List<KeyValuePair<string, string>>();

            if (getCurrentServiceToUse() == "VIA") {
                visits = _tbiInstrumentManager.getVisitsFromVIA(fromDate, toDate, out errorMessage);
            } else {
                visits = _tbiInstrumentManager.getVisits(fromDate, toDate, out errorMessage);
            }

            if (errorMessage == "SUCCESS") {
                errorMessage = null;
            }

            if (String.IsNullOrEmpty(errorMessage)) {
                DropDownListScheduledClinicAppointment.ClearSelection();
                DropDownListScheduledClinicAppointment.Items.Clear();
                DropDownListScheduledClinicAppointment.Items.Add(new ListItem("-- Select a Value --", "0"));


                //DropDownListScheduledClinicAppointment.DataSource = _tbiInstrumentManager.getVisits(fromDate.GetValueOrDefault(), toDate.GetValueOrDefault());
                DropDownListScheduledClinicAppointment.DataSource = visits;

                DropDownListScheduledClinicAppointment.DataBind();
            } else {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = errorMessage;
                return;
            }
        } catch (Exception ex) {
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "FilterAndBindVisits()");

            MDWSCallError.Text = ex.Message;
        }
    }

    private void FilterAndBindCosigners() {
        //populate Cosigners drop down list
        string errorMessage;

        List<KeyValuePair<string, string>> cosigners = new List<KeyValuePair<string, string>>();

        string strCosigners = TextBoxCosignerSearch.Text.Trim();

        if (getCurrentServiceToUse() == "VIA") {
            cosigners = _tbiInstrumentManager.cprsUserLookupFromVIA(strCosigners, out errorMessage);
        } else {
            cosigners = _tbiInstrumentManager.cprsUserLookup(strCosigners, out errorMessage);
        }

        try {

            if (errorMessage == "SUCCESS") {
                errorMessage = null;
            }

            if (String.IsNullOrEmpty(errorMessage)) {
                DropDownListCosigner.ClearSelection();
                DropDownListCosigner.Items.Clear();
                DropDownListCosigner.Items.Add(new ListItem("-- Select a Value --", "0"));

                DropDownListCosigner.DataSource = cosigners;
                DropDownListCosigner.DataBind();
            } else {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = errorMessage;

                return;
            }
        } catch (Exception ex) {
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleTBIException(ex, "Instrument.aspx", "100031", "FilterAndBindCosigners()");

            MDWSCallError.Text = ex.Message;
        }

    }

    #endregion
}