﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities; 
using VeteransAffairs.Registries.BusinessManager;
using VHAReportViewer;

public partial class ReportStatusCounts : System.Web.UI.Page
{
    private ReportViewerHandler _reportViewerHandler;
    private UserAccountManager _currentUser;
   
    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            ReportViewer1.Visible = false;

            if (!Page.IsPostBack)
            {
                ViewState["ReportViewerHandler"] = _reportViewerHandler = new ReportViewerHandler();
            }
            else
            {
                _reportViewerHandler = (ReportViewerHandler)ViewState["ReportViewerHandler"];

               
            }

            EnableButtonRunReport();
            
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void btnRunReport_Click(object sender, EventArgs e)
    {
        
        
        if (!String.IsNullOrEmpty(SSNAndFacilitySelect1.FacilityStationNumber))
        {
            ReportViewer1.Reset();

            _reportViewerHandler.ClearParams();

            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

            // _reportViewerHandler.AddReportVariable("TableTitle", ReportLevel1.TableTitle);
            //_reportViewerHandler.AddReportVariable("Date", DateTime.Now.ToShortDateString());
            _reportViewerHandler.AddReportVariable("VeteranSSN", this.SSNAndFacilitySelect1.Snum);
            _reportViewerHandler.AddReportVariable("Username", _currentUser1.FullName);
            _reportViewerHandler.AddReportVariable("FacilityId", this.SSNAndFacilitySelect1.FacilityStationNumber);

            ReportViewer1.ServerReport.ReportPath = "VeteransScreeningQuestions";

            //var config = RegistriesConfigurations.GetConfig();

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            //_reportViewerHandler.SetReportParameters(ReportViewer1);
            _reportViewerHandler.SetServerReportParameters(ReportViewer1);

            ReportViewer1.Visible = true;
     
            //ReportViewer1.ServerReport.DisplayName = "What";

            
            ReportViewer1.ProcessingMode = ProcessingMode.Remote;

            ReportViewer1.Visible = true;
            ReportViewer1.ServerReport.Refresh(); 
        
        }
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }
    private void EnableButtonRunReport()
    {
        //if (    
        //     SSNAndFacilitySelect1.VISN == "NoneSelected" ||
        //     string.IsNullOrEmpty(SSNAndFacilitySelect1.FacilityStationNumber) 
        //    //JH 3/25/2010 - not checking for SSN value here 
        //    //because if the user left blank and then selected visn and facility the report button will be grayed out.  
        //    //Then only way to enable is to change a visn or a facility.
        //    // string.IsNullOrEmpty(SSNAndFacilitySelect1.SSN) 
        //    )
        //{
        //    ButtonRunReport.Enabled = false;
        //}
        //else
        //    ButtonRunReport.Enabled = true;
    }
}
