﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportTimeToCompleteEvalGreater30Days : System.Web.UI.Page
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            SetReportParameters();

            if (!IsPostBack)
            {
                SetDropDownListLevel();
                EnableDropDownListsVisnAndStation(false, false);
                CheckBoxListStatus.SelectedIndex = 3;
            }
            EnableButtonRunReport();
            DisableReportViewer();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    
    void Page_PreRender(object sender, EventArgs e)
    {
        EnableButtonRunReport();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        ReportParameter reportParam = new ReportParameter("UserId", userId);
        _reportParameters.Add(reportParam);

        //var config = RegistriesConfigurations.GetConfig();

        if (ReportStatusIsSet())
        {
            if (DropDownListReportLevel.SelectedValue == "National")
            {
                //ReportViewerNational.Visible = true;
                //ReportViewerNational.LocalReport.Refresh();

                //if (!FromToDateSelector1.DateTimeFrom.HasValue)
                //    FromToDateSelector1.DateTimeFrom = new DateTime(1000, 1, 1);
                //if (!FromToDateSelector1.DateTimeTo.HasValue)
                //    FromToDateSelector1.DateTimeTo = new DateTime(3000, 1, 1);
                //if (DropDownListStatus.SelectedValue == "0")
                //    DropDownListStatus.SelectedValue = "2";

                ReportViewerNational.Reset();

                ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                _reportParameters.Add(reportParamFromDate);
                ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                _reportParameters.Add(reportParamToDate);

                //ReportParameter reportParamFromDate = new ReportParameter("FromDate", (FromToDateSelector1.DateTimeFrom.HasValue ? FromToDateSelector1.DateTimeFrom.ToString() : null));
                //_reportParameters.Add(reportParamFromDate);
                //ReportParameter reportParamToDate = new ReportParameter("ToDate", (FromToDateSelector1.DateTimeTo.HasValue ? FromToDateSelector1.DateTimeTo.ToString() : null));
                //_reportParameters.Add(reportParamToDate);
                ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                _reportParameters.Add(reportParamReferralStatusString);
                ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                _reportParameters.Add(reportParamUsername);

                ReportViewerNational.ServerReport.ReportPath = "ReportTimeToCompleteEvalGreater30DaysNational";
              
                ReportViewerNational.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                //ReportViewerNational.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
                if (ReportViewerNational.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                //if (ReportViewerNational.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
                {
                    ReportViewerNational.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerNational.ServerReport.ReportPath;
                    //ReportViewerNational.ServerReport.ReportPath = config.BaseReportPath + ReportViewerNational.ServerReport.ReportPath;
                }
                ReportViewerNational.ServerReport.SetParameters(_reportParameters.ToArray());

                ReportViewerNational.ProcessingMode = ProcessingMode.Remote;
                ReportViewerNational.ServerReport.Refresh();
                ReportViewerNational.Visible = true;
            }
            else if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                if (DropDownListVisnID.SelectedIndex > 0)
                {
                    //ReportViewerVisn.Visible = true;
                    //ReportViewerVisn.LocalReport.Refresh();

                    //if (!FromToDateSelector1.DateTimeFrom.HasValue)
                    //    FromToDateSelector1.DateTimeFrom = new DateTime(1000, 1, 1);
                    //if (!FromToDateSelector1.DateTimeTo.HasValue)
                    //    FromToDateSelector1.DateTimeTo = new DateTime(3000, 1, 1);
                    //if (DropDownListStatus.SelectedValue == "0")
                    //    DropDownListStatus.SelectedValue = "2";

                    ReportViewerVisn.Reset();

                    ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                    _reportParameters.Add(reportParamFromDate);
                    ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                    _reportParameters.Add(reportParamToDate);

                    //ReportParameter reportParamFromDate = new ReportParameter("FromDate", (FromToDateSelector1.DateTimeFrom.HasValue ? FromToDateSelector1.DateTimeFrom.ToString() : null));
                    //_reportParameters.Add(reportParamFromDate);
                    //ReportParameter reportParamToDate = new ReportParameter("ToDate", (FromToDateSelector1.DateTimeTo.HasValue ? FromToDateSelector1.DateTimeTo.ToString() : null));
                    //_reportParameters.Add(reportParamToDate);
                    ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                    _reportParameters.Add(reportParamReferralStatusString);
                    ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                    _reportParameters.Add(reportParamUsername);

                    ReportParameter reportParamVisnId = new ReportParameter("VisnId", (DropDownListVisnID.SelectedValue));
                    _reportParameters.Add(reportParamVisnId);

                    ReportViewerVisn.ServerReport.ReportPath = "ReportTimeToCompleteEvalGreater30DaysVisn";

                    ReportViewerVisn.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                    //ReportViewerVisn.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
                    if (ReportViewerVisn.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                    //if (ReportViewerVisn.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
                    {
                        ReportViewerVisn.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerVisn.ServerReport.ReportPath;
                        //ReportViewerVisn.ServerReport.ReportPath = config.BaseReportPath + ReportViewerVisn.ServerReport.ReportPath;
                    }
                    ReportViewerVisn.ServerReport.SetParameters(_reportParameters.ToArray());

                    ReportViewerVisn.ProcessingMode = ProcessingMode.Remote;
                    ReportViewerVisn.ServerReport.Refresh();
                    ReportViewerVisn.Visible = true;

                }
            }
            else
            {
                if (DropDownListFacility.SelectedIndex > 0)
                {
                    //ReportViewerStation.Visible = true;
                    //ReportViewerStation.LocalReport.Refresh();

                    //if (!FromToDateSelector1.DateTimeFrom.HasValue)
                    //    FromToDateSelector1.DateTimeFrom = new DateTime(1000, 1, 1);
                    //if (!FromToDateSelector1.DateTimeTo.HasValue)
                    //    FromToDateSelector1.DateTimeTo = new DateTime(3000, 1, 1);
                    //if (DropDownListStatus.SelectedValue == "0")
                    //    DropDownListStatus.SelectedValue = "2";

                    ReportViewerStation.Reset();
                    
                    ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                    _reportParameters.Add(reportParamFromDate);
                    ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                    _reportParameters.Add(reportParamToDate);
                    
                    //ReportParameter reportParamFromDate = new ReportParameter("FromDate", (FromToDateSelector1.DateTimeFrom.HasValue ? FromToDateSelector1.DateTimeFrom.ToString() : null));
                    //_reportParameters.Add(reportParamFromDate);
                    //ReportParameter reportParamToDate = new ReportParameter("ToDate", (FromToDateSelector1.DateTimeTo.HasValue ? FromToDateSelector1.DateTimeTo.ToString() : null));
                    //_reportParameters.Add(reportParamToDate);
                    ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                    _reportParameters.Add(reportParamReferralStatusString);
                    ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                    _reportParameters.Add(reportParamUsername);

                    ReportParameter reportParamVisnId = new ReportParameter("FacilityId", (DropDownListFacility.SelectedValue));
                    _reportParameters.Add(reportParamVisnId);

                    ReportViewerStation.ServerReport.ReportPath = "ReportTimeToCompleteEvalGreater30DaysSation";

                    ReportViewerStation.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                    //ReportViewerStation.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
                    if (ReportViewerStation.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                    //if (ReportViewerStation.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
                    {
                        ReportViewerStation.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerStation.ServerReport.ReportPath;
                        //ReportViewerStation.ServerReport.ReportPath = config.BaseReportPath + ReportViewerStation.ServerReport.ReportPath;
                    }
                    ReportViewerStation.ServerReport.SetParameters(_reportParameters.ToArray());

                    ReportViewerStation.ProcessingMode = ProcessingMode.Remote;
                    ReportViewerStation.ServerReport.Refresh();
                    ReportViewerStation.Visible = true;
                }
            }
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=101");
        }
    }
    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListReportLevel.SelectedValue == "Select One")
        {
            ButtonRunReport.Enabled = false;
            EnableDropDownListsVisnAndStation(false, false);
        }
        else if (DropDownListReportLevel.SelectedValue == "National")
        {
            ButtonRunReport.Enabled = true;
            EnableDropDownListsVisnAndStation(false, false);
        }
        else
        {
            EnableDropDownListsVisnAndStation(true, false);
            SetDropDownListVisnId();
        }
    }
    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListReportLevel.SelectedValue == "VISN")
        {
            EnableDropDownListsVisnAndStation(true, false);
        }
        else if (DropDownListReportLevel.SelectedValue == "Station")
        {
            SetDropDownListFacility();
            EnableDropDownListsVisnAndStation(true, true);
        }
    }
    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }

    private void SetDropDownListVisnId()
    {
        if (!_currentUser.IsInRole(16))
        {
            if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                DropDownListVisnID.DataSource = ObjectDataSourceDirectlyPermittedVISNs;
            }
            else if (DropDownListReportLevel.SelectedValue == "Station")
            {
                DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
            }
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
        DropDownListVisnID.SelectedIndex = 0;
    }
    private void SetDropDownListFacility()
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            if (_currentUser.IsInRole(16))
            {
                DropDownListFacility.DataSource = ObjectDataSource3;
            }
            else
            {
                DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
            }
            DropDownListFacility.DataBind();
            DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));
            DropDownListFacility.SelectedIndex = 0;
        }
    }
    private bool ReportStatusIsSet()
    {
        if (CheckBoxListStatus.Items[0].Selected & !CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "1";
        }
        else if (!CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "2";
        }
        else if (!CheckBoxListStatus.Items[0].Selected & !CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "3";
        }
        else if (CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "12";
        }
        else if (!CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "23";
        }
        else if (CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
        {
            DropDownListStatus.SelectedValue = "123";
        }
        else
        {
            DropDownListStatus.SelectedValue = "0";
            return false;
        }
        return true;
    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }
    private void SetReportParameters()
    {
        //string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        //ReportParameter reportParam = new ReportParameter("UserId", userId);
        //_reportParameters.Add(reportParam);
        //ReportViewerNational.LocalReport.SetParameters(_reportParameters.ToArray());
        //ReportViewerVisn.LocalReport.SetParameters(_reportParameters.ToArray());
        //ReportViewerStation.LocalReport.SetParameters(_reportParameters.ToArray());
    }
    private void SetDropDownListLevel()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        AddListItem("Select One");

        if (_currentUser.IsInRole(16))
        {
            AddListItem("National");
            AddListItem("VISN");
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }

        if (_currentUser.IsInRole(17))
        {
            AddListItem("VISN");
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }

        if (_currentUser.IsInRole(18))
        {
            AddListItem("Station");
            DropDownListReportLevel.Items[0].Selected = true;
        }
    }
    private void AddListItem(string itemValue)
    {
        var listItem = new ListItem(itemValue);
        if (!DropDownListReportLevel.Items.Contains(listItem))
            DropDownListReportLevel.Items.Add(listItem);
    }
    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        DivVISN.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        DivStation.Visible = dropDownListFacilityIsVisible;
    }
    private void EnableButtonRunReport()
    {
        if (CheckBoxListStatus.SelectedIndex < 0 ||
             DropDownListReportLevel.SelectedValue == "Select One" ||
             (DropDownListReportLevel.SelectedValue == "VISN" && DropDownListVisnID.SelectedIndex < 1) ||
             (DropDownListReportLevel.SelectedValue == "Station" &&
              (DropDownListVisnID.SelectedIndex < 1
               || DropDownListFacility.SelectedIndex < 1))
            )
        {
            ButtonRunReport.Enabled = false;
        }
        else
            ButtonRunReport.Enabled = true;
    }
    private void DisableReportViewer()
    {
        ReportViewerNational.Visible = false;
        ReportViewerVisn.Visible = false;
        ReportViewerStation.Visible = false;
    }
}
